% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densne.R
\name{densne}
\alias{densne}
\title{Density-preserving t-SNE}
\usage{
densne(
  X,
  dims = 2,
  perplexity = 50,
  theta = 0.5,
  check_duplicates = TRUE,
  pca = FALSE,
  initial_dims = 50,
  partial_pca = FALSE,
  pca_center = TRUE,
  pca_scale = FALSE,
  verbose = getOption("verbose", FALSE),
  max_iter = 1000,
  Y_init = NULL,
  stop_lying_iter = if (is.null(Y_init)) 250L else 0L,
  mom_switch_iter = if (is.null(Y_init)) 250L else 0L,
  momentum = 0.5,
  final_momentum = 0.8,
  eta = 200,
  exaggeration_factor = 12,
  dens_frac = 0.3,
  dens_lambda = 0.1,
  num_threads = 1,
  normalize = TRUE
)
}
\arguments{
\item{X}{Input data matrix, where rows are observations and columns are
features.}

\item{dims}{Integer output dimensionality.}

\item{perplexity}{Perplexity parameter (should not be bigger than
3 * perplexity < nrow(X) - 1).}

\item{theta}{Speed/accuracy trade-off (increase for less
accuracy), set to 0.0 for exact TSNE}

\item{check_duplicates}{logical; Checks whether duplicates are present.
It is best to make sure there are no duplicates present and set this option
to FALSE, especially for large datasets (default: TRUE)}

\item{pca}{logical; Whether an initial PCA step should be performed
(default: FALSE).}

\item{initial_dims}{integer; the number of dimensions that should be retained
in the initial PCA step (default: 50)}

\item{partial_pca}{logical; Whether truncated PCA should be used to calculate
principal components (requires the irlba package). This is faster for large
input matrices (default: FALSE)}

\item{pca_center, pca_scale}{Controls whether to centre and scale the data
before applying PCA. Defaults: TRUE, FALSE.}

\item{verbose}{Logical; Whether progress updates should be printed}

\item{max_iter}{integer; Number of iterations}

\item{Y_init}{matrix; Initial locations of the objects. If NULL, random
initialization will be used}

\item{stop_lying_iter}{integer; Iteration after which the perplexities are no
longer exaggerated}

\item{mom_switch_iter}{integer; Iteration after which the final momentum is
used}

\item{momentum}{numeric; Momentum used in the first part of the optimization}

\item{final_momentum}{numeric; Momentum used in the final part of the
optimization}

\item{eta}{numeric; Learning rate}

\item{exaggeration_factor}{numeric; Exaggeration factor used to multiply the
affinities matrix P in the first part of the optimization}

\item{dens_frac}{numeric; fraction of the iterations for which the full
objective function (including the density-preserving term) is used.
For the first \code{1 - dens_frac} fraction of the iterations, only
the original t-SNE objective function is used.}

\item{dens_lambda}{numeric; the relative importanceof the
density-preservation term compared to the original t-SNE objective function.}

\item{num_threads}{Number of threads to be used for parallelisation.}

\item{normalize}{logical; Should data be normalized internally prior to
distance calculations with \code{\link[Rtsne]{normalize_input}}?}
}
\value{
A numeric matrix corresponding to the t-SNE embedding
}
\description{
Density-preserving t-SNE
}
\examples{
x <- matrix(rnorm(1e3), nrow = 100)
d <- densne(x, perplexity = 5)
plot(d)
}
\references{
Density-Preserving Data Visualization Unveils Dynamic Patterns of Single-Cell
Transcriptomic Variability
Ashwin Narayan, Bonnie Berger, Hyunghoon Cho;
bioRxiv (2020)
\url{doi:10.1101/2020.05.12.077776}
}
