% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_dmDSprecision.R
\docType{class}
\name{dmDSprecision-class}
\alias{dmDSprecision-class}
\alias{design,dmDSprecision-method}
\alias{mean_expression}
\alias{mean_expression,dmDSprecision-method}
\alias{common_precision}
\alias{common_precision,dmDSprecision-method}
\alias{common_precision<-}
\alias{common_precision<-,dmDSprecision-method}
\alias{genewise_precision}
\alias{genewise_precision,dmDSprecision-method}
\alias{genewise_precision<-}
\alias{genewise_precision<-,dmDSprecision-method}
\title{dmDSprecision object}
\usage{
\S4method{design}{dmDSprecision}(object, type = "precision")

mean_expression(x, ...)

\S4method{mean_expression}{dmDSprecision}(x)

common_precision(x, ...)

\S4method{common_precision}{dmDSprecision}(x)

common_precision(x) <- value

\S4method{common_precision}{dmDSprecision}(x) <- value

genewise_precision(x, ...)

\S4method{genewise_precision}{dmDSprecision}(x)

genewise_precision(x) <- value

\S4method{genewise_precision}{dmDSprecision}(x) <- value
}
\arguments{
\item{type}{Character indicating which design matrix should be returned.
Possible values \code{"precision"}, \code{"full_model"} or
\code{"null_model"}.}

\item{x, object}{dmDSprecision object.}

\item{...}{Other parameters that can be defined by methods using this 
generic.}

\item{value}{Values that replace current attributes.}
}
\value{
\itemize{ \item \code{mean_expression(x)}: Get a data frame with mean gene
expression. \item \code{common_precision(x), common_precision(x) <- value}:
Get or set common precision. \code{value} must be numeric of length 1. \item
\code{genewise_precision(x), genewise_precision(x) <- value}: Get a data
frame with gene-wise precision or set new gene-wise precision. \code{value}
must be a data frame with "gene_id" and "genewise_precision" columns. }
}
\description{
dmDSprecision extends the \code{\linkS4class{dmDSdata}} by adding the 
precision estimates of the Dirichlet-multinomial distribution used to model 
the feature (e.g., transcript, exon, exonic bin) counts for each gene in the 
differential usage analysis. Result of calling the \code{\link{dmPrecision}}
function.
}
\details{
Normally, in the differential analysis based on RNA-seq data, such 
  as, for example, differential gene expression, dispersion (of 
  negative-binomial model) is estimated. Here, we estimate precision of the 
  Dirichlet-multinomial model as it is more convenient computationally. To 
  obtain dispersion estimates, one can use a formula: dispersion = 1 / (1 + 
  precision).
}
\section{Slots}{

\describe{
\item{\code{mean_expression}}{Numeric vector of mean gene expression.}

\item{\code{common_precision}}{Numeric value of estimated common precision.}

\item{\code{genewise_precision}}{Numeric vector of estimated gene-wise precisions.}

\item{\code{design_precision}}{Numeric matrix of the design used to estimate 
precision.}
}}

\examples{
# --------------------------------------------------------------------------
# Create dmDSdata object 
# --------------------------------------------------------------------------
## Get kallisto transcript counts from the 'PasillaTranscriptExpr' package

library(PasillaTranscriptExpr)
\donttest{
data_dir  <- system.file("extdata", package = "PasillaTranscriptExpr")

## Load metadata
pasilla_metadata <- read.table(file.path(data_dir, "metadata.txt"), 
header = TRUE, as.is = TRUE)

## Load counts
pasilla_counts <- read.table(file.path(data_dir, "counts.txt"), 
header = TRUE, as.is = TRUE)

## Create a pasilla_samples data frame
pasilla_samples <- data.frame(sample_id = pasilla_metadata$SampleName, 
  group = pasilla_metadata$condition)
levels(pasilla_samples$group)

## Create a dmDSdata object
d <- dmDSdata(counts = pasilla_counts, samples = pasilla_samples)

## Use a subset of genes, which is defined in the following file
gene_id_subset <- readLines(file.path(data_dir, "gene_id_subset.txt"))

d <- d[names(d) \%in\% gene_id_subset, ]

# --------------------------------------------------------------------------
# Differential transcript usage analysis - simple two group comparison 
# --------------------------------------------------------------------------

## Filtering
## Check what is the minimal number of replicates per condition 
table(samples(d)$group)

d <- dmFilter(d, min_samps_gene_expr = 7, min_samps_feature_expr = 3,
  min_gene_expr = 10, min_feature_expr = 10)

plotData(d)

## Create the design matrix
design_full <- model.matrix(~ group, data = samples(d))

## To make the analysis reproducible
set.seed(123)
## Calculate precision
d <- dmPrecision(d, design = design_full)

plotPrecision(d)

head(mean_expression(d))
common_precision(d)
head(genewise_precision(d))
}
}
\seealso{
\code{\linkS4class{dmDSdata}}, \code{\linkS4class{dmDSfit}}, 
  \code{\linkS4class{dmDStest}}
}
\author{
Malgorzata Nowicka
}
