% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/374-extractDrugHybridization.R
\name{extractDrugHybridizationComplete}
\alias{extractDrugHybridizationComplete}
\title{Calculate the Hybridization Molecular Fingerprints (in Complete Format)}
\usage{
extractDrugHybridizationComplete(molecules, depth = 6, size = 1024,
  silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{depth}{The search depth. Default is \code{6}.}

\item{size}{The length of the fingerprint bit string. Default is \code{1024}.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
An integer vector or a matrix. Each row represents one molecule,
the columns represent the fingerprints.
}
\description{
Calculate the Hybridization Molecular Fingerprints (in Complete Format)
}
\details{
Calculate the hybridization molecular fingerprints.
Similar to the standard type, but only consider hybridization state.
This is hashed fingerprints, with a default length of 1024.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
fp  = extractDrugHybridizationComplete(mol)
dim(fp)}
}
\seealso{
\link{extractDrugHybridization}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{extractDrugHybridizationComplete}
