% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optRandomParC.R, R/printRes.R
\encoding{UTF-8}
\name{optRandomParC}
\alias{optRandomParC}
\alias{print.optMorePar}
\title{Optimizing a set of partitions based on the value of a criterion function}
\usage{
optRandomParC(
  M,
  k,
  approaches,
  blocks,
  rep,
  save.initial.param = TRUE,
  save.initial.param.opt = FALSE,
  deleteMs = TRUE,
  max.iden = 10,
  switch.names = NULL,
  return.all = FALSE,
  return.err = TRUE,
  seed = NULL,
  RandomSeed = NULL,
  parGenFun = genRandomPar,
  mingr = NULL,
  maxgr = NULL,
  addParam = list(genPajekPar = TRUE, probGenMech = NULL),
  maxTriesToFindNewPar = rep * 10,
  skip.par = NULL,
  useOptParMultiC = FALSE,
  useMulti = useOptParMultiC,
  printRep = ifelse(rep <= 10, 1, round(rep/10)),
  n = NULL,
  nCores = 1,
  useParLapply = FALSE,
  useLB = NULL,
  chunk.size = 1,
  cl = NULL,
  stopcl = is.null(cl),
  useRegParrallaBackend = FALSE,
  ...
)

\method{print}{optMorePar}(x, ...)
}
\arguments{
\item{M}{A matrix representing the (usually valued) network. For multi-relational networks, this should be an array with the third dimension representing the relation. The network can have one or more modes (diferent kinds of units with no ties among themselves). If the network is not two-mode, the matrix must be square.}

\item{k}{The number of clusters used in the generation of partitions.}

\item{approaches}{One of the approaches (for each relation in multi-relational netowrks in a vector) described in Žiberna (2007). Possible values are:\cr
"bin" - binary blockmodeling,\cr
"val" - valued blockmodeling,\cr
"hom" - homogeneity blockmodeling,\cr
"ss" - sum of squares homogeneity blockmodeling, and\cr
"ad" - absolute deviations homogeneity blockmodeling.\cr
\cr
The last two options are "shorthand" for specifying \code{approaches="hom"} and  \code{homFun} to either \code{"ss"} or  \code{"ad"}.}

\item{blocks}{A vector, a list of vectors or an array with names of allowed blocy types. \cr
\cr
Only listing of allowed block types (blockmodel is not pre-specified).\cr
A vector with names of allowed block types. For multi-relational networks, it can be a list of such vectors. For \code{approaches = "bin"} or \code{approaches = "val"}, at least two should be selected. Possible values are:\cr
\code{"nul"} - null or empty block\cr
\code{"com"} - complete block\cr
\code{"rdo"}, \code{"cdo"} - row and column-dominant blocks (binary and valued approach only)\cr
\code{"reg"} - (f-)regular block\cr
\code{"rre"}, \code{"cre"} - row and column-(f-)regular blocks\cr
\code{"rfn"}, \code{"cfn"} - row and column-dominant blocks (binary, valued only)\cr
\code{"den"} - density block (binary approach only)\cr
\code{"avg"} - average block (valued approach only)\cr
\code{"dnc"} - do not care block - the error is always zero\cr
The ordering is important, since if several block types have identical error, the first on the list is selected.\cr\cr
A pre-specified blockmodel.\cr
An array with four dimensions (see example below). The third and the fourth represent the clusters (for rows and columns). The first is as long as the maximum number of allows block types for a given block. If some block has less possible block types, the empty slots should have values \code{NA}. The second dimension is the number of relations (1 for single-relational networks). The values in the array should be the ones from above. The array can have only three dimensions in case of one-relational networks or if the same pre-specified blockmodel is assumed for all relations. Further, it can have only two dimensions, if in addition only one block type is allowed per block.}

\item{rep}{The number of repetitions/different starting partitions to check.}

\item{save.initial.param}{Should the inital parameters (\code{approaches}, ...) be saved. The default value is \code{TRUE}.}

\item{save.initial.param.opt}{Should the inital parameters(\code{approaches}, ...) of using \code{optParC} be saved. The default value is \code{FALSE}.}

\item{deleteMs}{Delete networks/matrices from the results of to save space.}

\item{max.iden}{Maximum number of results that should be saved (in case there are more than \code{max.iden} results with minimal error, only the first \code{max.iden} will be saved).}

\item{switch.names}{Should partitions that only differ in group names be considered equal. By default it is set to \code{TRUE} if \code{blocks} is either a vector or a list of vectors and to \code{FALSE} otherwise.}

\item{return.all}{If \code{FALSE}, solution for only the best (one or more) partition/s is/are returned.}

\item{return.err}{Should the error for each optimized partition be returned.}

\item{seed}{Optional. The seed for random generation of partitions.}

\item{RandomSeed}{Optional. Integer vector, containing the random number generator. It is only looked for in the user's workspace.}

\item{parGenFun}{The function (object) that will generate random partitions. The default function is   \code{\link{genRandomPar}}. The function has to accept the following parameters: \code{k} (number o of partitions by modes, \code{n} (number of units by modes), \code{seed} (seed value for random generation of partition), \code{addParam} (a list of additional parameters).}

\item{mingr}{Minimal allowed group size.}

\item{maxgr}{Maximal allowed group size.}

\item{addParam}{A list of additional parameters for function specified above. In the usage section they are specified for the default function \code{\link{genRandomPar}}.}

\item{maxTriesToFindNewPar}{The maximum number of partition try when trying to find a new partition to optimize that was not yet checked before - the default value is \code{rep * 1000}.}

\item{skip.par}{The partitions that are not allowed or were already checked and should therefore be skipped.}

\item{useOptParMultiC}{For backward compatibility. May be removed soon. See next argument.}

\item{useMulti}{Which version of local search should be used. Default is currently \code{FALSE}. If \code{FALSE}, first possible all moves in random order and then all possible exchanges in random order are tried. When a move with lower value of criterion function is found, the algorithm moves to this new partition. If \code{TRUE} the version of local search where all possible moves and exchanges are tried first and then the one with the lowest error is selected and used. In this case, several optimal partitions are found. \code{maxPar} best partitions are returned.}

\item{printRep}{Should some information about each optimization be printed.}

\item{n}{The number of units by "modes". It is used only for generating random partitions. It has to be set only if there are more than two modes or if there are two modes, but the matrix representing the network is one mode (both modes are in rows and columns).}

\item{nCores}{Number of cores to be used. Value \code{0} means all available cores. It can also be a cluster object.}

\item{useParLapply}{Should \code{parLapplyLB} or \code{parLapply} (see \code{useLB}) be used for parallel execution (on multiple cores). Otherwise \code{mforeach} is used. Defaults to FALSE. If \code{useParLapply = TRUE} and \code{useLB = TRUE}, results are not reproducible.}

\item{useLB}{Should be logical if set. Only used if \code{useParLapply = TRUE}. Should load balancing be used (\code{parLapplyLB} instead of \code{parLapply}). Using load balancing usually means faster execution, but results are with not reproducible. Defaults to \code{NULL}, which is changed to \code{TRUE}, but a warning.}

\item{chunk.size}{chunk.size used in \code{parLapplyLB} if it is used, otherwise ignored. Defaults to 1.}

\item{cl}{The cluster to use (if formed beforehand). Defaults to \code{NULL}. Ignored if useParLapply=FALSE (default) and foreach::getDoParRegistered is true}

\item{stopcl}{Should the cluster be stoped after the function finishes. Defaults to \code{is.null(cl)}.}

\item{useRegParrallaBackend}{Should the function use already registered parallel backend. Defaults to \code{FALSE}. If \code{TRUE}, you must make sure that an appropriate backend is correctly set up and registered. Use only if \code{useParLapply = FALSE} (default) and \code{nCore} is not 1.}

\item{\dots}{Arguments passed to other functions, see \code{\link{critFunC}}.}

\item{x}{The result of \code{\link{optRandomParC}}.}

\item{genPajekPar}{Should the partitions be generated as in Pajek.}

\item{probGenMech}{Should the probabilities for different mechanisms for specifying the partitions be set. If \code{probGenMech} is not set, it is determined based on the parameter \code{genPajekPar}.}
}
\value{
\item{M}{The matrix of the network analyzed.}
  \item{res}{If \code{return.all = TRUE} - A list of results the same as \code{best} - one \code{best} for each partition optimized.}
  \item{best}{A list of results from \code{optParC}, only without \code{M}.}
  \item{err}{If \code{return.err = TRUE} - The vector of errors or inconsistencies of the empirical  network with the ideal network for a given blockmodel (model,approach,...) and parititions.}
  \item{nIter}{The vector of the number of iterations used - one value for each starting partition that was optimized. It can show that \code{maxiter} is too low if a lot of these values have the value of \code{maxiter}.}
  \item{checked.par}{If selected - A list of checked partitions. If \code{merge.save.skip.par} is \code{TRUE}, this list also includes the partitions in \code{skip.par}.}
  \item{call}{The call used to call the function.}
  \item{initial.param}{If selected - The initial parameters are used.}
}
\description{
The function optimizes a set of partitions based on the value of a criterion function  (see \code{\link{critFunC}} for details on the criterion function) for a given network and blockmodel for Generalized blockmodeling (Žiberna, 2007) based on other parameters (see below).
The optimization is done through local optimization, where the neighborhood of a partition includes all partitions that can be obtained by moving one unit from one cluster to another or by exchanging two units (from different clusters).
The number of clusters and a number of partitions to generate can be specified (\code{optParC}).
}
\section{Warning}{

It should be noted that the time complexity of package blockmodeling is increasing with
the number of units and the number of clusters (due to its algorithm). Therefore the analysis
of network with more than 100 units can take a lot of time (from a few hours to a few days).
}

\examples{
n <- 8 # If larger, the number of partitions increases dramatically
# as does if we increase the number of clusters
net <- matrix(NA, ncol = n, nrow = n)
clu <- rep(1:2, times = c(3, 5))
tclu <- table(clu)
net[clu == 1, clu == 1] <- rnorm(n = tclu[1] * tclu[1], mean = 0, sd = 1)
net[clu == 1, clu == 2] <- rnorm(n = tclu[1] * tclu[2], mean = 4, sd = 1)
net[clu == 2, clu == 1] <- rnorm(n = tclu[2] * tclu[1], mean = 0, sd = 1)
net[clu == 2, clu == 2] <- rnorm(n = tclu[2] * tclu[2], mean = 0, sd = 1)

# Optimizing 10 random chosen partitions with optRandomParC
res <- optRandomParC(M = net, k = 2, rep = 10,
approaches = "hom", homFun = "ss", blocks = "com")
plot(res) # Hopefully we get the original partition

}
\references{
Batagelj, V., & Mrvar, A. (2006). Pajek 1.11. Retrieved from http://vlado.fmf.uni-lj.si/pub/networks/pajek/

Doreian, P., Batagelj, V. & Ferligoj, A. (2005). Generalized blockmodeling, (Structural analysis in the social sciences, 25). Cambridge [etc.]: Cambridge University Press.

\enc{Žiberna, A.}{Ziberna, A.} (2007). Generalized Blockmodeling of Valued Networks. Social Networks, 29(1), 105-126. doi: 10.1016/j.socnet.2006.04.002

\enc{Žiberna, A.}{Ziberna, A.} (2008). Direct and indirect approaches to blockmodeling of valued networks in terms of regular equivalence. Journal of Mathematical Sociology, 32(1), 57-84. doi: 10.1080/00222500701790207

\enc{Žiberna, A.}{Ziberna, A.} (2014). Blockmodeling of multilevel networks. Social Networks, 39(1), 46-61. doi: 10.1016/j.socnet.2014.04.002
}
\seealso{
\code{\link{critFunC}}, \code{\link{IM}}, \code{\link{clu}}, \code{\link{err}}, \code{\link{plot.optMorePar}}
}
\author{
\enc{Aleš, Žiberna}{Ales Ziberna}
}
\keyword{cluster}
\keyword{graphs}
