% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-orderset.R
\name{chk_orderset}
\alias{chk_orderset}
\title{Check Set Ordered}
\usage{
chk_orderset(x, values, x_name = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{values}{A vector of the permitted values.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if the first occurrence of each shared element
in x is equivalent to the first occurrence of each shared element in values using
\code{vld_equivalent(unique(x[x \%in\% values]), values[values \%in\% x])}.
}
\examples{

# chk_orderset
chk_orderset(1:2, 1:2)
try(chk_orderset(2:1, 1:2))
}
\seealso{
Other chk_set: 
\code{\link{chk_join}()},
\code{\link{chk_not_subset}()},
\code{\link{chk_superset}()},
\code{\link{vld_not_subset}()},
\code{\link{vld_orderset}()}
}
\concept{chk_set}
