% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credential-api.R
\name{credential_api}
\alias{credential_api}
\alias{credential_fill}
\alias{credential_approve}
\alias{credential_reject}
\title{Retrieve and store git HTTPS credentials}
\usage{
credential_fill(cred, verbose = TRUE)

credential_approve(cred, verbose = TRUE)

credential_reject(cred, verbose = TRUE)
}
\arguments{
\item{cred}{named list with at least fields \code{protocol} and \code{host} and
optionally also \code{path}, \code{username} ,\code{password}.}

\item{verbose}{emit some useful output about what is happening}
}
\description{
Low-level wrappers for the \href{https://git-scm.com/docs/git-credential}{git-credential}
command line tool. Try the user-friendly \link{git_credential_ask}
and \link{git_credential_update} functions first.
}
\details{
The \link{credential_fill} function looks up credentials for a given host, and
if none exists it will attempt to prompt the user for new credentials. Upon
success it returns a list with the same \code{protocol} and \code{host} fields as the
\code{cred} input, and additional \code{username} and \code{password} fields.

After you have tried to authenticate the provided credentials, you can report
back if the credentials were valid or not. Call \link{credential_approve} and
\link{credential_reject} with the \code{cred} that was returned by \link{credential_fill}
in order to validate or invalidate a credential from the store.

Because git credential interacts with the system password manager, the appearance
of the prompts vary by OS and R frontend.  Note that \link{credential_fill} should
only be used interactively, because it may require the user to enter credentials
or unlock the system keychain. On the other hand \link{credential_approve} and
\link{credential_reject} are non-interactive and could be used to save or delete
credentials in a scripted program. However note that some credential helpers
(e.g. on Windows) have additional security restrictions that limit use of
\link{credential_approve} and \link{credential_reject} to credentials that were actually
entered by the user via \link{credential_fill}. Here it is not possible at all to
update the credential store without user interaction.
}
\examples{
\donttest{
# Insert example cred
example <- list(protocol = "https", host = "example.org",
  username = "test", password = "secret")
credential_approve(example)

# Retrieve it from the store
cred <- credential_fill(list(protocol = "https", host = "example.org", path = "/foo"))
print(cred)

# Delete it
credential_reject(cred)
}
}
