% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_npc.R
\name{as_npc}
\alias{as_npc}
\alias{as_npcx}
\alias{as_npcy}
\title{Convert Character Coordinates into Normalized Parent Coordinates (NPC)}
\usage{
as_npc(
  value,
  group = 1L,
  step = 0.1,
  margin.npc = 0.05,
  axis = c("xy", "x", "y")
)

as_npcx(value, group = 1L, step = 0.1, margin.npc = 0.05)

as_npcy(value, group = 1L, step = 0.1, margin.npc = 0.05)
}
\arguments{
\item{value}{numeric (in [0-1]) or character vector of coordinates. If
character, should be one of \code{c('right', 'left', 'bottom', 'top',
'center', 'centre', 'middle')}.}

\item{group}{integer ggplot's group id. Used to shift coordinates to avoid
overlaps.}

\item{step}{numeric value in [0-1]. The step size for shifting coordinates
in npc units. Considered as horizontal step for x-axis and vertical step
for y-axis. For y-axis, the step value can be negative to reverse the order of groups.}

\item{margin.npc}{numeric [0-1] The margin added towards the nearest
plotting area edge when converting character coordinates into npc.}

\item{axis}{the concerned axis . Should be one of \code{c("xy", "x", "y")}.}
}
\value{
A numeric vector with values in the range [0-1] representing npc
  coordinates.
}
\description{
Convert character coordinates to npc units and shift postions to avoid
overlaps when grouping is active. If numeric validate npc values.
}
\details{
the \code{as_npc()} function is an adaptation from
  \code{ggpmisc::compute_npc()}.
}
\section{Functions}{
\itemize{
\item \code{as_npc()}: converts x or y coordinate values into npc. Input values
should be numeric or one of the following values \code{c('right', 'left',
'bottom', 'top', 'center', 'centre', 'middle')}.

\item \code{as_npcx()}: converts x coordinate values into npc. Input values should
be numeric or one of the following values \code{c('right', 'left',
'center', 'centre', 'middle')}. Wrapper around \code{as_npc(axis = "x")}.

\item \code{as_npcy()}: converts y coordinate values into npc. Input values should
be numeric or one of the following values \code{c( 'bottom', 'top',
'center', 'centre', 'middle')}. Wrapper around \code{as_npc(axis = "y")}.

}}
\examples{
as_npc(c("left", "right"))
as_npc(c("top", "right"))

}
\seealso{
\code{\link{npc_to_data_coord}}, \code{\link{get_coord}}.
}
