% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_sbm}
\alias{sample_sbm}
\alias{sbm.game}
\alias{sbm}
\title{Sample stochastic block model}
\usage{
sample_sbm(n, pref.matrix, block.sizes, directed = FALSE, loops = FALSE)

sbm(...)
}
\arguments{
\item{n}{Number of vertices in the graph.}

\item{pref.matrix}{The matrix giving the Bernoulli rates.  This is a
\eqn{K\times K}{KxK} matrix, where \eqn{K} is the number of groups. The
probability of creating an edge between vertices from groups \eqn{i} and
\eqn{j} is given by element \eqn{(i,j)}. For undirected graphs, this matrix
must be symmetric.}

\item{block.sizes}{Numeric vector giving the number of vertices in each
group. The sum of the vector must match the number of vertices.}

\item{directed}{Logical scalar, whether to generate a directed graph.}

\item{loops}{Logical scalar, whether self-loops are allowed in the graph.}

\item{...}{Passed to \code{sample_sbm()}.}
}
\value{
An igraph graph.
}
\description{
Sampling from the stochastic block model of networks
}
\details{
This function samples graphs from a stochastic block model by (doing the
equivalent of) Bernoulli trials for each potential edge with the
probabilities given by the Bernoulli rate matrix, \code{pref.matrix}.
The order of the vertices in the generated graph corresponds to the
\code{block.sizes} argument.
}
\examples{

## Two groups with not only few connection between groups
pm <- cbind(c(.1, .001), c(.001, .05))
g <- sample_sbm(1000, pref.matrix = pm, block.sizes = c(300, 700))
g
}
\references{
Faust, K., & Wasserman, S. (1992a). Blockmodels: Interpretation
and evaluation. \emph{Social Networks}, 14, 5--61.
}
\seealso{
Random graph models (games)
\code{\link{erdos.renyi.game}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_correlated_gnp_pair}()},
\code{\link{sample_correlated_gnp}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_fitness}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_gnp}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_islands}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pa}()},
\code{\link{sample_pref}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_tree}()},
\code{\link{sample_}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{games}
\keyword{graphs}
