#' Context Functions
#' 
#' Context functions
#' 
#' \code{zmq.ctx.new()} initializes a ZMQ context for starting communication.
#' 
#' \code{zmq.ctx.destroy()} terminates the context for stopping communication.
#' 
#' @param ctx 
#' a ZMQ context
#' 
#' @return 
#' \code{zmq.ctx.new()} returns an R external pointer (\code{ctx})
#' generated by ZMQ C API pointing to a context if successful, otherwise
#' returns an R \code{NULL}.
#' 
#' \code{zmq.ctx.destroy()} returns 0 if successful, otherwise returns -1 and
#' sets \code{errno} to either \code{EFAULT} or \code{EINTR}.
#' 
#' @author Wei-Chen Chen \email{wccsnow@@gmail.com}.
#' 
#' @references ZeroMQ/4.1.0 API Reference:
#' \url{http://api.zeromq.org/4-1:_start}
#' 
#' Programming with Big Data in R Website: \url{http://r-pbd.org/}
#' 
#' @examples
#' \dontrun{
#' library(pbdZMQ, quietly = TRUE)
#' 
#' context <- zmq.ctx.new()
#' zmq.ctx.destroy(context)
#' }
#' 
#' @keywords programming
#' @seealso \code{\link{zmq.socket}()}, \code{\link{zmq.close}()},
#' \code{\link{zmq.bind}()}, \code{\link{zmq.connect}()}.
#' @rdname a0_d_context
#' @name Context Functions
NULL



#' @rdname a0_d_context
#' @export
zmq.ctx.new <- function(){
  ret <- .Call("R_zmq_ctx_new", PACKAGE = "pbdZMQ")
  ### Users are responsible to take care free and gc.
  # reg.finalizer(ret, zmq.ctx.destroy, TRUE)
  ret
}



#' @rdname a0_d_context
#' @export
zmq.ctx.destroy <- function(ctx){
  .Call("R_zmq_ctx_destroy", ctx, PACKAGE = "pbdZMQ")
  invisible()
}

