% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bab.R
\name{bab}
\alias{bab}
\alias{BranchAndBound}
\title{Branch and bound for finding all most parsimonious trees}
\usage{
bab(data, tree = NULL, trace = 1, ...)
}
\arguments{
\item{data}{an object of class phyDat.}

\item{tree}{a phylogenetic tree an object of class phylo, otherwise a
pratchet search is performed.}

\item{trace}{defines how much information is printed during optimization.}

\item{\dots}{Further arguments passed to or from other methods}
}
\value{
\code{bab} returns all most parsimonious trees in an object of class
\code{multiPhylo}.
}
\description{
\code{bab} finds all most parsimonious trees.
}
\details{
This implementation is very slow and depending on the data may take very
long time. In the worst case all
\eqn{(2n-5)!! = 1 \times 3 \times 5 \times \ldots \times (2n-5)}{1 * 3 * 5 * ... * (2n-5)}  possible trees have to be
examined, where n is the number of species / tips. For 10 species there are
already 2027025 tip-labelled unrooted trees. It only uses some basic
strategies to find a lower and upper bounds similar to penny from phylip.
\code{bab} uses a very basic heuristic approach of MinMax Squeeze
(Holland et al. 2005) to improve the lower bound.  On the positive side
\code{bab} is not like many other implementations restricted to binary or
nucleotide data.
}
\examples{

data(yeast)
dfactorial(11)
# choose only the first two genes
gene12 <- yeast[, 1:3158]
trees <- bab(gene12)

}
\references{
Hendy, M.D. and Penny D. (1982) Branch and bound algorithms to
determine minimal evolutionary trees.  \emph{Math. Biosc.} \bold{59},
277-290

Holland, B.R., Huber, K.T. Penny, D. and Moulton, V. (2005) The MinMax
Squeeze: Guaranteeing a Minimal Tree for Population Data, \emph{Molecular
Biology and Evolution}, \bold{22}, 235--242

White, W.T. and Holland, B.R. (2011) Faster exact maximum parsimony search
with XMP. \emph{Bioinformatics}, \bold{27(10)},1359--1367
}
\seealso{
\code{\link{pratchet}}, \code{\link{dfactorial}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com} based on work on Liam
Revell
}
\keyword{cluster}
