% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyCub.midpoint.R
\name{polyCub.midpoint}
\alias{polyCub.midpoint}
\title{Two-Dimensional Midpoint Rule}
\usage{
polyCub.midpoint(polyregion, f, ..., eps = NULL, dimyx = NULL,
  plot = FALSE)
}
\arguments{
\item{polyregion}{a polygonal integration domain.
It can be any object coercible to the \pkg{spatstat} class
\code{"\link[spatstat]{owin}"} via a corresponding
\code{\link[spatstat]{as.owin}}-method.
Note that this includes polygons of the classes \code{"gpc.poly"} and
\code{"\linkS4class{SpatialPolygons}"}, because \pkg{polyCub} defines
methods \code{\link{as.owin.gpc.poly}} and
\code{\link{as.owin.SpatialPolygons}}, respectively.}

\item{f}{a two-dimensional real function.
As its first argument it must take a coordinate matrix, i.e., a
numeric matrix with two columns, and it must return a numeric vector of
length the number of coordinates.}

\item{...}{further arguments for \code{f}.}

\item{eps}{width and height of the pixels (squares),
see \code{\link[spatstat]{as.mask}}.}

\item{dimyx}{number of subdivisions in each dimension,
see \code{\link[spatstat]{as.mask}}.}

\item{plot}{logical indicating if an illustrative plot of the numerical
integration should be produced.}
}
\value{
The approximated value of the integral of \code{f} over
\code{polyregion}.
}
\description{
The surface is converted to a binary pixel image
using the \code{\link[spatstat]{as.im.function}} method from package
\pkg{spatstat} (Baddeley and Turner, 2005).
The integral under the surface is then approximated as the
sum over (pixel area * f(pixel midpoint)).
}
\examples{
# see example(polyCub)
}
\references{
Baddeley, A. and Turner, R. (2005).
\pkg{spatstat}: an \R package for analyzing spatial point patterns.
\emph{Journal of Statistical Software}, \bold{12} (6), 1-42.
}
\seealso{
Other polyCub-methods: \code{\link{polyCub.SV}},
  \code{\link{polyCub.exact.Gauss}},
  \code{\link{polyCub.iso}}, \code{\link{polyCub}}
}
\keyword{math}
\keyword{spatial}
