% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin2factor.R
\name{step_bin2factor}
\alias{step_bin2factor}
\title{Create a Factors from A Dummy Variable}
\usage{
step_bin2factor(recipe, ..., role = NA, trained = FALSE, levels = c("yes",
  "no"), columns = NULL)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of 
operations for this recipe.}

\item{...}{Selector functions that choose which variables will be converted.
See \code{\link{selections}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing 
have been estimated.}

\item{levels}{A length 2 character string that indicate the factor levels
for the 1's (in the first position) and the zeros (second)}

\item{columns}{A vector with the selected variable names. This is
\code{NULL} until computed by \code{\link{prep.recipe}}.}
}
\value{
An updated version of \code{recipe} with the
  new step added to the sequence of existing steps (if any).
}
\description{
\code{step_bin2factor} creates a \emph{specification} of a recipe step that
will create a two-level factor from a single dummy variable.
}
\details{
This operation may be useful for situations where a binary piece of
  information may need to be represented as categorical instead of numeric.
  For example, naive Bayes models would do better to have factor predictors
  so that the binomial distribution is modeled in stead of a Gaussian
  probability density of numeric binary data.
Note that the numeric data is only verified to be numeric (and does not
count levels).
}
\examples{
data(covers)

rec <- recipe(~ description, covers) \%>\%
 step_regex(description, pattern = "(rock|stony)", result = "rocks") \%>\%
 step_regex(description, pattern = "(rock|stony)", result = "more_rocks") \%>\%
 step_bin2factor(rocks)

rec <- prep(rec, training = covers)
results <- bake(rec, newdata = covers)

table(results$rocks, results$more_rocks)
}
\concept{
preprocessing dummy_variables factors
}
\keyword{datagen}
