% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse-inject.R
\name{qq_show}
\alias{qq_show}
\title{Show injected expression}
\arguments{
\item{expr}{An expression involving \link[=topic-inject]{injection operators}.}
}
\description{
\code{qq_show()} helps examining \link[=topic-inject]{injected expressions}
inside a function. This is useful for learning about injection and
for debugging injection code.
}
\section{Examples}{


\code{qq_show()} shows the intermediary expression before it is
evaluated by R:\if{html}{\out{<div class="sourceCode r">}}\preformatted{list2(!!!1:3)
#> [[1]]
#> [1] 1
#> 
#> [[2]]
#> [1] 2
#> 
#> [[3]]
#> [1] 3

qq_show(list2(!!!1:3))
#> list2(1L, 2L, 3L)
}\if{html}{\out{</div>}}

It is especially useful inside functions to reveal what an injected
expression looks like:\if{html}{\out{<div class="sourceCode r">}}\preformatted{my_mean <- function(data, var) \{
  qq_show(data \%>\% dplyr::summarise(mean(\{\{ var \}\})))
\}

mtcars \%>\% my_mean(cyl)
#> data \%>\% dplyr::summarise(mean(^cyl))
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \ifelse{html}{\link[=topic-inject]{Injecting with !!, !!!, and glue syntax}}{\link[=topic-inject]{Injecting with !!, !!!, and glue syntax}}
}
}
