\name{permutation}
\alias{permutation}
\title{Sequence permutation according to several different models}
\description{
  Generates a random permutation of a given sequence, according to a
  given model. Available models are : \code{base}, \code{position},
  \code{codon}, \code{syncodon}.
}
\usage{permutation(sequence,modele='base',frame=0,
 replace=FALSE,prot=FALSE,numcode=1,ucoweight = NULL)}
\arguments{
  \item{sequence}{ A nucleic acids sequence }
  \item{modele}{ A string of characters describing the model chosen for
    the random generation }
  \item{frame}{ Only active for the \code{position}, \code{codon},
    \code{syncodon} models: starting position of CDS as in \code{splitseq} }
  \item{replace}{ This option is not active for the \code{syncodon}
    model: if \code{TRUE}, sampling is done with replacement }
  \item{prot}{ Only available for the \code{codon} model: if \code{TRUE}, the first and last codons are preserved, and only intern codons are shuffled }
  \item{numcode}{ Only available for the \code{syncodon} model: the
    genetic code number as in \code{translate}. }
  \item{ucoweight}{ A list of weights containing the desired codon usage
    bias as generated by \code{ucoweight}. If none is specified, the
    codon usage of the given sequence is used. }
}
\value{
  a sequence generated from the original one by a given model
}
\details{
  The \code{base} model allows for random sequence generation by
  shuffling (with/without replacement) of all bases in the sequence.

  The \code{position} model allows for random sequence generation
  by shuffling (with/without replacement) of bases within their
  position in the codon (bases in position I, II or III stay in
  position I, II or III in the new sequence.

  The \code{codon} model allows for random sequence generation by
  shuffling (with/without replacement) of codons.

  The \code{syncodon} model allows for random sequence generation
  by shuffling (with/without replacement) of synonymous codons.
  }
\references{
  \code{citation("seqinr")}
}
\author{L. Palmeira}
\seealso{ \code{\link{synsequence}} }
\examples{
  data(ec999)
  sequence=ec999[1][[1]]

  new=permutation(sequence,modele='base')
  identical(all.equal(count(new,1),count(sequence,1)),TRUE)

  new=permutation(sequence,modele='position')
  identical(all.equal(GC(new),GC(sequence)),TRUE)
  identical(all.equal(GC2(new),GC2(sequence)),TRUE)
  identical(all.equal(GC3(new),GC3(sequence)),TRUE)

  new=permutation(sequence,modele='codon')
  identical(all.equal(uco(new),uco(sequence)),TRUE)

  new=permutation(sequence,modele='syncodon',numcode=1)
  identical(all.equal(translate(new),translate(sequence)),TRUE)
}
\keyword{ utilities }
