% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thematic-save-plot.R
\name{thematic_save_plot}
\alias{thematic_save_plot}
\alias{default_device}
\title{Capture a thematic plot as a saved file}
\usage{
thematic_save_plot(
  expr,
  device = default_device(),
  filename = tempfile(fileext = ".png"),
  ...
)

default_device(type = c("png", "svg", "pdf", "tiff", "jpeg"))
}
\arguments{
\item{expr}{an expression that produces a plot.}

\item{device}{a graphics device to use for capturing the plot.}

\item{filename}{a filename for the produced plot. The file extension should
match the relevant \code{device}.}

\item{...}{arguments passed along to the graphics \code{device}.}

\item{type}{the type of output format}
}
\value{
\code{thematic_save_plot()} returns the \code{filename} of the produced plot
and \code{default_device()} returns a graphics device function.
}
\description{
Uses a \code{device} to capture the result of an expression (\code{expr})
that produces a plot. If \code{default_device()} is used, custom fonts
(specified through \code{\link[=font_spec]{font_spec()}}) are guaranteed to work, as long as
one of either the showtext or ragg package(s) are installed.
}
\examples{

library(thematic)
font <- font_spec("Rock Salt", scale = 1.25)
thematic_on("black", "white", font = font)
file <- thematic_save_plot(plot(1:10), res = 144)
if (interactive()) browseURL(file)
}
