% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus_tidiers.R
\name{corpus_tidiers}
\alias{corpus_tidiers}
\alias{tidy.corpus}
\alias{glance.corpus}
\title{Tidiers for a corpus object from the quanteda package}
\usage{
\method{tidy}{corpus}(x, ...)

\method{glance}{corpus}(x, ...)
}
\arguments{
\item{x}{A Corpus object, such as a VCorpus or PCorpus}

\item{...}{Extra arguments, not used}
}
\description{
Tidy a corpus object from the quanteda package. \code{tidy} returns a
tbl_df with one-row-per-document, with a \code{text} column containing
the document's text, and one column for each document-level metadata.
\code{glance} returns a one-row tbl_df with corpus-level metadata,
such as source and created. For Corpus objects from the tm package,
see \code{\link{tidy.Corpus}}.
}
\details{
For the most part, the \code{tidy} output is equivalent to the
"documents" data frame in the corpus object, except that it is converted
to a tbl_df, and \code{texts} column is renamed to \code{text}
to be consistent with other uses in tidytext.

Similarly, the \code{glance} output is simply the "metadata" object,
with NULL fields removed and turned into a one-row tbl_df.
}
\examples{

if (requireNamespace("quanteda", quietly = TRUE)) {
 data("data_corpus_inaugural", package = "quanteda")

 data_corpus_inaugural

 tidy(data_corpus_inaugural)
}

}
