#! /usr/bin/env perl

# Test package that computes default database settings; test 'ORDER BY'
# clause generation:

use strict;
use warnings;
use utf8;
use Data::Dumper;

use lib 'lib';
use Database;
use Database::Order;

binmode( STDOUT, "utf8" );

my $db2_settings = {
    content_db => {
        DB => "tests/inputs/db/empty.db2",
        engine => 'SQLite2'
    }
};

my $db3_settings = {
    content_db => {
        DB => "tests/inputs/db/empty.db3",
        engine => 'SQLite'
    }
};

my @cases = (
    [ $db2_settings,   'field1:a,field2:d,field3' ],
    [ $db3_settings,   'field1:a,field2:d,field3' ],
);

my $n = 0;
for my $case (@cases) {
    local $\ = "\n";

    print "\ntest ", ++$n, ":";
    
    my $db = Database->new( $case->[0] );

    # Hiding metadata tables:
    delete $db->{db}{meta};

    $db->connect();

    print "engine = ", $case->[0]{content_db}{engine}, ", order = ", $case->[1];
    my $order = Database::Order->new_from_string( $case->[1], 'default_table' );
    print $order->order_clause( $db->{db}{content}{delim} );
}
