///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// Hermitte cubic approximation
//
#include "basis_symbolic_hermite.h"
using namespace rheolef;
using namespace std;

class H3_symbolic : public basis_symbolic_hermite
{
public:
    H3_symbolic ();
};
H3_symbolic::H3_symbolic ()
: basis_symbolic_hermite("H3",3)
{
  on('p') << node(0) 
  	  << node_derivative (x, 1, 0)
	  << poly (1)
  	  << poly (x) << end;
  on('e') << node (0)
	  << node (1)
	  << node_derivative (x, -1, 0)  // second argument is the x component of the outward normal
	  << node_derivative (x, 1,  1)
	  << poly (1)
	  << poly (x)
	  << poly (x*x)
	  << poly (x*x*x)
	  << end;
}
int main (int argc, char **argv) {
	H3_symbolic H3;
	H3.put_cxx_main (argc,argv);
}
