#ifndef RIPOFFPREFERENCES_H
#define RIPOFFPREFERENCES_H
#include "lib/RipOff.h"
#include "RipOffPluginList.h"

struct RipOffPreferences_
{
	gchar *cd_path;
	gchar *file_pattern;
	gchar *output_folder;
	RipOffPluginList plugins;
	RipOffPlugin selected;
};
typedef struct RipOffPreferences_ * RipOffPreferences;

/* Sets up all the preferences member variables. Uses default values if no configuration file is 
   found, otherwise uses values stored in configuration file */
RipOffPreferences ripoff_preferences_new();

/* Brings up the ripoff preferences window */
void ripoff_preferences_draw_window(RipOffPreferences pref, GtkWidget *main_window);

/* used to inform the preferences object that all settings need to be saved. Periodically called
   and also called when Ripoff is closing */
gboolean ripoff_preferences_save(RipOffPreferences pref);

const gchar *ripoff_preferences_get_cd_device_path(RipOffPreferences pref);

const gchar *ripoff_preferences_get_file_pattern(RipOffPreferences pref);

const gchar *ripoff_preferences_get_output_folder(RipOffPreferences pref);

RipOffPlugin ripoff_preferences_get_plugin(RipOffPreferences pref);
#endif
