# The Rustc Book

- [What is rustc?](what-is-rustc.md)
- [Command-line Arguments](command-line-arguments.md)
    - [Codegen Options](codegen-options/index.md)
- [Lints](lints/index.md)
    - [Lint Levels](lints/levels.md)
    - [Lint Groups](lints/groups.md)
    - [Lint Listing](lints/listing/index.md)
        - [Allowed-by-default Lints](lints/listing/allowed-by-default.md)
        - [Warn-by-default Lints](lints/listing/warn-by-default.md)
        - [Deny-by-default Lints](lints/listing/deny-by-default.md)
- [JSON Output](json.md)
- [Tests](tests/index.md)
- [Platform Support](platform-support.md)
    - [Target Tier Policy](target-tier-policy.md)
    - [Template for Target-specific Documentation](platform-support/TEMPLATE.md)
    - [arm64e-apple-ios.md](platform-support/arm64e-apple-ios.md)
    - [arm64e-apple-darwin.md](platform-support/arm64e-apple-darwin.md)
    - [aarch64-apple-ios-sim](platform-support/aarch64-apple-ios-sim.md)
    - [arm64ec-pc-windows-msvc](platform-support/arm64ec-pc-windows-msvc.md)
    - [\*-apple-tvos](platform-support/apple-tvos.md)
    - [\*-apple-watchos\*](platform-support/apple-watchos.md)
    - [aarch64-apple-visionos\*](platform-support/apple-visionos.md)
    - [aarch64-nintendo-switch-freestanding](platform-support/aarch64-nintendo-switch-freestanding.md)
    - [armeb-unknown-linux-gnueabi](platform-support/armeb-unknown-linux-gnueabi.md)
    - [arm-none-eabi](platform-support/arm-none-eabi.md)
    - [armv4t-none-eabi](platform-support/armv4t-none-eabi.md)
    - [armv5te-none-eabi](platform-support/armv5te-none-eabi.md)
    - [armv7r-none-eabi](platform-support/armv7r-none-eabi.md)
    - [armv8r-none-eabihf](platform-support/armv8r-none-eabihf.md)
    - [armv6k-nintendo-3ds](platform-support/armv6k-nintendo-3ds.md)
    - [armv7-sony-vita-newlibeabihf](platform-support/armv7-sony-vita-newlibeabihf.md)
    - [armv7-unknown-linux-uclibceabi](platform-support/armv7-unknown-linux-uclibceabi.md)
    - [armv7-unknown-linux-uclibceabihf](platform-support/armv7-unknown-linux-uclibceabihf.md)
    - [\*-android and \*-androideabi](platform-support/android.md)
    - [\*-linux-ohos](platform-support/openharmony.md)
    - [\*-hurd-gnu](platform-support/hurd.md)
    - [aarch64-unknown-teeos](platform-support/aarch64-unknown-teeos.md)
    - [\*-esp-espidf](platform-support/esp-idf.md)
    - [\*-unknown-fuchsia](platform-support/fuchsia.md)
    - [\*-kmc-solid_\*](platform-support/kmc-solid.md)
    - [csky-unknown-linux-gnuabiv2\*](platform-support/csky-unknown-linux-gnuabiv2.md)
    - [hexagon-unknown-linux-musl](platform-support/hexagon-unknown-linux-musl.md)
    - [hexagon-unknown-none-elf](platform-support/hexagon-unknown-none-elf.md)
    - [loongarch\*-unknown-linux-\*](platform-support/loongarch-linux.md)
    - [loongarch\*-unknown-none\*](platform-support/loongarch-none.md)
    - [m68k-unknown-linux-gnu](platform-support/m68k-unknown-linux-gnu.md)
    - [mips64-openwrt-linux-musl](platform-support/mips64-openwrt-linux-musl.md)
    - [mipsel-sony-psx](platform-support/mipsel-sony-psx.md)
    - [mipsisa\*r6\*-unknown-linux-gnu\*](platform-support/mips-release-6.md)
    - [nvptx64-nvidia-cuda](platform-support/nvptx64-nvidia-cuda.md)
    - [powerpc64-ibm-aix](platform-support/aix.md)
    - [riscv32im-risc0-zkvm-elf](platform-support/riscv32im-risc0-zkvm-elf.md)
    - [riscv32imac-unknown-xous-elf](platform-support/riscv32imac-unknown-xous-elf.md)
    - [riscv32*-unknown-none-elf](platform-support/riscv32-unknown-none-elf.md)
    - [sparc-unknown-none-elf](./platform-support/sparc-unknown-none-elf.md)
    - [*-pc-windows-gnullvm](platform-support/pc-windows-gnullvm.md)
    - [\*-nto-qnx-\*](platform-support/nto-qnx.md)
    - [*-unikraft-linux-musl](platform-support/unikraft-linux-musl.md)
    - [*-unknown-hermit](platform-support/hermit.md)
    - [\*-unknown-netbsd\*](platform-support/netbsd.md)
    - [*-unknown-openbsd](platform-support/openbsd.md)
    - [\*-unknown-uefi](platform-support/unknown-uefi.md)
    - [wasm32-wasip1](platform-support/wasm32-wasip1.md)
    - [wasm32-wasip1-threads](platform-support/wasm32-wasip1-threads.md)
    - [wasm32-wasip2](platform-support/wasm32-wasip2.md)
    - [wasm64-unknown-unknown](platform-support/wasm64-unknown-unknown.md)
    - [\*-win7-windows-msvc](platform-support/win7-windows-msvc.md)
    - [x86_64-fortanix-unknown-sgx](platform-support/x86_64-fortanix-unknown-sgx.md)
    - [x86_64-unknown-none](platform-support/x86_64-unknown-none.md)
    - [x86_64h-apple-darwin](platform-support/x86_64h-apple-darwin.md)
- [Targets](targets/index.md)
    - [Built-in Targets](targets/built-in.md)
    - [Custom Targets](targets/custom.md)
    - [Known Issues](targets/known-issues.md)
- [Profile-guided Optimization](profile-guided-optimization.md)
- [Instrumentation-based Code Coverage](instrument-coverage.md)
- [Linker-plugin-based LTO](linker-plugin-lto.md)
- [Checking conditional configurations](check-cfg.md)
- [Exploit Mitigations](exploit-mitigations.md)
- [Symbol Mangling](symbol-mangling/index.md)
    - [v0 Symbol Format](symbol-mangling/v0.md)
- [Contributing to `rustc`](contributing.md)
