#!/bin/sh

INPATH=$(dirname "$0")
OUTPATH="${INPATH}/../../.github/workflows/ci.yaml"

gen_job () {
    grep -v "skip-$2" "$INPATH/$1-template.yaml" >> "$OUTPATH"
}

cat << 'EOF' > "$OUTPATH"
# GitHub Actions workflow generated by ci/actions-templates/gen-workflows.sh
# Do not edit this file in .github/workflows

name: CI

on:
  merge_group:
  pull_request:
    branches:
      - "*"
  push:
    branches:
      - master
      - stable
  schedule:
    - cron: "30 0 * * 1" # Every Monday at half past midnight UTC

jobs:
EOF

gen_job windows-builds pr
gen_job windows-builds master
gen_job windows-builds stable

gen_job linux-builds pr
gen_job linux-builds master
gen_job linux-builds stable

gen_job macos-builds x86_64
gen_job macos-builds aarch64

gen_job freebsd-builds master
gen_job freebsd-builds stable

# The following targets only have a single job
gen_job centos-fmt-clippy all
gen_job all-features all
gen_job test-docs all

# Finally, we generate the conclusion,
# adding all the `# job-name` jobs to the `needs` list.
gen_job conclusion all
cat "$INPATH"/*-template.yaml | perl -nE 'say "      - $1" if (m/^\s*([\w-_]+)\s*:.*job-name.*$/)' >> "$OUTPATH"
