<?php
/**
 * DokuWiki Bootstrap3 Template: Sidebar
 *
 * @link     http://dokuwiki.org/template:bootstrap3
 * @author   Giuseppe Di Terlizzi <giuseppe.diterlizzi@gmail.com>
 * @license  GPL 2 (http://www.gnu.org/licenses/gpl.html)
 */

global $TPL;
global $ACT;

$sidebar_title = $lang['sidebar'];

if ($TPL->getConf('sidebarShowPageTitle')) {
    $sidebar_title = p_get_first_heading(page_findnearest($sidebar_page, $TPL->getConf('useACL')));
    if (! $sidebar_title) $sidebar_title = $lang['sidebar'];
}

?>
<!-- sidebar -->
<aside id="<?php echo $sidebar_id ?>" class="dw__sidebar <?php echo $sidebar_class ?> hidden-print">
    <div class="dw-sidebar-content">
        <div class="dw-sidebar-title hidden-lg hidden-md hidden-sm" data-toggle="collapse" data-target="#<?php echo $sidebar_id ?> .dw-sidebar-body">
            <?php echo iconify('mdi:view-list'); ?> <?php echo $sidebar_title ?>
        </div>
        <div class="dw-sidebar-body collapse in small">
            <?php

                html_navigate();
                tpl_includeFile("$sidebar_header.html");
                if ($ACT == 'show') $TPL->includePage($sidebar_header);

                $TPL->normalizeSidebar(tpl_include_page($sidebar_page, 0, 1, $TPL->getConf('useACL'))); /* includes the nearest sidebar page */

                tpl_includeFile("$sidebar_footer.html");
                if ($ACT == 'show') $TPL->includePage($sidebar_footer)

            ?>
        </div>
    </div>
</aside>
<!-- /sidebar -->

<?php
// ENVOLE

function myhtml_index($ns){
    global $conf;
    global $ID;
    $ns  = cleanID($ns);
    #fixme use appropriate function
    if(empty($ns)){
        $ns = dirname(str_replace(':','/',$ID));
        if($ns == '.') $ns ='';
    }
    $ns  = utf8_encodeFN(str_replace(':','/',$ns));

    //echo p_locale_xhtml('index');
    //echo '<div class="bs-sidebar" role="navigation"><ul class="nav">';
	echo '<div class="monplan" id="index__tree"><h4 class="sectionedit4 text-primary">PLAN DU SITE</h4>';

    $data = array();
    search($data,$conf['datadir'],'search_index',array('ns' => $ns));
    echo html_buildlist($data,'idx','html_list_index','html_li_index');

    echo '</div>';
    //echo '</ul></div>';
 }

// recursive function to establish best navigate file to be used
function getNavigateFN($ns, $file) {

	// check for wiki page = $ns:$file (or $file where no namespace)
	$nsFile = ($ns) ? "$ns:$file" : $file;
	if (file_exists(wikiFN($nsFile))) return $nsFile;

	// no namespace left, exit with no file found
	if (!$ns) return '';

	$i = strrpos($ns, ":");
	$ns = ($i) ? substr($ns, 0, $i) : false;
	return getNavigateFN($ns, $file);
}

function html_navigate() {
	global $ID;
	global $REV;
	global $conf;

	// save globals
	$saveID = $ID;
	$saveREV = $REV;

	// discover file to be displayed in navigation sidebar
	$fileNavigate = '';

	if (isset($conf['navigate'])) {
		$fileNavigate = getNavigateFN(getNS($ID), $conf['navigate']);
	}

	// determine what to display
	if ($fileNavigate) {
		$ID = $fileNavigate;
		$REV = '';
		print p_wiki_xhtml($ID,$REV,false);
	}
	else {
		myhtml_index('.');
	}

	// close navigate <div>	and restore globals
	$ID = $saveID;
	$REV = $saveREV;

	return $ret;
}
?>
