/*
 * Decompiled with CFR 0.152.
 */
package gong.audio.data;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.xiph.speex.AudioFileWriter;
import org.xiph.speex.OggCrc;

public class OggSpeexWriter
extends AudioFileWriter {
    public static final int PACKETS_PER_OGG_PAGE = 250;
    private ByteArrayOutputStream out;
    private int mode;
    private int sampleRate;
    private int channels;
    private int nframes;
    private boolean vbr;
    private int size;
    private int streamSerialNumber;
    private byte[] dataBuffer;
    private int dataBufferPtr;
    private byte[] headerBuffer;
    private int headerBufferPtr;
    private int pageCount;
    private int packetCount;
    private long granulepos;

    public OggSpeexWriter() {
        if (this.streamSerialNumber == 0) {
            this.streamSerialNumber = new Random().nextInt();
        }
        this.dataBuffer = new byte[65565];
        this.dataBufferPtr = 0;
        this.headerBuffer = new byte[255];
        this.headerBufferPtr = 0;
        this.pageCount = 0;
        this.packetCount = 0;
        this.granulepos = 0L;
    }

    public OggSpeexWriter(int n, int n2, int n3, int n4, boolean bl) {
        this();
        this.setFormat(n, n2, n3, n4, bl);
    }

    private void setFormat(int n, int n2, int n3, int n4, boolean bl) {
        this.mode = n;
        this.sampleRate = n2;
        this.channels = n3;
        this.nframes = n4;
        this.vbr = bl;
    }

    public void setSerialNumber(int n) {
        this.streamSerialNumber = n;
    }

    public void close() throws IOException {
        this.flush(true);
        this.out.close();
    }

    public void open(File file) throws IOException {
        this.out = new ByteArrayOutputStream();
        this.size = 0;
    }

    public void open(String string) throws IOException {
        this.out = new ByteArrayOutputStream();
        this.size = 0;
    }

    public byte[] getData() {
        if (this.out == null) {
            return null;
        }
        return this.out.toByteArray();
    }

    public void writeHeader(String string) throws IOException {
        byte[] byArray = OggSpeexWriter.buildOggPageHeader(2, 0L, this.streamSerialNumber, this.pageCount++, 1, new byte[]{80});
        byte[] byArray2 = OggSpeexWriter.buildSpeexHeader(this.sampleRate, this.mode, this.channels, this.vbr, this.nframes);
        int n = OggCrc.checksum(0, byArray, 0, byArray.length);
        n = OggCrc.checksum(n, byArray2, 0, byArray2.length);
        OggSpeexWriter.writeInt(byArray, 22, n);
        this.out.write(byArray);
        this.out.write(byArray2);
        byArray = OggSpeexWriter.buildOggPageHeader(0, 0L, this.streamSerialNumber, this.pageCount++, 1, new byte[]{(byte)(string.length() + 8)});
        byArray2 = OggSpeexWriter.buildSpeexComment(string);
        n = OggCrc.checksum(0, byArray, 0, byArray.length);
        n = OggCrc.checksum(n, byArray2, 0, byArray2.length);
        OggSpeexWriter.writeInt(byArray, 22, n);
        this.out.write(byArray);
        this.out.write(byArray2);
    }

    public void writePacket(byte[] byArray, int n, int n2) throws IOException {
        if (n2 <= 0) {
            return;
        }
        if (this.packetCount > 250) {
            this.flush(false);
        }
        System.arraycopy(byArray, n, this.dataBuffer, this.dataBufferPtr, n2);
        this.dataBufferPtr += n2;
        this.headerBuffer[this.headerBufferPtr++] = (byte)n2;
        ++this.packetCount;
        this.granulepos += (long)(this.nframes * (this.mode == 2 ? 640 : (this.mode == 1 ? 320 : 160)));
    }

    private void flush(boolean bl) throws IOException {
        byte[] byArray = OggSpeexWriter.buildOggPageHeader(bl ? 4 : 0, this.granulepos, this.streamSerialNumber, this.pageCount++, this.packetCount, this.headerBuffer);
        int n = OggCrc.checksum(0, byArray, 0, byArray.length);
        n = OggCrc.checksum(n, this.dataBuffer, 0, this.dataBufferPtr);
        OggSpeexWriter.writeInt(byArray, 22, n);
        this.out.write(byArray);
        this.out.write(this.dataBuffer, 0, this.dataBufferPtr);
        this.dataBufferPtr = 0;
        this.headerBufferPtr = 0;
        this.packetCount = 0;
    }
}

