<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_adaptable', language 'fr', branch 'MOODLE_31_STABLE'
 *
 * @package   theme_adaptable
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['activebreadcrumb'] = 'Couleur d\'arrière-plan du fil d\'ariane actif';
$string['activebreadcrumbdesc'] = 'Configurer la couleur d\'arrière-plan du fil d\'ariane actif';
$string['alertaccess'] = 'Visibilité de l\'alerte';
$string['alertaccessadmins'] = 'Visible pour les administrateurs';
$string['alertaccessdesc'] = 'Configurer les règles d\'accès pour la visibilité des alertes. Note : si vous utilisez "Ajouter une restriction pour le profil personnalisé" vous devez remplir le champ ci-dessous.';
$string['alertaccessglobal'] = 'Visible pour tout le monde';
$string['alertaccessprofile'] = 'Ajouter une restriction pour le profil personnalisé';
$string['alertaccessusers'] = 'Visible pour les utilisateurs authentifiés';
$string['alertannounce'] = 'Annonces';
$string['alertcount'] = 'Nombre d\'alertes';
$string['alertcountdesc'] = 'Nombre d\'alertes à afficher';
$string['alertdesc'] = 'Saisir et personnaliser un texte à afficher comme alerte en haut du site. Il est possible de paramétrer plusieurs alertes pour cibler différents publics. Vous pouvez également afficher les alertes sur tout le site ou uniquement sur les pages d\'accueil.';
$string['alertinfo'] = 'Info';
$string['alertinfodesc'] = 'Afficher une annonce dans la boîte d\'alerte';
$string['alertkeyvalue'] = 'Code d\'alerte';
$string['alertkeyvalue_details'] = 'Code qui permet de distinguer cette alerte des alertes précédentes. Si vous changez ce code, tous les utilisateurs qui ont enlevé l\'alerte auparavant, la reverront. Si vous changez l\'alerte, changez ce code pour vous assurer que tous les utilisateurs la voient.';
$string['alertprofilefield'] = 'Champ pour le profil personnalisé. Nom=Valeur (optionnel)';
$string['alertprofilefielddesc'] = 'Ajouter une règle d\'accès en créant un profil personnalisé. Exemple : "usertype=student"';
$string['alertsettings'] = 'Boîte d\'alerte {$a}';
$string['alertsettingsgeneral'] = 'Paramètres généraux des Alertes';
$string['alertsettingsheading'] = 'Personnaliser l\'alerte. Voir la configuration <a href="./../theme/adaptable/pix/layout.png" target="_blank">ici</a>';
$string['alerttext'] = 'Texte d\'alerte';
$string['alerttextdesc'] = 'Saisir le texte à afficher comme message d\'alerte';
$string['alerttype'] = 'Type de message d\'alerte';
$string['alerttypedesc'] = 'Indiquer le type d\'alerte : info (bleu), attention (jaune) ou annonces (vert)';
$string['alertwarning'] = 'Attention';
$string['analyticscount'] = 'Nombre de champs Analytics';
$string['analyticscountdesc'] = 'Nombre de champs Analytics à afficher dans la zone ci-dessous.';
$string['analyticsprofilefield'] = 'Champ pour le profil personnalisé. Nom=Valeur (optionnel)';
$string['analyticsprofilefielddesc'] = 'Ajouter une règle d\'accès en créant un profil personnalisé. Exemple : "usertype=student"';
$string['analyticssettings'] = 'Analytics';
$string['analyticssettingsdesc'] = 'Vous pouvez configurer plusieurs codes pour Google Analytics et cibler des profils personnalisés';
$string['analyticssettingsheading'] = 'Configurer Google Analytics';
$string['analyticstext'] = 'ID Google Analytics';
$string['analyticstextdesc'] = 'Saisir l\'ID Google Analytics';
$string['backcolor'] = 'Couleur d\'arrière-plan';
$string['backcolordesc'] = 'Paramétrer la couleur d\'arrière-plan';
$string['blockbackgroundcolor'] = 'Couleur d\'arrière-plan du bloc';
$string['blockbackgroundcolordesc'] = 'Configurer la couleur d\'arrière-plan pour tous les blocs';
$string['blockbordercolor'] = 'Couleur de bordure du bloc';
$string['blockbordercolordesc'] = 'Configurer la couleur de bordure du bloc';
$string['blockheaderbackgroundcolor'] = 'Couleur d\'arrière-plan pour l\'en-tête de bloc';
$string['blockheaderbackgroundcolordesc'] = 'Configurer la couleur d\'arrière-plan de l\'en-tête de tous les blocs';
$string['blockheaderborderbottom'] = 'Epaisseur de la bordure du bas de l\'en-tête de bloc';
$string['blockheaderborderbottomdesc'] = 'Configurer l\'épaisseur de la bordure du bas des en-têtes de bloc';
$string['blockheaderborderleft'] = 'Epaisseur de la bordure de gauche de l\'en-tête de bloc';
$string['blockheaderborderleftdesc'] = 'Configurer l\'épaisseur de la bordure de gauche des en-têtes de bloc';
$string['blockheaderborderright'] = 'Epaisseur de la bordure de droite de l\'en-tête de bloc';
$string['blockheaderborderrightdesc'] = 'Configurer l\'épaisseur de la bordure de droite des en-têtes de bloc';
$string['blockheaderbordertop'] = 'Epaisseur de la bordure du haut de l\'en-tête de bloc';
$string['blockheaderbordertopdesc'] = 'Configurer l\'épaisseur de la bordure du haut des en-têtes de bloc';
$string['blockheaderbordertopstyle'] = 'Style de bordure de l\'en-tête de bloc';
$string['blockheaderbordertopstyledesc'] = 'Configurer le style de bordure des en-têtes de bloc';
$string['blockheaderbottomradius'] = 'Rayon bas de l\'en-tête de bloc';
$string['blockheaderbottomradiusdesc'] = 'Configurer le rayon bas de l\'en-tête de bloc pour donner un effet arrondi';
$string['blockheadercolor'] = 'Couleur de police de l\'en-tête de bloc';
$string['blockheadercolordesc'] = 'Détermine la couleur de police de l\'en-tête de bloc';
$string['blockheadertopradius'] = 'Rayon haut de l\'en-tête de bloc';
$string['blockheadertopradiusdesc'] = 'Configurer le rayon bas de l\'en-tête de bloc pour donner un effet arrondi';
$string['blockicons'] = 'Icônes de bloc';
$string['blockiconsdesc'] = 'Activer pour afficher les icônes dans l\'en-tête du bloc';
$string['blocklayoutbuilder'] = 'Zones de bloc de la page d\'accueil';
$string['blocklayoutbuilderdesc'] = 'CI-dessous vous pouvez déterminer la disposition des zones de bloc de la page d\'accueil.
Pour ajouter du contenu dans ces zones, vous devez <strong>activer l\'édition sur la page d\'accueil de Moodle</strong>.
Vous pourrez ensuite glisser/déposer les blocs dans les zones créées.';
$string['blocklayoutlayoutcheck'] = 'Configurez la dispositions';
$string['blocklayoutlayoutcheckdesc'] = 'Utiliser l\'outil ci-dessous pour choisir le nombre de blocs à utiliser et voir la nouvelle disposition';
$string['blocklayoutlayoutcount1'] = 'Vous pouvez configurer un maximum de';
$string['blocklayoutlayoutcount2'] = 'zones de blocs. Vous utilisez actuellement :';
$string['blocklayoutlayoutrow'] = 'Ligne de blocs';
$string['blocklayoutlayoutrowdesc'] = 'Ajouter / configurer la disposition de la ligne de blocs sur la page d\'accueil';
$string['blocklinkcolor'] = 'Couleur des liens du bloc';
$string['blocklinkcolordesc'] = 'Configurer la couleur des liens des blocs';
$string['blocklinkhovercolor'] = 'Couleur des liens du bloc au survol';
$string['blocklinkhovercolordesc'] = 'Configurer la couleur des liens des blocs au survol';
$string['blockmainborderbottom'] = 'Epaisseur de la bordure du bas du bloc principal';
$string['blockmainborderbottomdesc'] = 'Configurer l\'épaisseur de la bordure du bas du bloc principal';
$string['blockmainborderleft'] = 'Epaisseur de la bordure gauche du bloc principal';
$string['blockmainborderleftdesc'] = 'Configurer l\'épaisseur de la bordure gauche du bloc principal';
$string['blockmainborderright'] = 'Epaisseur de la bordure droite du bloc principal';
$string['blockmainborderrightdesc'] = 'Configurer l\'épaisseur de la bordure droite du bloc principal';
$string['blockmainbordertop'] = 'Epaisseur de la bordure du haut du bloc principal';
$string['blockmainbordertopdesc'] = 'Configurer l\'épaisseur de la bordure du haut du bloc principal';
$string['blockmainbordertopstyle'] = 'Style de bordure du bloc principal';
$string['blockmainbordertopstyledesc'] = 'Configurer le style de bordure du bloc principal';
$string['blockmainbottomradius'] = 'Rayon bas du bloc principal';
$string['blockmainbottomradiusdesc'] = 'Paramétrer le rayon bas du bloc principal pour donner un effet arrondi';
$string['blockmaintopradius'] = 'Rayon haut du bloc principal';
$string['blockmaintopradiusdesc'] = 'Paramétrer le rayon haut du bloc principal pour donner un effet arrondi';
$string['blockregionbackground'] = 'Couleur d\'arrière-plan de la zone de blocs';
$string['blockregionbackgrounddesc'] = 'Couleur d\'arrière-plan du conteneur de la page d\'accueil dans lequel se trouvent les blocs personnalisés';
$string['blocksettings'] = 'Paramètres des blocs';
$string['blockside'] = 'Emplacement des blocs';
$string['blocksidedesc'] = 'Choisir si les blocs apparaissent à gauche ou à droite de la page';
$string['breadcrumb'] = 'Couleur d\'arrière-plan du fil d\'ariane';
$string['breadcrumbdesc'] = 'Configurer la couleur d\'arrière-plan du fil d\'ariane';
$string['breadcrumbhomedesc'] = 'Définir l\'accueil du fil d\'Ariane sous forme d’icône ou de texte';
$string['breadcrumbhometext'] = 'Texte';
$string['breadcrumbseparator'] = 'Séparateur du fil d\'ariane';
$string['breadcrumbtextcolor'] = 'Couleur de texte du fil d\'ariane';
$string['breadcrumbtextcolordesc'] = 'Configurer la couleur de texte du fil d\'ariane';
$string['breadcrumbtitle'] = 'Nom du cours dans le fil d\'ariane';
$string['breadcrumbtitledesc'] = 'Activer pour afficher le titre du cours dans le fil d\'ariane';
$string['breadcrumbtitlefullname'] = 'Nom complet du cours';
$string['breadcrumbtitleshortname'] = 'Nom abrégé du cours';
$string['buttoncolor'] = 'Couleur de bouton';
$string['buttoncolordesc'] = 'Couleur des principaux boutons utilisés à travers le site';
$string['buttondesc'] = 'Modifier l\'apparence des boutons utilisés dans ce thème';
$string['buttonhovercolor'] = 'Couleur de bouton au survol';
$string['buttonhovercolordesc'] = 'Couleur du bouton affichée lors du survol de celui-ci';
$string['buttonlogincolor'] = 'Couleur du bouton Connexion';
$string['buttonlogincolordesc'] = 'Couleur du bouton Connexion';
$string['buttonloginheight'] = 'Configurer la hauteur du bouton Connexion';
$string['buttonloginheightdesc'] = 'Seulement valable avec un formulaire de connexion dans l\'en-tête';
$string['buttonloginhovercolor'] = 'Couleur du bouton Connexion au survol';
$string['buttonloginhovercolordesc'] = 'Couleur du bouton Connexion au survol de celui-ci';
$string['buttonloginmargintop'] = 'Configurer la marge haute du bouton Connexion';
$string['buttonloginmargintopdesc'] = 'Permettre de modifier la position du bouton Connexion';
$string['buttonloginpadding'] = 'Configurer la marge intérieure du bouton Connexion';
$string['buttonloginpaddingdesc'] = 'Chiffre plus élevé = bouton plus grand';
$string['buttonlogintextcolor'] = 'Couleur de texte du bouton Connexion';
$string['buttonlogintextcolordesc'] = 'Couleur du texte du bouton Connexion';
$string['buttonradius'] = 'Configurer le rayon du bouton';
$string['buttonradiusdesc'] = 'Rayon élevé = boutons arrondis, rayon faible = boutons rectangulaires';
$string['buttonsettings'] = 'Boutons';
$string['buttonsettingsheading'] = 'Personnaliser les boutions du thème';
$string['buttontextcolor'] = 'Couleur de texte des boutons';
$string['buttontextcolordesc'] = 'Couleur du texte des boutons utilisés à travers le site. Utiliser le code HTML hexadecimal';
$string['cachedef_userdata'] = 'Cache de session utiliser pour stocker les données utilisateur spécifiques.';
$string['colordesc'] = 'Vous pouvez choisir les couleurs que vous souhaitez utiliser à travers tout le thème. Utiliser les codes HEX (hexadécimal) ou toute autre notation standard. Comme solution alternative vous pouvez utiliser "transparent" et "inherited" (hériter) comme valeur';
$string['colorsettings'] = 'Couleurs';
$string['colorsettingsheading'] = 'Modifier les couleurs principales utilisées dans le thème';
$string['configtitle'] = 'Adaptable';
$string['course'] = 'Cours';
$string['coursedesc'] = 'Modifier les paramètres d\'affichage des sections de cours comme l\'en-tête, les couleurs d\'arrière-plan et les bordures.';
$string['coursesectionbordercolor'] = 'Couleur de bordure des sections de cours';
$string['coursesectionbordercolordesc'] = 'Configurer la couleur de bordure des sections de cours';
$string['coursesectionborderradius'] = 'Rayon des bordures des sections de cours';
$string['coursesectionborderradiusdesc'] = 'Configurer le rayon des bordures des sections de cours (coins arrondis)';
$string['coursesectionborderstyle'] = 'Style de bordure des sections de cours';
$string['coursesectionborderstyledesc'] = 'Configurer le style de bordure des sections de cours';
$string['coursesectionborderwidth'] = 'Largeur de bordure des sections de cours';
$string['coursesectionborderwidthdesc'] = 'Configurer la largeur de bordure des sections de cours';
$string['coursesectionheaderbg'] = 'Couleur d\'arrière-plan des en-têtes des sections de cours';
$string['coursesectionheaderbgdesc'] = 'Configurer la couleur d\'arrière-plan des en-têtes des sections de cours';
$string['coursesectionheaderbordercolor'] = 'Couleur de bordure des en-têtes des sections de cours';
$string['coursesectionheaderbordercolordesc'] = 'Configurer la couleur de bordure des en-têtes des sections de cours (seule la bordure du bas est utilisée puisque le conteneur extérieur a également une bordure)';
$string['coursesectionheaderborderradiusbottom'] = 'Rayon de la bordure du bas des en-têtes des sections de cours';
$string['coursesectionheaderborderradiusbottomdesc'] = 'Configurer la rayon de la bordure du bas des en-têtes des sections de cours (coins arrondis)';
$string['coursesectionheaderborderradiustop'] = 'Rayon de la bordure du haut des en-têtes des sections de cours';
$string['coursesectionheaderborderradiustopdesc'] = 'Configurer la rayon de la bordure du haut des en-têtes des sections de cours (coins arrondis)';
$string['coursesectionheaderborderstyle'] = 'Style de bordure des en-têtes des sections de cours';
$string['coursesectionheaderborderstyledesc'] = 'Configurer le style de bordure des en-têtes des sections de cours (seule la bordure du bas est utilisée puisque le conteneur extérieur a également une bordure)';
$string['coursesectionheaderborderwidth'] = 'Largeur de bordure des en-têtes des sections de cours';
$string['coursesectionheaderborderwidthdesc'] = 'Configurer la largeur de bordure des en-têtes des sections de cours (seule la bordure du bas est utilisée puisque le conteneur extérieur a également une bordure)';
$string['coursesettings'] = 'Sections de cours';
$string['coursesettingsheading'] = 'Paramètres des sections de cours';
$string['coursetitlemaxwidth'] = 'Largeur maximum du titre de cours';
$string['coursetitlemaxwidthdesc'] = 'Paramétrer la largeur maximum du titre de cours';
$string['coursetitlepaddingleft'] = 'Marge gauche du titre de cours';
$string['coursetitlepaddingleftdesc'] = 'Configurer la marge gauche du titre de cours pour ajuster la position';
$string['coursetitlepaddingtop'] = 'Marge haute du titre de cours';
$string['coursetitlepaddingtopdesc'] = 'Configurer la marge au-dessus du titre de cours pour ajuster la position';
$string['covbkcolor'] = 'Couleur d\'arrière-plan des titres des tuiles Conventry';
$string['covbkcolordesc'] = 'Configurer la couleur d\'arrière-plan des titres lorsque le rendu Tuiles Conventry est sélectionné';
$string['coventrystyle'] = 'Style Coventry';
$string['covfontcolor'] = 'Couleur de police des titres des tuiles Coventry';
$string['covfontcolordesc'] = 'Configurer la couleur de police des titres lorsque le rendu Tuiles Conventry est sélectionné';
$string['covhidebutton'] = 'Bouton de cours Tuiles Coventry';
$string['covhidebuttondesc'] = 'Cocher pour cacher le bouton du cours lorsque le rendu Tuiles Coventry est sélectionné';
$string['currentcolor'] = 'Couleur de mise en valeur de la section de cours actuelle';
$string['currentcolordesc'] = 'Configurer la couleur de mise en valeur de la section de cours actuelle';
$string['customcss'] = 'CSS personnalisée';
$string['customcssdesc'] = 'Toute règle CSS ajoutée dans cette zone sera répercutée sur chaque page, facilitant la personnalisation de ce thème.';
$string['customcssjssettings'] = 'CSS et Javascript personnalisés';
$string['disablecustommenu'] = 'Désactiver le menu Moodle personnalisé';
$string['disablecustommenudesc'] = 'Désactiver les menus personnalisés Moodle dans la barre de navigation (';
$string['disablemenuscoursepages'] = 'Désactiver les menus sur les pages de cours';
$string['disablemenuscoursepagesdesc'] = 'Activer cette option limitera l\'affichage des menus aux pages de site, à la page d\'accueil, au tableau de bord etc; et ne les affichera pas dans les pages de cours';
$string['displaylogin'] = 'Affichage connexion';
$string['displayloginbox'] = 'Menu de connexion';
$string['displayloginbutton'] = 'Bouton';
$string['displayloginno'] = 'Sans connexion';
$string['dividingline'] = 'Ligne de séparation dans l\'en-tête';
$string['dividingline2'] = 'Ligne de séparation dans le pied de page';
$string['dividingline2desc'] = 'Couleur de la ligne de séparation du pied de page';
$string['dividinglinedesc'] = 'Couleur de la ligne de séparation de l\'en-tête';
$string['editfont'] = 'Couleur de police du bouton Editer et personnaliser cette page';
$string['editfontdesc'] = 'Configurer la couleur de police du bouton Editer et personnaliser cette page';
$string['edithorizontalpadding'] = 'Configurer l\'espacement horizontal des boutons d\'édition';
$string['editoffbk'] = 'Arrière-plan';
$string['editoffbkdesc'] = 'Configurer la couleur d\'arrière-plan du bouton Editer et personnaliser cette page lorsqu\'il est désactivé';
$string['editonbk'] = 'Couleur d\'arrière-plan du bouton Editer et personnaliser cette page';
$string['editonbkdesc'] = 'Configurer la couleur d\'arrière-plan du bouton Editer et personnaliser cette page';
$string['edittopmargin'] = 'Configurer la marge haute des boutons d\'édition';
$string['editverticalpadding'] = 'Configurer l\'espacement vertical des boutons d\'édition';
$string['enablealert'] = 'Activer la boîte d\'alerte {$a}';
$string['enablealertcoursepages'] = 'Activer la boîte d\'alerte sur les pages de cours';
$string['enablealertcoursepagesdesc'] = 'Activer cette option affichera la boîte d\'alerte sur toutes les pages de cours';
$string['enablealertdesc'] = 'Activer la boîte d\'alerte {$a}';
$string['enablealerts'] = 'Activer / désactiver les alertes';
$string['enablealertsdesc'] = 'Activer / désactiver les alertes sur le site';
$string['enablealertstriptags'] = 'Enlever automatiquement les balises HTML des alertes';
$string['enablealertstriptagsdesc'] = 'Activer pour nettoyer automatiquement les messages d\'alerte. Désactiver pour utiliser du code HTML et des liens dans les messages mais vous devrez nettoyer manuellement en mode HTML.';
$string['enableanalytics'] = 'Activer Google Analytics';
$string['enableanalyticsdesc'] = 'Activer les paramètres de Google Analytics sur votre site';
$string['enableavailablecourses'] = 'Afficher les cours disponibles';
$string['enableavailablecoursesdesc'] = 'Afficher';
$string['enablebadges'] = 'Badges';
$string['enablebadgesdesc'] = 'Affiche un lien vers les badges des utilisateurs';
$string['enableblog'] = 'Mes blogs';
$string['enableblogdesc'] = 'Afficher un lien vers le blog des utilisateurs';
$string['enablecalendar'] = 'Calendrier utilisateur';
$string['enablecalendardesc'] = 'Afficher un lien vers les calendrier des utilisateurs';
$string['enableeditprofile'] = 'Modifier le profil';
$string['enableeditprofiledesc'] = 'Afficher un lien pour modifier les profils utilisateurs';
$string['enableeventsdesc'] = 'Afficher un lien vers le calendrier';
$string['enablefeed'] = 'Mes feedback';
$string['enablefeeddesc'] = 'Affiche un lien vers la pages "Mes feedback" - Note : cela nécessite le <a href="https://moodle.org/plugins/report_myfeedback" target="blank">plugin Mes Feedback</a>';
$string['enablegrades'] = 'Notes';
$string['enablegradesdesc'] = 'Afficher un lien vers les notes des utilisateurs';
$string['enableheading'] = 'Titre du cours dans l\'en-tête';
$string['enableheadingdesc'] = 'Activer ce mode pour afficher le titre du cours dans l\'en-tête';
$string['enablehelp'] = 'Lien d\'aide';
$string['enablehelpdesc'] = 'Ajouter un lien d\'aide dans la barre de navigation';
$string['enablehomedesc'] = 'Afficher un lien sur la page d\'accueil';
$string['enablehomeredirect'] = 'Activer la redirection redirect=0';
$string['enablehomeredirectdesc'] = 'Activer redirect=0 sur l\'accueil. Utile sur les sites où "Mon Accueil" est la page d\'accueil par défaut. Cela évite aux utilisateurs qui cliquent sur le lien Accueil d\'être redirigés sur la page Mon Accueil/Tableau de bord';
$string['enablemenus'] = 'Activer les menus';
$string['enablemenusdesc'] = 'Il est recommandé de laisser cette option désactivée si les menus ne sont pas utilisés pour des questions de performances';
$string['enablemy'] = 'Accueil';
$string['enablemydesc'] = 'Afficher un lien vers la page Mon Accueil';
$string['enablemyhomedesc'] = 'Afficher un lien vers {$a}';
$string['enablemysitesdesc'] = 'Afficher une liste déroulante avec les cours des utilisateurs';
$string['enablenote'] = 'Mes notifications';
$string['enablenotedesc'] = 'Afficher un lien vers la page de notifications de l\'utilisateur';
$string['enableposts'] = 'Mes messages';
$string['enablepostsdesc'] = 'Afficher un lien vers la page Mes messages';
$string['enablepref'] = 'Mes préférences';
$string['enableprefdesc'] = 'Afficher un lien vers les pages de préférences de l\'utilisateur';
$string['enableprivatefiles'] = 'Fichiers personnels';
$string['enableprivatefilesdesc'] = 'Afficher un lien vers les fichiers personnels de l\'utilisateur';
$string['enableprofile'] = 'Profil de l\'utilisateur';
$string['enableprofiledesc'] = 'Afficher un lien vers le profil de l\'utilisateur';
$string['enablesearchbox'] = 'Activer la barre de recherche';
$string['enablesearchboxdesc'] = 'Afficher un champ de recherche dans l\'en-tête';
$string['enableshowhideblocks'] = 'Activer Afficher/Masquer les blocs';
$string['enableshowhideblocksdesc'] = 'Autoriser les utilisateurs à afficher/masquer les blocs';
$string['enablethiscoursedesc'] = 'Afficher une liste déroulante avec les activités du cours actif';
$string['enableticker'] = 'Activer le fil d\'informations sur la page d\'accueil ?';
$string['enabletickerc'] = 'Activer le fil d\'informations sur les pages internes ?';
$string['enabletickercdesc'] = 'Cocher pour activer le fil d\'informations sur les pages internes.';
$string['enabletickerdesc'] = 'Cocher pour activer le fil d\'informations sur la page d\'accueil';
$string['enabletickermy'] = 'Activer le fil d\'informations sur la page Mon Accuei / Tableau de bord';
$string['enabletickermydesc'] = 'Cocher pour activer le fil d\'informations sur la page Mon Accuei / Tableau de bord';
$string['enabletoolsmenus'] = 'Activer les menus Outils';
$string['enabletoolsmenusdesc'] = 'Il est recommandé de laisser cette option désactivée si les menus ne sont pas utilisés pour des questions de performances';
$string['enablezoom'] = 'Activer le zoom';
$string['enablezoomdesc'] = 'Autoriser les utilisateurs à basculer entre le mode plein écran et la largeur fixe.';
$string['events'] = 'Événements';
$string['favicon'] = 'Favicon';
$string['favicondesc'] = 'Charger une favicon à utiliser sur le site';
$string['fontcolor'] = 'Couleur de police principale';
$string['fontcolordesc'] = 'Configurer la couleur de police du thème. Utiliser le code HTML hexadécimal.';
$string['fontdesc'] = 'Vous pouvez choisir la <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> que vous souhaitez utiliser dans le thème. Sélectionner le sous-ensemble souhaité (latin toujours inclus) et saisir l\'épaisseur de police ou la police ne sera pas affichée.';
$string['fontheadercolor'] = 'Couleur de police de l\'en-tête';
$string['fontheadercolordesc'] = 'Configurer la couleur de police des en-têtes du thème. Utiliser le code HTML hexadécimal.';
$string['fontheadername'] = 'Police d\'en-tête';
$string['fontheadernamedesc'] = 'Sélectionner la police par défaut ou la police <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> utilisée dans les en-têtes de bloc et les textes.';
$string['fontheaderweight'] = 'Epaisseur de la police des en-têtes';
$string['fontheaderweightdesc'] = 'Epaisseur de la police des en-têtes utilisée dans le site. Saisir une valeur entre 100 et 900 selon la police choisie.';
$string['fontname'] = 'Police principale';
$string['fontnamedesc'] = 'Sélectionner la police par défaut ou la police <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> utilisée dans le site';
$string['fontsettings'] = 'Polices';
$string['fontsettingsheading'] = 'Modifier les polices utilisées dans le thème';
$string['fontsubset'] = 'Sous-ensemble Google Fonts';
$string['fontsubsetdesc'] = 'Sélectionner un autre sous-ensemble de caractères que latin à appliquer à toutes les polices. Le sous-ensemble latin est inclus par défaut.';
$string['fonttitlecolor'] = 'Couleur de police du titre du site';
$string['fonttitlecolorcourse'] = 'Couleur de police du titre de cours';
$string['fonttitlecolorcoursedesc'] = 'Configurer la couleur de police du titre du cours dans le thème, utiliser le code HTML hexadécimal.';
$string['fonttitlecolordesc'] = 'Configurer la couleur de police du titre du site dans le thème, utiliser le code HTML hexadécimal.';
$string['fonttitlename'] = 'Police du titre du site';
$string['fonttitlenamecourse'] = 'Police sur titre du cours';
$string['fonttitlenamecoursedesc'] = 'Sélectionner la police par défaut ou une police <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> utilisée pour les titres de cours.';
$string['fonttitlenamedesc'] = 'Sélectionner la police par défaut ou une police <a href="https://www.google.com/fonts" target="_blank">Google Fonts</a> utilisée pour le titre de site.';
$string['fonttitlesize'] = 'Taille de police du titre du site';
$string['fonttitlesizecourse'] = 'Taille de police du titre de cours';
$string['fonttitlesizecoursedesc'] = 'Taille de police du titre de cours utilisée dans le site. Saisir une valeur en pixels.';
$string['fonttitlesizedesc'] = 'Taille de police du titre du site utilisée dans le site. Saisir une valeur en pixels.';
$string['fonttitleweight'] = 'Epaisseur de police du titre du site';
$string['fonttitleweightcourse'] = 'Epaisseur de police du titre de cours';
$string['fonttitleweightcoursedesc'] = 'Configurer l\'épaisseur de la police du titre du site. Saisir une valeur entre 100 et 900 selon la police choisie.';
$string['fonttitleweightdesc'] = 'Configurer l\'épaisseur de la police du titre dusite. Saisir une valeur entre 100 et 900 selon la police choisie.';
$string['fontweight'] = 'Epaisseur de la police principale';
$string['fontweightdesc'] = 'Epaisseur de la police utilisée dans le site. Saisir une valeur entre 100 et 900 selon la police choisie.';
$string['footerbkcolor'] = 'Couleur d\'arrière-plan du pied de page';
$string['footerbkcolordesc'] = 'Configurer la couleur d\'arrière-plan du pied de page';
$string['footerblocksplacement'] = 'Emplacement des blocs de pied de page';
$string['footerblocksplacement1'] = 'Ensemble du site';
$string['footerblocksplacement2'] = 'Page d\'accueil uniquement';
$string['footerblocksplacement3'] = 'Jamais';
$string['footerblocksplacementdesc'] = 'Contrôler les endroits où les blocs du pied de page sont affichés.  Par défaut sur l\'ensemble du site.';
$string['footercontent'] = 'Zone de contenu du pied de page';
$string['footercontentdesc'] = 'Ajouter du contenu à la zone du pied de page';
$string['footerdesc'] = 'Ajouter un titre à la zone du pied de page';
$string['footerheader'] = 'Titre de la zone du pied de page';
$string['footerlayoutrow'] = 'Paramétrage de la disposition du pied de page';
$string['footerlayoutrowdesc'] = 'Concevoir la disposition des blocs du pied de page';
$string['footerlinkcolor'] = 'Couleur des liens des blocs du pied de page';
$string['footerlinkcolordesc'] = 'Couleur des liens des blocs du pied de page';
$string['footersettings'] = 'Pied de page';
$string['footersettingsheading'] = 'Configurer le contenu qui apparait dans le pied de page. Voir la disposition<a href="./../theme/adaptable/pix/layout.png" target="_blank"> ici</a>';
$string['footertextcolor'] = 'Couleur de texte des blocs du pied de page';
$string['footertextcolor2'] = 'Couleur de texte du pied de page inférieur';
$string['footertextcolor2desc'] = 'Couleur de texte du pied de page inférieur';
$string['footertextcolordesc'] = 'Couleur de texte des zones du pied de page';
$string['footnote'] = 'Note de bas de page';
$string['footnotedesc'] = 'Ajouter du texte au pied de page';
$string['frnt-footer'] = 'Les blocs situés dans cette zone seront uniquement visibles des administrateurs.';
$string['frontpagealertsettings'] = 'Boîte d\'alerte';
$string['frontpageblockregionsettings'] = 'Paramétrage des zones de blocs';
$string['frontpageblocksenabled'] = 'Activer les zones de blocs sur la page d\'accueil';
$string['frontpageblocksenableddesc'] = 'Vous pouvez activer  /désactiver les zones de blocs sur la page d\'accueil';
$string['frontpageblocksettings'] = 'Blocs Marketing';
$string['frontpagecoursesettings'] = 'Cours sur la page d\'accueil';
$string['frontpagedesc'] = 'Configurer la manière dont les cours sont affichés sur la page d\'accueil';
$string['frontpagelogin'] = 'Connexion sur la page d\'accueil';
$string['frontpagelogindesc'] = 'Activer le formulaire de connexion dans l\'en-tête (affichera le bouton si coché)';
$string['frontpagemarketenabled'] = 'Activer les blocs Marketing';
$string['frontpagemarketenableddesc'] = 'Configurer les blocs Marketing sur la page d\'accueil';
$string['frontpagemarketoption'] = 'Choisir le style pour les blocs Marketing';
$string['frontpagemarketoptiondesc'] = 'Vous pouvez appliquer différents styles aux blocs marketings. Note : le style BCU est conçu pour fonctionner avec des images en haut du bloc.';
$string['frontpagerenderer'] = 'Boîtes d\'affichage des cours sur la page d\'accueil';
$string['frontpagerendererdefaultimage'] = 'Image pour les cours par défaut';
$string['frontpagerendererdefaultimagedesc'] = 'L\'image par défaut utilisée lorsqu\'aucune image de cours n\'est trouvée (valable uniquement pour le mode Tuiles avec superposition)';
$string['frontpagerendererdesc'] = 'Configure la manière dont les boîtes de cours sont affichées sur la page d\'accueil';
$string['frontpagerendereroption1'] = 'Tuiles';
$string['frontpagerendereroption2'] = 'Tuiles avec superposition';
$string['frontpagerendereroption3'] = 'Affichage Moodle par défaut';
$string['frontpagerendereroption4'] = 'Tuiles Coventry';
$string['frontpagesettingsheading'] = 'Présentation de la page d\'accueil';
$string['frontpageslidersettings'] = 'Diaporama de la page d\'accueil';
$string['frontpagetickersettings'] = 'Fil d\'informations de la page d\'accueil';
$string['fullscreen'] = 'Plein écran';
$string['fullscreenwidth'] = 'Largeur plein écran';
$string['fullscreenwidthdesc'] = 'Configurer la largeur maximum du thème lorsqu\'il est en mode plein écran / zoom.';
$string['genericsettingsheading'] = 'Appliquer vos propres modifications';
$string['headersettings'] = 'En-tête';
$string['help'] = 'Aide';
$string['helptitle'] = 'Aide';
$string['hideblocks'] = 'Cacher les blocs';
$string['layoutsettings'] = 'Mise en page';
$string['linkcolor'] = 'Couleur des liens';
$string['logintextbutton'] = 'Connexion';
$string['maincolor'] = 'Couleur principale';
$string['marketingsettings'] = 'Blocs marketing';
$string['menusettings'] = 'Menus de l\'en-tête';
$string['myblogs'] = 'Mes blogs';
$string['mysites'] = 'Mes cours';
$string['mysitesdisabled'] = 'Désactiver';
$string['navbarsettingsheading'] = 'Personnaliser la barre de navigation';
$string['newmenutitledefault'] = 'Menu';
$string['noenrolments'] = 'Aucune inscription trouvée';
$string['piwikenabled'] = 'Activé';
$string['region-frnt-footer'] = 'Pied de page';
$string['region-middle'] = 'centre';
$string['region-side-post'] = 'droite';
$string['region-side-pre'] = 'gauche';
$string['rightblocks'] = 'Droite';
$string['settingsalertbox'] = 'Boîte d\'alerte';
$string['settingsbreadcrumbcolors'] = 'Couleurs du fil d\'ariane';
$string['settingsfonts'] = 'Polices';
$string['settingsfootercolors'] = 'Couleurs du pied de page';
$string['settingsmenucolors'] = 'Couleurs du menu';
$string['showblocks'] = 'Afficher les blocs';
$string['sitetitletext'] = 'Titre du site';
$string['sliderenabled'] = 'Activer le diaporama';
$string['sliderfullscreen'] = 'Diaporama plein écran';
$string['socialsettings'] = 'Réseaux sociaux en en-tête';
$string['standardview'] = 'Vue standard';
$string['targetnewwindow'] = 'Nouvelle fenêtre';
$string['targetsamewindow'] = 'Même fenêtre';
$string['thiscourse'] = 'Cours actuel';
$string['ticker'] = 'Annonces';
$string['tickerdefault'] = 'Aucun nouvel élément à afficher';
$string['toolsmenuheading'] = 'Menu Outils';
$string['toolsmenulabel'] = 'Menu Outils';
$string['toolsmenutitle'] = 'Titre du menu Outils';
$string['toolsmenutitledefault'] = 'Outils';
