<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'admin', language 'fr', version '3.10'.
 *
 * @package     admin
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessdenied'] = 'Accès refusé';
$string['accounts'] = 'Comptes';
$string['addcategory'] = 'Ajouter une catégorie';
$string['additionalhtml'] = 'HTML additionnel';
$string['additionalhtml_desc'] = 'Ces réglages vous permettent de spécifier du code HTML que vous voulez ajouter à chaque page. Cette possibilité existe pour du code à ajouter dans la balise HEAD de la page, ou immédiatement après l\'ouverture de la balise BODY, ou juste avant la fermeture de la balise BODY.<br />Cela vous permet d\'ajouter à chaque page un entête ou un pied de page personnalisé, ou d\'appeler des scripts pour des services tels que Google Analytics, indépendamment du thème choisi pour l\'affichage de votre site.';
$string['additionalhtml_heading'] = 'HTML additionnel à ajouter à chaque page';
$string['additionalhtmlfooter'] = 'Avant la fermeture de BODY';
$string['additionalhtmlfooter_desc'] = 'Ce contenu sera ajouté à chaque page, juste avant la fermeture de la balise BODY.';
$string['additionalhtmlhead'] = 'Dans HEAD';
$string['additionalhtmlhead_desc'] = 'Ce contenu sera ajouté à chaque page, en bas de la balise HEAD.';
$string['additionalhtmltopofbody'] = 'Quand la balise BODY est ouverte';
$string['additionalhtmltopofbody_desc'] = 'Ce contenu sera ajouté à chaque page, juste après l\'ouverture de la balise BODY.';
$string['admincategory'] = 'Catégorie {$a}';
$string['adminseesall'] = 'Les administrateurs peuvent tout voir';
$string['adminseesallevents'] = 'Les administrateurs voient tous les événements';
$string['adminseesownevents'] = 'Les administrateurs sont considérés comme les autres utilisateurs';
$string['advancedfeatures'] = 'Fonctions avancées';
$string['agedigitalconsentverification'] = 'Vérification de l\'âge de majorité numérique';
$string['agedigitalconsentverification_desc'] = 'Active la vérification de l\'âge de majorité numérique des utilisateurs avant l\'affichage de la page d\'auto-inscription. Ceci permet d\'éviter que des mineurs s\'inscrivent sur votre site sans le consentement de leur représentant légal. <a target="_blank" href="{$a}">Des informations supplémentaires</a> sont disponibles pour les mineurs nécessitant de l\'aide.';
$string['ageofdigitalconsentmap'] = 'Âge de majorité numérique';
$string['ageofdigitalconsentmap_desc'] = 'L\'âge de majorité numérique par défaut ainsi que cet âge lorsqu\'il diffère de l\'âge par défaut peuvent être indiqués ici pour chaque pays. Saisissez chaque âge sur une nouvelle ligne, dans le format : code de pays, âge (séparé par une virgule). L\'âge par défaut est indiqué par un caractère * au lieu du code du pays. Les codes de pays doivent être conformes à la norme ISO 3166-2.';
$string['allcountrycodes'] = 'Tous les codes de pays';
$string['allowattachments'] = 'Permettre les annexes';
$string['allowbeforeblock'] = 'La liste des adresses IP permises est traitée en premier';
$string['allowbeforeblockdesc'] = 'Par défaut, la liste des adresses IP bloquées est traitée en premier. Lorsque cette option est activée, la liste des adresses IP autorisées sera traitée en premier.';
$string['allowblockstodock'] = 'Permettre aux blocs d\'utiliser le dock';
$string['allowcategorythemes'] = 'Autoriser les thèmes de catégories';
$string['allowcohortthemes'] = 'Autoriser les thèmes de cohortes';
$string['allowcoursethemes'] = 'Autoriser les thèmes de cours';
$string['allowedemaildomains'] = 'Domaines de courriel autorisés';
$string['allowediplist'] = 'Liste des IP autorisées';
$string['allowemailaddresses'] = 'Domaines courriel autorisés';
$string['allowemojipicker'] = 'Palette émoji';
$string['allowframembedding'] = 'Autoriser l\'intégration dans un cadre';
$string['allowframembedding_help'] = 'Lorsque ce réglage est activé, les pages de la plateforme peuvent être intégrées dans un cadre sur des sites externes, ce qui est recommandé lorsque le plugin « Publier comme outil LTI » est utilisé. Sinon, l\'activation de cette fonctionnalité n\'est pas recommandée, pour des raisons de sécurité. Ce réglage est ignoré pour l\'App mobile, dans laquelle l\'intégration des cadres est toujours autorisée.';
$string['allowguestmymoodle'] = 'Permettre aux utilisateurs anonymes d\'accéder au tableau de bord';
$string['allowindexing'] = 'Permettre l\'indexation par les moteurs de recherche';
$string['allowindexing_desc'] = 'Ce réglage détermine si les moteurs de recherche peuvent indexer votre site. L\'option « Partout » autorisera les moteurs de recherche à rechercher la totalité de vos pages, y compris les pages de connexion et de création de compte utilisateur ; cela signifie que les sites qui imposent une connexion seront malgré tout indexés. Pour éviter le risque de spam lorsque la page de connexion est indexée, utiliser l\'option « Partout, sauf les pages de connexion et de création de compte ». L\'option « Nulle part » indiquera aux moteurs de recherche de n\'indexer aucune page. Il ne s\'agit que d\'une balise dans l\'entête du site, qui sera respectée ou non par le moteur de recherche.';
$string['allowindexingeverywhere'] = 'Partout';
$string['allowindexingexceptlogin'] = 'Partout, sauf les pages de connexion et de création de compte';
$string['allowindexingnowhere'] = 'Nulle part';
$string['allowobjectembed'] = 'Autoriser les balises EMBED et OBJECT';
$string['allowthemechangeonurl'] = 'Autoriser le changement du thème dans l\'URL';
$string['allowuserblockhiding'] = 'Autoriser les utilisateurs à cacher les blocs';
$string['allowusermailcharset'] = 'Autoriser les utilisateurs à choisir un jeu de caractères';
$string['allowuserswitchrolestheycantassign'] = 'Autoriser les utilisateurs à basculer vers des rôles qu\'ils ne peuvent pas attribuer';
$string['allowuserthemes'] = 'Autoriser les thèmes utilisateur';
$string['alternativefullnameformat'] = 'Autre format d\'affichage des noms complets';
$string['alternativefullnameformat_desc'] = 'Ce réglage définit comment les noms sont affichés aux utilisateurs disposant de la capacité <em>viewfullnames</em> (par défaut, les utilisateurs ayant le rôle de gestionnaire, d\'enseignant ou d\'enseignant non éditeur). Les paramètres fictifs pouvant être utilisés sont les mêmes que ceux du réglage « Format d\'affichage des noms complets ».';
$string['always'] = 'Toujours';
$string['appearance'] = 'Présentation';
$string['aspellpath'] = 'Chemin d\'accès à <em>aspell</em>';
$string['authentication'] = 'Authentification';
$string['authpreventaccountcreation'] = 'Empêcher la création de compte lors de l\'authentification';
$string['authpreventaccountcreation_help'] = 'Lorsqu\'un utilisateur s\'authentifie, un compte est créé automatiquement sur le site s\'il n\'existe pas encore. Si une base externe, par exemple LDAP, est utilisée pour l\'authentification et que vous désirez restreindre l\'accès à votre site aux seuls utilisateurs avec un compte existant, vous devez activer cette option. Les nouveaux comptes devront alors être créés manuellement ou importés via un fichier. Ce réglage ne s\'applique pas à l\'authentification MNet.';
$string['authsettings'] = 'Gestion de l\'authentification';
$string['autolang'] = 'Détection automatique de la langue';
$string['autolangusercreation'] = 'Lors de la création du compte, définir la langue préférée de l\'utilisateur à partir de la langue de son navigateur';
$string['autologinguests'] = 'Connecter automatiquement les visiteurs anonymes';
$string['availablelicenses'] = 'Licences disponibles';
$string['availableto'] = 'Disponible pour';
$string['backgroundcolour'] = 'Couleur transparente';
$string['backup_shortname'] = 'Utiliser le nom du cours dans le nom du fichier de sauvegarde';
$string['backup_shortnamehelp'] = 'Utiliser le nom du cours dans le nom du fichier de sauvegarde';
$string['backups'] = 'Sauvegardes';
$string['badwordsconfig'] = 'Taper ici votre liste de mots à caviarder, séparés par des virgules.';
$string['badwordsdefault'] = 'Si votre liste de mots à caviarder est vide, une liste de mots tirée du paquetage de langue sera utilisée.';
$string['badwordslist'] = 'Votre liste de mots à caviarder';
$string['blockediplist'] = 'Liste des IP bloquées';
$string['blockinstances'] = 'Instances';
$string['blockmultiple'] = 'Multiple';
$string['blockprotect'] = 'Protéger les instances';
$string['blockprotect_help'] = 'Si vous verrouillez un type de bloc, personne ne pourra plus ajouter ni supprimer ce type de bloc. Il est bien sûr possible de déverrouiller si vous devez modifier certains blocs.

Ce réglage est destiné à protéger les blocs Navigation et Réglages, qui sont difficiles à récupérer lorsqu\'ils sont supprimés par inadvertance.';
$string['blocksettings'] = 'Gestion des blocs';
$string['blockunprotect'] = 'Déprotéger';
$string['bloglevel'] = 'Visibilité des blogs';
$string['bookmarkadded'] = 'Marque-page ajouté.';
$string['bookmarkalreadyexists'] = 'Vous avez déjà marqué cette page.';
$string['bookmarkdeleted'] = 'Marque-page supprimé.';
$string['bookmarkthispage'] = 'Marquer cette page';
$string['cacheapplication'] = 'Cache de l\'application';
$string['cacheapplicationhelp'] = 'Les éléments en cache sont partagés par tous les utilisateurs et arrivent à échéance après une durée déterminée (TTL).';
$string['cachejs'] = 'Mettre en cache le Javascript';
$string['cachejs_help'] = 'La mise en cache et compression du Javascript améliore de façon importante la performance de chargement des pages. Elle est vivement recommandée sur les sites en production. La désactivation de cette mise en page sera utile aux développeurs.';
$string['cacherequest'] = 'Requête cache';
$string['cacherequesthelp'] = 'Cache utilisateur qui arrive à échéance lorsque la requête est terminée. Destinée à remplacer les zones où des entrepôts statiques sont utilisés.';
$string['cachesession'] = 'Cache de session';
$string['cachesessionhelp'] = 'Cache utilisateur qui arrive à échéance lorsque la session se termine. Destinée à remédier aux problèmes de session.';
$string['cachesettings'] = 'Réglages de cache';
$string['cachetemplates'] = 'Mettre en cache les gabarits';
$string['cachetemplates_help'] = 'La mise en cache des gabarits améliorera les performances de chargement des pages ; elle est vivement recommandée sur les sites en production. Les développeurs en revanche voudront désactiver cette fonctionnalité.';
$string['caching'] = 'Cache';
$string['calendar_weekend'] = 'Jours du week-end';
$string['calendarexportsalt'] = 'Sel de l\'exportation des calendriers';
$string['calendarsettings'] = 'Calendrier';
$string['calendartype'] = 'Type de calendrier';
$string['calendartype_desc'] = 'Sélectionner un type de calendrier par défaut pour tout le site. Ce réglage peut être court-circuité dans les réglages de chaque cours ou par les utilisateurs dans leur profil personnel.';
$string['cannotdeletemodfilter'] = 'Vous ne pouvez pas désinstaller « {$a->filter} », car il fait partie du module « {$a->module} ».';
$string['cannotuninstall'] = 'Désinstallation de {$a} impossible.';
$string['categoryemail'] = 'Courriel';
$string['cfgwwwrootslashwarning'] = 'Le paramètre $CFG->wwwroot est défini incorrectement dans votre fichier config.php. Il contient une barre oblique « / » à la fin, qui doit être retirée.';
$string['cfgwwwrootwarning'] = 'Le paramètre $CFG->wwwroot est défini incorrectement dans votre fichier config.php. Il doit correspondre à l\'URL que vous utilisez pour accéder à cette page.';
$string['change'] = 'Changer';
$string['checkboxno'] = 'Non';
$string['checkboxyes'] = 'Oui';
$string['checkupgradepending'] = 'Mise à jour';
$string['choosefiletoedit'] = 'Sélectionnez le fichier à modifier';
$string['cleanup'] = 'Nettoyage';
$string['clianswerno'] = 'n';
$string['cliansweryes'] = 'y';
$string['cliexitgraceful'] = 'Arrêt normal, veuillez patienter…';
$string['cliexitnow'] = 'Arrêt immédiat';
$string['cliincorrectvalueerror'] = 'Erreur, valeur incorrecte « {$a->value} » pour le paramètre « {$a->option} »';
$string['cliincorrectvalueretry'] = 'Valeur incorrecte, veuillez réessayer';
$string['clistatusdisabled'] = 'Statut : désactivé';
$string['clistatusenabled'] = 'Statut : activé';
$string['clistatusenabledlater'] = 'Statut : le mode de maintenance CLI sera activé à {$a}';
$string['clitypevalue'] = 'type valeur';
$string['clitypevaluedefault'] = 'type valeur, tapez Entrée pour utiliser la valeur par défaut ({$a})';
$string['cliunknowoption'] = 'Options non reconnues :
 {$a}.
Utilisez l\'option --help.';
$string['cliupgradedefault'] = 'Nouveau réglage : {$a}';
$string['cliupgradedefaultheading'] = 'Réglage des nouvelles valeurs par défaut';
$string['cliupgradedefaultverbose'] = 'Nouveau réglage : {$a->name}, valeur par défaut : {$a->defaultsetting}';
$string['cliupgradefinished'] = 'Mise à jour en ligne de commande de la version {$a->oldversion} à la version {$a->newversion} terminée avec succès.';
$string['cliupgradenoneed'] = 'Aucune mise à jour nécessaire pour la version installée {$a}. C\'était quand même sympa de venir !';
$string['cliupgradepending'] = 'Une mise à jour est en attente';
$string['cliyesnoprompt'] = 'Tapez y (pour oui) ou n (pour non)';
$string['commentsperpage'] = 'Commentaires affichés par page';
$string['commonactivitysettings'] = 'Réglages communs';
$string['commonfiltersettings'] = 'Réglages communs aux filtres';
$string['commonsettings'] = 'Réglages communs';
$string['componentinstalled'] = 'Composant installé';
$string['computedfromlogs'] = 'Calculé à partir des journaux depuis {$a}.';
$string['condifmodeditdefaults'] = 'Les valeurs par défaut sont utilisées dans les réglages des nouvelles activités ou ressources créées.';
$string['confeditorhidebuttons'] = 'Sélectionner les boutons ne devant pas apparaître dans la barre de l\'éditeur.';
$string['configallcountrycodes'] = 'La liste des codes des pays pouvant être choisis par les utilisateurs, par exemple dans le profil. Veuillez indiquer une liste des codes à deux caractères des pays désirés, séparés par des virgules, par exemple « GB,FR,ES ». Si ce champ n\'est pas renseigné (réglage par défaut), la liste standard du fichier « countries.php » du paquetage de langue francophone est utilisée. Cette liste est conforme au standard ISO 3166-1. Si vous indiquez dans ce champ d\'autres codes non standards, vous devrez les ajouter manuellement dans le fichier « countries.php » du paquetage « en » ainsi que dans celui de votre langue.';
$string['configallowassign'] = 'Vous pouvez permettre aux utilisateurs ayant un rôle de la colonne de gauche d\'attribuer certains rôles de chaque colonne à d\'autres utilisateurs';
$string['configallowattachments'] = 'Si ce réglage est activé, les courriels envoyés depuis ce site peuvent comporter des annexes, par exemple des badges.';
$string['configallowblockstodock'] = 'Si ce réglage est activé et si le thème utilisé le supporte, les utilisateurs peuvent ranger les blocs dans un dock.';
$string['configallowcategorythemes'] = 'Si vous activez ce réglage, les thèmes pourront être définis au niveau des catégories. Le thème défini pour la catégorie sera hérité par toutes les sous-catégories et tous les cours qui s\'y trouvent, à moins qu\'un thème propre n\'y soit défini spécifiquement. ATTENTION ! L\'activation de cette option pourrait dégrader la performance de votre site.';
$string['configallowcohortthemes'] = 'Si ce réglage est activé, les thèmes peuvent être définis par cohorte. Ce réglage ne concerne que les utilisateurs faisant partie d\'une seule cohorte ou de plusieurs cohortes avec le même thème.';
$string['configallowcoursethemes'] = 'Si vous activez ce réglage, les thèmes pourront être définis au niveau des cours. Les thèmes de cours auront priorité sur tous les autres réglages de thème (thème du site, de la catégorie, de la cohorte, de l\'utilisateur ou défini dans l\'URL).';
$string['configallowedemaildomains'] = 'La liste des domaines de courriel autorisés pour la section « De » du courriel sortant. Le réglage par défaut (vide) utilisera l\'adresse de non-réponse pour tout le courrier sortant. L\'utilisation de caractères joker est permise. Par exemple, *.exemple.fr autorise l\'envoi de courriels depuis les adresses de courriel de tous les sous-domaines de exemple.fr, mais pas du domaine exemple.fr lui-même.';
$string['configallowemailaddresses'] = 'Pour restreindre les nouvelles adresses de courriel à certains domaines déterminés, saisissez ici les domaines autorisés, séparés par des espaces. Les autres domaines seront rejetés. Pour autoriser un domaine et ses sous-domaines, indiquez le domaine deux fois : d\'abord en le préfixant d\'un point, puis normalement, par exemple <strong>.monecole.fr monecole.fr </strong>.';
$string['configallowemojipicker'] = 'La palette émoji permet de sélectionner des émojis à ajouter aux messages et autres champs de texte au moyen d\'une palette accessible au moyen d\'un bouton dans la barre d\'outils de Atto.';
$string['configallowemojipickerincompatible'] = 'La configuration actuelle de votre base de données ne permet pas le support des émojis. Afin d\'activer la palette émoji, vous devez <a href="https://docs.moodle.org/fr/Support_unicode_complet_pour_MySQL">mettre à jour votre base de données pour permettre le support unicode complet</a>.';
$string['configallowguestmymoodle'] = 'Si ce réglage est activé, les utilisateurs anonymes peuvent accéder au tableau de bord. Dans le cas contraire, les utilisateurs anonymes sont dirigés vers la page d\'accueil du site.';
$string['configallowobjectembed'] = 'Par mesure de sécurité, les utilisateurs normaux n\'ont pas les permissions requises pour intégrer des fichiers multimédias (par exemple Flash) dans des textes à l\'aide de balises EMBED et OBJECT du code HTML. Ils peuvent cependant le faire de manière sûre avec le filtre multimédia. Si vous voulez permettre l\'utilisation de ces balises, activez cette option.';
$string['configallowoverride'] = 'Vous pouvez permettre aux utilisateurs ayant un rôle de la colonne de gauche de définir pour d\'autres utilisateurs des dérogations aux rôles de chaque colonne';
$string['configallowoverride2'] = 'Sélectionnez les rôles pour lesquels les rôles de la colonne de gauche peuvent définir des dérogations.<br />Ce réglage ne s\'applique qu\'aux utilisateurs possédant la capacité moodle/role:override ou la capacité moodle/role:safeoverride.';
$string['configallowswitch'] = 'Sélectionnez les rôles vers lesquels un utilisateur pourra changer de rôle, sur la base des rôles qu\'il possède déjà. En plus d\'une indication dans ce tableau, l\'utilisateur doit également avoir la capacité moodle/role:switchroles pour pouvoir changer de rôle.<br />Il n\'est possible de changer de rôle que vers des rôles ayant la capacité moodle/course:view et n\'ayant pas la capacité moodle/site:doanything. C\'est pourquoi certaines colonnes de ce tableau sont inactives.';
$string['configallowthemechangeonurl'] = 'Si ce réglage est activé, le thème pourra être changé en ajoutant soit<br />theme=nom_du_theme à une URL de Moodle (par exemple : http://monsitemoodle.fr/?theme=monbeautheme), ou <br />&theme=nom_du_theme à une URL Moodle interne (par exemple : http://monsitemoodle.fr/course/view.php?id=2&theme=monbeautheme ).';
$string['configallowuserblockhiding'] = 'Voulez-vous autoriser les utilisateurs à cacher/afficher les blocs latéraux de ce site ? Cette fonctionnalité utilise Javascript et les cookies pour se souvenir de l\'état d\'affichage de chaque bloc. Elle n\'a d\'effet que sur l\'affichage du site pour l\'utilisateur.';
$string['configallowusermailcharset'] = 'Si ce réglage est activé, les utilisateurs peuvent spécifier dans leurs préférences de messagerie l\'encodage de caractères à utiliser pour leurs courriels.';
$string['configallowuserswitchrolestheycantassign'] = 'Par défaut, la capacité moodle/role:assign est requise pour qu\'un utilisateur puisse basculer vers un autre rôle. L\'activation de ce réglage supprime cette condition, ce qui a pour résultat que le basculement vers d\'autres rôles n\'est déterminé que par le tableau « Autoriser les attributions de rôles ». Il est recommandé que la configuration de ce tableau ne permette pas de basculer vers un rôle comportant plus de permissions que le rôle existant.';
$string['configallowuserthemes'] = 'Si vous activez ce réglage, les utilisateurs pourront choisir leur propre thème. Le thème choisi par l\'utilisateur aura priorité sur le thème du site (mais pas sur les thèmes des cours).';
$string['configallowview'] = 'Sélectionner les rôles qu\'un utilisateur verra, pourra filtrer, etc. sur la base des rôles qu\'il a déjà.';
$string['configallusersaresitestudents'] = 'Pour les activités affichées sur la page d\'accueil du site, TOUS les utilisateurs doivent-ils être considérés comme des étudiants ? Si vous choisissez « Oui », tout utilisateur possédant un compte confirmé pourra participer à ces activités en tant qu\'étudiant. Si vous choisissez « Non », seuls les participants d\'au moins un cours pourront participer aux activités de la page d\'accueil.';
$string['configauthenticationplugins'] = 'Veuillez choisir les plugins d\'authentification que vous voulez utiliser et les arranger dans l\'ordre de vérification désiré.';
$string['configautolang'] = 'Détecter automatiquement la langue par défaut d\'après les réglages du navigateur, si la langue par défaut du site est désactivée.';
$string['configautolangusercreation'] = 'Si ce réglage est activé, lorsqu\'un compte utilisateur est automatiquement créé lors de sa première connexion (par exemple avec l\'authentification LDAP ou OAuth 2), la langue du navigateur de l\'utilisateur est définie comme sa langue préférée. Sinon, la langue par défaut du site est utilisée pour cela.';
$string['configautologinguests'] = 'Connecter automatiquement en tant que visiteur anonyme les utilisateurs accédant directement à un cours ouvert aux visiteurs anonymes.';
$string['configbloglevel'] = 'Ce réglage permet de restreindre le niveau auquel les blogs des utilisateurs peuvent être consultés sur ce site. Veuillez noter que ce réglage indique le contexte maximal de la personne qui <em>consulte</em> le blog, et non l\'auteur, ni le type des messages de blog. Les blogs peuvent également être désactivés, si vous ne les voulez pas du tout.';
$string['configcalendarcustomexport'] = 'Activer intervalle de dates personnalisé dans l\'exportation des calendriers';
$string['configcalendarexportsalt'] = 'Ce texte aléatoire est utilisé pour améliorer la sécurité des jetons d\'authentification utilisés pour l\'exportation des calendriers. Si vous modifiez ce texte, tous les jetons en cours seront rendus non valides.';
$string['configcookiehttponly'] = 'Active une nouvelle fonctionnalité de PHP 5.2.0. Les navigateurs doivent envoyer les cookies en utilisant uniquement des requêtes http réelles. Les cookies ne doivent pas être accessibles pour les langages de script. Ce réglage n\'est pas supporté par tous les navigateurs et n\'est peut-être pas totalement compatible avec le code actuel. Il permet d\'éviter certains types d\'attaques XSS.';
$string['configcookiesecure'] = 'Si le serveur accepte uniquement des connexions https, il est recommandé d\'activer l\'envoi sécurisé des cookies. Une fois activé, assurez-vous que le serveur web n\'accepte pas http:// ou fournit une redirection permanente vers une adresse https://. Idéalement, fournissez également des entêtes HSTS. Si l\'adresse <em>wwwroot</em> ne commence pas par https://, ce réglage est désactivé automatiquement.';
$string['configcountry'] = 'Si vous choisissez un pays ici, il sera sélectionné par défaut lors de la création de nouveaux comptes. Si vous souhaitez forcer les utilisateurs à choisir un pays, laissez ce champ vide.';
$string['configcoursegraceperiodafter'] = 'Classer comme « en cours » les anciens cours durant ce nombre de journées après la date de fin du cours.';
$string['configcoursegraceperiodbefore'] = 'Classer comme « en cours » les futurs cours durant ce nombre de journées avant la date de début du cours.';
$string['configcourseoverviewfilesext'] = 'Une liste d\'extensions de nom des fichiers image de cours autorisées (séparées par des virgules)';
$string['configcourseoverviewfileslimit'] = 'Le nombre maximal de fichiers pouvant être ajoutés à un résumé de cours. Le premier fichier image ajouté est utilisé comme image de cours dans la vue d\'ensemble des cours sur le tableau de bord des utilisateurs. Les autres fichiers ne sont affichés que sur la page avec la liste des cours.';
$string['configcourserequestnotify'] = 'Indiquez le nom d\'utilisateur de la personne devant être informée lors de la demande de nouveaux cours.';
$string['configcourserequestnotify2'] = 'Les utilisateurs qui seront avertis lors d\'une demande de cours. Seuls les utilisateurs ayant les permissions requises pour approuver des demandes de cours sont affichés.';
$string['configcoursesperpage'] = 'Saisissez le nombre de cours à afficher par page dans la liste des cours.';
$string['configcourseswithsummarieslimit'] = 'Le nombre maximum de cours à afficher dans les listes des cours, y compris les résumés, avant de passer à une liste plus simple, sans les résumés.';
$string['configcronclionly'] = 'Le lancement du cron par l\'intermédiaire d\'un navigateur web peut exposer des informations sensibles à des utilisateurs anonymes. Il est donc recommandé de ne lancer le cron qu\'en ligne de commande ou de définir un mot de passe pour l\'accès distant au cron.';
$string['configcronremotepassword'] = 'Ce paramètre signifie que le script cron.php ne pourra pas être lancé depuis un navigateur web sans indiquer le mot de passe, suivant la syntaxe d\'URL :<pre>
http://site.exemple.fr/admin/cron.php?password=lemotdepasse
</pre>Si le champ n\'est pas renseigné, aucun mot de passe n\'est nécessaire.';
$string['configcurlcache'] = 'Durée de vie du cache cURL, en secondes.';
$string['configcustommenuitems'] = 'Vous pouvez définir ici un menu personnalisé qui sera affiché par les thèmes. Chaque ligne est constituée d\'un texte du menu, d\'une URL (optionnelle) et d\'un texte (optionnel) à afficher dans une infobulle et d\'un code de langue ou d\'une liste de tels codes séparés par des virgules (optionnel, pour permettre l\'affichage d\'éléments en fonction de la langue). Ces éléments sont séparés par des caractères « trait vertical » (|). Une structure hiérarchique peut être définie à l\'aide de tirets au début des lignes, et des lignes de séparation peuvent être indiquées à l\'aide de ###. Exemple :
<pre>
Cours
-Tous les cours|/course/
-Recherche de cours|/course/search.php
-###
-FAQ|https://une-url.xyz/faq
-Preguntas más frecuentes|https://une-url.xyz/pmf||es
Mobile app|https://une-url.xyz/app|Téléchargez notre app
</pre>';
$string['configcustomusermenuitems'] = 'Vous pouvez configurer le contenu du menu utilisateur (à l\'exception du lien de déconnexion, qui est ajouté automatiquement). Chaque ligne définit un élément de menu et comprend 3 éléments, séparés par des barres verticales (|) : 1) une chaîne de caractères de la forme « chaînedecaractèresmoodle, nomducomposant » ou un simple texte, 2) une URL, et 3) une icône, soit sous la forme d\'une icône de thème pix (dans le dossier pix avec structure [sousdossier]/[icône], p.ex. i/publish), soit sous la forme d\'une URL. Des barres de séparation peuvent être spécifiées en ajoutant à l\'endroit désiré une ligne avec un ou plusieurs #.';
$string['configdbsessions'] = 'Si ce réglage est activé, les informations sur les sessions en cours seront enregistrées dans la base de données. Attention ! si vous changez ce réglage, tous les utilisateurs seront immédiatement déconnectés, vous y compris ! Si vous utilisez une base de données MySQL, assurez-vous que la variable « max_allowed_packet » dans <em>my.cnf</em> (ou <em>my.ini</em>) ait au moins une valeur de 4M. D\'autres pilotes de sessions peuvent être configurés directement dans le fichier config.php. Veuillez consulter le fichier config-dist.php pour plus d\'information. Ce réglage n\'est plus affiché si un tel pilote de session est configuré dans le fichier config.php.';
$string['configdebug'] = 'Si vous activez cette option, le paramètre PHP « error_reporting » sera augmenté afin que les avertissements soient affichés. Ceci est utile essentiellement pour les développeurs.';
$string['configdebugdisplay'] = 'Une fois ce réglage activé, les rapports d\'erreur seront affichés sur la page HTML. C\'est pratique, mais cela rend non conforme le XHTML, le JS, les cookies et les entêtes HTTP en général. Si le réglage est désactivé, les rapports sont écrits dans les journaux du serveur, permettant un meilleur débogage. Le réglage error_log de PHP contrôle dans quel fichier les rapports sont écrits.';
$string['configdebugpageinfo'] = 'Activer cette option pour afficher des informations concernant la page dans le pied de page.';
$string['configdebugvalidators'] = 'Activer cette option si vous voulez que les liens vers des serveurs de validation soient visibles dans le pied de page. Il vous sera peut-être nécessaire de créer dans votre Moodle un nouvel utilisateur dont le nom d\'utilisateur est <em>w3cvalidator</em> et d\'activer l\'accès aux visiteurs anonymes. Ces modifications peuvent ouvrir l\'accès à votre serveur par des personnes non autorisées. Ne les activez pas sur des serveurs en production !';
$string['configdefaulthomepage'] = 'Ce réglage permet de déterminer le premier lien de la navigation des utilisateurs connectés';
$string['configdefaultrequestcategory'] = 'Les cours demandés par les utilisateurs qui en ont la capacité seront automatiquement classés dans cette catégorie, à moins qu\'ils puisent choisir une catégorie différente.';
$string['configdefaultrequestedcategory'] = 'Catégorie par défaut où placer les cours dont la demande a été approuvée.';
$string['configdefaultuserroleid'] = 'Tous les utilisateurs connectés auront les capacités du rôle spécifié ici, au niveau du site, EN PLUS de celles de tous les autres rôles qu\'ils ont déjà. Par défaut, il s\'agit du rôle « Utilisateur authentifié ». Il est à remarquer que cela n\'entrera pas en conflit avec les autres rôles disponibles, à moins que vous n\'interdisiez des capacités : cela permet simplement de s\'assurer que tous les utilisateurs possèdent les capacités qui ne peuvent être attribuées au niveau des cours (par exemple écrire des articles de blog, gérer son calendrier, etc.).';
$string['configdeleteincompleteusers'] = 'Après ce laps de temps, tout compte sans nom, prénom ou adresse de courriel sera supprimé.';
$string['configdeleteunconfirmed'] = 'Certaines méthodes d\'authentification, par exemple l\'auto-inscription par courriel, exigent que les utilisateurs confirment leur compte durant une période déterminée. À l\'échéance de cette période, tout compte non confirmé sera supprimé.';
$string['configdenyemailaddresses'] = 'Pour interdire les adresses de courriel de certains domaines pour les nouveaux utilisateurs, saisissez ici les domaines rejetés, séparés par des espaces. Pour interdire des sous-domaines, indiquez-les en les préfixant d\'un point, par exemple <strong>hotmail.com yahoo.fr .live.com</strong>. Les adresses de tous les autres domaines seront acceptées.';
$string['configdisableuserimages'] = 'Désactiver la modification de l\'image des utilisateurs dans leur profil.';
$string['configdisplayloginfailures'] = 'Active l\'affichage aux utilisateurs des informations sur les échecs de connexion antérieurs.';
$string['configdndallowtextandlinks'] = 'Activer ou désactiver le glisser-déposer de textes et de liens sur la page du cours, en plus du glisser-déposer des fichiers. Le glisser-déposer de textes avec Firefox ou entre différents navigateurs ne fonctionne pas de manière fiable et pourra avoir comme conséquence le dépôt de textes corrompus ou pas de dépôt du tout.';
$string['configdoclang'] = 'Cette langue sera utilisée pour les liens vers les pages de documentation.';
$string['configdocroot'] = 'Définit l\'URL de Moodle Docs pour la documentation contextuelle signalée par le lien « Aide et documentation » au bas de chaque page. Si le champ n\'est pas renseigné, les liens ne seront pas affichés.';
$string['configdoctonewwindow'] = 'Si ce réglage est activé, les liens vers Moodle Docs s\'ouvriront dans une nouvelle fenêtre.';
$string['configeditordictionary'] = 'Cette valeur sera utilisée si aucun dictionnaire dans la langue de l\'utilisateur n\'est disponible pour aspell.';
$string['configeditorfontlist'] = 'Sélectionner les polices à afficher dans le menu déroulant de l\'éditeur.';
$string['configemailchangeconfirmation'] = 'Exiger une confirmation par courriel lors du changement d\'adresse de courriel par les utilisateurs.';
$string['configemaildkimselector'] = 'Le sélecteur DKIM est arbitraire et votre configuration DNS doit y correspondre.';
$string['configemailfromvia'] = 'Ajoute une information de routage dans la section « De » du courriel sortant. Une telle information informe le destinataire de la provenance du message et aide à éviter que le destinataire réponde accidentellement à des adresses de non-réponse.';
$string['configemailheaders'] = 'Entêtes de courriel à ajouter verbatim à tous les courriels sortant.';
$string['configemailsubjectprefix'] = 'Texte à préfixer à l\'objet de tous les courriels sortants.';
$string['configenableactivitychooser'] = 'Le sélecteur d\'activité est une fenêtre de dialogue comportant une brève description de chaque type d\'activité et de ressource. S\'il est désactivé, des menus déroulant séparés sont affichés pour l\'ajout des ressources et des activités.';
$string['configenableanalytics'] = 'Les modèles d\'analyse de données, par exemple « Étudiants en risque de décrochage » ou « Activités à venir à effectuer », peuvent générer des prédictions, envoyer des notifications d\'indications et offrir d\'autres actions, comme l\'envoi de messages aux utilisateurs.';
$string['configenableblogs'] = 'Ce réglage permet de fournir à tous les utilisateurs du site leur propre blog.';
$string['configenablecalendarexport'] = 'Activer l\'exportation et l\'abonnement aux calendriers.';
$string['configenablecomments'] = 'Activer les commentaires';
$string['configenablecourserequests'] = 'Si ce réglage est activé, les utilisateurs ayant la capacité de demander des cours (moodle/course:request) pourront faire des demandes de création de cours. Cette capacité n\'est permise pour aucun rôle standard. Elle peut être attribuée dans les contextes système et catégorie.';
$string['configenabledevicedetection'] = 'Active la détection des types d\'appareils utilisés pour accéder à la plateforme (téléphone mobile, tablette, ordinateur portable ou de bureau, etc.) pour l\'application de réglages spécifiques (thème, etc.)';
$string['configenablemobilewebservice'] = 'Active le service mobile pour l\'application officielle Moodle ou d\'autres applications le demandant. Pour plus d\'information, lire la {$a}';
$string['configenablerssfeeds'] = 'Si ce réglage est activé, des flux RSS seront générés pour diverses fonctionnalités sur tout le site, par exemple les blogs, forums, bases de données et glossaires. Il sera également nécessaire d\'activer les flux RSS pour chacun des différents modules d’activité.';
$string['configenablerssfeedsdisabled'] = 'Non disponible, car les flux RSS ne sont pas activés pour le site. Pour les activer, voyez l\'option Paramètres techniques sous Administration -> Configuration.';
$string['configenablerssfeedsdisabled2'] = 'Les flux RSS sont désactivés au niveau du site. Ils peuvent être activés dans les fonctions avancées de l\'administration du site.';
$string['configenablestats'] = 'Si vous activez ce réglage, le cron automatique de Moodle traitera les journaux et produira quelques statistiques. Suivant la quantité de trafic sur votre site, le traitement peut prendre du temps. Les statistiques vous fourniront d\'intéressants graphiques et des statistiques sur chaque cours ou sur la totalité du site.';
$string['configenabletrusttext'] = 'Par défaut, Moodle nettoie soigneusement tous les fichiers déposés et textes saisis par les utilisateurs, afin d\'en retirer les éventuels scripts, médias, etc. pouvant constituer une faille de sécurité. Le système « Contenu fiable » vous permet de donner à certains utilisateurs en qui vous avez confiance les permissions requises pour inclure sans interférence de tels éléments dans leurs ressources. Pour faire fonctionner ce système, veuillez d\'abord l\'activer ici, puis accorder la permission « Utiliser des contenus potentiellement dangereux » à un rôle spécifique. Les textes créés ou déposés par des utilisateurs ayant ce rôle seront marqués comme fiables et ne seront alors pas nettoyés avant leur affichage.';
$string['configenablewebservices'] = 'Les services web permettent à d\'autres systèmes, comme l\'app Moodle, de se connecter au site et y effectuer des opérations. Pour plus de sécurité, le réglage doit être désactivé, si vous n\'utilisez pas l\'app ou un autre service externe requérant l\'intégration au moyen de services web.';
$string['configenablewsdocumentation'] = 'Ce réglage active la génération automatique de la documentation des services web. L\'utilisateur d\'un service web peut accéder à sa propre documentation sur sa page de clefs de sécurité {$a}. Seule la documentation sur les protocoles activés est affichée.';
$string['configerrorlevel'] = 'Choisir la quantité d\'avertissement PHP que vous souhaitez voir afficher. « Normal » est généralement le meilleur choix.';
$string['configexportlookahead'] = 'Nombre de jours suivants à exporter';
$string['configexportlookback'] = 'Nombre de jours précédents à exporter';
$string['configextendedusernamechars'] = 'Si ce réglage est activé, les noms d\'utilisateur peuvent comporter n\'importe quel caractère, sauf les caractères haut de casse. Sinon, seuls les caractères alphanumériques bas de casse et les caractères sous-ligné (_), tiret (-), point (.) et arobase (@) sont autorisés.';
$string['configextramemorylimit'] = 'Certains scripts, par exemple pour rechercher, sauvegarder/restaurer ou le cron nécessitent plus de mémoire. Ce réglage spécifie la taille maximale de la mémoire supplémentaire. Indiquez des valeurs plus élevées pour de gros sites.';
$string['configfilterall'] = 'Filtrer toutes les chaînes, y compris les entêtes, titres, barre de navigation, etc. Ce réglage n\'est utile qu\'en combinaison avec l\'utilisation du filtre « Contenus multilingues ». Utilisé seul, il ne fera que charger inutilement votre serveur.';
$string['configfiltermatchoneperpage'] = 'Un seul lien automatique par page sera généré par les filtres de liaison automatique, pour chaque première apparition du texte. Toutes les autres occurrences seront ignorées.';
$string['configfiltermatchonepertext'] = 'Les filtres de liaison automatique ne génèrent qu\'un seul lien, pour la première occurence du texte correspondant sur une page. Les autres occurrences seront ignorées. Ce réglage n\'a pas d\'effet si le réglage « Filtrer une occurrence par page » est désactivé.';
$string['configfilteruploadedfiles'] = 'Filtrer les fichiers HTML et fichiers texte déposés avant de les afficher, ne filtrer que les fichiers HTML déposés ou ne filtrer aucun fichier.';
$string['configforcelogin'] = 'Habituellement, la page d\'accueil du site et la liste des cours (mais pas les cours eux-mêmes) peuvent être consultés sans se connecter au site. Si vous désirez forcer les visiteurs à se connecter avant de faire <strong>quoi que ce soit</strong> dans le site, veuillez activer cette option.';
$string['configforceloginforprofiles'] = 'L\'activation de ce réglage impose aux visiteurs de se connecter en tant qu\'utilisateur réel (authentifié) pour pouvoir consulter les profils des autres utilisateurs. Si vous le désactivez, il pourra arriver que certains utilisateurs utilisent leur profil pour y inclure de la publicité (spam) ou d\'autres contenus inadéquats, qui seront alors visibles par tout le monde.';
$string['configfrontpage'] = 'Les éléments ci-dessus seront affichés sur la page d\'accueil.';
$string['configfrontpagecourselimit'] = 'Nombre maximal de cours';
$string['configfrontpagecourselimithelp'] = 'Ce réglage détermine le nombre maximal de cours à afficher dans les listes de cours sur la page d\'accueil du site.';
$string['configfrontpageloggedin'] = 'Les éléments sélectionnés seront affichés sur la page d\'accueil pour les utilisateurs connectés.';
$string['configfullnamedisplay'] = 'Ce réglage définit comment les noms sont affichés en format complet. La valeur par défaut, « language », conserve le réglage défini en fonction de votre paquetage de langue (les diverses langues ont des conventions différentes).

Pour la plupart des sites monolingues, le réglage le plus efficace est le réglage « Prénom Nom », mais vous pouvez choisir par exemple de cacher les noms de familles. Vous pouvez utiliser ici les variables prédéfinies suivantes : firstname, lastname, firstnamephonetic, lastnamephonetic, middlename, et alternatename.';
$string['configgeoipfile'] = 'Emplacement du fichier binaire GeoLite2 City. Ce fichier ne fait pas partie de la distribution de Moodle. Il doit être obtenu séparément chez <a href="https://www.maxmind.com/">MaxMind</a>. Vous pouvez soit en acheter une version commerciale, soit utiliser la version gratuite. Pour télécharger le fichier de données des villes, vous devez vous enregistrer sur <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/" >https://dev.maxmind.com/geoip/geoip2/geolite2/</a>. Une fois le fichier téléchargé, décompressez-le dans le dossier « {$a} » de votre serveur.';
$string['configgetremoteaddrconf'] = 'Si votre serveur est situé derrière un proxy inverse, vous pouvez utiliser ce réglage pour indiquer les entêtes HTTP dont on peut être sûr qu\'elles contiennent l\'adresse IP distante. Les entêtes sont lues dans l\'ordre indiqué, la première disponible étant utilisée.';
$string['configgradebookroles'] = 'Ce réglage permet de configurer les rôles apparaissant dans le carnet de notes. Pour être mentionnés dans le carnet de notes d\'un cours, les utilisateurs doivent avoir au moins l\'un de ces rôles dans ce cours.';
$string['configgradeexport'] = 'Sélectionnez les formats d\'exportation privilégiés du carnet de notes. Les sélections mettront en place et utiliseront ensuite un champ « dernière exportation » pour chaque note. Par exemple, cela permettra d\'identifier des notes exportées comme « nouvelles » ou « modifiées ». Si vous n\'êtes pas sûr à ce sujet, ne cochez rien.';
$string['confighiddenuserfields'] = 'Veuillez sélectionner quelles informations vous désirez cacher aux autres utilisateurs du cours que les administrateurs/enseignants. Vous pourrez ainsi améliorer la protection des données des étudiants. Il est possible de sélectionner plusieurs champs.';
$string['configidnumber'] = 'Cette option précise si (a) les utilisateurs doivent indiquer un numéro d\'identification non vide ; (b) les utilisateurs doivent indiquer un numéro d\'identification qui peut être vide ; (c) les utilisateurs n\'ont pas besoin d\'indiquer de numéro d\'identification. Le cas échéant, le numéro d\'identification est affiché dans le profil de l\'utilisateur.';
$string['configintro'] = 'Cette page permet de paramétrer certaines variables de configuration qui permettront à Moodle de fonctionner correctement sur ce serveur. Inutile de trop s\'en inquiéter, les paramètres par défaut conviennent la plupart du temps et il est toujours possible de revenir plus tard sur cette page pour les modifier.';
$string['configintroadmin'] = 'Cette page permet de configurer votre compte administrateur principal qui aura le contrôle total du site. Assurez-vous de lui donner un nom et un mot de passe sûrs, ainsi qu\'une adresse de courriel valable. Vous pourrez créer plus tard d\'autres comptes administrateur.';
$string['configintrosite'] = 'Cette page permet définir l\'aspect de la page d\'accueil et le nom de votre site. Vous pourrez modifier ces paramètres en tout temps en utilisant les menus d\'administration.';
$string['configiplookup'] = 'Lorsque que vous cliquez sur une adresse IP (par exemple 34.12.222.93) notamment dans les journaux, une carte de monde vous est affichée, avec une estimation la meilleure possible de la localisation de cette adresse IP. Diverses extensions sont disponibles pour effectuer cette tâche, ayant chacune ses avantages et inconvénients.';
$string['configkeeptagnamecase'] = 'Cocher cette option si vous désirez que les noms des tags conservent leur casse originale, telle que saisie par les utilisateurs qui les créent.';
$string['configlang'] = 'Choisir une langue par défaut pour l\'ensemble du site. Les utilisateurs ont la possibilité de la modifier à l\'aide du menu de langue ou en modifiant le réglage de leur profil personnel.';
$string['configlanglist'] = 'Si ce champ est laissé vide, toutes les langues installées sur ce site seront disponibles dans le menu des langues. Dans le cas contraire, il est possible d\'abréger cette liste en spécifiant une liste des codes des langues désirées, séparés par des virgules, par exemple : fr,es_es,de,en,it. Au besoin, un nom de langue différent de celui du paquetage peut être indiqué en utilisant le format : code de langue|nom de la langue, par exemple : fr_ca|Français,en_kids|English,de_kids|Deutsch.';
$string['configlangmenu'] = 'Déterminer si vous voulez afficher ou non le menu du choix de la langue sur la page d\'accueil, la page de connexion, etc. Les utilisateurs peuvent sélectionner leur langue préférée dans leur propre profil indépendamment de ce réglage.';
$string['configlangstringcache'] = 'Ce réglage active la mise en cache des chaînes de caractères des paquetages de langues dans le dossier de données. Si vous traduisez Moodle ou modifiez des chaînes dans le code source de Moodle, il pourrait être utile de désactiver ce réglage. Sinon, laissez-le activé pour bénéficier d\'une meilleure performance.';
$string['configlatinexcelexport'] = 'Choisir l\'encodage des caractères pour les exportations en format Excel.';
$string['configlocale'] = 'Indiquer un environnement <em>locale</em> pour l\'affichage des dates. <strong>Laissez ce champ vide</strong>, sauf si vous avez une très bonne raison de faire autrement. Si le champ est renseigné, l\'environnement spécifié sera utilisé pour toutes les langues du site et empêchera l\'adaptation automatique de l\'affichage des dates en fonction de la langue choisie par l\'utilisateur.';
$string['configlockrequestcategory'] = 'Si ce réglage est activé, les utilisateurs ayant la capacité de demander des cours ne pourront pas choisir de catégorie dans le formulaire de demande de cours. Une autre possibilité d\'empêcher les utilisateurs de demander un cours dans une catégorie est d\'attribuer cette capacité dans le contexte catégorie.';
$string['configloglifetime'] = 'Ce champ permet de spécifier la durée de conservation des journaux d\'activité des utilisateurs. Il est conseillé de choisir une durée aussi longue que possible. Si votre plateforme est très fréquentée et que la performance se dégrade, il peut être judicieux de diminuer cette durée. Les valeurs inférieures à 30 ne sont pas recommandées, car les statistiques ne fonctionneraient alors pas correctement.';
$string['configlookahead'] = 'Jours à anticiper';
$string['configmailnewline'] = 'Caractère de nouvelle ligne à utiliser dans les messages par courriel. Selon la RFC 822bis, CRLF est obligatoire. Certains serveurs de courriel effectuent une conversion automatique de LF (LineFeed) vers CRLF (CarriageReturn et LineFeed), tandis que d\'autres effectuent une conversion incorrecte de CRLF vers CRCRLF. D\'autres encore rejettent les messages comprenant LF seulement (par exemple qmail). Si vous avez des problèmes de messages non délivrés ou contenant des lignes vides, essayez de modifier ce réglage.';
$string['configmaxbytes'] = 'Ce réglage détermine la taille maximale des fichiers à déposer sur la plateforme. Cette valeur est limitée par les réglages PHP post_max_size et upload_max_filesize, ainsi que par le réglage Apache LimitRequestBody. Elle limite quant à elle la taille maximale pour un fichier à déposer au niveau des cours ou des activités. Si vous choisissez « Limite serveur », la taille maximale allouée par le serveur sera utilisée.';
$string['configmaxconsecutiveidentchars'] = 'Les mots de passe ne doivent pas comporter plus que ce nombre de caractères identiques consécutifs. Indiquez 0 pour désactiver ce contrôle.';
$string['configmaxeditingtime'] = 'Ce paramètre indique la durée pendant laquelle les utilisateurs ont la possibilité de modifier un message, un article de glossaire, etc. qu\'ils ont écrit. Habituellement, 30 minutes est une bonne valeur.';
$string['configmaxevents'] = 'Nombre d\'événements à anticiper';
$string['configmaxusersperpage'] = 'Nombre maximum d\'utilisateurs affichés dans les champs de sélection d\'utilisateurs des cours, groupes, cohortes, services web, etc.';
$string['configmessaging'] = 'Si ce réglage est activé, les utilisateurs peuvent envoyer des messages instantanés à d\'autres utilisateurs du site.';
$string['configmessagingallowemailoverride'] = 'Permet aux utilisateurs de recevoir les notifications par courriel à une autre adresse que celle de leur profil';
$string['configmessagingallusers'] = 'Si ce réglage est activé, les utilisateurs peuvent consulter la liste de tous les utilisateurs du site pour envoyer des messages personnels. Leurs préférences de messagerie incluent en outre une option pour accepter les messages de tous les utilisateurs du site. Si le réglage n\'est pas activé, les utilisateurs ne voient que la liste des utilisateurs de leurs cours, et n\'ont que deux options dans leurs préférences de messagerie : n\'accepter les messages que de leurs contacts ou de leurs contacts et des autres utilisateurs dans leurs cours.';
$string['configmessagingdefaultpressenter'] = 'Si ce réglage est activé, « Taper entrée pour envoyer » est activé par défaut dans les réglages de messagerie des utilisateurs.';
$string['configmessagingdeleteallnotificationsdelay'] = 'Les notifications lues et non lues peuvent être supprimées pour gagner de l\'espace. Combien de temps après sa création une notification peut-elle être supprimée ?';
$string['configmessagingdeletereadnotificationsdelay'] = 'Les notifications de lecture peuvent être supprimées pour gagner de l\'espace. Après combien de temps une telle notification doit être supprimée ?';
$string['configminpassworddigits'] = 'Les mots de passe doivent comporter au moins ce nombre de chiffres.';
$string['configminpasswordlength'] = 'Les mots de passe doivent comporter au moins ce nombre de caractères.';
$string['configminpasswordlower'] = 'Les mots de passe doivent comporter au moins ce nombre de lettres minuscules.';
$string['configminpasswordnonalphanum'] = 'Les mots de passe doivent comporter au moins ce nombre de caractères non alphanumériques.';
$string['configminpasswordupper'] = 'Les mots de passe doivent comporter au moins ce nombre de lettres majuscules.';
$string['configmodchooserdefault'] = 'Présenter par défaut le sélecteur d\'activités ?';
$string['configmycoursesperpage'] = 'Nombre maximal de cours à afficher dans les listes des cours propres à un utilisateur';
$string['configmymoodleredirect'] = 'Ce réglage active la redirection vers le dossier /my lors de la connexion des non-administrateurs et remplace le premier niveau de la barre de navigation du site par /my';
$string['configmypagelocked'] = 'Ce réglage permet d\'éviter la modification de la page par défaut par des non administrateurs';
$string['confignavcourselimit'] = 'Nombre maximum de cours affichés dans la navigation.';
$string['confignavshowallcourses'] = 'Ce réglage détermine si les utilisateurs inscrits dans des cours peuvent voir Cours (la liste de tous les cours) dans la navigation, en plus de Mes cours (la liste des cours dans lesquels ils sont inscrits).';
$string['confignavshowcategories'] = 'Affiche les catégories de cours dans la barre de navigation et dans le bloc de navigation. Cela n\'est pas le cas avec les cours dans lesquels l\'utilisateur est inscrit ; ils seront listés sans catégories sous Mes cours.';
$string['confignoreplyaddress'] = 'Les courriels sont parfois envoyés au nom d\'un utilisateur (par exemple les messages des forums). L\'adresse de courriel spécifiée ici sera utilisée comme adresse de l\'expéditeur lorsqu\'il n\'est pas souhaitable que les utilisateurs répondent directement à l\'auteur du message (par exemple s\'il ne veut pas que son adresse de courriel soit divulguée).';
$string['confignotifyloginfailures'] = 'Active l\'envoi des notifications d\'échec de connexion aux utilisateurs sélectionnés. Ce réglage requiert l\'activation d\'un stockage de journaux interne (par exemple standard).';
$string['confignotifyloginthreshold'] = 'Lorsque les notifications des tentatives de connexion sont activées, combien de tentatives (provenant du même utilisateur ou de la même adresse IP) doivent être notifiées ?';
$string['confignotloggedinroleid'] = 'Les utilisateurs non connectés dans le site seront traités comme si ce rôle leur était accordé au niveau du contexte du site. Le rôle « Visiteur anonyme » est presque toujours ce dont vous aurez besoin ; il se peut toutefois que vous vouliez créer des rôles plus ou moins restrictifs. Les actions telles qu\'écrire des messages dans les forums requièrent toujours une véritable connexion.';
$string['configopentowebcrawlers'] = 'Si vous activez cette option, Google pourra entrer dans votre site en tant qu\'utilisateur anonyme. En outre, les internautes arrivant sur votre site depuis une recherche Google seront automatiquement connectés en tant qu\'utilisateur anonyme. Cependant, cela ne permet un accès transparent qu\'aux cours déjà ouverts aux visiteurs anonymes.';
$string['configoverride'] = 'Défini dans config.php';
$string['configpasswordpolicy'] = 'Si ce réglage est activé, Moodle vérifie si les mots de passe sont conformes à la politique définie ci-dessous. L\'activation de ce réglage n\'a pas d\'impact sur les mots de passe des utilisateurs existants, jusqu\'à ce qu\'ils décident ou ne soient forcés de changer leur mot de passe, ou que le réglage « Vérifier le mot de passe lors de la connexion » soit activé.';
$string['configpasswordpolicycheckonlogin'] = 'Si ce réglage est activé, Moodle vérifiera lors de chaque connexion si les mots de passe sont conformes à la politique des mots de passe. Si la vérification échoue, l\'utilisateur devra modifier son mot de passe avant de pouvoir continuer. Il est utile d\'activer ce réglage après une modification de la politique des mots de passe.';
$string['configpasswordresettime'] = 'Ce réglage spécifie le temps à disposition des utilisateurs pour valider une demande de réinitialisation de mot de passe avant son échéance.
Une durée de 30 minutes est adéquate.';
$string['configpathtodu'] = 'Chemin d\'accès du programme « du » (disk usage). En général quelque chose comme « /usr/bin/du ». Si vous spécifiez ce chemin, les pages affichant le contenu de dossiers contenant beaucoup de fichiers se chargeront beaucoup plus vite.';
$string['configpathtophp'] = 'Chemin d\'accès du programme « PHP CLI ». En général, quelque chose comme « /usr/bin/php ». Si vous spécifiez ce chemin, les scripts de cron pourront être lancés à partir de l\'interface web d\'administration.';
$string['configperfdebug'] = 'L\'activation de cette option a pour effet l\'affichage d\'informations de performance dans le pied de page du thème standard.';
$string['configprofileroles'] = 'Liste des rôles affichés sur les profils utilisateurs et la page de participation.';
$string['configprofilesforenrolledusersonly'] = 'Afin de prévenir les abus de spammeurs, le profil des utilisateurs qui ne sont inscrits à aucun cours sont cachés. Les nouveaux utilisateurs doivent s\'inscrire au moins à un cours pour pouvoir ajouter une description à leur profil.';
$string['configprotectusernames'] = 'Si ce réglage est activé, le formulaire de récupération du mot de passe n\'affiche pas d\'indice pour aider à deviner le nom d\'utilisateur ou l\'adresse de courriel.';
$string['configproxybypass'] = 'Liste séparée par des virgules de noms de domaines ou d\'adresses IP (éventuellement partiels) ne devant pas passer par le proxy (par exemple : 192.168., .mondomaine.com)';
$string['configproxyhost'] = 'Si le serveur qui héberge le site Moodle a besoin d\'utiliser un proxy (dans le cas, par exemple, où il existe un firewall sur le réseau), indiquer ici le nom de ce proxy. Sinon laisser vide.';
$string['configproxypassword'] = 'Mot de passe requis pour accéder à Internet au travers du proxy, si nécessaire. Laisser vide dans le cas contraire (l\'extension cURL de PHP est requise).';
$string['configproxyport'] = 'Si le serveur requiert l\'utilisation d\'un proxy, indiquez ici le port du proxy.';
$string['configproxytype'] = 'Type de proxy web (PHP5 et son extension cURL sont requis pour le support de SOCKS5).';
$string['configproxyuser'] = 'Nom d\'utilisateur requis pour accéder à Internet au travers du proxy, si nécessaire. Laisser vide dans le cas contraire (l\'extension cURL de PHP est requise).';
$string['configrecaptchaprivatekey'] = 'Chaîne de caractères (clef secrète) utilisée pour communiquer entre votre serveur Moodle et le serveur recaptcha. Les clefs reCAPTCHA peuvent être obtenues de <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrecaptchapublickey'] = 'Chaîne de caractères (clef de site) utilisée pour afficher l\'élément reCAPTCHA dans le formulaire d\'enregistrement. Les clefs reCAPTCHA peuvent être obtenues de <a target="_blank" href="https://www.google.com/recaptcha">Google reCAPTCHA</a>.';
$string['configrequestcategoryselection'] = 'Permettre le choix d\'une catégorie lors de la demande d\'un cours';
$string['configrequestedstudentname'] = 'Terme utilisé pour « étudiant » dans les cours demandés';
$string['configrequestedstudentsname'] = 'Terme utilisé pour « étudiants » dans les cours demandés';
$string['configrequestedteachername'] = 'Terme utilisé pour « enseignant » dans les cours demandés';
$string['configrequestedteachersname'] = 'Terme utilisé pour « enseignants » dans les cours demandés';
$string['configreverseproxyignore'] = 'Si votre serveur est derrière plusieurs proxys inverses qui complétent l\'entête X-Forwarded-For, veuillez indiquer une liste, séparée par des virgules, des adresses IP ou des sous-réseaux des proxys inverses à ignorer afin de trouver l\'adresse IP correctes des utilisateurs.';
$string['configsectioninterface'] = 'Interface';
$string['configsectionmail'] = 'Courriel';
$string['configsectionmaintenance'] = 'Maintenance';
$string['configsectionmisc'] = 'Divers';
$string['configsectionoperatingsystem'] = 'Système d\'exploitation';
$string['configsectionpermissions'] = 'Permissions';
$string['configsectionrequestedcourse'] = 'Demande de cours';
$string['configsectionsecurity'] = 'Sécurité';
$string['configsectionstats'] = 'Statistiques';
$string['configsectionuser'] = 'Utilisateur';
$string['configsecureforms'] = 'Moodle peut utiliser un niveau additionnel de sécurité pour la gestion des formulaires web. Si cette option est activée, la variable HTTP_REFERRER du navigateur est comparée à l\'adresse du formulaire. Cela peut poser des problèmes lors de l\'utilisation d\'un firewall (p. ex. Zonealarm) configuré pour ôter HTTP_REFERRER de leur trafic web. Le symptôme est alors le « gel » du formulaire. Si vos utilisateurs ont des problèmes de connexion, par exemple sur la page de connexion, désactiver cette option. Dans le doute, réglez cette option sur « Oui ».';
$string['configsessioncookie'] = 'Ce réglage permet de changer le nom du cookie utilisé pour les sessions de Moodle. Il est optionnel et uniquement utile pour éviter les confusions entre cookies sur un site web où tournent plusieurs Moodle.';
$string['configsessioncookiedomain'] = 'Ce réglage vous permet de modifier le domaine depuis lequel les cookies de Moodle sont disponibles. Ceci est utile pour les modifications locales de Moodle (par exemple les plugins d\'authentification ou d\'inscription) nécessitant de partager les informations de session Moodle avec une application web dans un autre sous-domaine. <strong>ATTENTION ! il est vivement recommandé de ne pas modifier ce réglage et de le laisser vide. Une valeur incorrecte empêchera toute connexion au site.</strong>';
$string['configsessioncookiepath'] = 'Si vous voulez modifier l\'endroit où les navigateurs envoient les cookies, vous pouvez changer ce réglage en indiquant un sous-dossier de votre site web. Dans le cas contraire, le réglage par défaut « / » sera adéquat.';
$string['configsessiontimeout'] = 'Les utilisateurs connectés seront automatiquement déconnectés (leur session sera terminée) après le laps de temps d\'inactivité spécifié dans ce champ.';
$string['configshowcommentscount'] = 'Affiche le nombre de commentaires. Ceci coûte une requête supplémentaire dans la base de données lors de l\'affichage du lien vers les commentaires';
$string['configshowicalsource'] = 'Afficher les informations de la source des événements de calendriers abonnés.';
$string['configshowsiteparticipantslist'] = 'Tous les étudiants et les enseignants de la page d\'accueil de ce site seront affichés dans la liste des participants du site. Qui doit avoir les permissions requises pour voir cette liste des participants de la page d\'accueil ?';
$string['configsitedefaultlicense'] = 'Licence par défaut du site';
$string['configsitedefaultlicensehelp'] = 'La licence par défaut sera utilisée pour publier les contenus sur ce site';
$string['configsitemailcharset'] = 'Ce réglage définit l\'encodage de caractères par défaut des courriels envoyés depuis ce site.';
$string['configsitemaxcategorydepth'] = 'Nombre maximum de niveaux de catégories';
$string['configsitemaxcategorydepthhelp'] = 'Ce réglage détermine le nombre maximal de niveaux de catégories filles affichés dans les listes de catégories ou listes combinées. Les niveaux de catégories plus profonds apparaîtront sous forme de liens et pourront être dépliés par l\'utilisateur.';
$string['configslasharguments'] = 'Les « <em>slash arguments</em> » (qui utilisent <em>PATH_INFO</em>) sont requis pour un affichage correct des paquetages SCORM et des ressources multi-fichiers. Si votre serveur web ne supporte pas les « <em>slash arguments</em> » et que vous ne pouvez pas les configurer, ce réglage peut être désactivé, mais alors certains éléments de Moodle ne fonctionneront plus.<br />Remarque : l\'utilisation des « <em>slash arguments</em> » sera requise dans les prochaines versions de Moodle.';
$string['configsmartpix'] = 'Lorsque ce réglage est activé, les icônes sont affichées via un script PHP, qui les cherche dans le thème actuel, puis dans tous les thèmes parents, et finalement dans le dossier /pix de Moodle. Ainsi il n\'est plus nécessaire de dupliquer les images dans les thèmes, pour un léger coût de performance.';
$string['configsmtpauthtype'] = 'Ce réglage détermine le type d\'authentification à utiliser sur le serveur SMTP.';
$string['configsmtphosts'] = 'Indiquer le nom complet d\'un ou plusieurs serveurs SMTP locaux que Moodle devra utiliser pour envoyer des courriels (par exemple, « mail.a.com » ou « mail.a.com;mail.b.com »). Pour indiquer un port non standard (c\'est-à-dire autre que le port 25), utiliser la syntaxe [server]:[port], par exemple « mail.a.com:587 ». Pour des connexions sécurisées, le port 465 est habituellement utilisé avec SSL, et le port 587 est habituellement utilisé avec TLS ; veuillez si nécessaire indiquer le protocole sécurisé ci-dessous. Si ce paramètre est laissé vide, Moodle utilisera la méthode par défaut de PHP pour envoyer des courriels.';
$string['configsmtpmaxbulk'] = 'Nombre maximum de messages de courriel envoyés lors d\'une session SMTP. En groupant les messages dans une session, on peut accélérer l\'envoi des messages par courriel. Une valeur inférieure à 2 force la création d\'une session SMTP pour chaque message.';
$string['configsmtpsecure'] = 'Si le serveur SMTP requiert une connexion sécurisée, spécifiez le type de protocole adéquat.';
$string['configsmtpuser'] = 'Si vous avez indiqué un nom de serveur SMTP ci-dessus et qu\'il requiert une authentification, entrez ici le nom d\'utilisateur et le mot de passe à utiliser.';
$string['configstartwday'] = 'Début de la semaine';
$string['configstatsfirstrun'] = 'Ce réglage permet de spécifier jusqu\'à quelle date dans le passé les journaux doivent être traités lors de la <b>première fois</b> que le cron traite les statistiques. Si vous avez beaucoup de trafic ou si vous partagez un hébergement, il vous est déconseillé de remonter trop loin dans le temps, car le processus peut prendre beaucoup de temps et nécessite beaucoup de ressources processeur. (Pour ce réglage, veuillez noter que 1 mois = 28 jours. Dans les graphiques et statistiques générées, 1 mois = 1 mois du calendrier.)';
$string['configstatsmaxruntime'] = 'Le traitement des statistiques peut être très intensif. Nous vous conseillons d\'utiliser une combinaison de ce champ et du champ suivant pour spécifier quand le traitement sera lancé et durant combien de temps il tournera.';
$string['configstatsmaxruntime2'] = 'Le traitement des statistiques peut être très intensif. Veuillez indiquer la durée maximale permise pour la récolte des statistiques d\'une journée. Le nombre maximum de jours traités durant l\'exécution d\'un cron est 31.';
$string['configstatsmaxruntime3'] = 'Ce réglage spécifie la durée maximale allouée pour le calcul des statistiques d\'une journée. Les statistiques peuvent être très gourmandes et peuvent fortement charger votre serveur. Le nombre maximum de jours à traiter lors d\'une exécution du cron peut être indiqué ci-dessous.';
$string['configstatsruntimedays'] = 'Ce réglage spécifie le nombre maximal de jours traités lors d\'une même exécution des statistiques. Lorsque les statistiques sont à jour, un seul jour sera traité. Veuillez donc ajuster cette valeur en tenant compte de la capacité de calcul de votre serveur, en la réduisant si le cron doit être exécuté plus rapidement.';
$string['configstatsruntimestart'] = 'Spécifie l\'heure à laquelle le cron lançant le traitement des statistiques doit démarrer. Il est conseillé d\'indiquer des heures différentes si plusieurs instances de Moodle sont installées sur le même serveur.';
$string['configstatsuserthreshold'] = 'Ce réglage spécifie le nombre minimum d\'utilisateurs inscrits dans un cours pour que celui-ci soit inclus dans les statistiques.';
$string['configstrictformsrequired'] = 'Si ce réglage est activé, les utilisateurs ne pourront pas ne saisir qu\'un espace et un saut de ligne dans les champs requis.';
$string['configstripalltitletags'] = 'Désactivez cette option si vous voulez autoriser les balises HTML dans le nom des activités et des ressources.';
$string['configsupportemail'] = 'Cette adresse de courriel sera publiée pour les utilisateurs du site comme une adresse où ils peuvent obtenir de l\'assistance (par exemple lors de la création des comptes des nouveaux utilisateurs). Si le champ n\'est pas renseigné, aucune adresse de courriel ne sera publiée à cet effet.';
$string['configsupportname'] = 'Le nom de la personne ou du service fournissant de l\'assistance par courriel ou sur un site web.';
$string['configsupportpage'] = 'Cette adresse sera publiée pour les utilisateurs du site comme le site web où ils peuvent obtenir de l\'assistance (par exemple lors de la création des comptes des nouveaux utilisateurs). Si le champ n\'est pas renseigné, aucun lien ne sera publié à cet effet.';
$string['configtempdatafoldercleanup'] = 'Supprimer du dossier de données les fichiers temporaires plus anciens que la durée sélectionnée.';
$string['configthemedesignermode'] = 'Normalement, toutes les images et feuilles de styles des thèmes sont mises en cache par les navigateurs pour une longue durée, afin d\'améliorer les performances. Si vous concevez des thèmes ou développez du code, ce réglage vous permet de ne pas faire afficher les versions stockées en cache. Attention ! Ce réglage rend votre site plus lent pour tous les utilisateurs ! Une alternative est de réinitialiser manuellement les caches de thèmes dans la page de sélection de thèmes.';
$string['configthemelist'] = 'Laissez ce champ vide si vous voulez permettre l\'utilisation de n\'importe quel thème. Si vous voulez raccourcir le menu des thèmes, vous pouvez spécifier ici une liste de noms de thèmes autorisés, séparés par des virgules. Par exemple : « clean,more ». N\'utilisez pas d\'espaces !';
$string['configtimezone'] = 'Le fuseau horaire par défaut pour l\'affichage des dates. Chaque utilisateur peut modifier ce réglage dans son propre profil. Les tâches de cron et autres réglages du serveur sont données dans ce fuseau horaire. Vous devez modifier ce réglage si la mention « Fuseau horaire non valide » est affichée.';
$string['configuseblogassociations'] = 'Ce réglage détermine si les utilisateurs peuvent organiser leur blog en associant des articles à des cours ou des modules de cours.';
$string['configuseexternalyui'] = 'Utiliser les fichiers en ligne sur les serveurs de Yahoo au lieu des fichiers installés sur votre serveur. Attention ! Sans connexion internet, les fonctionnalités AJAX ne fonctionneront pas sur votre site. Ce réglage n\'est pas compatible avec les sites utilisant https.';
$string['configuserquota'] = 'Le nombre maximal d\'octets qu\'un utilisateur a à sa disposition pour stocker des fichiers dans sa zone de fichiers personnels. {$a->bytes} octets == {$a->displaysize}';
$string['configusesitenameforsitepages'] = 'Si ce réglage est activé, le nom abrégé du site est utilisé dans la barre de navigation pour les pages du site, au lieu de la chaîne « Pages du site ».';
$string['configusetags'] = 'La fonctionnalité des tags doit-elle être activée sur tout le site ?';
$string['configvariables'] = 'Paramètres techniques';
$string['configverifychangedemail'] = 'Active la vérification des adresses de courriel lorsqu\'elles sont modifiées, en utilisant les réglages des domaines autorisés et interdits. Si ce réglage est désactivé, les restrictions de domaines ne sont appliquées que lors de la création des nouveaux comptes.';
$string['configvisiblecourses'] = 'Afficher normalement les cours placés dans des catégories cachées';
$string['configwarning'] = 'Attention ! Des valeurs inadaptées pour ces paramètres peuvent engendrer des problèmes.';
$string['configyuicomboloading'] = 'Cette option permet un chargement combiné des bibliothèques YUI pour améliorer la performance. Ce réglage devrait être activé sur des sites en production.';
$string['confirmation'] = 'Confirmation';
$string['confirmcontextlock'] = '{$a->contextname} n\'est actuellement pas gelé. Son gel le placera en lecture seule et empêchera les utilisateurs d\'y faire des modifications. Voulez-vous vraiment continuer ?';
$string['confirmcontextunlock'] = '{$a->contextname} est actuellement gelé. Son dégel permettra aux utilisateurs d\'y effectuer des modifications. Voulez-vous vraiment continuer ?';
$string['confirmdeletecomments'] = 'Voulez-vous vraiment supprimer des commentaires ?';
$string['confirmed'] = 'Confirmé';
$string['contenttypeuninstalling'] = 'Il y a {$a->count} contenus utilisant {$a->type}. Ces contenus seront supprimés. Voulez-vous vraiment continuer ?';
$string['contextlockappliestoadmin'] = 'Le gel des contextes s\'applique aux administrateurs';
$string['contextlockappliestoadmin_desc'] = 'Si ce réglage est désactivé, les administrateurs conserveront leur accès en écriture dans tous les contextes gelés.';
$string['contextlocking'] = 'Gel de contexte';
$string['contextlocking_desc'] = 'Ce réglage permet de placer en lecture seule des catégories, cours, activités et blocs sélectionnés.';
$string['cookiehttponly'] = 'Cookies http uniquement';
$string['cookiesecure'] = 'Cookies sécurisé uniquement';
$string['country'] = 'Pays par défaut';
$string['course_customfield'] = 'Champs personnalisés du cours';
$string['coursecolor'] = 'Couleur {$a}';
$string['coursecolorheading_desc'] = 'Les cours qui n\'ont pas d\'image de cours définie dans les paramètres du cours sont affichés dans le tableau de bord avec dans une carte à motifs colorés. Les couleurs à utiliser peuvent être indiquées ci-dessous.';
$string['coursecolorsettings'] = 'Couleurs des cartes de cours';
$string['coursecontact'] = 'Contacts de cours';
$string['coursecontact_desc'] = 'Ce réglage permet de choisir les utilisateurs apparaissant dans la description du cours. Pour être affichés dans la description d\'un cours, les utilisateurs doivent avoir au moins l\'un de ces rôles dans ce cours.';
$string['coursecontactduplicates'] = 'Afficher tous les rôles de contact de cours';
$string['coursecontactduplicates_desc'] = 'Si ce réglage est activé, les utilisateurs avec plus d\'un rôle de contact de cours dans l\'un des cours sélectionnés seront affichés dans la description du cours avec chacun de ces rôles. Sinon, ils ne seront affichés qu\'avec un seul de ces rôles (celui qui est le premier dans la liste « Définition des rôles » dans l\'administration de la plateforme.';
$string['coursegraceperiodafter'] = 'Délai d\'attente pour les cours passés';
$string['coursegraceperiodbefore'] = 'Délai d\'anticipation pour les cours futurs';
$string['courselistshortnames'] = 'Afficher les noms de cours étendus';
$string['courselistshortnames_desc'] = 'Si ce réglage est activé, le nom abrégé des cours est affiché en plus du nom complet du cours dans les listes de cours. Si nécessaire, il est possible de modifier le nom étendu des cours en modifiant la chaîne de caractères « courseextendednamedisplay » dans le paquetage de langue.';
$string['coursemgmt'] = 'Gestion des cours et catégories';
$string['courseoverview'] = 'Vue d\'ensemble cours';
$string['courserequestnotify'] = 'Notification des demandes de cours';
$string['courserequestnotifyemail'] = 'L\'utilisateur {$a->user} a demandé un nouveau cours sur {$a->link}';
$string['courserequests'] = 'Demandes de cours';
$string['courserequestspending'] = 'Demandes de création de cours en attente';
$string['courses'] = 'Cours';
$string['coursesperpage'] = 'Cours par page';
$string['courseswithsummarieslimit'] = 'Limite des cours avec résumé';
$string['creatornewroleid'] = 'Rôle des créateurs de cours dans les nouveaux cours';
$string['creatornewroleid_help'] = 'Si l\'utilisateur n\'a pas déjà les permissions requises pour gérer le nouveau cours, il y sera automatiquement inscrit avec ce rôle.';
$string['cron'] = 'Cron';
$string['cron_enabled'] = 'Activer le cron';
$string['cron_enabled_desc'] = 'Le cron doit normalement être activé, mais ce réglage permet de le désactiver temporairement, par exemple avant un redémarrage du serveur. Si ce réglage est désactivé, le système ne lancera plus de nouvelles tâches de fond. Le cron ne doit pas être désactivé trop longtemps, car cela bloquerait d\'importantes fonctionnalités de Moodle.';
$string['cron_help'] = 'Le script cron.php lance certaines tâches programmées à intervalle régulier, comme l\'envoi par courriel des copies des messages de forums. Il doit être lancé de façon régulière, idéalement chaque minute.';
$string['cronclionly'] = 'Exécution du cron uniquement en mode terminal';
$string['cronerrorclionly'] = 'Désolé, l\'accès à cette page depuis le web a été désactivé par l\'administrateur';
$string['cronerrorpassword'] = 'Désolé, vous n\'avez pas fourni un mot de passe valide pour accéder à cette page';
$string['croninfrequent'] = 'Une durée de {$a->actual} s\'est écoulée entre les deux derniers lancements du script de maintenance <em>cron</em>, alors qu\'il devrait être lancé toutes les {$a->expected}. Il est recommandé de configurer des lancements plus fréquents.';
$string['cronremotepassword'] = 'Mot de passe pour lancer le cron à distance';
$string['cronwarning'] = 'Le <a href="{$a->url}">script de maintenance admin/cron.php</a> n\'a pas été lancé depuis {$a->actual} et devrait être lancé toutes les {$a->expected}.';
$string['cronwarningcli'] = 'Le script de maintenance <code>admin/cli/cron.php</code> n\'a pas été lancé depuis {$a->actual} ; il devrait être lancé toutes les {$a->expected}.';
$string['cronwarningnever'] = 'Le script de maintenance <code>admin/cli/cron.php</code> n\'a jamais été lancé ; il devrait être lancé toutes les {$a->expected}.';
$string['cronwarningneverweb'] = 'Le script <a href="{$a->url}">admin/cron.php</a> n\'a jamais été lancé ; il doit être lancé toutes les {$a->expected}.';
$string['ctyperequired'] = 'L\'installation de l\'extension ctype de PHP est maintenant requise par Moodle, afin d\'améliorer les performances du site et d\'offrir la compatibilité multilingue.';
$string['curlcache'] = 'Durée du cache cURL';
$string['curlrequired'] = 'L\'installation de l\'extension cURL de PHP est maintenant requise par Moodle, afin de pouvoir communiquer avec les dépôts de documents de Moodle.';
$string['curlsecurityallowedport'] = 'Liste de ports cURL autorisés';
$string['curlsecurityallowedportsyntax'] = 'La liste des numéros des ports par lesquels cURL peut se connecter. Les données valides sont des nombres entiers. Si le champ est laissé vide, tous les ports sont autorisés. Si vous indiquez des nombres, les ports 443 et 80 doivent pratiquement toujours être indiqués afin de permettre à cURL de se connecter aux ports standards HTTPS et HTTP.';
$string['curlsecurityblockedhosts'] = 'Liste d\'hôtes bloqués pour cURL';
$string['curlsecurityblockedhostssyntax'] = 'Saisir une adresse ou une plage d\'adresses sur chaque ligne. Les données valides sont soit des adresses complètes IPv4 ou IPv6 (par exemple 192.168.10.1, 0:0:0:0:0:0:0:1, ::1, fe80::), qui correspondent à une serveur unique, soit une plage d\'adresses en notation CIDR (par exemple 231.54.211.0/20 ou fe80::/64), soit une plage d\'adresses IP dont l\'intervalle est spécifié sur le dernier segment de l\'adresse (par exemple 231.3.56.10-20 ou fe80::1111-bbbb), soit un nom de domaine avec joker, par exemple *.exemple.fr ou *.un.exemple.fr). Les lignes vides ne sont pas permises.';
$string['curlsecurityurlblocked'] = 'L\'URL est bloquée.';
$string['curltimeoutkbitrate'] = 'Bande passante à utiliser pour le calcul des timeouts de cURL (kbps)';
$string['curltimeoutkbitrate_help'] = 'Ce réglage est utilisé pour calculer un timeout adéquat durant les grosses requêtes cURL. Pour ce calcul, une requête HTTP HEAD est effectuée pour déterminer la taille du téléchargement. La valeur 0 désactive cette requête.';
$string['currenttheme'] = 'Thème actuel';
$string['customcheck'] = 'Autres vérifications';
$string['custommenu'] = 'Menu personnalisé';
$string['custommenuitems'] = 'Éléments du menu personnalisé';
$string['customusermenuitems'] = 'Éléments du menu utilisateur';
$string['datarootsecurityerror'] = '<p><strong>NOTIFICATION DE SÉCURITÉ !</strong></p><p>Votre dossier de données n\'est pas placé au bon endroit. Il est directement exposé au web. Ceci signifie que tous les fichiers privés de votre Moodle sont disponibles pour n\'importe qui et que certains d\'entre eux peuvent être utilisés par des pirates pour accéder de façon non autorisée à l\'administration de votre site !</p><p>Vous <em>devez</em> déplacer votre dossier de données ({$a}) en dehors de votre dossier web public et mettre à jour le réglage <code>$CFG->dataroot</code> de votre fichier config.php de façon adéquate.</p>';
$string['datarootsecuritywarning'] = 'La configuration de votre site semble ne pas être sûre. Veuillez vous assurer que le dossier des données de Moodle ({$a}) ne soit pas directement accessible depuis le web.';
$string['dbsessions'] = 'Stocker les informations de session dans la base de données';
$string['debug'] = 'Messages de débogage';
$string['debugall'] = 'Tout : afficher tous les messages de débogage de PHP';
$string['debugdeveloper'] = 'Développeur : afficher tous les messages de débogage de Moodle';
$string['debugdisplay'] = 'Afficher les informations de débogage';
$string['debugging'] = 'Débogage';
$string['debugminimal'] = 'Minimal : n\'afficher que les erreurs fatales';
$string['debugnone'] = 'Aucun : n\'afficher aucune erreur, ni avertissement';
$string['debugnormal'] = 'Normal : afficher les erreurs, avertissements et notices';
$string['debugpageinfo'] = 'Afficher les informations concernant la page';
$string['debugsqltrace'] = 'Afficher l\'origine des appels SQL';
$string['debugsqltrace1'] = 'N\'afficher qu\'une seule ligne d\'appel';
$string['debugsqltrace100'] = 'Afficher la trace complète';
$string['debugsqltrace2'] = 'Afficher 2 lignes de la trace';
$string['debugsqltrace_desc'] = 'Si ce réglage est activé, la trace PHP complète ou partielle des appels est insérée en commentaire dans le code SQL.';
$string['debugstringids'] = 'Afficher l\'origine des chaînes de caractères';
$string['debugstringids_desc'] = 'Si ce réglage est activé, l\'identifiant de chaque chaîne de caractères et son composant d\'origine sont affichés lorsque ?strings=1 ou &strings=1 est ajouté à l\'URL de la page.';
$string['debugvalidators'] = 'Afficher les liens de validation W3C';
$string['defaultcity'] = 'Localité par défaut';
$string['defaultcity_help'] = 'La localité saisie ici sera la ville par défaut lors de la création de nouveaux comptes utilisateurs.';
$string['defaultformatnotset'] = 'Erreur de détection du format de cours. Veuillez vérifier les réglages du site.';
$string['defaulthomepage'] = 'Page d\'accueil des utilisateurs';
$string['defaultrequestcategory'] = 'Catégorie par défaut des demandes de cours';
$string['defaultsettinginfo'] = 'Défaut : {$a}';
$string['defaultuserroleid'] = 'Rôle par défaut des utilisateurs';
$string['deleteincompleteusers'] = 'Supprimer les utilisateurs incomplets après';
$string['deleteunconfirmed'] = 'Supprimer les utilisateurs non entièrement configurés après';
$string['deleteuser'] = 'Supprimer l\'utilisateur';
$string['density'] = 'Densité';
$string['denyemailaddresses'] = 'Domaines courriel interdits';
$string['development'] = 'Développement';
$string['devicedetectregex'] = 'Expressions régulières de détection d\'appareils';
$string['devicedetectregex_desc'] = '<p>Par défaut, Moodle est capable de détecter des appareils de type standard (ordinateurs de bureau, ordinateurs portables, etc.), mobiles (téléphones et appareils de petite taille), tablettes (iPads, tablettes Android) et obsolètes (utilisateurs d\'Internet Explorer 6). Le sélecteur de thème peut être utilisé pour appliquer des thèmes distincts pour ces différents appareils. Ce réglage comprend les expressions régulières pour détecter des types de périphériques supplémentaires (ces types ont priorité sur les types par défaut).</p>
<p>Par exemple, vous pouvez entrer l\'expression régulière « /(MIDP-1.0|Maemo|Windows CE)/ » pour détecter certains téléphones, et ajouter la valeur de retour « FeaturePhone ». Cela ajoute l\'option « FeaturePhone » dans le sélecteur de thème, vous permettant d\'ajouter un thème qui serait utilisé sur ces appareils. D\'autres téléphones utiliseraient toujours le thème choisi pour le type de périphérique mobile.</p>';
$string['devicedetectregexexpression'] = 'Expression régulière';
$string['devicedetectregexvalue'] = 'Valeur retournée';
$string['devicetype'] = 'Type d\'appareil';
$string['devlibdirpresent'] = 'Les dossiers contenant des bibliothèques de développement, en particulier <em>/vendor</em> et <em>/node_modules</em>, ne doivent pas être présents sur des sites publics. Consulter le <a href="{$a->moreinfourl}">Panorama de sécurité</a> pour plus de détails.';
$string['disabled'] = 'Désactivé';
$string['disableuserimages'] = 'Désactiver les avatars des utilisateurs';
$string['displayerrorswarning'] = 'L\'activation du réglage PHP <em>display_errors</em> n\'est pas recommandée sur des sites en production, car certains messages d\'erreur peuvent révéler des informations sensibles au sujet de votre serveur.';
$string['displayloginfailures'] = 'Afficher les échecs de connexion';
$string['divertallemails'] = 'Déviation des courriels';
$string['divertallemailsdetail'] = 'À utiliser en environnement de développement lors des tests de l\'envoi de courriels. Ne doit pas être utilisé en production.';
$string['divertallemailsexcept'] = 'Exceptions de la déviation de courriels';
$string['divertallemailsexcept_desc'] = 'Une liste de règles d\'exceptions d\'adresses de courriel, séparées soit par des virgules, soit par des fins de ligne. Chaque règle est interprétée comme une expression régulière, par exemple :
<pre>simone@acme.com
.*@acme.com
fred(\\+.*)?@acme.com
</pre>';
$string['divertallemailsto'] = 'Dévier tous les courriels';
$string['divertallemailsto_desc'] = 'Si ce réglage est activé, tous les courriels seront déviés vers cette unique adresse de courriel.';
$string['dndallowtextandlinks'] = 'Dépôt de textes/liens par glisser-déposer';
$string['doclang'] = 'Langue pour docs';
$string['docroot'] = 'URL du site Moodle Docs';
$string['doctonewwindow'] = 'Ouvrir dans une nouvelle fenêtre';
$string['doesnotfit'] = 'Réglages d\'affichage de courriel';
$string['doesnotfitdetail'] = 'Afficher les réglages des messages qui partent de Moodle.';
$string['download'] = 'Télécharger';
$string['downloadcoursecontentallowed'] = 'Fonctionnalité de téléchargement de contenus de cours disponible';
$string['downloadcoursecontentallowed_desc'] = 'Indique si la fonctionnalité de téléchargement des contenus de cours est disponible dans les cours. Si elle est disponible, le téléchargement de contenus de cours peut être activé ou désactivé à l\'aide du réglage « Activer le téléchargement des contenus de cours » du menu d\'édition des cours (le réglage par défaut de cette option peut être défini dans les <a href={$a} target="_blank">Réglages par défaut des cours</a>).';
$string['durationunits'] = 'unités de durée';
$string['edithelpdocs'] = 'Modifier les fichiers d\'aide';
$string['editlang'] = '<b>Modifier</b>';
$string['editorbackgroundcolor'] = 'Couleur de fond';
$string['editordictionary'] = 'Dictionnaire de l\'éditeur';
$string['editorfontfamily'] = 'Famille de police';
$string['editorfontlist'] = 'Liste des polices';
$string['editorfontsize'] = 'Corps de police';
$string['editorhidebuttons'] = 'Boutons cachés';
$string['editorkillword'] = 'Filtre Word';
$string['editorspelling'] = 'Correction orthographique de l\'éditeur';
$string['editorspellinghelp'] = 'Activer ou désactiver la correction orthographique. Une fois activée, le programme <strong>aspell</strong> doit être installé sur le serveur.';
$string['editstrings'] = 'Modifier les chaînes de caractères';
$string['emailchangeconfirmation'] = 'Confirmation de modification de courriel';
$string['emaildkim'] = 'Signature DKIM (DomainKeys Identified Mail) des courriels';
$string['emaildkiminfo'] = 'Si le sélecteur DKIM et si de plus un fichier de certificat privé correspondant au nom de domaine de l\'adresse "From" se trouve dans $CFG->dataroot/dkim/[domain]/[selector].private, le courriel sera signé. Dans la plupart des cas, (par exemple si allowedemaildomains est vide), un seul certificat est nécessaire dans : <pre>{$a->path}</pre>. Pour plus de détails de configuration, consulter la <a href="{$a->docs}">configuration du courriel</a>.';
$string['emaildkimselector'] = 'Sélecteur DKIM';
$string['emailfromvia'] = 'Information de routage du courriel';
$string['emailheaders'] = 'Entêtes de courriel';
$string['emailsubjectprefix'] = 'Préfixe de l\'objet des courriels';
$string['emoticonalt'] = 'Texte alternatif';
$string['emoticoncomponent'] = 'Composant de l\'image';
$string['emoticonimagename'] = 'Nom de l\'image';
$string['emoticons'] = 'Binettes';
$string['emoticons_desc'] = 'Ce formulaire définit les binettes (ou émoticônes) utilisées sur votre site. Pour définir une nouvelle binette, renseignez les champs de la dernière rangée. Pour supprimer une rangée, effacez son contenu et enregistrez le formulaire. Pour réinitialiser tous les champs à leur valeur par défaut, cliquez sur le lien au-dessous de la table

* Texte (requis) : ce texte sera remplacé par l\'image de la binette. Il doit comporter au moins deux caractères.
* Nom de l\'image (requis) : le nom du fichier de l\'image de la binette, sans extension, relativement au dossier pix du composant.
* Composant de l\'image (requis) : le composant fournissant l\'image.
* Texte alternatif (optionnel) : chaîne de caractères utilisée comme texte alternatif de la binette.';
$string['emoticonsreset'] = 'Réinitialiser les binettes aux valeurs par défaut';
$string['emoticontext'] = 'Texte';
$string['emptysettingvalue'] = 'Vide';
$string['enableactivitychooser'] = 'Activer le sélecteur d\'activités';
$string['enableanalytics'] = 'Analyses de données';
$string['enableblogs'] = 'Activer les blogs';
$string['enablecalendarexport'] = 'Activer l\'exportation des calendriers';
$string['enablecomments'] = 'Activer les commentaires';
$string['enablecourserelativedates'] = 'Activer les dates de cours relatives';
$string['enablecourserelativedates_desc'] = 'Permet de configurer les cours pour afficher les dates relativement à la date de commencement du cours par l\'utilisateur.';
$string['enablecourserequests'] = 'Activer les demandes de création de cours';
$string['enabled'] = 'Activé';
$string['enabledevicedetection'] = 'Activer la détection des appareils';
$string['enableglobalsearch'] = 'Activer la recherche globale';
$string['enableglobalsearch_desc'] = 'Si ce réglage est activé, les données sont indexées et synchronisées au moyen d\'une tâche programmée.';
$string['enablegravatar'] = 'Activer Gravatar';
$string['enablegravatar_help'] = 'Quand ce réglage est activé, Moodle essaiera d\'afficher un avatar à partir de Gravatar, si l\'utilisateur n\'a pas déposé d\'image.';
$string['enablemobilewebservice'] = 'Activer les services web pour appareils mobiles';
$string['enablerecordcache'] = 'Activer le cache des enregistrements';
$string['enablerssfeeds'] = 'Activer les flux RSS';
$string['enablesearchareas'] = 'Activer les zones de recherche';
$string['enablestats'] = 'Activer les statistiques';
$string['enabletrusttext'] = 'Activer le système Contenu fiable';
$string['enableuserfeedback'] = 'Activer le feedback à propos de ce logiciel';
$string['enableuserfeedback_desc'] = 'Si ce réglage est activé, un lien « Envoyer un feedback sur ce logiciel » permettant aux utilisateurs de donner à Moodle HQ un feedback au sujet de Moodle est affiché dans le pied de page. Si l\'option « Prochain rappel de feedback » est activée, un rappel est également affiché sur le tableau de bord des utilisateurs après la durée indiquée. Si la durée indiquée est « Jamais », le rappel est désactivé, mais le lien du pied de page reste affiché.';
$string['enablewebservices'] = 'Activer les services web';
$string['enablewsdocumentation'] = 'Documentation services web';
$string['enrolinstancedefaults'] = 'Réglages par défaut des instances d\'inscription';
$string['enrolinstancedefaults_desc'] = 'Réglages par défaut de l\'inscription dans les nouveaux cours.';
$string['enrolmultipleusers'] = 'Inscrire les utilisateurs';
$string['environment'] = 'Environnement';
$string['environmenterrortodo'] = 'Vous devez résoudre tous les problèmes liés à l\'environnement (erreurs) décrits ci-dessus avant de continuer l\'installation de cette version de Moodle !';
$string['environmenterrorupgrade'] = 'Attention ! Veuillez résoudre tous les problèmes d\'environnement (erreurs) mentionnés ci-dessus avant de continuer la mise à jour vers cette version de Moodle ! La mise à jour sans correction de ces problèmes causera vraisemblablement des problèmes, par exemple des pertes de données. Voulez-vous vraiment continuer maintenant la mise à jour ?';
$string['environmentmariadbwrongdbtype'] = 'Type de base de données <code>$CFG->dbtype</code> incorrect. Veuillez le modifier dans votre fichier <code>config.php</code>, en remplaçant « <code>mysql</code> » par « <code>mariadb</code> ».';
$string['environmentmustfixsetting'] = 'Le réglage doit être modifié.';
$string['environmentok'] = 'Votre environnement serveur possède les modules requis.';
$string['environmentrecommendcustomcheck'] = 'L\'échec de ce test indique un problème potentiel';
$string['environmentrecommendinstall'] = 'L\'extension devrait être installée et activée pour une fonctionnalité optimale';
$string['environmentrecommendversion'] = 'La version {$a->needed} est recommandée ; vous utilisez actuellement la version {$a->current}';
$string['environmentrequirecustomcheck'] = 'ce test doit réussir';
$string['environmentrequireinstall'] = 'L\'extension doit être installée et activée';
$string['environmentrequireversion'] = 'La version {$a->needed} est requise ; vous utilisez actuellement la version {$a->current}';
$string['environmentsettingok'] = 'Réglage recommandé détecté';
$string['environmentshouldfixsetting'] = 'Le réglage devrait être modifié.';
$string['environmentxmlerror'] = 'Erreur lors de la lecture des données d\'environnement ({$a->error_code})';
$string['errordeletingconfig'] = 'Une erreur est survenue lors de la suppression des enregistrements de configuration du plugin « {$a} ».';
$string['errorsetting'] = 'Impossible d\'enregistrer le réglage';
$string['errorwithsettings'] = 'Certains réglages n\'ont pas pu être modifiés en raison d\'une erreur.';
$string['eventshandlersinuse'] = 'Les plugins suivants de votre plateforme utilisent les agents obsolètes suivants de l\'API d\'événements 1 : « {$a} ». Veuillez les mettre à jour pour qu\'ils utilisent l\'API d\'événements 2. Référez-vous à https://docs.moodle.org/dev/Event_2#Event_dispatching_and_observers.';
$string['everyonewhocan'] = 'Tous les utilisateurs pouvant « {$a} »';
$string['exceptions'] = 'Exceptions';
$string['execpathnotallowed'] = 'Le réglage des chemins d\'exécutables et chemins locaux est désactivé dans config.php';
$string['experimental'] = 'Expérimental';
$string['experimentalsettings'] = 'Réglages expérimentaux';
$string['extendedusernamechars'] = 'Autoriser les caractères spéciaux dans les noms d\'utilisateur';
$string['extramemorylimit'] = 'Limite supplémentaire de mémoire PHP';
$string['fatalsessionautostart'] = '<p>Une grave erreur de configuration a été détectée. Veuillez en informer l\'administrateur du serveur.</p><p>Pour fonctionner correctement, Moodle nécessite la modification de certains réglages PHP par l\'administrateur.</p><p>Le réglage <code>session.auto_start</code> doit être désactivé (<code>off</code>).</p><p>Ce réglage peut être modifié sur le serveur dans le fichier <code>php.ini</code>, dans la configuration de Apache/IIS ou dans le fichier <code>.htaccess</code>.</p>';
$string['feedbacksettings'] = 'Réglages de feedback';
$string['fileconversioncleanuptask'] = 'Nettoyage des enregistrements temporaires des conversions de fichiers';
$string['filecreated'] = 'Nouveau fichier créé';
$string['filescleanupperiod'] = 'Nettoyer les fichiers supprimés';
$string['filescleanupperiod_help'] = 'Ce réglage détermine la fréquence de nettoyage des fichiers supprimés. Ces fichiers sont associés à des contextes qui n\'existent plus, par exemple lorsqu\'un cours est supprimé. Remarque : ce réglage peut conduire à des fichiers manquants dans un cours qui a été sauvegardé, supprimé, puis est restauré, si le réglage « Inclure les fichiers » est désactivé dans les « Réglages des sauvegardes automatiques ».';
$string['filesizeunits'] = 'unités de taille de fichiers';
$string['filestoredin'] = 'Enregistre le fichier dans le dossier :';
$string['filestoredinhelp'] = 'Où le fichier doit être stocké';
$string['filterall'] = 'Filtrer toutes les chaînes de caractères';
$string['filtermatchoneperpage'] = 'Filtrer une occurrence par page';
$string['filtermatchonepertext'] = 'Filtrer une occurrence par élément';
$string['filters'] = 'Filtres';
$string['filtersettings'] = 'Gestion des filtres';
$string['filtersettingsgeneral'] = 'Réglages généraux des filtres';
$string['filteruploadedfiles'] = 'Filtrer les fichiers déposés';
$string['forceclean'] = 'Nettoyage du contenu partout';
$string['forceclean_desc'] = 'Les contenus ajoutés à ce site sont normalement nettoyés avant leur affichage, afin d\'y supprimer tout ce qui pourrait constituer un risque de sécurité. Cependant, les contenus ne sont pas nettoyés dans certains endroits, comme la description des activités, les ressources de type page ou les blocs HTML, afin de permettre d\'y ajouter des scripts, des médias, d\'y intégrer des cadres, etc. Si ce réglage est activé, tous les contenus seront nettoyés, ce qui pourrait avoir pour conséquence un affichage incorrect de certains contenus.';
$string['forcelogin'] = 'Imposer la connexion';
$string['forceloginforprofileimage'] = 'Imposer la connexion pour voir les avatars';
$string['forceloginforprofileimage_help'] = 'Si ce réglage est activé, les utilisateurs doivent se connecter afin de voir les images des profils des utilisateurs (avatars). L\'avatar générique sera utilisé pour toutes les notifications par courriel.';
$string['forceloginforprofiles'] = 'Imposer la connexion pour voir les profils';
$string['forcetimezone'] = 'Imposer un fuseau horaire';
$string['formatuninstallwithcourses'] = 'Le format de cours {$a->format} est utilisé dans {$a->count} cours. Après sa suppression, ces cours auront le format {$a->defaultformat} (format par défaut). Certaines données spécifiques au format pourraient être perdues. Voulez-vous vraiment continuer ?';
$string['frontpage'] = 'Page d\'accueil';
$string['frontpagebackup'] = 'Sauvegarde page d\'accueil';
$string['frontpagedefaultrole'] = 'Rôle par défaut sur la page d\'accueil';
$string['frontpagefilters'] = 'Filtres de la page d\'accueil';
$string['frontpageloggedin'] = 'Éléments de la page d\'accueil, une fois connecté';
$string['frontpageoverrides'] = 'Dérogations aux permissions de la page d\'accueil';
$string['frontpagequestions'] = 'Questions de la page d\'accueil';
$string['frontpagerestore'] = 'Restauration page d\'accueil';
$string['frontpageroles'] = 'Rôles page d\'accueil';
$string['frontpagesettings'] = 'Réglages page d\'accueil';
$string['fullnamedisplay'] = 'Format d\'affichage des noms complets';
$string['fullnamedisplayprivate'] = 'Format d\'affichage des noms complets – privé';
$string['gdrequired'] = 'L\'extension GD est désormais requise par Moodle pour modifier les images.';
$string['generalsettings'] = 'Réglages généraux';
$string['geoipfile'] = 'Base de données MaxMind GeoLite2 City';
$string['getremoteaddrconf'] = 'Source de l\'adresse IP enregistrée';
$string['globalsearch'] = 'Recherche globale';
$string['globalsearchmanage'] = 'Gérer la recherche globale';
$string['googlemapkey3'] = 'Clef de Google Maps API v3';
$string['googlemapkey3_help'] = 'Vous devez saisir une clef spéciale pour utiliser Google Maps pour la localisation des adresses IP. Vous pouvez obtenir gratuitement une telle clef sur <a href="https://developers.google.com/maps/documentation/javascript/tutorial#api_key" target="_blank">https://developers.google.com/maps/documentation/javascript/tutorial#api_key</a>.';
$string['gotofirst'] = 'Afficher la première chaîne manquante';
$string['gradebook'] = 'Carnet de notes';
$string['gradebookroles'] = 'Rôles évalués';
$string['gradeexport'] = 'Modules principaux d\'exportation des notes';
$string['gravatardefaulturl'] = 'URL de l\'image Gravatar par défaut';
$string['gravatardefaulturl_help'] = 'Gravatar a besoin d\'une image à afficher par défaut s\'il n\'arrive pas à trouver d\'image pour un utilisateur donné. Veuillez indiquer une URL complète. Si vous laissez vide ce réglage, Moodle tentera d\'utiliser une image la plus adéquate possible selon la page consultée. Gravatar permet d\'utiliser divers codes pouvant être utilisés pour <a href="https://en.gravatar.com/site/implement/images/#default-image">générer des images par défaut</a>.';
$string['groupenrolmentkeypolicy'] = 'Politique des clefs d\'inscription aux groupes';
$string['groupenrolmentkeypolicy_desc'] = 'Si ce réglage est activé, Moodle vérifie si les clefs d\'inscription aux groupes sont conformes à la politique de mots de passe définie ci-dessus.';
$string['guestroleid'] = 'Rôle du compte « Visiteur anonyme »';
$string['guestroleid_help'] = 'Ce rôle est automatiquement attribué au compte Utilisateur anonyme. Il est également attribué temporairement aux utilisateurs qui entrent dans un cours via le plugin d\'inscription des utilisateurs anonymes.';
$string['h5pgetcontenttypestask'] = 'Télécharger depuis h5p.org les types de contenus H5P disponibles';
$string['helpadminseesall'] = 'Ce réglage détermine si dans le calendrier du site, les administrateurs voient et peuvent filtrer les événements des calendriers de tous les cours ou seulement des cours auxquels ils sont inscrits. Indépendamment de ce réglage, les administrateurs peuvent toujours gérer les événements du calendrier de chaque cours en visitant d\'abord le cours, puis en accédant au calendrier du cours.';
$string['helpcalendarcustomexport'] = 'Activer des intervalles de dates personnalisés dans l\'exportation des calendriers. L\'exportation des calendriers doit être activée pour que ce réglage soit utilisé.';
$string['helpexportlookahead'] = 'Le nombre de jours après la date d\'aujourd\'hui durant lesquels des événements doivent être recherchés afin de les exporter lors des exportations personnalisées.';
$string['helpexportlookback'] = 'Le nombre de jours avant la date d\'aujourd\'hui durant lesquels des événements doivent être recherchés afin de les exporter lors des exportations personnalisées.';
$string['helpforcetimezone'] = 'Vous pouvez autoriser les utilisateurs à choisir leur fuseau horaire ou imposer le même fuseau horaire pour tous.';
$string['helpshowicalsource'] = 'Si vous activez ce réglage, le nom et le lien du calendrier abonné seront affichés pour les événements importés.';
$string['helpsitemaintenance'] = 'Activer le mode de maintenance';
$string['helpstartofweek'] = 'Quel est le premier jour de la semaine dans le calendrier ?';
$string['helpupcominglookahead'] = 'Par défaut, combien de jours dans le futur le calendrier considère-t-il les événements à venir ?';
$string['helpupcomingmaxevents'] = 'Par défaut, quel est le nombre maximum d\'événements à venir affichés ?';
$string['helpweekenddays'] = 'Quel jours sont traités comme jours du « week-end » et affichés d\'une couleur différente ?';
$string['hiddenuserfields'] = 'Masquer les champs des utilisateurs';
$string['hidefromall'] = 'Cacher pour tous les utilisateurs';
$string['hidefromnone'] = 'Ne pas cacher';
$string['hidefromstudents'] = 'Cacher pour les étudiants';
$string['htmleditor'] = 'Éditeur WYSIWYG';
$string['htmleditorsettings'] = 'Réglages éditeur';
$string['htmlsettings'] = 'Réglages HTML';
$string['http'] = 'HTTP';
$string['httpsecurity'] = 'Sécurité HTTP';
$string['iconvrequired'] = 'L\'installation de l\'extension ICONV de PHP est requise.';
$string['igbinary322buggyversion'] = 'L\'extension php-igbinary installée sur ce site peut entraîner des problèmes lorsqu\'elle fonctionne avec PHP7.2. Il est recommandé soit de mettre à jour php-igbinary à la version 3.2.5 ou ultérieure, soit de mettre à jour PHP vers la version PHP7.3 ou ultérieure.';
$string['ignore'] = 'Ignorer';
$string['includemoduleuserdata'] = 'Inclure les données utilisateurs des modules';
$string['incompatibleblocks'] = 'Blocs incompatibles';
$string['incompleteunicodesupport'] = 'La configuration actuelle de MySQL ou de MariaDB utilise le réglage « utf8 ». Cet encodage de caractères ne supporte pas les caractères encodés sur 4 octets, comme certains emoji. L\'utilisation de ces caractères provoquera une erreur et les informations envoyées à la base de données seront perdues. Veuillez modifier votre réglage à « utf8mb4 ». Consultez <a href="https://docs.moodle.org/3x/fr/Support_unicode_complet_pour_MySQL">la documentation</a> pour plus de détails.';
$string['indexdata'] = 'Indexer les données';
$string['indexinginfo'] = 'La manière recommandée d\'indexer les contenus de votre plateforme est l\'utilisation de la tâche programmée « Indexation pour recherche globale ».';
$string['installhijacked'] = 'L\'installation doit être terminée depuis la même adresse IP.';
$string['installsessionerror'] = 'Impossible d\'initialiser la session PHP. Veuillez vérifier que votre navigateur accepte les cookies.';
$string['intlrecommended'] = 'L\'installation de l\'extension optionnelle Intl de PHP est utilisée pour améliorer le support de l\'internationalisation, par exemple pour les tris alphabétiques.';
$string['intlrequired'] = 'L\'extension Intl de PHP est nécessaire afin d\'améliorer le support de l\'internationalisation, par exemple le tri en fonction de la langue et les noms de domaines internationaux.';
$string['invalidagedigitalconsent'] = 'L\'âge de majorité numérique n\'est pas valide : {$a}';
$string['invalidforgottenpasswordurl'] = 'L\'URL de récupération de mot de passe n\'est pas valide.';
$string['invalidsection'] = 'Section non valide.';
$string['invalidthemepreset'] = 'Le fichier de préréglages choisi n\'est pas compatible avec ce thème. L\'erreur de compilation SCSS était : « {$a} »';
$string['invaliduserchangeme'] = 'Le nom d\'utilisateur « changeme » est réservé. Il n\'est pas permis de créer un compte de ce nom.';
$string['ipblocked'] = 'Ce site n\'est actuellement pas accessible.';
$string['ipblocker'] = 'Blocage IP';
$string['ipblockersyntax'] = 'Indiquer une adresse (complète ou partielle) ou une plage d\'adresses par ligne. Des entrées valides sont soit une adresse IP complète (par exemple <b>192.168.10.1</b>), qui correspond à un seul serveur, soit une adresse IP partielle, (par exemple <b>192.168</b>), qui correspond à la plage des adresses commençant par ces nombres, ou une adresse en format CIDR (par exemple <b>231.54.211.0/20</b>), ou encore une plage d\'adresses IP (par exemple <b>231.3.56.10-20</b>) dans laquelle la plage est indiquée sur la dernière partie de l\'adresse. Les noms de domaines (comme « exemple.fr ») ne sont pas autorisés. Les lignes vide et le texte après un caractère « # » sont ignorés.';
$string['iplookup'] = 'Recherche d\'adresse IP';
$string['iplookupgeoplugin'] = 'Le service <a href="https://www.geoplugin.com">geoPlugin</a> est actuellement utilisé pour obtenir les informations géographiques. Pour des résultats plus précis, l\'installation d\'une copie locale de la base de données MaxMind GeoLite est recommandée.';
$string['iplookupinfo'] = 'Par défaut, Moodle utilise le service en ligne gratuit NetGeo (Internet Geographic Database) pour afficher la localisation des adresses IP. Malheureusement cette base de données n\'est plus entretenue et peut fournir des résultats <em>totalement faux</em>. Il est recommandé d\'installer sur votre serveur une copie gratuite de la base de données GeoLite2 City de MaxMind.<br />La localisation des adresses IP est affichée sur une simple carte ou à l\'aide de Google Maps. Veuillez noter que vous aurez besoin d\'un compte Google et de demander une clef gratuite pour l\'utilisation de l\'API de Google Maps API pour activer les cartes interactives.';
$string['iplookupmaxmindnote'] = 'Ce produit comprend les données GeoLite2 créées par MaxMind, disponibles sur <a href="https://www.maxmind.com/">https://www.maxmind.com/</a>.';
$string['iscustomadminwarnings'] = 'Votre site utilise un dossier « admin » personnalisé. Cette fonctionnalité n\'est plus supportée et sera supprimée après Moodle 4.2.';
$string['ishttpswarning'] = 'Votre site n\'est pas sécurisé au moyen de HTTPS. Il est vivement recommandé de passer votre site en HTTPS pour une sécurité accrue et une meilleure intégration à d\'autres systèmes.';
$string['keeptagnamecase'] = 'Conserver la casse des tags';
$string['lang'] = 'Langue par défaut';
$string['langcache'] = 'Cache du menu des langues';
$string['langcache_desc'] = 'Mettre en cache le menu des langues. L\'activation de cette option met en cache la liste des langues disponibles. Le cache est automatiquement reconstruit lors de l\'installation ou de la suppression d\'une langue par le gestionnaire des langues de Moodle. Si vous installez une langue manuellement, veuillez utiliser la fonction de purge des caches pour actualiser la liste.';
$string['langlist'] = 'Langues du menu des langues';
$string['langmenu'] = 'Afficher le menu des langues';
$string['langmenuinsecurelayout'] = 'Afficher le menu des langues dans l\'affichage sécurisé';
$string['langmenuinsecurelayout_desc'] = 'Si ce réglage est activé, un utilisateur pourra modifier la langue d\'affichage lors de la participation à un test ou à une autre activité utilisant l\'affichage sécurisé.';
$string['langpackwillbeupdated'] = 'Au cours de la mise à jour, Moodle mettra également à jour les paquetages de langue installés.';
$string['langstringcache'] = 'Mettre en cache toutes les chaînes de langue';
$string['languagesettings'] = 'Réglages langue';
$string['latinexcelexport'] = 'Encodage Excel';
$string['legacyfilesaddallowed'] = 'Permettre l\'ajout de fichiers aux fichiers de cours obsolètes';
$string['legacyfilesaddallowed_help'] = 'Si un cours contient des fichiers de cours obsolètes, permettre d\'y ajouter de nouveaux fichiers et dossiers.';
$string['legacyfilesinnewcourses'] = 'Fichiers du cours (obsolète) dans les nouveaux cours';
$string['legacyfilesinnewcourses_help'] = 'Par défaut, les zones de fichiers du cours (obsolètes) ne sont disponibles que dans les cours provenant de mises à jour de versions antérieures. Veuillez prendre note que certaines fonctionnalités, notamment la sauvegarde et la restauration d\'une activité unique, ne sont pas compatibles avec ce réglage.';
$string['libcurlwarning'] = 'La bibliothèque libcurl détectée ne supporte pas CURLOPT_PROTOCOL. Pour des raisons de sécurité, il est recommandé de mettre à jour libcurl.';
$string['licensesettings'] = 'Réglages de licence';
$string['linkadmincategories'] = 'Lier les catégories de l\'administration';
$string['linkadmincategories_help'] = 'Si ce réglage est activé, les catégories des paramètres de l\'administration seront affichées dans la navigation comme des liens menant aux pages des diverses catégories.';
$string['linkcoursesections'] = 'Toujours lier les sections de cours';
$string['linkcoursesections_help'] = 'Si ce réglage est activé, un lien vers les sections de cours sera toujours fourni. Les sections de cours ne sont habituellement affichées sous forme de liens que si le format de cours affiche une seule section par page.';
$string['loading'] = 'Chargement';
$string['localetext'] = 'Locale du site';
$string['localstringcustomization'] = 'Modification locale des chaînes de caractères';
$string['location'] = 'Lieu';
$string['locationsettings'] = 'Réglages lieu';
$string['locked'] = 'Verrouillé';
$string['lockoutduration'] = 'Durée de blocage du compte';
$string['lockoutduration_desc'] = 'Les comptes bloqués seront automatiquement débloqués une fois cette durée écoulée';
$string['lockoutemailbody'] = 'Votre compte utilisateur « {$a->username} » sur le serveur « {$a->sitename} » a été bloqué suite à plusieurs tentatives de connexion non valides.

Pour débloquer votre compte immédiatement, veuillez consulter la page à l\'adresse

{$a->link}

Dans la plupart des logiciels de courriel, cette adresse devrait apparaître comme un lien de couleur bleue qu\'il vous suffit de cliquer. Si cela ne fonctionne pas, copiez ce lien et collez-le dans la barre d\'adresse de votre navigateur web.

Si vous avez besoin d\'aide, veuillez contacter l\'administrateur du site,
{$a->admin}';
$string['lockoutemailsubject'] = 'Votre compte sur {$a} a été bloqué';
$string['lockouterrorunlock'] = 'Information de déblocage du compte non valide.';
$string['lockoutthreshold'] = 'Limite pour blocage de compte';
$string['lockoutthreshold_desc'] = 'Indiquer le nombre de tentatives infructueuses successives de connexion déclenchant le blocage du compte. Cette fonctionnalité peut être utilisée lors d\'attaques en déni de service.';
$string['lockoutwindow'] = 'Période d\'observation pour blocage des comptes';
$string['lockoutwindow_desc'] = 'Période durant laquelle le nombre de tentatives infructueuses successives de connexion est contrôlé. Si aucune nouvelle tentative infructueuse n\'a lieu durant cette période, le compteur est remis à zéro.';
$string['lockrequestcategory'] = 'Empêcher la sélection d\'une catégorie';
$string['log'] = 'Journaux';
$string['logguests'] = 'Enregistrer les journaux de l\'utilisateur anonyme';
$string['logguests_help'] = 'Ce réglage permet d\'enregistrer les actions du compte utilisateur anonyme et des utilisateurs non authentifiés. Les sites avec un grand trafic de visiteurs anonymes devraient désactiver cette option en cas de baisse de performance. Il est recommandé d\'activer ce réglage sur les sites en production.';
$string['logininfoinsecurelayout'] = 'Afficher le nom de l\'utilisateur connecté dans l\'affichage sécurisé';
$string['logininfoinsecurelayout_desc'] = 'Si ce réglage est activé, le nom complet de l\'utilisateur est affiché dans la barre de navigation lors de la participation à un test ou à une autre activité utilisant l\'affichage sécurisé.';
$string['loginpageautofocus'] = 'Curseur automatique dans les champs du formulaire de connexion';
$string['loginpageautofocus_help'] = 'L\'activation de ce réglage améliore l\'ergonomie de la page de connexion, au prix d\'une accessibilité diminuée (car le placement automatique du curseur dans les champs de saisie n\'est pas toujours accessible).';
$string['loglifetime'] = 'Conserver les journaux durant';
$string['logo'] = 'Logo';
$string['logo_desc'] = 'Un logo ou logotype qui sera utilisé par certains thèmes. Cette image peut être en haute résolution, car elle sera mise à l \'échelle (et mise en cache pour augmenter la performance). Les logos plus larges que long donnent de meilleurs résultats. Formats acceptés : PNG et JPG.';
$string['logocompact'] = 'Logo compact';
$string['logocompact_desc'] = 'Une version compacte du même logo que ci-dessus, par exemple une icône ou un emblême. L\'image doit être lisible même en petite taille. Formats acceptés : PNG et JPG.';
$string['logossettings'] = 'Logos';
$string['logstorenotrequired'] = 'Stockage de journaux non requis';
$string['logstoressupported'] = 'Stockages de journaux permettant ce rapport';
$string['longtimewarning'] = '<b>Veuillez noter que ce processus peut prendre beaucoup de temps.</b>';
$string['mailnewline'] = 'Caractère de fin de ligne des courriels';
$string['maintenancemode'] = 'En mode de maintenance';
$string['maintenancemodeisscheduled'] = 'Le site passera en mode de maintenance dans {$a->min} min {$a->sec} s';
$string['maintenancemodeisscheduledlong'] = 'Ce site passera en mode de maintenance dans {$a->hour} heures {$a->min} min {$a->sec} s';
$string['maintfileopenerror'] = 'Erreur lors de l\'ouverture des fichiers de maintenance !';
$string['maintinprogress'] = 'Opérations de maintenance en cours…';
$string['managecontextlock'] = 'Geler ce contexte';
$string['managecontextlocklocked'] = '{$a->contextname} et tous ses sous-contextes sont maintenant gelés.';
$string['managecontextlockunlocked'] = '{$a->contextname} et tous ses sous-contextes sont maintenant dégelés.';
$string['managecontextunlock'] = 'Dégeler ce contexte';
$string['managecustomfields'] = 'Gérer les types de champs personnalisés';
$string['manageformats'] = 'Gérer les formats de cours';
$string['manageformatsgotosettings'] = 'Le format par défaut peut être changé dans {$a}';
$string['managelang'] = 'Gérer';
$string['managelicenses'] = 'Gérer les licences';
$string['manageqbehaviours'] = 'Gérer les comportements de question';
$string['manageqtypes'] = 'Gérer les types de question';
$string['maturity100'] = 'Bêta';
$string['maturity150'] = 'Version candidate';
$string['maturity200'] = 'Version stable';
$string['maturity50'] = 'Alpha';
$string['maturityallowunstable'] = 'Conseil : lancer ce script avec l\'option --allow-unstable';
$string['maturitycoreinfo'] = 'Votre site utilise actuellement du code de développement instable « {$a} ».';
$string['maturitycorewarning'] = 'Vous êtes sur le point d\'installer une version ou de mettre à jour Moodle vers un version marquée comme « {$a} », qui n\'est pas considérée comme prête pour la production. Veuillez vous assurer que cette action est intentionnelle et que vous utilisez la version voulue de Moodle.';
$string['maxbytes'] = 'Taille maximale des fichiers déposés';
$string['maxconsecutiveidentchars'] = 'Caractères identiques consecutifs';
$string['maxeditingtime'] = 'Durée maximale de modification des messages';
$string['maxsizeperdownloadcoursefile'] = 'Taille maximale par fichier';
$string['maxsizeperdownloadcoursefile_desc'] = 'La taille maximale de chaque fichier lors du téléchargement de contenus de cours. Les fichiers dépassant cette taille ne seront pas inclus.';
$string['maxtimelimit'] = 'Temps d\'exécution maximal';
$string['maxtimelimit_desc'] = 'Si vous voulez restreindre la durée maximale d\'exécution des scripts PHP permise par Moodle sans modification d\'affichage, veuillez saisir ici une valeur (en secondes). Une valeur 0 indique que les restrictions par défaut seront utilisées. Si votre serveur impose ses propres limites, indiquez ici une valeur inférieure afin d\'obtenir les erreurs PHP dans les journaux. Ce réglage ne s\'applique pas aux scripts en ligne de commande.';
$string['maxusersperpage'] = 'Nombre maximum d\'utilisateurs par page';
$string['mbstringrecommended'] = 'Bien que la bibliothèque MBSTRING soit facultative, il est vivement recommandé de l\'installer sur le serveur pour de meilleures performances, notamment si votre site supporte des caractères non latins.';
$string['mbstringrequired'] = 'L\'installation de la bibliothèque MBSTRING est requise afin d\'améliorer les performance du site, notamment si des langues avec des caractères non romains sont utilisées sur le site.';
$string['mediapluginavi'] = 'Activer le filtre .avi';
$string['mediapluginflv'] = 'Activer le filtre .flv';
$string['mediapluginimg'] = 'Activer l\'intégration automatique d\'images liées';
$string['mediapluginmov'] = 'Activer le filtre .mov';
$string['mediapluginmp3'] = 'Activer le filtre .mp3';
$string['mediapluginmpg'] = 'Activer le filtre .mpg';
$string['mediapluginogg'] = 'Autoriser le filtre .ogg';
$string['mediapluginogv'] = 'Autoriser le filtre .ogv';
$string['mediapluginram'] = 'Activer le filtre .ram';
$string['mediapluginrm'] = 'Activer le filtre .rm';
$string['mediapluginrpm'] = 'Activer le filtre .rpm';
$string['mediapluginswf'] = 'Activer le filtre .swf';
$string['mediapluginswfnote'] = 'Par mesure de sécurité, les utilisateurs normaux ne doivent pas avoir les permissions requises pour intégrer des fichiers flash au format swf.';
$string['mediapluginwmv'] = 'Activer le filtre .wmv';
$string['mediapluginyoutube'] = 'Activer le filtre YouTube';
$string['messaging'] = 'Activer la messagerie';
$string['messagingallowemailoverride'] = 'Adresse de notification de remplacement';
$string['messagingallusers'] = 'Permettre les messages de site';
$string['messagingcategory'] = 'Messagerie';
$string['messagingdefaultpressenter'] = 'Taper entrée pour envoyer activé par défaut';
$string['messagingdeleteallnotificationsdelay'] = 'Supprimer toutes les notifications';
$string['messagingdeletereadnotificationsdelay'] = 'Supprimer les notifications de lecture';
$string['messagingssettings'] = 'Réglages de messagerie';
$string['minpassworddigits'] = 'Chiffres';
$string['minpasswordlength'] = 'Longueur du mot de passe';
$string['minpasswordlower'] = 'Lettres minuscules';
$string['minpasswordnonalphanum'] = 'Caractères non alphanumériques';
$string['minpasswordupper'] = 'Lettres majuscules';
$string['misc'] = 'Divers';
$string['mlbackendsettings'] = 'Réglages d\'apprentissage automatique';
$string['mnetrestore_extusers'] = '<strong>Remarque :</strong> ce fichier de sauvegarde contient des comptes utilisateurs distants provenant d\'un réseau Moodle, qui seront restaurés au cours du processus.';
$string['mnetrestore_extusers_admin'] = '<strong>Remarque :</strong> ce fichier de sauvegarde semble provenir d\'une installation de Moodle différente et contient des comptes utilisateurs distants du Réseau Moodle. Le processus de restauration tentera de faire correspondre les serveur Réseau Moodle pour tous les utilisateurs créés. Ceux qui n\'auront pas de correspondance seront automatiquement basculés en mode d\'authentification interne (au lieu de mnet). Le journal de restauration vous informera à ce sujet.';
$string['mnetrestore_extusers_mismatch'] = '<strong>Remarque :</strong> ce fichier de sauvegarde semble provenir d\'une installation de Moodle différente. Il contient des comptes utilisateurs distants provenant d\'un réseau Moodle dont la restauration pourrait échouer. Cette opération n\'est pas supportée. Si vous êtes vraiment certain que ce fichier a été créé sur ce Moodle, ou si vous pouvez vous assurer que tous les serveurs du réseau Moodle sont configurés correctement, vous pouvez malgré tout tenter la restauration.';
$string['mnetrestore_extusers_noadmin'] = '<strong>Remarque :</strong> ce fichier de sauvegarde semble provenir d\'une installation de Moodle différente et contient des comptes utilisateurs distants du Réseau Moodle. Vous n\'avez pas les permissions requises pour effectuer ce type de restauration. Veuillez contacter l\'administrateur du site ou restaurer le cours sans les informations des utilisateurs (modules, fichiers, etc.)';
$string['mnetrestore_extusers_switchuserauth'] = 'Authentification de l\'utilisateur {$a->username} du Réseau Moodle distant (provenant de {$a->mnethosturl}) basculée vers utilisateur authentifié localement {$a->auth}.';
$string['mobilenotconfiguredwarning'] = 'L\'app Moodle n\'est pas activée.';
$string['modchooserdefault'] = 'Utiliser le sélecteur d\'activités';
$string['modeditdefaults'] = 'Valeurs par défaut des réglages des activités';
$string['modsettings'] = 'Gestion des activités';
$string['modulesecurity'] = 'Sécurité modules';
$string['moodleapp'] = 'App Moodle';
$string['moodleapp_help'] = '<p>L\'app Moodle gratuite permet aux utilisateurs d\'accéder à leurs cours avec leurs appareils mobiles. Plus de fonctionnalités sont disponibles avec un plan Pro ou Premium pour l\'app.</p>
<a href="https://moodle.com/mobile-app">Obtenir l\'app Moodle</a><br />
<a href="https://apps.moodle.com">Portail des apps Moodle</a>';
$string['moodlebrandedapp'] = 'App Moodle personnalisée';
$string['moodlebrandedapp_help'] = '<p>L\'app Moodle personnalisée a toutes les fonctionnalités de notre app mobile gratuite pour Moodle, avec votre propre visuel personnalisé.</p>
<a href="https://moodle.com/branded-app">À propos de l\'app Moodle personnalisée</a>';
$string['moodlebrandedappreference'] = 'Autrement, obtenez une <a href="https://moodle.com/branded-app">app Moodle personnalisée</a> avec vos propres visuels.';
$string['moodlepartners'] = 'Partenaires Moodle';
$string['moodlepartners_help'] = '<p>Les Partenaires Moodle sont des fournisseurs de services certifiés par Moodle HQ pour fournir des services Moodle de qualité élevée pour l\'organisation de votre environnement d\'apprentissage Moodle.</p>
<a href="https://moodle.com/about-partners/">À propos de nos Partenaires Moodle</a><br />
<a href="https://moodle.com/partners">Trouver un Partenaire</a>';
$string['moodleservices'] = 'Services Moodle';
$string['moodleservices_help'] = 'Assurez-vous d\'obtenir le meilleur de votre environnement d\'apprentissage Moodle en utilisant les services Moodle ci-dessous.';
$string['multilangforceold'] = 'Imposer l\'ancienne syntaxe du filtre multilingue : &lt;span&gt; sans class="multilang" et &lt;lang&gt;';
$string['mustenablestats'] = 'Les statistiques n\'ont pas encore été activées sur ce site.';
$string['mycoursesperpage'] = 'Nombre de cours';
$string['mydashboard'] = 'Tableau de bord par défaut';
$string['mymoodle'] = 'Tableau de bord';
$string['mymoodleredirect'] = 'Imposer aux utilisateurs l\'utilisation de Ma page';
$string['mypage'] = 'Tableau de bord par défaut';
$string['mypagelocked'] = 'Verrouiller la page par défaut';
$string['myprofile'] = 'Page de profil par défaut';
$string['navadduserpostslinks'] = 'Ajouter des liens permettant d\'afficher les messages postés par l\'utilisateur';
$string['navadduserpostslinks_help'] = 'Quand ce réglage est activé, deux liens seront affichés dans le bloc de navigation, permettant de consulter les discussions lancées par l\'utilisateur et les messages qu\'il a postés sur les forums du site ou de cours spécifiques.';
$string['navcourselimit'] = 'Limite de cours';
$string['navigationupgrade'] = 'Cette mise à jour introduit deux nouveaux blocs de navigation destinés à remplacer les blocs suivants : Administration, Cours, Activités et Participants. Si vous avez défini des permissions particulières pour ces blocs, veuillez vérifier que tout fonctionne comme vous le désirez.';
$string['navshowallcourses'] = 'Afficher tous les cours';
$string['navshowcategories'] = 'Afficher les catégories de cours';
$string['navshowfrontpagemods'] = 'Afficher les activités de la page d\'accueil dans la navigation';
$string['navshowfrontpagemods_help'] = 'Si ce réglage est activé, les activités de la page d\'accueil seront affichées dans la navigation, au-dessous des pages de site.';
$string['navshowfullcoursenames'] = 'Afficher les noms complets des cours';
$string['navshowfullcoursenames_help'] = 'Si ce réglage est activé, les noms complets des cours seront utilisés dans la navigation, au lieu des noms abrégés.';
$string['navshowmycoursecategories'] = 'Afficher mes catégories de cours';
$string['navshowmycoursecategories_help'] = 'Si ce réglage est activé, les cours d\'un utilisateur affichés dans Mes cours seront affichés dans leur catégorie dans le bloc de navigation (uniquement pour les thèmes basés sur Classic).';
$string['navsortmycourseshiddenlast'] = 'Trier mes cours cachés en dernier';
$string['navsortmycourseshiddenlast_help'] = 'Si ce réglage est activé, les cours cachés seront listés après les cours visibles (pour les utilisateurs qui peuvent voir les cours cachés). Sinon les cours seront triés selon l\'ordre défini par le réglage « Trier mes cours », indépendamment de leur visibilité.';
$string['navsortmycoursessort'] = 'Trier mes cours';
$string['navsortmycoursessort_help'] = 'Détermine si les cours dans Mes cours sont listés dans l\'ordre de tri actif (l\'ordre de tri indiqué dans Administration du site > Cours > Gestion des cours) ou suivant l\'ordre alphabétique.';
$string['never'] = 'Jamais';
$string['neverdeleteruns'] = 'Ne jamais supprimer les profilages';
$string['newestdocindexed'] = 'Dernier document indexé';
$string['nobookmarksforuser'] = 'Vous n\'avez pas de marque-page.';
$string['nodatabase'] = 'Pas de base de données';
$string['nohttpsformobilewarning'] = 'Il est recommandé d\'activer HTTPS avec un certificat valide. L\'app Moodle tentera toujours d\'utiliser en premier une connexion sécurisée.';
$string['nomissingstrings'] = 'Aucune chaîne manquante';
$string['none'] = 'Aucun';
$string['nonewsettings'] = 'Aucun nouveau réglage n\'a été ajouté lors de cette mise à jour.';
$string['nonexistentbookmark'] = 'Le marque-page demandé n\'existe pas.';
$string['noreplyaddress'] = 'Adresse de non-réponse';
$string['noreplydomain'] = 'Non-réponse et domaine';
$string['noreplydomaindetail'] = 'Réglages de non-réponse et domaines configurés';
$string['noresults'] = 'Aucun résultat trouvé.';
$string['noroles'] = 'Pas de rôle';
$string['nosupportedlogstore'] = 'Aucun stockage de journaux supporté';
$string['notifications'] = 'Notifications';
$string['notifyloginfailures'] = 'Envoyer les erreurs de connexion à';
$string['notifyloginthreshold'] = 'Seuil pour les notifications par courriel';
$string['notloggedinroleid'] = 'Rôle des utilisateurs non connectés';
$string['numberofmissingstrings'] = 'Nombre de chaînes de caractères manquantes : {$a}';
$string['numberofstrings'] = 'Nombre total de chaînes de caractères : {$a->strings}<br />Manquantes : {$a->missing} ({$a->missingpercent} %)';
$string['oauthrefreshtokenexpired'] = 'Le jeton d\'actualisation pour l\'un des services OAuth {$a->issuer} de votre site {$a->siteurl} est échu. Par conséquent, les fonctionnalités des plugins qui utilisent ce service seront limitées. Pour corriger ceci, veuillez viser la page de configuration des services OAuth 2 et cliquer sur l\'icône « Connect system account » dans la rangée correspondant à ce service. Assurez-vous de vous connecter à chaque fois avec le même compte de service de OAuth.';
$string['oauthrefreshtokenexpiredshort'] = 'Jeton d\'actualisation échu pour {$a->issuer} sur votre site {$a->siteurl}.';
$string['onlynoreply'] = 'Seulement à partir d\'une adresse de non-réponse';
$string['opcacherecommended'] = 'La mise en cache PHP opcode améliore les performances et diminue les besoins en mémoire. L\'extension OPcache de PHP est recommandée et totalement supportée.';
$string['opensslrecommended'] = 'L\'installation de la bibliothèque optionnelle OpenSSL est vivement recommandée, afin de pouvoir utiliser la fonctionnalité Réseau Moodle.';
$string['opensslrequired'] = 'L\'extension OpenSSL de PHP est requise par Moodle, pour fournir des services cryptographiques plus robustes.';
$string['opentowebcrawlers'] = 'Ouvert à Google';
$string['optionalmaintenancemessage'] = 'Message de maintenance facultatif';
$string['order1'] = 'Premier';
$string['order2'] = 'Deuxième';
$string['order3'] = 'Troisième';
$string['order4'] = 'Quatrième';
$string['outgoingmailconfig'] = 'Configuration du courriel sortant';
$string['overridetossl'] = 'HTTPS pour les connexions est désormais obsolète. Cet instance impose désormais SSL. Pour supprimer cet avertissement, veuillez modifier le paramètre wwwroot de votre fichier config.php en remplaçant http:// par https://.';
$string['pageinfodebugsummary'] = 'Informations sur cette page : {$a}';
$string['passwordchangelogout'] = 'Déconnexion après changement de mot de passe';
$string['passwordchangelogout_desc'] = 'Si ce réglage est activé, lorsqu\'un mot de passe est modifié, toutes les sessions de navigateurs sont terminées, à l\'exception de celle dans laquelle le nouveau mot de passe est spécifié (ce réglage ne concerne pas le changement de mots de passe par le dépôt d\'utilisateurs en lots).';
$string['passwordchangetokendeletion'] = 'Supprimer les jetons d\'accès aux services web après un changement de mot de passe';
$string['passwordchangetokendeletion_desc'] = 'Si ce réglage est activé, lorsqu\'un mot de passe est modifié, tous les jetons de services web de l\'utilisateur sont supprimés.';
$string['passwordpolicy'] = 'Politique de mots de passe';
$string['passwordpolicycheckonlogin'] = 'Vérifier le mot de passe lors de la connexion';
$string['passwordresettime'] = 'Durée maximale pour valider la demande de réinitialisation du mot de passe';
$string['passwordreuselimit'] = 'Limite de rotation des mots de passe';
$string['passwordreuselimit_desc'] = 'Le nombre de fois qu\'un utilisateur doit changer son mot de passe avant de pouvoir réutiliser un mot de passe. Les hachages des mots de passe utilisés sont stockés dans la base de données. Cette fonctionnalité peut ne pas être compatible avec certains plugins d\'authentification externe.';
$string['pathtodot'] = 'Chemin d\'accès à <em>dot</em>';
$string['pathtodot_help'] = 'Chemin d\'accès du programme « dot ». Sur Linux, quelque chose comme /usr/bin/dot. Sur MacOS, quelque chose comme /usr/local/bin/dot. Sous Windows, quelque chose comme C:\\Program Files (x86)\\Graphviz2.38\\bin\\dot.exe. Pour permettre de générer des fichiers graphiques à partir de fichiers DOT, vous devez installer l’exécutable dot et indiquer ici son chemin d\'accès.';
$string['pathtodu'] = 'Chemin d\'accès à <em>du</em>';
$string['pathtogs'] = 'Chemin d\'accès à <em>ghostscript</em>';
$string['pathtogs_help'] = 'Chemin d\'accès du programme « ghostscript ». En général quelque chose comme « /usr/bin/gs ». Sur les serveurs Windows, cela sera quelque chose comme « c:\\gs\\bin\\gswin32c.exe » (assurez-vous qu\'il n\'y a pas d\'espace dans le chemin d\'accès. Si nécessaire, copiez les fichiers « gswin32c.exe » et « gsdll32.dll » dans un nouveau dossier dont le chemin d\'accès ne comporte pas d\'espace).';
$string['pathtopgdump'] = 'Chemin d\'accès à <em>pg_dump</em>';
$string['pathtopgdumpdesc'] = 'Il n\'est nécessaire de renseigner ce champ que si vous avez plus d\'un programme <em>pg_dump</em> sur votre serveur (par exemple si plus d\'une version de postgresql est installée)';
$string['pathtopgdumpinvalid'] = 'Chemin d\'accès à <em>pg_dump</em> non valide. Le chemin est incorrect ou le programme n\'est pas exécutable';
$string['pathtophp'] = 'Chemin d\'accès à <em>PHP CLI</em>';
$string['pathtopsql'] = 'Chemin d\'accès à <em>psql</em>';
$string['pathtopsqldesc'] = 'Il n\'est nécessaire de renseigner ce champ que si vous avez plus d\'un programme <em>psql</em> sur votre serveur (par exemple si plus d\'une version de postgresql est installée)';
$string['pathtopsqlinvalid'] = 'Chemin d\'accès à <em>psql</em> non valide. Le chemin est incorrect ou le programme n\'est pas exécutable';
$string['pathtopython'] = 'Chemin d\'accès à <em>Python</em>';
$string['pathtopythondesc'] = 'Chemin d\'accès du programme Python (Python 2 et Python 3 sont acceptables).';
$string['pathtosassc'] = 'Chemin d\'accès à <em>SassC</em>';
$string['pathtosassc_help'] = 'Si le chemin d\'accès au programme SassC est renseigné, la compilation SASS sera effectuée par ce programme, au lieu du code PHP de Moodle. Consultez https://github.com/sass/sassc pour des informations supplémentaires.';
$string['pcreunicodewarning'] = 'Il est vivement recommandé d\'utiliser l\'extension PCRE de PHP, qui est compatible avec les caractères Unicode.';
$string['perfdebug'] = 'Informations de performance';
$string['performance'] = 'Performance';
$string['pgcluster'] = 'PostgreSQL Cluster';
$string['pgclusterdescription'] = 'Paramètre de version/cluster de PostgreSQL pour les opérations en ligne de commande. Si vous n\'avez qu\'un seul postgresql sur votre serveur ou n\'êtes pas sûr de ce dont il s\'agit, laissez ce champ vide.';
$string['phpfloatproblem'] = 'Un problème a été détecté dans le traitement des nombres par PHP : {$a}';
$string['pleaserefreshregistration'] = 'Votre site a été enregistré. L\'enregistrement a été mis à jour le {$a}.<br />La tâche programmée « Enregistrement du site » s\'occupe de tenir à jour votre enregistrement. Vous pouvez aussi mettre à jour votre enregistrement n\'importe quand, autant de fois que vous le voulez.';
$string['pleaserefreshregistrationnewdata'] = 'Les informations d\'enregistrement ont été modifiées. Veuillez le confirmer en cliquant sur le bouton « Mettre à jour l\'enregistrement ».';
$string['pleaserefreshregistrationunknown'] = 'Votre site a été enregistré, mais la date de l\'enregistrement est inconnue. Veuillez mettre à jour votre enregistrement en cliquant sur le bouton « Mettre à jour l\'enregistrement » ou vous assurer que la tâche programmée « Enregistrement du site » est activée, de sorte que votre enregistrement se mette à jour automatiquement.';
$string['plugin'] = 'Plugin';
$string['plugins'] = 'Plugins';
$string['pluginscheck'] = 'Vérification des dépendances des plugins';
$string['pluginscheckfailed'] = 'La vérification des dépendances des plugins a échoué pour {$a->pluginslist}';
$string['pluginschecktodo'] = 'Toutes les exigences nécessaires pour les plugins doivent être satisfaites avant d\'installer cette version de Moodle !';
$string['pluginsoverview'] = 'Vue d\'ensemble des plugins';
$string['pluginsoverviewsee'] = 'Voir <a href="{$a->url}">la vue d\'ensemble des plugins</a> pour plus de détails.';
$string['policysettings'] = 'Réglages des politiques';
$string['privacy:metadata'] = 'Le plugin Administration n\'enregistre aucune donnée personnelle.';
$string['privacyandpolicies'] = 'Protection des données et politiques';
$string['privacysettings'] = 'Réglages de protection des données';
$string['profilecategory'] = 'Catégorie';
$string['profilecategoryname'] = 'Nom de catégorie (doit être unique)';
$string['profilecategorynamenotunique'] = 'Ce nom de catégorie est déjà utilisé';
$string['profilecommonsettings'] = 'Réglages communs';
$string['profileconfirmcategorydeletion'] = 'Le(s) {$a} champ(s) de cette catégorie seront déplacés dans la catégorie ci-dessus (ou ci-dessous s\'ils sont dans la catégorie racine).<br />Voulez-vous vraiment supprimer cette catégorie ?';
$string['profileconfirmfielddeletion'] = 'Les {$a} enregistrement(s) de ce champ seront supprimés.<br />Voulez-vous vraiment supprimer ce champ ?';
$string['profilecreatecategory'] = 'Créer une nouvelle catégorie de profil';
$string['profilecreatefield'] = 'Créer un nouveau champ de profil :';
$string['profilecreatenewcategory'] = 'Création d\'une catégorie';
$string['profilecreatenewfield'] = 'Création d\'un nouveau champ de profil « {$a} »';
$string['profiledefaultcategory'] = 'Autres champs';
$string['profiledefaultchecked'] = 'Cochée par défaut';
$string['profiledefaultdata'] = 'Valeur par défaut';
$string['profiledeletecategory'] = 'Suppression d\'une catégorie';
$string['profiledeletefield'] = 'Suppression du champ « {$a} »';
$string['profiledescription'] = 'Description du champ';
$string['profiledscript'] = 'Ce script a été profilé';
$string['profiledscriptview'] = 'Afficher l\'information de profilage de ce script';
$string['profileeditcategory'] = 'Modification de la catégorie : {$a}';
$string['profileeditfield'] = 'Modification du champ : {$a}';
$string['profilefield'] = 'Champ de profil';
$string['profilefieldcolumns'] = 'Colonnes';
$string['profilefieldispassword'] = 'Champ mot de passe';
$string['profilefieldlink'] = 'Lien';
$string['profilefieldlink_help'] = 'Pour transformer un texte en lien, tapez une URL contenant $$. Les $$ seront remplacés par le texte. Par exemple pour transformer un identifiant Twitter en lien, tapez https://twitter.com/$$.';
$string['profilefieldlinktarget'] = 'Cible du lien';
$string['profilefieldmaxlength'] = 'Longueur maximale';
$string['profilefieldrows'] = 'Lignes';
$string['profilefields'] = 'Champs du profil';
$string['profilefieldsize'] = 'Taille d\'affichage';
$string['profileforceunique'] = 'Les données du champ doivent-elles être uniques ?';
$string['profileinvaliddata'] = 'Valeur incorrecte';
$string['profilelocked'] = 'Ce champ est-il verrouillé ?';
$string['profilemenudefaultnotinoptions'] = 'La valeur par défaut n\'est pas une des options';
$string['profilemenunooptions'] = 'Aucune option de menu n\'est donnée';
$string['profilemenuoptions'] = 'Options de menu (une par ligne)';
$string['profilemenutoofewoptions'] = 'Vous devez fournir au moins 2 options';
$string['profilename'] = 'Nom';
$string['profilenofieldsdefined'] = 'Aucun champ n\'a été défini';
$string['profilerequired'] = 'Ce champ est-il requis ?';
$string['profileroles'] = 'Rôles affichés dans les profils';
$string['profilesforenrolledusersonly'] = 'Affichage du profil des utilisateurs inscrits à des cours uniquement';
$string['profileshortname'] = 'Nom abrégé (doit être unique)';
$string['profileshortnameinvalid'] = 'Ce nom abrégé ne peut contenir que des caractères alphanumériques (lettres et chiffres) ou souligné (_).';
$string['profileshortnamenotunique'] = 'Ce nom abrégé est déjà utilisé';
$string['profilesignup'] = 'Afficher sur la page de création de compte ?';
$string['profilespecificsettings'] = 'Réglages spécifiques';
$string['profilevisible'] = 'Pour qui ce champ est-il visible ?';
$string['profilevisible_help'] = '* caché - pour les données privées, uniquement visible pour les administrateurs
* visible pour l\'utilisateur - pour les données personnelles, visibles par l\'utilisateur et les administrateurs
* visible pour l\'utilisateur, les enseignants et les administrateurs - pour les données personnelles, visibles par l\'utilisateur, les enseignants et les administrateurs (sur le profil de cours)
* visible pour tous';
$string['profilevisibleall'] = 'Visible pour tous';
$string['profilevisiblenone'] = 'Caché';
$string['profilevisibleprivate'] = 'Visible pour l\'utilisateur';
$string['profiling'] = 'Profilage';
$string['profilingallowall'] = 'Profilage en continu';
$string['profilingallowall_help'] = 'Si vous activez ce réglage, vous pourrez utiliser à tout moment le paramètre PROFILEALL pour activer le profilage de tous les scripts exécutés au cours d\'une session Moodle. De façon analogue, vous pourrez utiliser le paramètre PROFILEALLSTOP pour stopper le profilage.';
$string['profilingallowme'] = 'Profilage sélectif';
$string['profilingallowme_help'] = 'Si vous activez ce réglage, vous pourrez utiliser sélectivement le paramètre PROFILEME et le profilage du script concerné aura lieu. De façon analogue, vous pourrez utiliser le paramètre DONTPROFILEME pour éviter le profilage.';
$string['profilingautofrec'] = 'Profilage automatique';
$string['profilingautofrec_help'] = 'Après configuration de ce réglage, certaines requêtes (aléatoires, sur la base de la fréquence spécifiée, 1 sur N) seront choisies et profilées automatiquement, et les résultats du profilage seront stockés pour analyse ultérieure. Ce type de profilage respecte les réglages d\'inclusion/exclusion. Une valeur 0 désactive le profilage automatique.';
$string['profilingenabled'] = 'Activer le profilage';
$string['profilingenabled_help'] = 'Ce réglage permet d\'activer le profilage pour votre site. Vous pourrez alors définir comment le profilage se déroule à l\'aide des options ci-dessous.';
$string['profilingexcluded'] = 'Exclure du profilage';
$string['profilingexcluded_help'] = 'Liste d\'URLs (séparées par des virgules ou des sauts de lignes) qui seront exclus du profilage, parmi ceux qui sont spécifiés sous « URLs à profiler ».';
$string['profilingimportprefix'] = 'Préfixe d\'importation de profilage';
$string['profilingimportprefix_desc'] = 'Pour faciliter la détection, toutes les exécutions de profilage importées seront préfixées avec le texte renseigné ici.';
$string['profilingincluded'] = 'URLs à profiler';
$string['profilingincluded_help'] = 'Liste d\'URLs (séparées par des virgules ou des sauts de ligne) qui seront automatiquement profilées. Exemples : /index.php, /course/view.php. Ce champ accepte le caractère joker * à n\'importe quel endroit, par exemple /mod/forum/*, /mod/*/view.php.';
$string['profilinglifetime'] = 'Conserver les profilages';
$string['profilinglifetime_help'] = 'Veuillez indiquer le laps de temps durant lequel vous désirez conserver les informations d\'anciens profilages. Les plus anciens seront supprimés périodiquement. Les profilages marqués comme « profilage de référence » ne sont pas concernés par ce réglage et seront de toute manière conservés.';
$string['profilingslow'] = 'Profiler les pages lentes';
$string['profilingslow_help'] = 'Si une durée minimale en secondes est indiquée, toutes les pages plus lentes que cette durée seront profilées. Seuls les profils plus lents qu\'un profil existant pour le même script seront conservés. Indiquez 0 pour désactiver. Les réglages d\'exclusion s\'appliquent.';
$string['protectusernames'] = 'Protéger les noms d\'utilisateur';
$string['proxybypass'] = 'Exceptions du proxy';
$string['proxyhost'] = 'Hôte du proxy';
$string['proxypassword'] = 'Mot de passe du proxy';
$string['proxyport'] = 'Port du proxy';
$string['proxytype'] = 'Type de proxy';
$string['proxyuser'] = 'Nom d\'utilisateur du proxy';
$string['purgecaches'] = 'Purger tous les caches';
$string['purgecachesconfirm'] = 'Moodle peut placer en cache les thèmes, le code Javascript, les chaînes de caractères traduites, le texte filtré, les flux RSS et beaucoup d\'autres données calculées. En effaçant ces caches, des données seront supprimées du serveur et forceront les navigateurs à recalculer les données pour être sûr que les données affichées sont bien celles qui sont à jour. L\'effacement des caches ne cause aucun problème, mais votre site semblera plus lent durant un certain temps, car le serveur et les clients devront calculer les nouvelles données et les placer en cache.';
$string['purgecachesfinished'] = 'Tous les caches ont été purgés.';
$string['purgecachesnoneselected'] = 'Sélectionner un ou plusieurs caches à purger';
$string['purgecachespage'] = 'Purger les caches';
$string['purgefiltercache'] = 'Filtres texte';
$string['purgejscache'] = 'JavaScript';
$string['purgelangcache'] = 'Chaînes de langue';
$string['purgemuc'] = 'Tous les caches MUC';
$string['purgeothercaches'] = 'Tous les caches de fichiers et divers';
$string['purgeselectedcaches'] = 'Purger les caches sélectionnés';
$string['purgeselectedcachesfinished'] = 'Les caches sélectionnés ont été purgés.';
$string['purgetemplates'] = 'Gabarits';
$string['purgethemecache'] = 'Thèmes';
$string['query'] = 'Requête';
$string['question'] = 'Question';
$string['questionbehaviours'] = 'Comportements de question';
$string['questioncwqpfscheck'] = 'Une ou plusieurs questions aléatoires d\'un test tire ses questions de catégories partagées et de catégories non partagées. Pour ne savoir plus, consulter le <a href="{$a->reporturl}">rapport des questions aléatoires</a> et la <a href="{$a->docsurl}">documentation</a>.';
$string['questioncwqpfsok'] = 'Il n\'y a dans vos tests aucune question aléatoire tirant ses questions de catégories partagées et de catégories non partagées.';
$string['questiontype'] = 'Type de question';
$string['questiontypes'] = 'Types de question';
$string['quizattemptsupgradedmessage'] = 'Une mise à jour majeure des questions était comprise dans Moodle 2.1. Il était alors possible de retarder cette mise à niveau. Avant de passer à Moodle 2.7, cette mise à jour est désormais obligatoire.';
$string['recaptchaprivatekey'] = 'Clef secrète ReCAPTCHA';
$string['recaptchapublickey'] = 'Clef de site ReCAPTCHA';
$string['referrernone'] = 'Réglage par défaut du navigateur';
$string['referrerpolicy'] = 'Politique de référent';
$string['referrerpolicydesc'] = 'Détermine l\'entête de politique de référent à inclure dans les réponses envoyées par votre site.';
$string['register'] = 'Enregistrer votre site';
$string['registermoodlenet'] = '<p>Nous serions heureux de garder le contact et de vous donner des informations importantes au sujet de votre plateforme Moodle !</p>
<p>En enregistrant votre site,</p>
<ul><li>vous pouvez vous inscrire pour recevoir la notification des nouvelles versions de Moodle, des alertes de sécurité et d\'autres informations importantes ;</li>
<li>vous pouvez avoir accès et activer les notifications <em>push</em> pour mobiles à partir de votre site Moodle au moyen de notre <a href="https://download.moodle.org/mobile/">app Moodle</a> gratuite ;</li>
<li>vous contribuez aux <a href="https://stats.moodle.org">statistiques Moodle</a> de la communauté mondiale, ce qui nous aide à améliorer Moodle et nos sites communautaires ;</li>
<li>si vous le désirez, votre site peut être inclus dans la <a href="https://moodle.net/stats">liste des sites Moodle enregistrés</a> de votre pays.</li></ul>';
$string['registermoodleorg'] = 'Lors de l\'enregistrement de votre site';
$string['registermoodleorgli1'] = 'Vous êtes inscrit à une liste de diffusion à bas trafic diffusant des notifications importantes, comme des alertes de sécurité et les nouvelles versions de Moodle.';
$string['registermoodleorgli2'] = 'Des statistiques sur votre site sont ajoutées aux {$a} de la communauté mondiale de Moodle.';
$string['registerwithmoodleorg'] = 'Enregistrer votre site';
$string['registration'] = 'Enregistrement';
$string['registration_help'] = 'Grâce à l\'enregistrement de votre site :

* vous recevrez les alertes de sécurité
* vous pourrez activer les notifications push de l\'app mobile pour votre site
* vous contribuez aux statistiques Moodle de la communauté internationale';
$string['registrationwarning'] = 'Votre site n\'est pas encore enregistré.';
$string['registrationwarningcontactadmin'] = 'Votre site n\'est pas encore enregistré. Veuillez en informer l\'administrateur de la plateforme.';
$string['releasenoteslink'] = 'Pour des informations sur cette version de Moodle, veuillez consulter les <a target="_blank" href="{$a}">Notes de mise à jour</a> en ligne.';
$string['rememberuserlicensepref'] = 'Enregistrer le choix de licence de l\'utilisateur';
$string['rememberuserlicensepref_help'] = 'Si ce réglage est activé, la dernière licence choisie par l\'utilisateur est présélectionnée quand il dépose un fichier dans le sélecteur de fichiers. Sinon, la licence par défaut du site est présélectionnée.';
$string['rememberusername'] = 'Se souvenir du nom d\'utilisateur';
$string['rememberusername_desc'] = 'Si ce réglage est activé, le nom de l\'utilisateur est enregistré de façon permanente dans un cookie, lors de la connexion. Les cookies permanents peuvent soulever des questions de protection des données personnelles quand ils sont utilisés sans le consentement de l\'utilisateur.';
$string['reportsmanage'] = 'Gérer les rapports';
$string['requestcategoryselection'] = 'Activer le choix de catégorie';
$string['required'] = 'Requis';
$string['requiredentrieschanged'] = 'Information : après la mise à jour, le réglage « Fiches requises avant consultation » est imposé dans les bases de données suivantes :<br/><strong>{$a->text}</strong><br/>';
$string['requiremodintro'] = 'Exiger une description';
$string['requiremodintro_desc'] = 'Si cette option est activée, une description est requise pour chaque activité.';
$string['requires'] = 'Requiert';
$string['restorecourse'] = 'Restaurer un cours';
$string['restorernewroleid'] = 'Rôle de l\'utilisateur qui restaure un cours';
$string['restorernewroleid_help'] = 'Si l\'utilisateur qui restaure un cours n\'a pas les permissions requises pour gérer le cours nouvellement restauré, il est au besoin automatiquement inscrit au cours et ce rôle lui est attribué. Choisir « Aucun » si vous ne voulez pas que les utilisateurs qui restaurent des cours puissent gérer les cours restaurés.';
$string['resultfilter'] = 'Filtrer par résultat';
$string['reverseproxy'] = 'Proxy inverse';
$string['reverseproxyignore'] = 'Ignorer les proxys inverses';
$string['riskconfig'] = 'Les utilisateurs pourraient modifier la configuration et le comportement du site';
$string['riskconfigshort'] = 'Configuration des risques';
$string['riskdataloss'] = 'Les utilisateurs pourraient détruire une grande quantité de contenus ou d\'informations';
$string['riskdatalossshort'] = 'Risque de perte de données';
$string['riskmanagetrust'] = 'Les utilisateurs pourraient modifier les réglages de confiance d\'autres utilisateurs';
$string['riskmanagetrustshort'] = 'Gestion des réglages de confiance';
$string['riskpersonal'] = 'Les utilisateurs pourraient avoir accès aux informations personnelles d\'autres utilisateurs';
$string['riskpersonalshort'] = 'Risque lié à la protection des données';
$string['riskspam'] = 'Les utilisateurs pourraient envoyer du spam à des utilisateurs du site ou d\'autres personnes';
$string['riskspamshort'] = 'Risque de spam';
$string['riskxss'] = 'Les utilisateurs pourraient déposer des fichiers ou écrire des textes permettant le « cross-site scripting » (XSS)';
$string['riskxssshort'] = 'Risque XSS';
$string['roleswithexceptions'] = '{$a->roles}, avec {$a->exceptions}';
$string['rssglobaldisabled'] = 'Désactivé au niveau du site';
$string['save'] = 'Enregistrer';
$string['savechanges'] = 'Enregistrer les modifications';
$string['scssinvalid'] = 'Le code SCSS n\'est pas valide. Erreur avec : {$a}';
$string['search'] = 'Recherche';
$string['searchablecourses'] = 'Cours recherchables';
$string['searchallavailablecourses'] = 'Cours recherchables';
$string['searchallavailablecourses_desc'] = 'Dans certaines situations, le moteur de recherche ne fonctionnera pas lors de la recherche parmi un grand nombre de cours. Spécifiez une recherche uniquement dans les cours où l\'utilisateur est inscrit si vous voulez restreindre le nombre de cours recherchés.';
$string['searchallavailablecourses_off'] = 'Ne rechercher que dans les cours où l\'utilisateur est inscrit';
$string['searchallavailablecourses_on'] = 'Rechercher dans tous les cours accessibles à l\'utilisateur';
$string['searchallavailablecoursesdesc'] = 'Si ce réglage spécifie de ne rechercher que dans les cours où l\'utilisateur est inscrit, la recherche n\'aura lieu que parmi les informations (nom et résumé) et le contenu des cours dans lequel l\'utilisateur est inscrit. Sinon, elle s\'effectuera dans tous les cours auquel l\'utilisateur peut avoir accès, tels que ceux ouverts aux utilisateurs anonymes.';
$string['searchalldeleted'] = 'Tous les contenus indexés ont été supprimés';
$string['searchalternatesettings'] = 'Réglages alternatifs pour requêtes uniquement';
$string['searchalternatesettings_desc'] = 'Si ces réglages sont définis, des réglages alternatifs peuvent être sélectionnés pour ce moteur de recherche parmi les réglages alternatifs pour requêtes uniquement sur la page « Gestion de la recherche ». Ceci n\'est utile que lorsque l\'on migre d\'un moteur de recherche à un autre du même type.';
$string['searchareadisabled'] = 'Zone de recherche désactivée';
$string['searchareaenabled'] = 'Zone de recherche activée';
$string['searchareas'] = 'Zones de recherche';
$string['searchbanner'] = 'Informations de recherche';
$string['searchbannerenable'] = 'Afficher les informations de recherche';
$string['searchbannerenable_desc'] = 'Si ce réglage est activé, le texte ci-dessous sera affiché en haut de la page de recherche pour tous les utilisateurs. Ceci peut être utilisé pour informer les utilisateurs qu\'une maintenance du système de recherche est en cours.';
$string['searchdefaultcategory'] = 'Catégorie de recherche par défaut';
$string['searchdefaultcategory_desc'] = 'Les résultats de la zone de recherche sélectionnée seront affichés par défaut.';
$string['searchdeleteindex'] = 'Supprimer tous les contenus indexés';
$string['searchdisplay'] = 'Options d\'affichage des résultats de recherche';
$string['searchenablecategories'] = 'Afficher les résultats en catégories séparées';
$string['searchenablecategories_desc'] = 'Si ce réglage est activé, les résultats de recherche seront affichés en catégories séparées.';
$string['searchengine'] = 'Moteur de recherche';
$string['searchenginealternatesettings'] = '{$a} (réglages alternatifs)';
$string['searchenginequeryonly'] = 'Moteur de recherche pour requêtes uniquement';
$string['searchenginequeryonly_desc'] = 'Ce moteur de recherche ne sera utilisé que pour lancer des requêtes, et non pour l\'indexation. L\'utilisation de cette fonctionnalité permet de réindexer dans un autre moteur de recherche, pendant que les requêtes des utilisateurs continuent d\'être traitée sur celui-ci.';
$string['searchenginequeryonly_none'] = 'Aucun (utiliser le moteur de recherche principal pour les requêtes)';
$string['searchenginequeryonlysame'] = 'Le moteur de recherche pour requêtes uniquement et le moteur de recherche principal ne peuvent pas avoir le même réglage.';
$string['searchhideallcategory'] = 'Cacher la catégorie tous les résultats';
$string['searchhideallcategory_desc'] = 'Si cette case est cochée, la catégorie avec tous les résultats sera cachée dans l\'écran des résultats de recherche.';
$string['searchincludeallcourses'] = 'Inclure tous les cours visibles';
$string['searchincludeallcourses_desc'] = 'Si ce réglage est activé, les résultats de recherche incluront les informations (nom et résumé) de tous les cours visibles, même pour les utilisateurs n\'ayant pas accès aux contenus de ces cours.';
$string['searchindexactions'] = 'Action d\'index';
$string['searchindexdeleted'] = 'Index supprimé';
$string['searchindextime'] = 'Limite du temps d\'indexation';
$string['searchindextime_desc'] = 'Lors de l\'indexation de grandes quantités de nouveaux contenus, la tâche programmée s\'arrêtera une fois cette durée atteinte. La tâche continuera lors de son prochain lancement.';
$string['searchindexupdated'] = 'Les contenus du moteur de recherche ont été mis à jour';
$string['searchindexwhendisabled'] = 'Indexer si désactivée';
$string['searchindexwhendisabled_desc'] = 'Permet à la tâche programmée de construire l\'index de recherche, même si la recherche est désactivée. Cette option est utile pour construire l\'index avant de rendre la recherche disponible pour les étudiants.';
$string['searchinsettings'] = 'Recherche dans les paramètres';
$string['searchlastrun'] = 'Dernière exécution (heure, # docs, # enregistrements, # ignorés)';
$string['searchmanagement'] = 'Gestion de la recherche';
$string['searchmanagement_desc'] = 'Ces réglages sont utiles lors de modifications de sites avec de très volumineux index de recherche prenant un temps considérable à reconstruire.';
$string['searchnotavailable'] = 'La recherche n\'est pas disponible';
$string['searchoptions'] = 'Options de recherche';
$string['searchpartial'] = '(pas encore totalement indexé)';
$string['searchreindexed'] = 'Tous les contenus de la plateforme ont été réindexés.';
$string['searchreindexindex'] = 'Réindexer tous les contenus du site';
$string['searchresults'] = 'Résultats';
$string['searchsetupinfo'] = 'Paramètres de recherche';
$string['searchupdateindex'] = 'Mettre à jour les contenus indexés';
$string['sectionerror'] = 'Erreur de section !';
$string['secureforms'] = 'Utiliser une meilleure sécurité pour les formulaires';
$string['security'] = 'Sécurité';
$string['selectdevice'] = 'Choisir un appareil';
$string['selectsearchengine'] = 'Sélectionner un moteur de recherche';
$string['selecttheme'] = 'Choisir un thème pour l\'appareil {$a}';
$string['server'] = 'Serveur';
$string['serverchecks'] = 'Vérifications serveur';
$string['serverlimit'] = 'Limite serveur';
$string['sessionautostartwarning'] = '<p>Une grave erreur de configuration a été détectée. Veuillez en informer l\'administrateur du serveur.</p><p>Pour fonctionner correctement, Moodle nécessite la modification de certains réglages PHP par l\'administrateur.</p><p>Le réglage <code>session.auto_start</code> doit être désactivé (<code>off</code>).</p><p>Ce réglage peut être modifié sur le serveur dans le fichier <code>php.ini</code>, dans la configuration de Apache/IIS ou dans le fichier <code>.htaccess</code>.</p>';
$string['sessioncookie'] = 'Préfixe du cookie';
$string['sessioncookiedomain'] = 'Domaine du cookie';
$string['sessioncookiepath'] = 'Chemin d\'accès au cookie';
$string['sessionhandling'] = 'Gestion des sessions';
$string['sessiontimeout'] = 'Délai d\'attente';
$string['settingdependenton'] = 'Ce réglage peut être caché, en fonction de la valeur de <strong>{$a}</strong>.';
$string['settingfileuploads'] = 'Le dépôt de fichiers est nécessaire pour un fonctionnement normal. Veuillez l\'activer dans la configuration de PHP.';
$string['settingmaxinputvars'] = 'La valeur recommandée pour le réglage PHP max_input_vars est de 5000.';
$string['settingmaxinputvarsrequired'] = 'Le réglage PHP max_input_vars doit être au mininum 5000.';
$string['settingmemorylimit'] = 'Mémoire insuffisante détectée. Veuillez fixer une limite de mémoire plus élevée dans la configuration de PHP.';
$string['settingsafemode'] = 'Moodle n\'est pas totalement compatible avec le <em>safe mode</em>. Veuillez demander à l\'administrateur du serveur de le désactiver. Le fonctionnement de Moodle avec le <em>safe mode</em> actif n\'est pas supporté. Vous rencontrerez vraisemblablement des problèmes si vous essayez.';
$string['setupsearchengine'] = 'Configurer le moteur de recherche';
$string['showcommentscount'] = 'Afficher le nombre des commentaires';
$string['showdetails'] = 'Afficher les détails';
$string['showuseridentity'] = 'Afficher l\'identité de l\'utilisateur';
$string['showuseridentity_desc'] = 'Lors de la recherche ou de la sélection d\'utilisateurs, ainsi que lors de l\'affichage de listes d\'utilisateurs, ces champs peuvent être affichés en plus du nom complet. Ils ne sont montrés qu\'aux utilisateurs ayant la capacité moodle/site:viewuseridentity (par défaut, les gestionnaires et les enseignants). Ce réglage a plus de sens si vous imposez un ou deux champs obligatoires dans votre institution.';
$string['simplexmlrequired'] = 'L\'installation de l\'extension SimpleXML de PHP est maintenant requise par Moodle.';
$string['sitemailcharset'] = 'Jeu de caractères';
$string['sitemaintenance'] = 'Ce site est actuellement en maintenance. Il est donc temporairement non disponible';
$string['sitemaintenancemode'] = 'Mode de maintenance';
$string['sitemaintenanceoff'] = 'Le mode de maintenance a été désactivé et le site fonctionne à nouveau normalement';
$string['sitemaintenanceon'] = 'Votre site est actuellement en mode maintenance (seuls les administrateurs peuvent se connecter et utiliser le site).';
$string['sitemaintenanceoncli'] = 'Votre site est actuellement en mode de maintenance CLI. Aucun accès web n\'est autorisé.';
$string['sitemaintenancetitle'] = '{$a} est en cours de maintenance';
$string['sitemaintenancewarning'] = 'Votre site est actuellement en mode de maintenance (seuls les administrateurs peuvent s\'y connecter). Pour revenir à un fonctionnement normal du site, veuillez <a href="maintenance.php">désactiver le mode de maintenance</a>.';
$string['sitemaintenancewarning2'] = 'Votre site est actuellement en mode de maintenance (seuls les administrateurs peuvent s\'y connecter). Pour revenir à un fonctionnement normal du site, veuillez <a href="{$a}">désactiver le mode de maintenance</a>.';
$string['sitemenubar'] = 'Navigation du site';
$string['sitepolicies'] = 'Réglages de sécurité du site';
$string['sitepolicy'] = 'URL de la politique du site';
$string['sitepolicy_help'] = 'L\'URL de la politique du site que tous les utilisateurs enregistrés sur le site doivent consulter et accepter avant d\'accéder au site. Ce réglage n\'a d\'effet que si le gestionnaire de politiques par défaut (cœur) est actif.';
$string['sitepolicyguest'] = 'URL de la politique du site pour visiteurs anonymes';
$string['sitepolicyguest_help'] = 'L\'URL de la politique du site que tous les visiteurs anonymes doivent lire et accepter avant d\'accéder au site. Ce réglage n\'a d\'effet que si le gestionnaire de politiques du site choisi est celui par défaut (cœur).';
$string['sitepolicyhandler'] = 'Gestionnaire des politiques du site';
$string['sitepolicyhandler_desc'] = 'Ce réglage détermine comment sont gérés les politiques du site et les consentements donnés par les utilisateurs. Le composant par défaut (cœur) permet de spécifier une URL pour la politique du site et une URL pour la politique du site pour visiteurs anonymes. Le gestionnaire des politiques permet de définir une politique de site, une politique de confidentialité et d\'autres politiques. Il active également l\'affichage du consentement des utilisateurs, et si nécessaire le consentement à donner au nom des mineurs.';
$string['sitepolicyhandlercore'] = 'Par défaut';
$string['sitepolicyhandlerplugin'] = '{$a->name} ({$a->component})';
$string['sitesectionhelp'] = 'Si cette option est activée, une section sera affichée sur la page d\'accueil du site.';
$string['sixtyfourbitswarning'] = 'Votre site n\'utilise pas une version 64 bits de PHP. Il est recommandé de mettre à jour votre serveur afin d\'assurer une pleine compatibilité des prochaines versions de Moodle.';
$string['slasharguments'] = 'Utiliser les « slash arguments »';
$string['slashargumentswarning'] = 'Il est recommandé que le réglage <em>slasharguments</em> soit activé. L\'activation sera prochainement rendue obligatoire. Pour plus de détails, veuillez consulter la documentation sur l\'utilisation des <a href="https://docs.moodle.org/en/admin/environment/slasharguments"><em>slash arguments</em></a> (en anglais).';
$string['smartpix'] = 'Recherche intelligente des icônes';
$string['smtp'] = 'SMTP';
$string['smtpauthtype'] = 'Type d\'authentification SMTP';
$string['smtpdetail'] = 'Réglages SMTP (Simple Mail Transfer Protocol) pour l\'envoi du courriel.';
$string['smtphosts'] = 'Hôtes SMTP';
$string['smtpmaxbulk'] = 'Limite de session SMTP';
$string['smtppass'] = 'Mot de passe SMTP';
$string['smtpsecure'] = 'Sécurité SMTP';
$string['smtpuser'] = 'Nom d\'utilisateur SMTP';
$string['soaprecommended'] = 'L\'installation de l\'extension optionnelle SOAP de PHP est utile pour les services web et d\'autres plugins.';
$string['sort_fullname'] = 'Nom complet du cours';
$string['sort_idnumber'] = 'No identifiant du cours';
$string['sort_shortname'] = 'Nom abrégé du cours';
$string['sort_sortorder'] = 'Ordre de tri';
$string['spellengine'] = 'Vérificateur orthographique';
$string['spelllanguagelist'] = 'Liste des langues à vérifier orthographiquement';
$string['splrequired'] = 'L\'installation de l\'extension SPL de PHP est maintenant requise par Moodle.';
$string['stats'] = 'Statistiques';
$string['statsfirstrun'] = 'Intervalle maximal de traitement';
$string['statsmaxruntime'] = 'Temps maximal de traitement';
$string['statsmoodleorg'] = 'statistiques';
$string['statsruntimedays'] = 'Jours à traiter';
$string['statsruntimestart'] = 'Lancer à';
$string['statsuserthreshold'] = 'Seuil utilisateurs';
$string['stickyblocks'] = 'Blocs fixes';
$string['stickyblockscourseview'] = 'Page de cours';
$string['stickyblocksduplicatenotice'] = 'Si l\'un des blocs que vous ajoutez ici existe déjà sur une page, il y aura alors un doublon.<br />Seul celui qui est fixe ne sera pas modifiable. Le doublon pourra encore être modifié.';
$string['stickyblocksmymoodle'] = 'Ma page';
$string['stickyblockspagetype'] = 'Type de page à configurer';
$string['strictformsrequired'] = 'Validation stricte des champs requis';
$string['stripalltitletags'] = 'Retirer les balises HTML du nom des activités';
$string['supportcontact'] = 'Contact d\'assistance';
$string['supportemail'] = 'Courriel d\'assistance';
$string['supportname'] = 'Nom d\'assistance';
$string['supportpage'] = 'Page d\'assistance';
$string['suspenduser'] = 'Suspendre le compte utilisateur';
$string['switchlang'] = 'Changer de dossier de langue';
$string['systempaths'] = 'Chemins système';
$string['tablenosave'] = 'Les modifications dans la table ci-dessus sont enregistrées automatiquement.';
$string['tablesnosave'] = 'Les modifications dans les tables ci-dessus sont enregistrées automatiquement.';
$string['tabselectedtofront'] = 'Dans les tables avec onglets, la rangée contenant l\'onglet sélectionné doit-elle être ramenée au premier plan ?';
$string['tabselectedtofronttext'] = 'Ramener au premier plan la rangée de l\'onglet sélectionné';
$string['task_adhoc_concurrency_limit'] = 'Limite du nombre de tâches ad hoc simultanées';
$string['task_adhoc_concurrency_limit_desc'] = 'Le nombre de programmes d\'exécution de tâches ad hoc pouvant tourner simultanément. Si la limite est élevée, les tâches programmées pourraient ne pas être exécutées régulièrement dans le cas où il y a un grand nombre de tâches ad hoc. La valeur 0 désactive le lancement des tâches ad hoc.';
$string['task_adhoc_max_runtime'] = 'Durée de vie du programme d\'exécution des tâches ad hoc';
$string['task_adhoc_max_runtime_desc'] = 'La durée avant de libérer un programme d\'exécution de tâche ad hoc. Une faible durée est recommandée, puisqu\'il n\'y a pas de limite au nombre de tâches ad hoc en attente. Si ce nombre est trop élevé et que la file d\'attente des tâches ad hoc est longue, les tâches programmées pourraient ne pas être exécutées régulièrement.';
$string['task_dbstats'] = 'Base de données';
$string['task_duration'] = 'Durée';
$string['task_logmode'] = 'Mode d\'enregistrement des journaux';
$string['task_logmode_all'] = 'Enregistrer les journaux de toutes les tâches.';
$string['task_logmode_desc'] = 'Les tâches à journaliser. Par défaut, des journaux sont enregistrés pour toutes les tâches. Il est possible de désactiver totalement la journalisation ou de n\'enregistrer les journaux qu\'en cas d\'échec d\'une tâche.';
$string['task_logmode_failonly'] = 'N\'enregistrer les journaux que pour les tâches qui échouent';
$string['task_logmode_none'] = 'Ne rien enregistrer';
$string['task_logretainruns'] = 'Exécutions conservées';
$string['task_logretainruns_desc'] = 'Le nombre d\'exécutions de chaque tâche à conserver. Ce réglage est complémentaire du réglage « Période de conservation » : celui qui est atteint en premier sera utilisé.';
$string['task_logretention'] = 'Période de conservation';
$string['task_logretention_desc'] = 'La durée maximale de conservation des journaux. Ce réglage est complémentaire du réglage « Exécutions conservées » : celui qui est atteint en premier sera utilisé.';
$string['task_logtostdout'] = 'Afficher l\'output des tâches';
$string['task_logtostdout_desc'] = 'Ce réglage spécifie si, quand les tâches sont en cours d\'exécution et que leur output est enregistré, l\'output enregistré doit aussi être affiché.';
$string['task_result'] = 'Résultat';
$string['task_result:failed'] = 'Échec';
$string['task_scheduled_concurrency_limit'] = 'Limite du nombre de tâches programmées simultanées';
$string['task_scheduled_concurrency_limit_desc'] = 'Le nombre de programmes d\'exécution de tâches programmées pouvant tourner simultanément. Si la limite est élevée, le serveur pourrait subir une charge élevée et dégrader les performances. La valeur 0 désactive le lancement des tâches programmées.';
$string['task_scheduled_max_runtime'] = 'Durée de vie du programme d\'exécution des tâches programmées';
$string['task_scheduled_max_runtime_desc'] = 'La durée avant de libérer un programme d\'exécution des tâches.';
$string['task_starttime'] = 'Début';
$string['task_stats:dbreads'] = '{$a} lectures';
$string['task_stats:dbwrites'] = '{$a} écritures';
$string['task_type:adhoc'] = 'Ad hoc';
$string['task_type:scheduled'] = 'Programmée';
$string['taskadmintitle'] = 'Tâches';
$string['taskanalyticscleanup'] = 'Nettoyage des analyses de données';
$string['taskautomatedbackup'] = 'Sauvegardes automatiques';
$string['taskbackupcleanup'] = 'Nettoyage des tables de sauvegarde et des journaux';
$string['taskbadgescron'] = 'Décernement des badges';
$string['taskbadgesmessagecron'] = 'Traitement en tâche de fond de l\'envoi des notifications de badge';
$string['taskblogcron'] = 'Synchronisation des blogs externes';
$string['taskcachecleanup'] = 'Suppression des éléments en cache échus';
$string['taskcachecron'] = 'Traitement en tâche de fond des caches';
$string['taskcalendarcron'] = 'Envoi des notifications de calendrier';
$string['taskcheckforupdates'] = 'Recherche des mises à jour';
$string['taskcompletiondaily'] = 'Marquage des achèvements comme commencés';
$string['taskcompletionregular'] = 'Calcul des données d\'achèvement';
$string['taskcontextcleanup'] = 'Nettoyage des contextes';
$string['taskcreatecontexts'] = 'Création des contextes manquants';
$string['taskdeletecachetext'] = 'Suppression des anciennes entrées texte du cache';
$string['taskdeleteincompleteusers'] = 'Suppression des comptes utilisateur incomplets';
$string['taskdeleteunconfirmedusers'] = 'Suppression des comptes utilisateur non confirmés';
$string['taskeventscron'] = 'Traitement en tâche de fond des événements';
$string['taskfiletrashcleanup'] = 'Nettoyage des fichiers de la corbeille';
$string['taskglobalsearchindex'] = 'Indexation pour recherche globale';
$string['taskglobalsearchoptimize'] = 'Optimisation de l\'index de recherche globale';
$string['taskgradecron'] = 'Traitement en tâche de fond du carnet de notes';
$string['taskgradehistorycleanup'] = 'Traitement en tâche de fond du nettoyage des tables d\'historiques de notes';
$string['tasklegacycron'] = 'Traitement du cron des plugins obsolètes';
$string['tasklogcleanup'] = 'Nettoyage des journaux des tâches';
$string['tasklogging'] = 'Configuration des journaux de tâches';
$string['tasklogs'] = 'Journaux des tâches programmées';
$string['taskmessagingcleanup'] = 'Traitement en tâche de fond des messages';
$string['taskpasswordresetcleanup'] = 'Nettoyage des tentatives de réinitialisation de mot de passe';
$string['taskplagiarismcron'] = 'Traitement en tâche de fond des cron obsolètes des plugins de détection de plagiat';
$string['taskportfoliocron'] = 'Traitement en tâche de fond des plugins de portfolio';
$string['taskprocessing'] = 'Traitement des tâches';
$string['taskquestioncron'] = 'Nettoyage en tâche de fond des prévisualisations de question';
$string['taskquestionstatscleanupcron'] = 'Nettoyage en tâche de fond des caches de statistiques de question';
$string['taskrefreshsystemtokens'] = 'Renouveler les jetons OAuth des comptes de service';
$string['taskregistrationcron'] = 'Enregistrement du site';
$string['tasksendfailedloginnotifications'] = 'Envoi des notifications d\'échec de connexion';
$string['tasksendnewuserpasswords'] = 'Envoi des nouveaux mots de passe';
$string['tasksessioncleanup'] = 'Nettoyage des anciennes sessions';
$string['taskstatscron'] = 'Traitement en tâche de fond des statistiques';
$string['tasktagcron'] = 'Traitement en tâche de fond des tags';
$string['tasktempfilecleanup'] = 'Suppression des fichiers temporaires inutilisés';
$string['tasktype'] = 'Type';
$string['tempdatafoldercleanup'] = 'Nettoyer les fichiers temporaires plus anciens que';
$string['templates'] = 'Gabarits';
$string['testoutgoingmailconf'] = 'Test de la configuration du courriel sortant';
$string['testoutgoingmailconf_errorcommunications'] = 'Votre site n\'a pas pu communiquer avec votre serveur de courriel. Veuillez vérifier la configuration du courriel sortant.';
$string['testoutgoingmailconf_message'] = 'Ceci est un message confirmant que vous avez configuré correctement les réglages de courriel sortant de votre site.';
$string['testoutgoingmailconf_sendtest'] = 'Envoyer un message de test';
$string['testoutgoingmailconf_sentmail'] = 'Ce site a délivré correctement un message de test au serveur de courriel.<br />De : {$a->fromemail}<br />À : {$a->toemail}';
$string['testoutgoingmailconf_subject'] = '{$a} : message de test';
$string['testoutgoingmailconf_toemail'] = 'Adresse de courriel de destination';
$string['testoutgoingmaildetail'] = 'Attention ! Veuillez enregistrer la configuration avant de lancer le test.<br />{$a}';
$string['testsiteupgradewarning'] = 'Vous utilisez actuellement le site de test {$a}. Pour e mettre à jour correctement, veuillez utiliser l\'outil de mise à jour en ligne de commande.';
$string['themedesignermode'] = 'Mode concepteur de thème';
$string['themedesignermodewarning'] = 'Le mode concepteur de thème est activé. Ce mode ne devrait pas être activité sur une plateforme en production, car les performances en sont notablement réduites.';
$string['themelist'] = 'Liste des thèmes';
$string['themenoselected'] = 'Aucun thème sélectionné';
$string['themeresetcaches'] = 'Vider les caches de thème';
$string['themeselect'] = 'Changer de thème';
$string['themeselector'] = 'Sélecteur de thème';
$string['themesettings'] = 'Réglages thème';
$string['therewereerrors'] = 'Des erreurs sont présentes dans vos données';
$string['thirdpartylibrary'] = 'Bibliothèque';
$string['thirdpartylibrarylocation'] = 'Emplacement';
$string['thirdpartylibs'] = 'Bibliothèques additionnelles';
$string['timezone'] = 'Fuseau horaire par défaut';
$string['timezoneforced'] = 'Ce réglage est imposé par l\'administrateur du site';
$string['timezoneinvalid'] = 'Fuseau horaire « {$a} » non valide';
$string['timezoneisforcedto'] = 'Imposer à tous les utilisateurs l\'utilisation du fuseau horaire';
$string['timezonenotforced'] = 'Les utilisateurs peuvent choisir leur fuseau horaire';
$string['timezonephpdefault'] = 'Fuseau horaire PHP par défaut ({$a})';
$string['timezoneserver'] = 'Fuseau horaire du serveur ({$a})';
$string['tlswarning'] = 'L\'extension cURL de PHP avec support de TLSv1.2 n\'a pas été détectée. Certains services ne fonctionneront peut-être pas. Il est vivement recommandé de mettre à jour vos bibliothèques TLS.';
$string['tokenduration'] = 'Durée des jetons créés par les utilisateurs';
$string['tokenduration_desc'] = 'La durée de validité des jetons créés par un utilisateur (par exemple dans l\'app mobile).';
$string['tokenizerrecommended'] = 'L\'installation de l\'extension Tokenizer de PHP est recommandée. Elle améliore les fonctionnalités du Réseau Moodle.';
$string['tools'] = 'Outils d\'administration';
$string['toolsmanage'] = 'Gérer les outils d\'administration';
$string['unattendedoperation'] = 'Opération sans surveillance';
$string['unbookmarkthispage'] = 'Retirer cette page des marque-pages';
$string['unicoderequired'] = 'Le stockage des données en format Unicode (UTF-8) est requis. Toute nouvelle installation de Moodle doit être effectuée dans une base de données ayant comme jeu de caractères par défaut Unicode (UTF-8). Si vous effectuez une mise à jour de Moodle, veuillez procéder à la migration de votre base de données en Unicode (voir la page Notifications).';
$string['uninstallplugin'] = 'Désinstaller';
$string['unlockaccount'] = 'Débloquer ce compte';
$string['unoconvwarning'] = 'La version installée de <em>unoconv</em> n\'est pas supportée.';
$string['unsettheme'] = 'Ne pas définir de thème';
$string['unsupported'] = 'Non supporté';
$string['unsupporteddbfileformat'] = 'Votre base de données utilise le format de fichier Antelope. Le support complet de l\'encodage UTF-8 dans MySQL et MariaDB requiert le format Barracuda. Veuillez passer au format de fichier Barracuda. Consultez la documentation <a href="https://docs.moodle.org/fr/Support_unicode_complet_pour_MySQL">Support unicode complet pour MySQL</a> pour des informations supplémentaires.';
$string['unsupporteddbfilepertable'] = 'Pour un support complet de l\'encodage UTF-8, tant MySQL que MariaDB nécessitent d\'activer le paramètre « innodb_file_per_table ». Veuillez consulter la documentation pour plus de détails.';
$string['unsupporteddblargeprefix'] = 'Pour un support complet de l\'encodage UTF-8, tant MySQL que MariaDB nécessitent d\'activer le paramètre « innodb_large_prefix ». Veuillez consulter la documentation pour plus de détails.';
$string['unsupporteddbstorageengine'] = 'Le moteur de base de données utilisé n\'est plus supporté.';
$string['unsupporteddbtablerowformat'] = 'Votre base de données comporte des tables qui utilisent le format de fichier Antelope. Il vous est vivement recommandé de convertir les tables au format de fichier Barracuda. Veuillez consulter la <a href="https://docs.moodle.org/fr/Administration_en_ligne_de_commande">documentation sur l\'Administration en ligne de commande</a> pour des informations détaillées sur l\'<a href="https://docs.moodle.org/fr/Administration_en_ligne_de_commande#Conversion_des_tables_InnoDB_au_format_Barracuda">outil de conversion des tables InnoDB en format Barracuda</a>.';
$string['unsupportedphpversion7'] = 'La version 7 de PHP n\'est pas supportée.';
$string['unsupportedphpversion71'] = 'La version 7.1 de PHP n\'est pas supportée.';
$string['unsupportedphpversion72'] = 'La version 7.2 de PHP n\'est pas supportée.';
$string['unsupportedphpversion73'] = 'La version 7.3 de PHP n\'est pas supportée.';
$string['unsupportedphpversion74'] = 'La version 7.4 de PHP n\'est pas supportée.';
$string['unsupportedphpversion80'] = 'La version 8.0 de PHP n\'est pas supportée.';
$string['unsuspenduser'] = 'Activez le compte utilisateur';
$string['updateaccounts'] = 'Modifier des comptes existants';
$string['updateautocheck'] = 'Chercher automatiquement les mises à jour disponibles';
$string['updateautocheck_desc'] = 'Si ce réglage est activé, votre site cherchera automatiquement si des mises à jour sont disponibles pour votre site Moodle et pour tous les plugins additionnels. Si une mise à jour est disponible, une notification sera envoyée aux administrateurs du site.';
$string['updateavailable'] = 'Une nouvelle version de Moodle est disponible !';
$string['updateavailable_moreinfo'] = 'Plus d\'info…';
$string['updateavailable_release'] = 'Moodle {$a}';
$string['updateavailable_version'] = 'Version {$a}';
$string['updateavailabledetailslink'] = 'Voir {$a->url} pour plus d\'informations';
$string['updateavailableforplugin'] = 'Une nouvelle version de certains de vos plugins est disponible !';
$string['updateavailableinstall'] = 'Installer cette mise à jour';
$string['updateavailableinstallall'] = 'Installer les mises à jour disponibles ({$a})';
$string['updateavailableinstallallhead'] = 'Installation des mises à jour disponibles';
$string['updateavailablenot'] = 'Votre Moodle est à jour !';
$string['updateavailablerecommendation'] = 'Il vous est vivement recommandé de mettre à jour votre site à la dernière version afin d\'obtenir les derniers correctifs de sécurité et de bogues.';
$string['updatecomponent'] = 'Mettre à jour le composant';
$string['updateminmaturity'] = 'Maturité de code requise';
$string['updateminmaturity_desc'] = 'Ne notifier les mises à jour disponibles que si la nouvelle version a au moins le niveau de maturité sélectionné. Les nouvelles versions des plugins qui ne déclarent pas leur niveau de maturité seront annoncées quel que soit ce réglage.';
$string['updatenotificationfooter'] = 'Votre site Moodle {$a->siteurl} est configuré pour vérifier automatiquement si des mises à jours sont disponibles. Vous recevez ce message en tant qu\'administrateur de la plateforme. Vous pouvez désactiver ces vérifications automatiques sous Administration du site / Serveur / Notifications de mises à jour ou personnaliser dans vos préférences la façon dont le message vous est adressé.';
$string['updatenotifications'] = 'Notifications de mises à jour';
$string['updatenotificationsubject'] = 'Des mises à jour de Moodle sont disponibles ({$a->siteurl})';
$string['updatenotifybuilds'] = 'Notifier les nouvelles microversions';
$string['updatenotifybuilds_desc'] = 'Si ce réglage est activé, les mises à jour du code de Moodle sont aussi notifiées lorsqu\'une nouvelle microversion est disponible. Les microversions sont des améliorations continues apportées à une version de Moodle. Elles sont en principe publiées chaque semaine. Si le réglage est désactivé, les mises à jour disponibles seront notifiées seulement lorsqu\'une nouvelle version est publiée. La vérification des plugins n\'est pas touchée par ce réglage.';
$string['upgradeerror'] = 'Erreur lors de la mise à jour de {$a->plugin} à la version {$a->version}. Impossible de continuer.';
$string['upgradeforumread'] = 'Moodle 1.5 possède une nouvelle fonctionnalité permettant de signaler quels messages des forums ont été lus.<br />Pour profiter de cette fonctionnalité, les tables de la base de données <a href="{$a}">doivent être mises à jour</a>.';
$string['upgradeforumreadinfo'] = 'Moodle 1.5 possède une nouvelle fonctionnalité permettant de signaler quels messages des forums ont été lus. Pour profiter de cette fonctionnalité, les tables de la base de données doivent être complétées avec le statut de lecture pour les messages existants. Suivant la taille de votre site, cette mise à jour peut prendre beaucoup de temps (quelques heures) et risque de surcharger la base de données. Nous vous conseillons donc de l\'effectuer lors d\'une période creuse. Durant cette mise à jour, votre site continuera à fonctionner et les utilisateurs ne seront pas touchés. Une fois l\'opération démarrée, vous devez la laisser se terminer (en laissant ouverte la fenêtre du navigateur). Si par inadvertance vous interrompez le processus, par exemple en fermant la fenêtre, vous pourrez le recommencer sans dommage.<br /><br />Voulez-vous commencer maintenant cette opération ?';
$string['upgradekeyreq'] = 'Clef de mise à jour requise';
$string['upgradekeyset'] = 'Mettre à jour la clef (laisser vide pour ne pas la définir)';
$string['upgradelogs'] = 'Pour profiter de toutes les fonctionnalités, les anciens journaux doivent être mis à jour. <a href="{$a}">Plus d\'informations</a>';
$string['upgradelogsinfo'] = 'Récemment, des changements ont eu lieu dans la façon de conserver les journaux. Afin de pouvoir profiter de l\'affichage des anciens journaux par activité, ceux-ci doivent être mis à jour. Selon la taille de votre site, cette opération peut durer assez longtemps (c\'est-à-dire plusieurs heures) et peut ralentir les bases de données des sites complexes et très actifs. Une fois l\'opération démarrée, vous devez la laisser se terminer (en laissant ouverte la fenêtre du navigateur). N\'ayez crainte, votre site continuera à très bien fonctionner pour les autres utilisateurs durant la mise à jour des journaux.<br /><br />Voulez-vous mettre à jour maintenant vos journaux ?';
$string['upgradepluginsfirst'] = 'Il est recommandé d\'installer avant tout toutes les mises à jour disponibles';
$string['upgradepluginsinfo'] = 'Mise à jour des plugins';
$string['upgradepluginsinfo_help'] = 'Des mises à jour sont disponibles pour certains de vos plugins. Veuillez les installer avant d\'effectuer la mise à jour de la base de données de Moodle. Si votre site ne permet pas le déploiement automatique des mises à jour, veuillez télécharger et installer manuellement sur votre serveur les nouvelles versions disponibles des plugins.';
$string['upgradesettings'] = 'Nouveaux réglages';
$string['upgradesettingsintro'] = 'Les réglages ci-dessous ont été ajoutés lors de la dernière mise à jour de votre Moodle. Effectuez les modifications nécessaires et cliquez ensuite sur « Enregistrer les modifications » au bas de cette page.';
$string['upgradestalefiles'] = 'Mélange de versions de Moodle détectées. La mise à jour ne peut pas être poursuivie';
$string['upgradestalefilesinfo'] = 'La mise à jour de Moodle a été interrompue, car des fichiers PHP d\'au moins deux versions majeures différentes de Moodle ont été détectés dans le dossier Moodle.

Cette situation pourrait causer ultérieurement de graves problèmes. Pour cette raison, afin de continuer la mise à jour, vous devez vous assurer que le dossier Moodle ne contient que des fichiers d\'une seule version de Moodle.

Pour nettoyer votre dossier Moodle, il est recommandé d\'agir ainsi :

* renommer votre dossier Moodle en « moodle_old »;
* créer un nouveau dossier Moodle ne contenant que les fichiers provenant soit de la distribution standard de Moodle préalablement téléchargée, soit du dépôt Git de Moodle ;
* déplacer le fichier config.php et tous les plugins non-standards du dossier « moodle_old » vers le nouveau dossier Moodle.

Une fois votre dossier Moodle nettoyé, rafraîchissez l\'affichage de cette page pour reprendre le processus de mise à jour de Moodle.

Cet avertissement s\'affiche le plus souvent suite au dé-compactage d\'une archive ZIP standard de Moodle par-dessus une version existante de Moodle. Ce procédé est valable pour les mises à jour mineures. Il est en revanche vigoureusement déconseillé pour les mises à jour majeures de Moodle.

L\'avertissement peut également être causé par la mise à jour incomplète d\'un dépôt Git. Dans ce cas, attendez la fin de la mise à jour, lancez une commande adéquate pour nettoyer le dossier et réessayez l\'opération.

Vous trouverez plus d\'informations à ce sujet dans la documentation de mise à jour ici : <a href="{$a}">{$a}</a>';
$string['upgradestart'] = 'Mettre à jour la base de données maintenant';
$string['upgradesure'] = '<p>Certains fichiers de votre Moodle ont été modifiés, et vous êtes sur le point de lancer la procédure automatique de mise à jour de votre plateforme vers cette version :</p>
<p><strong>{$a}</strong></p>
<p>Une fois cette mise à jour effectuée, il sera impossible de revenir en arrière ! Veuillez noter que le processus peut durer assez longtemps.</p>
<p>Voulez-vous vraiment mettre à jour ce Moodle vers cette version ?</p>';
$string['upgradetimedout'] = 'La mise à jour a dépassé le temps imparti. Veuillez recommencer la mise à jour.';
$string['upgradingdata'] = 'Mise à jour des données';
$string['upgradinglogs'] = 'Mise à jour des journaux';
$string['upgradingversion'] = 'Mise à jour vers une nouvelle version';
$string['upwards'] = 'et ultérieures';
$string['useblogassociations'] = 'Activer les associations';
$string['useexternalyui'] = 'Utiliser les bibliothèques YUI en ligne';
$string['user'] = 'Utilisateur';
$string['userbulk'] = 'Actions en lots sur les utilisateurs';
$string['userbulkdownload'] = 'Exporter les utilisateurs sous le nom';
$string['userdefaultpreferences'] = 'Préférences utilisateur par défaut';
$string['userfeedbackafterupgrade'] = 'Après chaque mise à jour majeure';
$string['userfeedbackencouragement'] = '<p>Dans Moodle 3.9 et les versions ultérieures, une nouvelle fonctionnalité donne l\'opportunité aux utilisateurs de communiquer à Moodle HQ leur avis sur le logiciel Moodle au moyen d\'une plateforme d\'enquête hébergée par Moodle HQ. Aucune information d\'identification des utilisateurs n\'est transmise à la plateforme d\'enquête.</p>
<p>Moodle HQ s\'efforce d\'être ouvert et transparent dans ses démarches de collecte de données. C\'est pourquoi, nous voulons nous assurer que vous êtes parfaitement au courant de cette fonctionnalité et que vous en avez le contrôle.</p>
<p>Les feedbacks des utilisateurs aideront considérablement Moodle HQ à améliorer Moodle. Pour activer cette fonctionnalité, rendez-vous sur les <a href="{$a}">réglages de feedback</a>.</p>';
$string['userfeedbacknextreminder'] = 'Prochain rappel de feedback';
$string['userfeedbacknextreminder_desc'] = 'Quand demander  à l\'utilisateur de donner un nouveau feedback ?';
$string['userfeedbackperiodically'] = 'Périodiquement';
$string['userfeedbackremindafter'] = 'Afficher un rappel après';
$string['userfeedbackremindafter_desc'] = 'Rappeler aux utilisateurs de donner un feedback après le nombre de jours indiqué.';
$string['userfiltersdefault'] = 'Filtres utilisateur par défaut';
$string['userfiltersdefault_desc'] = 'Sélectionner les filtres à afficher sur les pages « Liste des utilisateurs » et « Actions en lots sur les utilisateurs ». Garder la touche ctrl ou cmd pour sélectionner plusieurs éléments. Les filtres non sélectionnés seront disponibles en cliquant sur « Afficher plus...».';
$string['userimagesdisabled'] = 'Les images des profils utilisateur sont désactivés';
$string['userlist'] = 'Liste des utilisateurs';
$string['usermanagement'] = 'Gestion utilisateur';
$string['userpolicies'] = 'Politiques utilisateurs';
$string['userpreference'] = 'Préférence utilisateur';
$string['userquota'] = 'Taille zone de fichiers personnels';
$string['userquota_desc'] = 'Le taille maximum des données que chaque utilisateur peut enregistrer dans sa zone de fichiers personnels.';
$string['users'] = 'Utilisateurs';
$string['usesitenameforsitepages'] = 'Utiliser le nom du site pour les pages du site';
$string['usetags'] = 'Activer les tags';
$string['validateemptylineerror'] = 'Les lignes vides ne sont pas valides';
$string['validateerror'] = 'Cette valeur n\'est pas valide';
$string['validateerrorlist'] = 'Ces données ne sont pas valides : {$a}';
$string['validateiperror'] = 'Ces adresses IP ne sont pas valides : {$a}';
$string['verifychangedemail'] = 'Appliquer les restrictions de domaines lors des modifications d\'adresse de courriel';
$string['warningcurrentsetting'] = 'Valeur actuelle non valide : {$a}';
$string['warningiconvbuggy'] = 'Votre version de la bibliothèque iconv ne supporte pas le mot clef //IGNORE. Veuillez installer l\'extension mbstring qui peut être utilisée pour nettoyer les chaînes de caractères contenant des caractères UTF-8 non valides.';
$string['webproxy'] = 'Proxy web';
$string['webproxyinfo'] = 'Renseignez les options suivantes si votre serveur Moodle n\'a pas un accès direct à Internet. L\'accès direct à Internet est requis pour le téléchargement des données de l\'environnement, les paquetages de langue, les flux RSS, les fuseaux horaires, etc.<br /><em>L\'extension cURL de PHP est vivement recommandée.</em>';
$string['xmlrpcrecommended'] = 'L\'extension XMLRPC de PHP est utile pour les services web et la mise en réseau de Moodle.';
$string['yuicomboloading'] = 'Chargement du combo YUI';
$string['ziprequired'] = 'L\'extension Zip de PHP est maintenant requise par Moodle. Les exécutables info-ZIP et la bibliothèque PclZip ne sont plus utilisés.';
