<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_stash', language 'fr', branch 'MOODLE_36_STABLE'
 *
 * @package   block_stash
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accept'] = 'Accepter l\'échange';
$string['additem'] = 'Ajouter un objet';
$string['addnewdrop'] = 'Ajouter un nouveau lieu de dépôt';
$string['addnewtradeitem'] = 'Ajouter un nouvel objet au troc';
$string['addtoinventory'] = 'Ajouter un objet à l\'inventaire.';
$string['addtrade'] = 'Ajouter un troc';
$string['addtradeitem'] = 'Ajouter un objet au troc';
$string['aftercreatinglocationhelp'] = 'Après avoir créé un objet et ajouté un lieu pour cet objet, vous devez ajouter un petit morceau de code quelque part dans votre cours pour afficher l\'objet.';
$string['appearance'] = 'Affichage';
$string['backtostart'] = 'Retour à l\'écran principal';
$string['buttontext'] = 'Texte du bouton';
$string['configurationtitle'] = 'Nom du bloc';
$string['copypaste'] = 'Copiez et collez ce code dans un éditeur de texte dans une ou plusieurs activités/ressources de votre cours.';
$string['copytoclipboard'] = 'Copier dans le presse-papiers';
$string['cost'] = 'Coût';
$string['deletedrop'] = 'Supprimer {$a}';
$string['deleteitem'] = 'Supprimer {$a}';
$string['dropa'] = 'Lieu « {$a} »';
$string['dropname'] = 'Lieu';
$string['dropname_help'] = 'Le nom du lieu vous sert à les organiser, il ne sera pas affiché aux étudiants.';
$string['drops'] = 'Lieux';
$string['drops_help'] = '<p>Les lieux sont des endroits où vos objets sont présents dans le <em>monde virtuel</em>. Sans <em>lieu</em> défini, les étudiants ne pourront pas récupérer l\'objet.</p>
<p>Quelques options sont proposées pour les lieux, notamment le nombre de fois qu\'un étudiant peut récupérer l\'objet dans ce lieu ou la fréquence à laquelle l\'objet réapparaît dans le même lieu après avoir été récupéré.</p>
<p>Par exemple, si vos étudiants doivent récupérer une <em>clé</em> pour débloquer une activité, vous préciserez que les étudiants ne peuvent la récupérer qu\'une seule fois dans ce lieu.</p>
<p>Si par contre il leur faut <em>5 pièces</em> pour débloquer une autre activité, vous pouvez spécifier que l\'objet doit réapparaître quotidiennement pour les encourager à consulter votre cours chaque jour.</p>
<p>Notez toutefois que les objets n\'apparaîtront pas par magie dans votre cours, vous devrez ajouter un code spécial dans un contenu pour qu\'ils apparaîssent.</p>';
$string['dropslist'] = 'Liste des lieux';
$string['dropsnippet'] = 'Code pour « {$a} »';
$string['dropsummary'] = 'Paramètres du lieu';
$string['edit'] = 'Modifier';
$string['editdrop'] = 'Modifier le lieu « {$a} »';
$string['edititem'] = 'Modifier l\'objet « {$a} »';
$string['edittrade'] = 'Modifier le troc « {$a} »';
$string['edittradeitem'] = 'Modifier l\'objet du troc « {$a} »';
$string['eginthecastle'] = 'P. ex. Dans le château';
$string['eventitemacquired'] = 'Un objet a été récupéré.';
$string['filtershortcodesnotactive'] = 'Le filtre Shortcodes est installé mais pas encore activé dans ce cours. Consultez <a href="{$a->activeurl}" target="_blank">cette page</a> pour l\'activer dans le cours.';
$string['filtershortcodesnotenabled'] = 'Le filtre Shortcodes est installé mais pas encore <a href="{$a->enableurl}" target="_blank">activé</a>.';
$string['filtershortcodesnotinstalled'] = 'Nous vous conseillons d\'installer et d\'activer le <a href="{$a->installurl}" target="_blank">filtre Shortcodes</a>. Il rend l\'utilisation des codes plus facile et plus fiable. De plus il permet d\'utiliser le troc.';
$string['filterstashdeprecated'] = 'Vous utilisez l\'ancien filtre Stash qui n\'est plus maintenu. Nous vous conseillons de le remplacer par le <a href="{$a->installurl}" target="_blank">filtre Shortcodes</a>. Celui-ci permet également d\'utiliser la fonctionnalité de troc.';
$string['filterstashnotactive'] = 'Le filtre est installé mais pas encore activé dans ce cours. Consultez <a href="{$a->activeurl}" target="_blank">cette page</a> pour l\'activer dans le cours.';
$string['filterstashnotenabled'] = 'Le filtre est installé mais pas encore <a href="{$a->enableurl}" target="_blank">activé</a>.';
$string['filterstashnotinstalled'] = 'Nous vous conseillons d\'installer et d\'activer le <a href="{$a->installurl}" target="_blank">filtre Stash</a>. Il rend l\'utilisation des codes plus facile et plus fiable. De plus il permet d\'utiliser le troc.';
$string['filterstashwrongversion'] = 'Le filtre que vous avez installé est une ancienne version qui ne gère pas la fonctionnalité de troc. Consultez <a href="{$a}" target="_blank">cette page</a> pour obtenir la dernière version.';
$string['gain'] = 'Gain';
$string['gainloss'] = 'Gagnez ou perdez';
$string['gaintitle'] = 'Intitulé du gain';
$string['gaintitle_help'] = 'Intitulé de la colonne d\'objets que l\'utilisateur récupérera grâce à ce troc.';
$string['image'] = 'Image';
$string['imageandbutton'] = 'Image et bouton';
$string['item'] = 'Objet';
$string['itemdetail'] = 'Détails';
$string['itemdetail_help'] = 'Détails concernant l\'objet';
$string['itemimage'] = 'Image';
$string['itemimage_help'] = 'Cette image sera utilisée pour afficher l\'objet. La taille recommandée est de 100x100 pixels.';
$string['itemname'] = 'Nom de l\'objet';
$string['itemname_help'] = 'Le nom de l\'objet qui sera affiché aux étudiants.';
$string['items'] = 'Objets';
$string['itemslist'] = 'Liste des objets';
$string['locations'] = 'Lieux';
$string['loss'] = 'Perte';
$string['losstitle'] = 'Intitulé de la perte';
$string['losstitle_help'] = 'Intitulé de la colonne d\'objets que l\'utilisateur cédera lors de ce troc.';
$string['maxnumber'] = 'Nombre maximum à récupérer';
$string['maxpickup'] = 'Nombre maximum';
$string['maxpickup_help'] = 'Le nombre de fois qu\'un même objet peut être récupéré par chaque étudiant dans ce lieu. Par exemple, si vous spécifiez « 1 », il ne sera récupérable qu\'une fois par étudiant. Par contre, si vous spécifiez « 5 », chaque étudiant pourra le récupérer 5 fois dans ce lieu. Pour les valeurs différentes de « 1 », il est préférable de l\'utiliser en combinaison avec « l\'intervalle de récupération ».';
$string['navdrops'] = 'Lieux';
$string['navinventory'] = 'Inventaire';
$string['navitems'] = 'Objets';
$string['navreport'] = 'Rapport';
$string['navtrade'] = 'Troc';
$string['none'] = 'Aucun';
$string['number'] = 'Nombre';
$string['pickupa'] = 'Récupérez « {$a} »';
$string['pickupinterval'] = 'Intervalle de récupération';
$string['pickupinterval_help'] = '<p>Ceci définit le temps nécessaire pour qu\'un objet réapparaisse pour les étudiants qui l\'ont déjà récupéré. Par exemple, si vous avez ajouté un objet «pain» vous pourriez définir un intervalle de récupération de 24 heures pour laisser le temps au boulanger d\'en refaire. Il est important de savoir que lorsqu\'un étudiant récupère un objet, les autres étudiants ne sont pas impactés.</p>
<p>Ce paramètre n\'a pas d\'effet si «Nombre maximum» est égal à «1».';
$string['pluginname'] = 'Baluchon';
$string['privacy:metadata:pickup'] = 'Enregistrement des objets récupérés dans un certain lieu.';
$string['privacy:metadata:pickup:dropid'] = 'Identifiant du lieu.';
$string['privacy:metadata:pickup:lastpickup'] = 'Moment auquel l\'objet a été récupéré.';
$string['privacy:metadata:pickup:pickupcount'] = 'Quantité récupérée dans ce lieu.';
$string['privacy:metadata:pickup:timecreated'] = 'Moment auquel l\'enregistrement a été créé.';
$string['privacy:metadata:pickup:timemodified'] = 'Moment auquel l\'enregistrement a été modifié pour la dernière fois.';
$string['privacy:metadata:pickup:userid'] = 'Identifiant de l\'utilisateur qui a récupéré l\'objet.';
$string['privacy:metadata:useritem'] = 'Enregistrement des objets qu\'un utilisateur possède.';
$string['privacy:metadata:useritem:itemid'] = 'Identifiant de l\'objet.';
$string['privacy:metadata:useritem:quantity'] = 'Quantité récupérée.';
$string['privacy:metadata:useritem:timecreated'] = 'Moment auquel l\'enregistrement a été créé.';
$string['privacy:metadata:useritem:timemodified'] = 'Moment auquel l\'enregistrement a été modifié pour la dernière fois.';
$string['privacy:metadata:useritem:userid'] = 'Identifiant de l\'utilisateur qui possède l\'objet';
$string['quantity'] = 'Quantité';
$string['reallydeletedrop'] = 'Voulez-vous vraiment supprimer ce lieu?';
$string['reallydeleteitem'] = 'Voulez-vous vraiment supprimer cet objet?';
$string['reallyresetstashof'] = 'Voulez vous vraiment vider le baluchon de {$a}';
$string['report'] = 'Rapport';
$string['resetstashof'] = 'Vider le baluchon de {$a}';
$string['saveandnext'] = 'Enregistrer et continuer';
$string['savechanges'] = 'Enregistrer';
$string['settings'] = 'Paramètres';
$string['setup'] = 'Configuration';
$string['shortcode:stashdrop'] = 'Affiche l\'objet afin que les utilisateurs puissent le récupérer';
$string['shortcode:stashtrade'] = 'Affiche le troc';
$string['snippet'] = 'Code';
$string['stash'] = 'Baluchon';
$string['stash:acquireitems'] = 'L\'utilisateur peut récupérer des objets';
$string['stash:addinstance'] = 'Ajouter le bloc à une page';
$string['stashdisabled'] = 'Le baluchon n\'est pas activé. Le bloc a-t-il bien été ajouté au cours?';
$string['stash:view'] = 'Afficher le contenu du baluchon';
$string['text'] = 'Texte';
$string['thedrophasbeendeleted'] = 'Le lieu « {$a} » a été supprimé';
$string['theitemhasbeendeleted'] = 'L\'objet « {$a} » a été supprimé';
$string['thestashofhasbeenreset'] = 'Le baluchon de « {$a} » a été vidé';
$string['thetradehasbeendeleted'] = 'Le troc « {$a} » a été supprimé';
$string['thetradeitemhasbeendeleted'] = 'Le troc a été supprimé';
$string['title'] = 'Titre';
$string['trade'] = 'Troc';
$string['tradecreated'] = 'Troc « {$a} » ajouté';
$string['tradeitem'] = 'Objet pour le troc';
$string['tradeitems'] = 'Objets pour le troc';
$string['tradelist'] = 'Liste des trocs';
$string['tradename'] = 'Nom du troc';
$string['tradename_help'] = 'Le nom du troc. Il peut être affiché aux étudiants.';
$string['tradewidget'] = 'Ajouter un troc';
$string['tradewidget_help'] = '<p>Un troc permet d\'obtenir les objets de la colonne de gauche en échange des objets de la colonne de droite.</p>Cliquez le symbole + en-dessous de la colonne pour y ajouter des objets.</p><p>Le quantité doit être un nombre positif.</p>';
$string['unlimited'] = 'Illimité';
$string['whataredrops'] = 'Qu\'est-ce qu\'un lieu?';
$string['whatisadrophelp'] = 'Un lieu est un endroit de votre cours où vous souhaitez afficher votre objet.';
$string['whatisatradedrophelp'] = 'Un lieu est un endroit de votre cours où vous souhaitez proposer un troc.';
$string['whatisthisthing'] = 'Qu\'est ce que c\'est que ça? Je suis sûr que ça vous sera utile!';
$string['whatsnext'] = 'Et ensuite?';
$string['whatsthis'] = 'Qu\'est-ce que c\'est que ça?';
$string['yourinventoryisempty'] = 'Votre baluchon est vide.';
