<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'quiz', language 'fr', branch 'MOODLE_36_STABLE'
 *
 * @package   quiz
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accessnoticesheader'] = 'Vous pouvez prévisualiser ce test, mais s\'il s\'agit d\'une tentative réelle, vous serez bloqué en raison de :';
$string['action'] = 'Action';
$string['activityoverview'] = 'Vous avez des tests à terminer';
$string['adaptive'] = 'Mode adaptatif';
$string['adaptive_help'] = 'Si ce paramètre est activé, il est permis de répondre plusieurs fois à une même question au cours d\'une même tentative à un test. Par exemple, si une réponse est marquée comme incorrecte, l\'étudiant peut réessayer immédiatement de répondre correctement. Toutefois, selon la fonction choisie dans « Appliquer les pénalités », une pénalité sera habituellement déduite à chaque essai incorrect.';
$string['add'] = 'Ajouter';
$string['addaquestion'] = 'une question';
$string['addarandomquestion'] = 'une question aléatoire';
$string['addarandomquestion_help'] = 'Quand une question aléatoire est ajoutée, une question choisie au hasard dans la catégorie est insérée dans le test. Les étudiants auront une sélection de questions différentes. Quand un test permet plusieurs tentatives, chaque tentative pourra contenir une sélection différente de questions.';
$string['addarandomselectedquestion'] = 'Ajouter une question choisie aléatoirement...';
$string['addasection'] = 'Un nouveau titre de section';
$string['adddescriptionlabel'] = 'Ajouter un élément descriptif';
$string['addingquestion'] = 'Ajout d\'une question';
$string['addingquestions'] = '<p>Vous gérez votre banque de questions dans cette partie de la page. Les questions sont réparties en catégories, afin de les organiser. Elles peuvent être utilisées dans n\'importe lequel de vos cours, ou même dans d\'autres cours si vous les « publiez ».</p>
<p>Créez d\'abord une catégorie. Vous pourrez ensuite créer ou modifier des questions. Vous pouvez choisir une de ces questions pour l\'ajouter à votre test dans l\'autre partie de la page.</p>';
$string['addmoreoverallfeedbacks'] = 'Ajouter {no} champs de feedback';
$string['addnewgroupoverride'] = 'Ajouter une dérogation de groupe';
$string['addnewpagesafterselected'] = 'Ajouter de nouvelles pages après les questions sélectionnées';
$string['addnewquestionsqbank'] = 'Ajouter des questions à la catégorie {$a->catname} : {$a->link}';
$string['addnewuseroverride'] = 'Ajouter une dérogation d\'utilisateur';
$string['addpagebreak'] = 'Ajouter un saut de page';
$string['addpagehere'] = 'Ajouter une page ici';
$string['addquestion'] = 'Ajouter question';
$string['addquestionfrombankatend'] = 'Ajouter une question à la fin, tirée de la banque de questions';
$string['addquestionfrombanktopage'] = 'Ajouter à la page {$a} une question de la banque de questions';
$string['addquestions'] = 'Ajouter des questions';
$string['addquestionstoquiz'] = 'Ajouter ces questions au test en cours';
$string['addrandom'] = 'Ajouter {$a} questions aléatoires';
$string['addrandom1'] = '<< Ajouter';
$string['addrandom2'] = 'questions aléatoires';
$string['addrandomfromcategory'] = 'Ajouter des questions aléatoires depuis la catégorie';
$string['addrandomquestion'] = 'Ajouter question aléatoire';
$string['addrandomquestionatend'] = 'Ajouter une question aléatoire à la fin';
$string['addrandomquestiontopage'] = 'Ajouter à la page {$a} une question aléatoire';
$string['addrandomquestiontoquiz'] = 'Ajouter une question aléatoire au test {$a}';
$string['addselectedquestionstoquiz'] = 'Ajouter au test les questions sélectionnées';
$string['addselectedtoquiz'] = 'Ajouter la sélection au test';
$string['addtoquiz'] = 'Ajouter au test';
$string['affectedstudents'] = 'Étudiants concernés';
$string['aftereachquestion'] = 'Après l\'ajout de chaque question';
$string['afternquestions'] = 'Après l\'ajout de {$a} questions';
$string['age'] = 'âge';
$string['allattempts'] = 'Toutes les tentatives';
$string['allinone'] = 'Illimité';
$string['allowreview'] = 'Autoriser la relecture';
$string['alreadysubmitted'] = 'Vous avez probablement déjà répondu ainsi à ce test';
$string['alternativeunits'] = 'Autres unités';
$string['alwaysavailable'] = 'Toujours disponible';
$string['analysisoptions'] = 'Options d\'analyse';
$string['analysistitle'] = 'Table d\'analyse des éléments';
$string['answer'] = 'Réponse';
$string['answered'] = 'Répondu';
$string['answerhowmany'] = 'Plusieurs réponses ou une seule :';
$string['answers'] = 'Réponses';
$string['answersingleno'] = 'Plusieurs choix possibles';
$string['answersingleyes'] = 'Une seule réponse';
$string['answertoolong'] = 'Réponse trop longue après la ligne {$a} (255 caractères max.)';
$string['anytags'] = 'Tous les tags';
$string['aon'] = 'Format AON';
$string['areyousureremoveselected'] = 'Voulez-vous vraiment retirer les questions sélectionnées ?';
$string['asshownoneditscreen'] = 'Tel qu\'affiché sur la page de modification';
$string['attempt'] = 'Tentative {$a}';
$string['attemptalreadyclosed'] = 'Cette tentative a déjà été terminée.';
$string['attemptclosed'] = 'La tentative n\'est pas encore fermée';
$string['attemptduration'] = 'Temps utilisé';
$string['attemptedon'] = 'Tentative le';
$string['attempterror'] = 'Vous ne pouvez pas effectuer ce test actuellement pour la raison suivante : {$a}';
$string['attempterrorcontentchange'] = 'La prévisualisation du test n\'existe plus (lorsque qu\'un test est modifié, toutes les prévisualisations en cours sont supprimées).';
$string['attempterrorcontentchangeforuser'] = 'La tentative de test n\'existe plus.';
$string['attempterrorinvalid'] = 'Identifiant de tentative de test non valide';
$string['attemptfirst'] = 'Première tentative';
$string['attemptincomplete'] = 'Cette tentative (de {$a}) n\'est pas encore terminée.';
$string['attemptlast'] = 'Dernière tentative';
$string['attemptnumber'] = 'Tentative';
$string['attemptquiznow'] = 'Faire le test';
$string['attemptreviewtitle'] = '{$a} : relecture de tentative';
$string['attemptreviewtitlepaged'] = '{$a->name} : relecture de tentative (page {$a->currentpage} sur {$a->totalpages})';
$string['attempts'] = 'Tentatives';
$string['attemptsallowed'] = 'Nombre de tentatives autorisées';
$string['attemptsdeleted'] = 'Tentatives de tests supprimées';
$string['attemptselection'] = 'Choisir les tentatives à analyser par participant :';
$string['attemptsexist'] = 'Vous ne pouvez plus ajouter ou retirer des questions.';
$string['attempts_help'] = 'Le nombre totale de tentatives autorisées (pas le nombre de tentatives supplémentaires).';
$string['attemptsnum'] = 'Tentatives : {$a}';
$string['attemptsnumthisgroup'] = 'Tentatives : {$a->total} ({$a->group} de ce groupe)';
$string['attemptsnumyourgroups'] = 'Tentatives : {$a->total} ({$a->group} de vos groupes)';
$string['attemptsonly'] = 'N\'afficher que les étudiants ayant déjà effectué le test';
$string['attemptstate'] = 'État';
$string['attemptstillinprogress'] = 'Tentative encore en cours';
$string['attemptsummarytitle'] = '{$a} : résumé de tentative';
$string['attemptsunlimited'] = 'Nombre illimité de tentatives';
$string['attempttitle'] = '{$a}';
$string['attempttitlepaged'] = '{$a->name} (page {$a->currentpage} sur {$a->totalpages})';
$string['autosaveperiod'] = 'Délai d\'enregistrement automatique';
$string['autosaveperiod_desc'] = 'Durant les tests, les réponses des participants peuvent être enregistrées automatiquement. Les réponses sont enregistrées dès que l\'une d\'entre elles est modifiée ou après la durée indiquée ici. Un délai plus court augmente la charge sur le serveur, mais réduit en revanche les risques de perte du travail des participants. Si vous voulez réduire considérablement ce délai, essayez de le diminuer graduellement en observant la charge du serveur. Si elle devient trop grande, allongez le délai. En fixant le délai à 0, l\'enregistrement automatique est désactivé.';
$string['back'] = 'Retour à la question précédente';
$string['backtocourse'] = 'Retour au cours';
$string['backtoquestionlist'] = 'Retour à la liste des questions';
$string['backtoquiz'] = 'Retour à l\'édition du test';
$string['basicideasofquiz'] = 'Les concepts de base pour créer des tests';
$string['bestgrade'] = 'Meilleure note';
$string['bothattempts'] = 'Afficher aussi les étudiants n\'ayant pas fait le test';
$string['browsersecurity'] = 'Sécurité du navigateur';
$string['browsersecurity_help'] = 'Si vous sélectionnez l\'option « Nouvelle fenêtre plein écran avec un peu de sécurité Javascript »,

* le test démarre uniquement si l\'étudiant possède un navigateur qui accepte le Javascript ;
* le test démarre dans une nouvelle fenêtre qui couvre entièrement les autres fenêtres et qui ne possède pas de boutons de navigation ;
* les fonctions telles que copier-coller sont, autant que possible, bloquées pour l\'étudiant.';
$string['calculated'] = 'Calculée';
$string['calculatedquestion'] = 'Question calculée non supportée (ligne {$a}). La question sera ignorée';
$string['cannotcreatepath'] = 'Le fichier ne peut pas être créé ({$a})';
$string['cannoteditafterattempts'] = 'Vous ne pouvez pas ajouter ou retirer des questions, car ce test a déjà été effectué ({$a}).';
$string['cannotfindprevattempt'] = 'Impossible de trouver une tentative précédente.';
$string['cannotfindquestionregard'] = 'Impossible d\'obtenir les questions à ré-évaluer !';
$string['cannotinsert'] = 'Impossible d\'insérer la question';
$string['cannotinsertrandomquestion'] = 'Impossible d\'insérer une nouvelle question aléatoire !';
$string['cannotloadquestion'] = 'Impossible de charger les options de question';
$string['cannotloadtypeinfo'] = 'Impossible de lire les informations du type de question de cette question';
$string['cannotopen'] = 'Impossible d\'ouvrir le fichier d\'exportation ({$a})';
$string['cannotremoveallsectionslots'] = 'Vous avez sélectionné toutes les questions sous l\'entête de section « {$a} ». Il n\'est pas permis de supprimer toutes les questions dans sous un entête de section.';
$string['cannotremoveslots'] = 'Impossible de supprimer des questions';
$string['cannotrestore'] = 'Impossible de restaurer les sessions de question';
$string['cannotreviewopen'] = 'Vous ne pouvez pas relire cette tentative, qui est encore ouverte.';
$string['cannotsavelayout'] = 'Impossible d\'enregistrer la disposition';
$string['cannotsavenumberofquestion'] = 'Impossible d\'enregistrer le nombre de questions par page';
$string['cannotsavequestion'] = 'Impossible d\'enregistrer la liste des questions';
$string['cannotsetgrade'] = 'Impossible de modifier la note maximale de ce test';
$string['cannotsetsumgrades'] = 'Impossible modifier la somme des notes';
$string['cannotstartgradesmismatch'] = 'Impossible de commencer une tentative. Ce test est censé être évalué sur une note maximale de {$a->grade}, or aucune des questions ne peut être notée. Ceci peut être corrigé sur la page « Modifier le test ».';
$string['cannotstartmissingquestion'] = 'Impossible de démarrer ce test. Le test comporte une question qui n\'existe pas.';
$string['cannotstartnoquestions'] = 'Impossible de commencer une tentative. Ce test n\'a pas encore été configuré et ne comporte aucune question.';
$string['cannotwrite'] = 'Impossible d\'écrire dans le fichier d\'exportation ({$a})';
$string['canredoquestions'] = 'Autoriser à répondre à nouveau aux questions au cours d\'une tentative';
$string['canredoquestions_desc'] = 'Si ce réglage est activé, quand les élèves ont répondu à une question, ils voient un bouton « Répondre à nouveau à la question ». Cette fonction permet de répondre différemment à la même question, sans avoir à envoyer la tentative de l\'ensemble du test et d\'en commencer une autre. Elle est utile pour les tests de formation ou d\'entraînement.

Ce réglage n\'affecte que les questions et les comportements offrant aux étudiants la possibilité de terminer la question avant que la tentative ne soit envoyée (par exemple, les comportements « Feedback immédiat » et « Interactif avec essais multiples »).';
$string['canredoquestions_help'] = 'Si cette option est activée, après que les élèves ont répondu à une question, ils voient un bouton « Répondre à nouveau à la question ». Cette fonction permet de répondre différemment à la même question, sans avoir à envoyer la tentative de l\'ensemble du test et d\'en commencer une autre. Elle est utile pour les tests de formation ou d\'entraînement.

Ce réglage n\'affecte que les questions et les comportements offrant aux étudiants la possibilité de terminer la question avant que la tentative ne soit envoyée (par exemple, les comportements « Feedback immédiat » et « Interactif avec essais multiples »).';
$string['canredoquestionsyes'] = 'Les étudiants peuvent répondre à nouveau à toute question terminée';
$string['caseno'] = 'La casse des caractères indiffère';
$string['casesensitive'] = 'Casse des caractères';
$string['caseyes'] = 'La casse des caractères doit être respectée';
$string['categoryadded'] = 'La catégorie « {$a} » a été ajoutée';
$string['categorydeleted'] = 'La catégorie « {$a} » a été supprimée';
$string['categorynoedit'] = 'Vous n\'avez pas les autorisations nécessaires pour modifier la catégorie « {$a} ».';
$string['categoryupdated'] = 'La catégorie a été modifiée';
$string['close'] = 'Fermer la prévisualisation';
$string['closebeforeopen'] = 'Impossible de modifier le test : vous avez indiqué une date de fermeture antérieure à la date d\'ouverture du test.';
$string['closed'] = 'Fermé';
$string['closepreview'] = 'Fermer la prévisualisation';
$string['closereview'] = 'Fermer la relecture';
$string['comment'] = 'Commentaire';
$string['commentorgrade'] = 'Commenter ou modifier la note';
$string['comments'] = 'Commentaires';
$string['completedon'] = 'Terminé le';
$string['completionattemptsexhausted'] = 'Ou toutes les tentatives terminées';
$string['completionattemptsexhausteddesc'] = 'Achevé si toutes les tentatives disponibles sont épuisées';
$string['completionattemptsexhausted_help'] = 'Marquer le test comme terminé lorsque l\'étudiant a épuisé le nombre maximal de tentatives.';
$string['completionpass'] = 'Requiert la note de passage';
$string['completionpassdesc'] = 'L\'étudiant doit atteindre une note minimale pour achever cette activité';
$string['completionpass_help'] = 'Si ce réglage est activé, l\'activité est considérée comme terminée lorsque l\'étudiant reçoit la note pour passer (définie ainsi dans la section Notes des réglages du test) ou une note supérieure.';
$string['configadaptive'] = 'Si cette option est activée, le participant pourra donner plusieurs réponses à une question lors de la même tentative du test.';
$string['configattemptsallowed'] = 'La restriction du nombre des tentatives des participants est autorisée.';
$string['configdecimaldigits'] = 'Le nombre de chiffres après la virgule lors de l\'affichage des notes.';
$string['configdecimalplaces'] = 'Le nombre de chiffres à afficher après la virgule lors de l\'affichage des notes du test.';
$string['configdecimalplacesquestion'] = 'Le nombre de chiffres à afficher après la virgule lors de l\'affichage de la note de chaque question.';
$string['configdelay1'] = 'Si vous indiquez une durée, les participants devront attendre ce laps de temps avant d\'effectuer une nouvelle tentative après la première.';
$string['configdelay1st2nd'] = 'Si vous indiquez une durée, les participants devront attendre ce laps de temps avant d\'effectuer une nouvelle tentative après la première.';
$string['configdelay2'] = 'Si vous indiquez une durée, les participants devront attendre ce laps de temps avant d\'effectuer une troisième ou d\'ultérieures tentatives.';
$string['configdelaylater'] = 'Si vous indiquez une durée, les participants devront attendre ce laps de temps avant d\'effectuer des tentatives ultérieures après la précédente.';
$string['configeachattemptbuildsonthelast'] = 'Détermine si les nouvelles tentatives contiennent les résultats des précédentes.';
$string['configgrademethod'] = 'Définit la méthode à utiliser pour calculer la note finale du test pour les participants.';
$string['configintro'] = 'Les valeurs indiquées ici définissent les valeurs utilisées par défaut lors de la création d\'un test. Vous pouvez également définir les réglages des tests considérés comme avancés.';
$string['configmaximumgrade'] = 'La note maximale du test par défaut. Si elle est différente de celle du test lui-même, la note des participants sera adaptée adéquatement.';
$string['confignavmethod'] = 'En mode navigation libre, les questions peuvent être répondues dans n\'importe quel ordre. Dans mode séquentiel, les questions doivent être traitées strictement dans l\'ordre établi.';
$string['confignewpageevery'] = 'Lors de l\'ajout de questions, des sauts de pages seront insérés automatiquement d\'après ce réglage.';
$string['configoutcomesadvanced'] = 'Si ce réglage est activé, les objectifs seront des réglages avancés dans le formulaire de modification des tests.';
$string['configpenaltyscheme'] = 'Pénalité soustraite pour chaque mauvaise réponse dans les tests en mode adaptatif.';
$string['configpopup'] = 'Forcer l\'affichage du test dans une nouvelle fenêtre et utiliser des astuces Javascript pour essayer d\'empêcher le copier/coller, etc. durant les tentatives de tests.';
$string['configrequirepassword'] = 'Les participants doivent saisir ce mot de passe avant de pouvoir effectuer des tentatives.';
$string['configrequiresubnet'] = 'Les participants ne peuvent effectuer des tentatives que depuis les ordinateurs sur ces réseaux.';
$string['configreviewoptions'] = 'Ces options déterminent les informations que les participants peuvent voir lorsqu\'ils relisent une tentative de test ou quand ils consultent les rapports de tests.';
$string['configshowblocks'] = 'Afficher les blocs durant les tests.';
$string['configshowuserpicture'] = 'Afficher l\'avatar du participant durant les tentatives.';
$string['configshufflewithin'] = 'Si cette option est activée, les parties des questions seront mélangées aléatoirement lors de chaque tentative de chaque participant, pour autant que l\'option soit également définie dans les réglages de la question.';
$string['configtimelimit'] = 'Le temps imparti aux participants pour effectuer les tests, en minutes. Le nombre 0 indique qu\'il n\'y a pas de limite de temps.';
$string['configtimelimitsec'] = 'Le temps imparti aux participants pour effectuer les tests, en secondes. Le nombre 0 indique qu\'il n\'y a pas de limite de temps.';
$string['configurerandomquestion'] = 'Configurer la question';
$string['confirmclose'] = 'Une fois la tentative envoyée, vous n\'aurez plus la possibilité de modifier vos réponses pour cette tentative.';
$string['confirmremovequestion'] = 'Voulez-vous vraiment supprimer cette question {$a} ?';
$string['confirmremovesectionheading'] = 'Voulez-vous vraiment supprimer le titre de section « {$a} » ?';
$string['confirmserverdelete'] = 'Voulez-vous vraiment supprimer le serveur <b>{$a}</b> de la liste ?';
$string['connectionerror'] = 'Connexion réseau perdue (échec de l\'enregistrement automatique).

Veuillez prendre note de toutes les réponses que vous avez saisies sur cette page au cours des quelques dernières minutes, puis essayez de vous reconnecter.

Une fois la connexion rétablie, vos réponses devraient être enregistrées et ce message disparaîtra.';
$string['connectionok'] = 'Connexion réseau rétablie. Vous pouvez continuer.';
$string['containercategorycreated'] = 'Cette catégorie a été créée pour y placer les catégories originales qui ont été déplacées au niveau du site pour les raisons spécifiées ci-dessous.';
$string['continueattemptquiz'] = 'Continuer la dernière tentative';
$string['continuepreview'] = 'Continuer la dernière prévisualisation';
$string['copyingfrom'] = 'Création d\'une copie de la question « {$a} »';
$string['copyingquestion'] = 'Copie d\'une question';
$string['correct'] = 'Correct';
$string['correctanswer'] = 'Bonne réponse';
$string['correctanswerformula'] = 'Formule de la bonne réponse';
$string['correctansweris'] = 'Bonne réponse : {$a}';
$string['correctanswerlength'] = 'Chiffres significatifs';
$string['correctanswers'] = 'Bonnes réponses';
$string['correctanswershows'] = 'La bonne réponse affiche';
$string['corrresp'] = 'Réponse correcte';
$string['countdown'] = 'Compte à rebours';
$string['countdownfinished'] = 'Le test se termine, vous devez envoyer vos réponses maintenant.';
$string['countdowntenminutes'] = 'Le test se terminera dans 10 minutes.';
$string['coursetestmanager'] = 'Format CTM';
$string['createcategoryandaddrandomquestion'] = 'Créer une catégorie et ajouter une question aléatoire';
$string['createfirst'] = 'Vous devez d\'abord créer quelques questions à réponse courte.';
$string['createmultiple'] = 'Ajouter plusieurs questions aléatoires au test';
$string['createnewquestion'] = 'Créer une question';
$string['createquestionandadd'] = 'Créer une question et l\'ajouter au test.';
$string['custom'] = 'Format personnalisé';
$string['dataitemneed'] = 'Un jeu de données au moins doit être ajouté pour obtenir une question valide';
$string['datasetdefinitions'] = 'Définitions du jeu de données réutilisable de la catégorie {$a}';
$string['datasetnumber'] = 'Nombre';
$string['daysavailable'] = 'Jours disponibles';
$string['decimaldigits'] = 'Décimales dans les notes';
$string['decimalplaces'] = 'Décimales dans les notes';
$string['decimalplaces_help'] = 'Ce réglage vous permet de choisir le nombre de décimales à afficher dans les scores ou dans les notes. Ces réglages n\'agissent que sur l\'affichage des notes, et n\'altèrent pas les notes stockées dans la base de données, ni les calculs internes qui sont effectués avec précision.';
$string['decimalplacesquestion'] = 'Décimales dans les notes des questions';
$string['decimalplacesquestion_help'] = 'Ce réglage permet de déterminer le nombre de décimales à afficher dans la présentation des notes pour chaque question.';
$string['decimalpoints'] = 'Points décimaux';
$string['default'] = 'Défaut';
$string['defaultgrade'] = 'Note par défaut';
$string['defaultinfo'] = 'Catégorie par défaut pour les questions.';
$string['delay1'] = 'Délai entre la première et la deuxième tentative';
$string['delay1st2nd'] = 'Délai imposé entre la première et la deuxième tentative';
$string['delay1st2nd_help'] = 'Si ce réglage est activé, les étudiants doivent attendre le laps de temps indiqué avant d\'entreprendre une deuxième tentative pour le test.';
$string['delay2'] = 'Délai entre les tentatives suivantes';
$string['delaylater'] = 'Délai imposé entre les tentatives suivantes';
$string['delaylater_help'] = 'Si ce réglage est activé, ce délai détermine la durée que devra attendre l\'étudiant avant sa troisième tentative, ou les suivantes.';
$string['deleteattemptcheck'] = 'Voulez-vous vraiment supprimer complètement ces tentatives ?';
$string['deleteselected'] = 'Supprimer la sélection';
$string['deletingquestionattempts'] = 'Suppression des tentatives de tests';
$string['description'] = 'Description';
$string['disabled'] = 'Désactivé';
$string['displayoptions'] = 'Options d\'affichage';
$string['donotuseautosave'] = 'Ne pas utiliser l\'enregistrement automatique';
$string['download'] = 'Cliquer pour télécharger le fichier exporté';
$string['downloadextra'] = '(le fichier est aussi déposé dans les fichiers du cours, dans le dossier /backupdata/quiz)';
$string['dragtoafter'] = 'Après {$a}';
$string['dragtostart'] = 'Au début';
$string['duplicateresponse'] = 'Cet envoi a été ignoré, car vous avez déjà donné auparavant une réponse équivalente.';
$string['eachattemptbuildsonthelast'] = 'Chaque tentative complète la précédente';
$string['eachattemptbuildsonthelast_help'] = 'Lorsqu\'on autorise l\'étudiant à refaire plusieurs fois un test et que cette option est activée, l\'étudiant pourra commencer une nouvelle tentative à partir des résultats de l\'essai précédent. L\'étudiant pourra ainsi compléter un test en plusieurs fois.';
$string['editcategories'] = 'Modifier les catégories';
$string['editcategory'] = 'Modifier la catégorie';
$string['editcatquestions'] = 'Modifier les questions de la catégorie';
$string['editingquestion'] = 'Modification d\'une question';
$string['editingquiz'] = 'Modification du test';
$string['editingquiz_help'] = 'Lors de la création d\'un test, les concepts principaux suivants sont à considérer :

* le test, qui contient des questions sur une ou plusieurs pages ;
* la banque de questions, qui contient des copies de toutes les questions, organisées en catégories ;
* les questions aléatoires. Les étudiants obtiennent des questions différentes lors de leur tentative du test, et un étudiant obtient des questions différentes lors de chaque tentative.';
$string['editingquizx'] = 'Modification du test {$a}';
$string['editmaxmark'] = 'Modifier le score maximum';
$string['editoverride'] = 'Modifier une dérogation';
$string['editqcats'] = 'Modifier les catégories de questions';
$string['editquestion'] = 'Modifier la question';
$string['editquestions'] = 'Modifier les questions';
$string['editquiz'] = 'Modifier le test';
$string['editquizquestions'] = 'Modifier les questions du test';
$string['emailconfirmbody'] = 'Bonjour {$a->username},

Vous avez envoyé vos réponses au test « {$a->quizname} » du cours « {$a->coursename} » à {$a->submissiontime}.

Ce message confirme que vos réponses ont été enregistrées.

Vous pouvez accéder à ce test en suivant le lien {$a->quizurl}.';
$string['emailconfirmsmall'] = 'Merci pour l\'envoi de vos réponses au test {$a->quizname}';
$string['emailconfirmsubject'] = 'Confirmation d\'envoi : {$a->quizname}';
$string['emailnotifybody'] = 'Bonjour {$a->username},

Le participant {$a->studentname} a terminé le test « {$a->quizname} » ({$a->quizurl}) du cours « {$a->coursename} ».

Vous pouvez voir cette tentative en suivant le lien {$a->quizreviewurl}.';
$string['emailnotifysmall'] = '{$a->studentname} a terminé le test {$a->quizname}. Consultez {$a->quizreviewurl}';
$string['emailnotifysubject'] = 'Le participant {$a->studentname} a terminé le test {$a->quizname}';
$string['emailoverduebody'] = 'Bonjour {$a->studentname},

Vous avez commencé une tentative du test « {$a->quizname} » dans le cours « {$a->coursename} », mais ne l\'avez jamais envoyée. Elle aurait dû être envoyée jusqu\'au {$a->attemptduedate}.

Si vous voulez envoyer cette tentative, veuillez vous rendre sur {$a->attemptsummaryurl} et cliquer sur le bouton d\'envoi.
Vous devez faire ceci avant {$a->attemptgraceend}, sans quoi votre tentative ne sera pas prise en compte.';
$string['emailoverduesmall'] = 'Vous n\'avez pas envoyé votre tentative du test {$a->quizname}. Veuillez visiter {$a->attemptsummaryurl} avant {$a->attemptgraceend} si vous désirez l\'envoyer.';
$string['emailoverduesubject'] = 'Tentative maintenant en retard : {$a->quizname}';
$string['empty'] = 'Vide';
$string['enabled'] = 'Activé';
$string['endtest'] = 'Terminer le test...';
$string['erroraccessingreport'] = 'Vous ne pouvez pas consulter ce rapport';
$string['errorinquestion'] = 'Erreur dans la question';
$string['errormissingquestion'] = 'Erreur ! Le système ne trouve pas la question d\'identifiant {$a}';
$string['errornotnumbers'] = 'Erreur ! Les réponses doivent être numériques';
$string['errorunexpectedevent'] = 'Code d\'événement {$a->event} inattendu trouvé pour la question {$a->questionid} dans la tentative {$a->attemptid}.';
$string['essay'] = 'Composition';
$string['essayquestions'] = 'Questions';
$string['eventattemptdeleted'] = 'Tentative de test supprimée';
$string['eventattemptpreviewstarted'] = 'Prévisualisation de tentative de test commencée';
$string['eventattemptreviewed'] = 'Tentative de test relue';
$string['eventattemptsummaryviewed'] = 'Résumé de tentative de test consulté';
$string['eventattemptviewed'] = 'Tentative de test consultée';
$string['eventeditpageviewed'] = 'Page de modification de test consultée';
$string['eventoverridecreated'] = 'Dérogation de test créée';
$string['eventoverridedeleted'] = 'Dérogation de test supprimée';
$string['eventoverrideupdated'] = 'Dérogation de test modifiée';
$string['eventquestionmanuallygraded'] = 'Question évaluée manuellement';
$string['eventquizattemptabandoned'] = 'Tentative de test abandonnée';
$string['eventquizattemptstarted'] = 'Tentative de test commencée';
$string['eventquizattemptsubmitted'] = 'Tentative de test envoyée';
$string['eventquizattempttimelimitexceeded'] = 'Durée limite de tentative de test dépassée';
$string['eventreportviewed'] = 'Rapport de test consulté';
$string['everynquestions'] = 'Toutes les {$a} questions';
$string['everyquestion'] = 'Chaque question';
$string['everythingon'] = 'Tout activer';
$string['existingcategory'] = 'Catégorie existante';
$string['exportcategory'] = 'Exporter catégorie';
$string['exporterror'] = 'Une erreur est survenue durant l\'exportation';
$string['exportingquestions'] = 'Les questions sont exportées vers un fichier';
$string['exportname'] = 'Nom de fichier';
$string['exportquestions'] = 'Exporter des questions vers un fichier';
$string['extraattemptrestrictions'] = 'Restrictions supplémentaires sur les tentatives';
$string['false'] = 'Faux';
$string['feedback'] = 'Feedback';
$string['feedbackerrorboundaryformat'] = 'Les limites des notes des feedbacks doivent être soit un nombre, soit un pourcentage. La valeur saisie pour la limite {$a} n\'est pas correcte.';
$string['feedbackerrorboundaryoutofrange'] = 'Les limites des notes des feedbacks doivent être entre 0% et 100%. La valeur saisie pour la limite {$a} n\'est pas dans cet intervalle.';
$string['feedbackerrorjunkinboundary'] = 'Les limites des notes des feedbacks doivent être saisies sans discontinuité.';
$string['feedbackerrorjunkinfeedback'] = 'Les champs pour les feedbacks doivent être remplis sans discontinuité.';
$string['feedbackerrororder'] = 'Les limites des notes des feedbacks doivent être ordonnées, la plus haute en premier. La valeur saisie pour la limite {$a} n\'est pas dans l\'ordre.';
$string['file'] = 'Fichier';
$string['fileformat'] = 'Format de fichier';
$string['fillcorrect'] = 'Remplir correctement';
$string['filloutnumericalanswer'] = 'Vous devez fournir au moins une proposition de réponse possible et sa tolérance. La première proposition correspondant à la réponse donnée par le participant sera utilisée pour déterminer la note et le feedback. Si vous fournissez un feedback pour une proposition vide à la fin de la liste, celui-ci sera présenté aux participants dont la réponse ne correspond à aucune des propositions.';
$string['filloutoneanswer'] = 'Vous devez fournir au moins une proposition. Les propositions laissées vides ne seront pas prises en compte. Le caractère * (joker) peut être utilisé pour correspondre à n\'importe quelle caractère. La première proposition correspondant à la réponse donnée par le participant sera utilisée pour déterminer la note et le feedback.';
$string['filloutthreequestions'] = 'Vous devez fournir au moins trois propositions avec les réponses correspondantes.<br />Les propositions laissées vides ne seront pas prises en compte.';
$string['fillouttwochoices'] = 'Vous devez donner au moins deux propositions.<br />Les propositions laissées vides ne seront pas prises en compte.';
$string['finishattemptdots'] = 'Terminer le test...';
$string['finishreview'] = 'Terminer la relecture';
$string['forceregeneration'] = 'Forcer l\'actualisation';
$string['formatnotfound'] = 'Le format d\'importation/exportation {$a} n\'a pas été trouvé';
$string['formulaerror'] = 'Erreur de formule';
$string['fractionsaddwrong'] = 'La somme des notes positives que vous avez choisies n\'atteint pas 100%.<br />Elle est de {$a}%.<br />Souhaitez-vous revenir en arrière pour corriger cela ?';
$string['fractionsnomax'] = 'L\'une des propositions devrait avoir la note 100% afin qu\'il soit<br />possible d\'obtenir la note maximale à cette question.<br />Souhaitez-vous revenir en arrière pour corriger cela ?';
$string['fromfile'] = 'Depuis le fichier :';
$string['functiondisabledbysecuremode'] = 'Cette fonctionnalité est actuellement désactivée';
$string['generalfeedback'] = 'Feedback général';
$string['generalfeedback_help'] = 'Le feedback général d\'une question est le texte présenté à l\'étudiant après une tentative de réponse. Contrairement au feedback pour une question spécifique, qui dépend du type de question et de la réponse donnée, le même feedback général est toujours affiché.';
$string['graceperiod'] = 'Délai supplémentaire pour envoi';
$string['graceperiod_desc'] = 'Si à l\'échéance du temps imparti, il s\'agit de donner un délai supplémentaire pour envoyer le test, sans permettre de modification aux réponses, cette valeur désigne le temps supplémentaire octroyé, en secondes.';
$string['graceperiod_help'] = 'Le délai supplémentaire octroyé pour envoyer le test, sans permettre de modifier les réponses.';
$string['graceperiodmin'] = 'Délai supplémentaire pour envoi';
$string['graceperiodmin_desc'] = 'Un problème peut survenir à la fin d\'un test. D\'une part, vous voulez laisser travailler les participants jusqu\'à la dernière seconde, et laisser le chronomètre envoyer automatiquement le test lorsque le temps imparti est écoulé. D\'autre part, le serveur pourrait être surchargé à cet instant et prendre un peu de temps pour traiter les réponses.
Pour éviter de pénaliser les participants si le serveur est lent, Moodle accepte les réponses après l\'échéance du délai, durant le laps de temps spécifié ici. Cela a pour conséquence que les participants pourraient tricher en utilisant ce laps de temps supplémentaire pour répondre. C\'est à vous de décider la durée à fixer ici, suivant la performance de votre serveur durant les tests.';
$string['graceperiodtoosmall'] = 'Le délai supplémentaire doit être plus grand que {$a}';
$string['grade'] = 'Note';
$string['gradeall'] = 'Tout évaluer';
$string['gradeaverage'] = 'Note moyenne';
$string['gradeboundary'] = 'Limite de note';
$string['gradeessays'] = 'Évaluer les compositions';
$string['gradehighest'] = 'Note la plus haute';
$string['grademethod'] = 'Méthode d\'évaluation';
$string['grademethod_help'] = 'Lorsqu\'il est permis à l\'étudiant d\'effectuer plusieurs tentatives, les possibilités suivantes sont disponibles pour calculer sa note finale pour le test.

* Note la plus élevée – la meilleure des notes de toutes les tentatives
* Note moyenne – la moyenne arithmétique de toutes les tentatives
* Première note – la note obtenue à la première tentative (les autres tentatives sont ignorées)
* Dernière note – la note obtenue à la dernière tentative (les autres tentatives sont ignorées)';
$string['gradesdeleted'] = 'Notes de tests supprimées';
$string['gradesofar'] = '{$a->method} : {$a->mygrade} / {$a->quizgrade}.';
$string['gradetopassmustbeset'] = 'La note pour passer ne peut pas être zéro, car l\'achèvement de ce test requiert une note pour passer. Veuillez indiquer une note non nulle.';
$string['gradetopassnotset'] = 'Ce test n\'a pas encore de note pour passer. Une telle note peut être définie dans la section Notes des réglages du test.';
$string['gradingdetails'] = 'Points pour cet envoi : {$a->raw}/{$a->max}.';
$string['gradingdetailsadjustment'] = 'En tenant compte des pénalités précédentes, cela donne <strong>{$a->cur}/{$a->max}</strong>.';
$string['gradingdetailspenalty'] = 'Cet envoi a reçu une pénalité de {$a}.';
$string['gradingdetailszeropenalty'] = 'Vous n\'avez pas été pénalisé par cet envoi.';
$string['gradingmethod'] = 'Méthode d\'évaluation : {$a}';
$string['groupoverrides'] = 'Dérogations de groupe';
$string['groupoverridesdeleted'] = 'Dérogations de groupe supprimées';
$string['groupsnone'] = 'Il n\'y a pas de groupe auquel vous pouvez accéder.';
$string['guestsno'] = 'Désolé, les visiteurs anonymes n\'ont pas accès aux tests';
$string['hidebreaks'] = 'Cacher les sauts de page';
$string['hidereordertool'] = 'Cacher l\'outil de réarrangement';
$string['history'] = 'Historique des réponses :';
$string['howquestionsbehave_desc'] = 'Réglage par défaut pour le comportement des questions dans un test.';
$string['imagedisplay'] = 'Image à afficher';
$string['importcategory'] = 'Importer une catégorie';
$string['importerror'] = 'Une erreur est survenue lors de l\'importation';
$string['importfilearea'] = 'Importer à partir d\'un fichier du cours...';
$string['importfileupload'] = 'Importer à partir d\'un fichier à déposer...';
$string['importfromthisfile'] = 'Importer à partir de ce fichier';
$string['import_help'] = 'Cette fonction vous permet d\'importer des questions à partir de fichiers texte externes.

Si votre fichier comprend des caractères étendus, il doit être encodé en UTF-8. Soyez particulièrement prudent avec les fichiers générés par les applications Microsoft Office, qui utilisent habituellement des encodages exotiques qui ne seront pas traités correctement.

';
$string['importingquestions'] = 'Importation de {$a} questions à partir du fichier';
$string['importmax10error'] = 'Cette question comporte une erreur. Il est impossible d\'avoir plus de 10 réponses';
$string['importmaxerror'] = 'Cette question comporte une erreur. Elle propose trop de réponses.';
$string['importquestions'] = 'Importer les questions d\'un fichier';
$string['inactiveoverridehelp'] = '* L\'étudiant n\'est pas dans le groupe correct ou n\'a pas le rôle adéquat pour effectuer le test, ou le test est caché';
$string['incorrect'] = 'Incorrect';
$string['indicator:cognitivedepth'] = 'Test : aspect cognitif';
$string['indicator:cognitivedepth_help'] = 'Cet indicateur est basé sur la profondeur cognitive atteinte par l\'étudiant dans une activité Test.';
$string['indicator:socialbreadth'] = 'Test : aspect social';
$string['indicator:socialbreadth_help'] = 'Cet indicateur se base sur l\'interaction sociale atteinte par l\'étudiant dans une activité Quiz.';
$string['indivresp'] = 'Réponses de chaque personne à toutes les questions';
$string['info'] = 'Info';
$string['infoshort'] = 'i';
$string['initialnumfeedbacks'] = 'Nombre initial de champs pour le feedback général';
$string['initialnumfeedbacks_desc'] = 'Ce réglage détermine le nombre de champs vides pour le feedback général lors de la création d\'un nouveau test. Une fois le test créé, le formulaire affiche le nombre de champs requis pour le nombre de feedbacks du test. Ce réglage doit être au minimum 1.';
$string['inprogress'] = 'En cours';
$string['introduction'] = 'Description';
$string['invalidattemptid'] = 'Cet identifiant de tentative n\'existe pas';
$string['invalidcategory'] = 'L\'identifiant de catégorie n\'est pas valide';
$string['invalidoverrideid'] = 'Identifiant de dérogation non valide';
$string['invalidquestionid'] = 'Identifiant de question non valide';
$string['invalidquizid'] = 'Identifiant de test non valide';
$string['invalidrandomslot'] = 'Id d\'insertion de question aléatoire non valide.';
$string['invalidsource'] = 'La source n\'est pas acceptée comme valable.';
$string['invalidsourcetype'] = 'Type de la source non valable.';
$string['invalidstateid'] = 'Identifiant d\'état non valide';
$string['lastanswer'] = 'Votre dernière réponse était';
$string['layout'] = 'Mise en page';
$string['layoutasshown'] = 'Mise en page telle qu\'affichée.';
$string['layoutasshownwithpages'] = 'Mise en page telle qu\'affichée. <small>(Nouvelle page toutes les {$a} questions.)</small>';
$string['layoutshuffledandpaged'] = 'Questions mélangées aléatoirement, avec {$a} questions par page.';
$string['layoutshuffledsinglepage'] = 'Questions mélangées aléatoirement, toute sur une seule page.';
$string['link'] = 'Lien';
$string['listitems'] = 'Liste des questions du test';
$string['literal'] = 'Lettre';
$string['loadingquestionsfailed'] = 'Échec du chargement des questions : {$a}';
$string['makecopy'] = 'Enregistrer comme nouvelle question';
$string['managetypes'] = 'Gérer les types de question et les serveurs';
$string['manualgradequestion'] = 'Évaluer manuellement la question {$a->question} dans {$a->quiz}, de {$a->user}';
$string['manualgrading'] = 'Attribution des notes';
$string['mark'] = 'Envoyer';
$string['markall'] = 'Envoyer la page';
$string['marks'] = 'Points';
$string['marks_help'] = 'Les points (numériques) pour chaque question, ainsi que le score total de la tentative.';
$string['match'] = 'Appariement';
$string['matchanswer'] = 'Réponse correspondante';
$string['matchanswerno'] = 'Réponse correspondante {$a}';
$string['max'] = 'Max';
$string['maxmark'] = 'Score maximum';
$string['messageprovider:attempt_overdue'] = 'Avertir lorsque la tentative de test est en retard';
$string['messageprovider:confirmation'] = 'Confirmation de l\'envoi de vos propres réponses de tests';
$string['messageprovider:submission'] = 'Notifications des réponses aux tests';
$string['min'] = 'Min';
$string['minutes'] = 'minutes';
$string['missingcorrectanswer'] = 'La réponse correcte doit être indiquée';
$string['missingitemtypename'] = 'Nom manquant';
$string['missingquestion'] = 'La question n\'existe plus.';
$string['modulename'] = 'Test';
$string['modulename_help'] = 'Le module d\'activité test permet à l\'enseignant de créer des tests comportant des questions de divers types, notamment des questions à choix multiple, vrai-faux, d\'appariement, à réponses courtes ou calculées.

L\'enseignant peut autoriser plusieurs tentatives pour un test, les questions étant mélangées ou choisies aléatoirement dans une banque de questions. Une limite de temps peut être fixée.

Chaque tentative est évaluée automatiquement, à l\'exception des questions de composition, et la note est enregistrée dans le carnet de notes.

L\'enseignant peut choisir quand et si il veut que des indices, un feedback et les réponses correctes soient proposés aux étudiants.

Les tests peuvent notamment être utilisés :

* pour des évaluations certificatives (examen),
* comme mini-tests pour des devoirs de lecture ou au terme de l\'étude d\'un thème,
* comme exercice pour un examen, en utilisant les questions de l\'examen de l\'année précédente,
* pour fournir un feedback de performance,
* pour l\'auto-évaluation.';
$string['modulenameplural'] = 'Tests';
$string['moveselectedonpage'] = 'Déplacer les questions sélectionnées vers la page {$a}';
$string['multichoice'] = 'Choix multiple';
$string['multipleanswers'] = 'Veuillez choisir au moins une réponse.';
$string['mustbesubmittedby'] = 'Cette tentative doit être envoyée avant {$a}.';
$string['name'] = 'Nom';
$string['navigatenext'] = 'Page suivante';
$string['navigateprevious'] = 'Page précédente';
$string['navmethod'] = 'Méthode de navigation';
$string['navmethod_free'] = 'Libre';
$string['navmethod_help'] = 'Lorsque la navigation séquentielle est activée, les participants doivent parcourir le test dans l\'ordre et ne peuvent ni revenir à la page précédente, ni passer à une page ultérieure.';
$string['navmethod_seq'] = 'Séquentielle';
$string['navnojswarning'] = 'Attention ! Ces liens n\'enregistrent pas vos réponses. Utilisez le bouton suivant au bas de la page.';
$string['neverallononepage'] = 'Jamais, toutes les questions sur une page';
$string['newattemptfail'] = 'Erreur ! Impossible de commencer une tentative de ce test';
$string['newcategory'] = 'Nouvelle catégorie';
$string['newpage'] = 'Nouvelle page';
$string['newpageevery'] = 'Commencer automatiquement une nouvelle page';
$string['newpage_help'] = 'Pour les tests longs, il peut être utile de répartir le test sur plusieurs pages, en définissant un nombre de questions par page. Lorsque vous ajouterez des questions au test, les boutons de changement de page seront automatiquement introduits, selon le paramètre indiqué ici. Par ailleurs, vous pourrez également déplacer manuellement ce changement de page, en modifiant la page.';
$string['newsectionheading'] = 'Nouveau titre';
$string['noanswers'] = 'Aucune réponse n\'a été sélectionnée !';
$string['noattempts'] = 'Aucune tentative n\'a été réalisée sur ce test';
$string['noattemptsfound'] = 'Aucune tentative trouvée.';
$string['noattemptstoshow'] = 'Il n\'y a pas de tentative à afficher';
$string['nocategory'] = 'Catégorie incorrecte ou manquante';
$string['noclose'] = 'Pas de date de fermeture';
$string['nocommentsyet'] = 'Pas encore de commentaire.';
$string['noconnection'] = 'Aucune connexion à un service web ne permet actuellement de traiter cette question. Veuillez contacter votre administrateur';
$string['nodataset'] = 'rien - ce n\'est pas un caractère joker';
$string['nodatasubmitted'] = 'Aucune donnée transmise.';
$string['noessayquestionsfound'] = 'Aucune question à évaluation manuelle';
$string['nogradewarning'] = 'Ce test n\'est pas évalué ; par conséquent, vous ne pouvez pas spécifier un feedback général qui diffère suivant la note.';
$string['nomoreattempts'] = 'Aucune autre tentative n\'est autorisée';
$string['none'] = 'Aucun';
$string['noopen'] = 'Pas de date d\'ouverture';
$string['nooverridedata'] = 'Vous devez définir une dérogation pour au moins un des paramètres du test.';
$string['nopossibledatasets'] = 'Aucun jeu de données possible';
$string['noquestionintext'] = 'Le texte de la question ne contient aucune question intégrée';
$string['noquestions'] = 'Aucune question n\'a été encore ajoutée';
$string['noquestionsfound'] = 'Aucune question trouvée';
$string['noquestionsinquiz'] = 'Il n\'a y pas de question dans ce test.';
$string['noquestionsnotinuse'] = 'Cette question aléatoire n\'est pas utilisée, car sa catégorie est vide.';
$string['noquestionsonpage'] = 'Page vide';
$string['noresponse'] = 'Pas de réponse';
$string['noreview'] = 'Vous n\'êtes pas autorisé à relire ce test';
$string['noreviewattempt'] = 'Vous n\'êtes pas autorisé à relire cette tentative.';
$string['noreviewshort'] = 'Non autorisé';
$string['noreviewuntil'] = 'Vous n\'êtes pas autorisé à relire ce test avant le {$a}';
$string['noreviewuntilshort'] = 'Disponible le {$a}';
$string['noscript'] = 'Javascript doit être activé pour continuer !';
$string['notavailabletostudents'] = 'Ce test n\'est actuellement pas disponible pour vos étudiants';
$string['notenoughrandomquestions'] = 'Il n\'y a pas assez de questions dans la catégorie {$a->category} pour créer la question {$a->name} ({$a->id}).';
$string['notenoughsubquestions'] = 'Vous n\'avez pas défini assez de sous-questions !<br />Souhaitez-vous revenir en arrière pour corriger cela ?';
$string['notimedependentitems'] = 'Les éléments dépendant du temps ne sont pour l\'instant pas supportés dans le module test. Comme pis aller, vous pouvez fixer une limite de durée pour la totalité du test. Voulez-vous choisir un autre élément (ou utiliser malgré tout cet élément-ci) ?';
$string['notyetgraded'] = 'Pas encore évalué';
$string['notyetviewed'] = 'Pas encore vu';
$string['notyourattempt'] = 'Il ne s\'agit pas de votre tentative !';
$string['noview'] = 'L\'utilisateur connecté n\'a pas l\'autorisation de voir ce test';
$string['numattempts'] = '{$a->studentnum} {$a->studentstring} ont fait {$a->attemptnum} tentatives';
$string['numattemptsmade'] = '{$a} tentatives de ce test effectuées';
$string['numberabbr'] = 'No';
$string['numerical'] = 'Numérique';
$string['numquestionsx'] = 'Questions : {$a}';
$string['oneminute'] = '1 minute';
$string['onlyteachersexport'] = 'Seuls les enseignants peuvent exporter des questions';
$string['onlyteachersimport'] = 'Seuls les enseignants avec droit d\'édition peuvent importer des questions';
$string['onthispage'] = 'Cette page';
$string['open'] = 'Pas répondu';
$string['openafterclose'] = 'Impossible de modifier le test. Vous avez indiqué une date d\'ouverture postérieure à la date de fermeture.';
$string['openclosedatesupdated'] = 'Dates d\'ouverture et de fermeture du test modifiées';
$string['optional'] = 'Facultatif';
$string['orderandpaging'] = 'Ordre et pagination';
$string['orderandpaging_help'] = 'Les nombres 10, 20, 30, ... en face de chaque question indiquent l\'ordre des questions. Les nombres augmentent par pas de 10 pour laisser de la place à l\'insertion éventuelle de questions supplémentaires. Pour réarranger les questions, modifiez les nombres, puis cliquez sur le bouton « Arranger les questions ».

Pour ajouter des sauts de page après certaines questions, cochez la case en face de ces questions, puis cliquez sur le bouton « Ajouter de nouvelles pages après les questions sélectionnées ».

Pour organiser les questions sur plusieurs pages, cliquez sur le bouton « Repagination » et indiquez le nombre de questions désirées par page.';
$string['orderingquiz'] = 'Ordre et pagination';
$string['orderingquizx'] = 'Ordre et pagination {$a}';
$string['outcomesadvanced'] = 'Les objectifs sont des réglages avancés';
$string['outof'] = '{$a->grade} sur {$a->maxgrade}';
$string['outofpercent'] = '{$a->grade} sur {$a->maxgrade} ({$a->percent}%)';
$string['outofshort'] = '{$a->grade}/{$a->maxgrade}';
$string['overallfeedback'] = 'Feedback global';
$string['overallfeedback_help'] = 'Le feedback global est un texte montré à l\'étudiant lorsqu\'il a terminé une tentative d\'un test. En spécifiant des limites de notes supplémentaires (sous forme de nombre ou de pourcentage), le texte affiché peut différer suivant la note obtenue par l\'étudiant.';
$string['overdue'] = 'En retard';
$string['overduehandling'] = 'Lorsque le temps imparti échoit';
$string['overduehandlingautoabandon'] = 'La tentative doit être envoyée avant l\'échéance, sans quoi elle n\'est pas comptabilisée';
$string['overduehandlingautosubmit'] = 'La tentative en cours est envoyée automatiquement';
$string['overduehandling_desc'] = 'Ce qui doit arriver par défaut si un participant n\'envoie pas son test dans le temps imparti.';
$string['overduehandlinggraceperiod'] = 'Un laps de temps supplémentaire est donné pour envoyer le test. Il n\'est pas permis de répondre aux questions durant cette période';
$string['overduehandling_help'] = 'Ce réglage détermine ce qui se passe si l\'étudiant n\'envoie pas son test avant l\'échéance du délai. Si l\'étudiant est actif à cet instant, la tentative sera envoyée automatiquement. S\'il n\'est pas connecté, ce réglage détermine ce qui se passe à ce moment.';
$string['overduemustbesubmittedby'] = 'Cette tentative est maintenant en retard et aurait déjà dû être envoyée. Si vous désirez que ce test soit évalué, vous devez l\'envoyer jusqu\'à {$a}. Si vous ne le faites pas, vous n\'obtiendrez pas de note pour cette tentative.';
$string['override'] = 'Dérogation';
$string['overridedeletegroupsure'] = 'Voulez-vous vraiment supprimer la dérogation pour le groupe {$a} ?';
$string['overridedeleteusersure'] = 'Voulez-vous vraiment supprimer la dérogation pour l\'utilisateur {$a} ?';
$string['overridegroup'] = 'Dérogation de groupe';
$string['overridegroupeventname'] = '{$a->quiz} - {$a->group}';
$string['overrides'] = 'Dérogations';
$string['overrideuser'] = 'Dérogation utilisateur';
$string['overrideusereventname'] = '{$a->quiz} - Dérogation';
$string['page-mod-quiz-attempt'] = 'Page de tentative de test';
$string['page-mod-quiz-edit'] = 'Modifier la page du test';
$string['page-mod-quiz-report'] = 'Toute page de rapport de test';
$string['page-mod-quiz-review'] = 'Page de relecture de tentative de test';
$string['page-mod-quiz-summary'] = 'Page de résumé de tentative de test';
$string['page-mod-quiz-view'] = 'Page d\'information de test';
$string['page-mod-quiz-x'] = 'Toute page du module test';
$string['pageshort'] = 'P.';
$string['pagesize'] = 'Taille de page';
$string['parent'] = 'Catégorie supérieure';
$string['parentcategory'] = 'Catégorie parente';
$string['parsingquestions'] = 'Analyse des questions du fichier à importer.';
$string['partiallycorrect'] = 'Partiellement correct';
$string['penalty'] = 'Pénalité';
$string['penaltyscheme'] = 'Appliquer les pénalités';
$string['penaltyscheme_help'] = 'Si ce réglage est activé, une pénalité est déduite de la note finale d\'une question pour chaque mauvaise réponse donnée. L\'ampleur de la pénalité est déterminée dans les paramètres de la question. Ce réglage n\'a d\'effet que si le test est réalisé en mode adaptatif.';
$string['percentcorrect'] = 'Pourcentage de réponses correctes';
$string['pleaseclose'] = 'Votre requête a été traitée. Vous pouvez maintenant fermer cette fenêtre';
$string['pluginadministration'] = 'Administration du test';
$string['pluginname'] = 'Test';
$string['popup'] = 'Afficher le test dans une fenêtre « sécurisée »';
$string['popupblockerwarning'] = 'Cette section du test est en mode sécurisé, ce qui nécessite de faire le test dans une fenêtre sécurisée. Veuillez désactivez le blocage des fenêtres surgissantes.';
$string['popupnotice'] = 'Pour les étudiants, l\'affichage de ce test se fera dans une fenêtre « sécurisée »';
$string['preprocesserror'] = 'Erreur lors du pré-traitement !';
$string['preview'] = 'Prévisualisation';
$string['previewquestion'] = 'Prévisualiser la question';
$string['previewquiz'] = 'Prévisualiser {$a}';
$string['previewquiznow'] = 'Prévisualiser le test maintenant';
$string['previous'] = 'État précédent';
$string['privacy:metadata:core_question'] = 'L\'activité Test enregistre les informations d\'utilisation des questions dans le sous-système core_question.';
$string['privacy:metadata:quiz'] = 'L\'activité test fait usage des rapports de tests.';
$string['privacy:metadata:quizaccess'] = 'L\'activité test fait usage des règles d\'accès aux tests.';
$string['privacy:metadata:quiz_attempts'] = 'Inforamtions sur chaque tentative d\'un test.';
$string['privacy:metadata:quiz_attempts:attempt'] = 'Le numéro de la tentative.';
$string['privacy:metadata:quiz_attempts:currentpage'] = 'La page sur laquelle l\'utilisateur est actuellement.';
$string['privacy:metadata:quiz_attempts:preview'] = 'S\'il s\'agit d\'une prévisualisation du test.';
$string['privacy:metadata:quiz_attempts:state'] = 'Le statut actuel de la tentative.';
$string['privacy:metadata:quiz_attempts:sumgrades'] = 'La somme des notes de la tentative.';
$string['privacy:metadata:quiz_attempts:timecheckstate'] = 'La date et l\'heure du contrôle du statut.';
$string['privacy:metadata:quiz_attempts:timefinish'] = 'La date et l\'heure de la tin de la tentative.';
$string['privacy:metadata:quiz_attempts:timemodified'] = 'La date et l\'heure de la modification de la tentative.';
$string['privacy:metadata:quiz_attempts:timemodifiedoffline'] = 'La date et l\'heure de la modification de la tentative par une modification hors ligne.';
$string['privacy:metadata:quiz_attempts:timestart'] = 'La date et l\'heure du début de la tentative.';
$string['privacy:metadata:quiz_grades'] = 'Informations sur la note globale pour ce test.';
$string['privacy:metadata:quiz_grades:grade'] = 'La note globale pour ce test.';
$string['privacy:metadata:quiz_grades:quiz'] = 'Le test qui a été évalué.';
$string['privacy:metadata:quiz_grades:timemodified'] = 'La date et l\'heure de la modification de la note.';
$string['privacy:metadata:quiz_grades:userid'] = 'L\'utilisateur qui a été évalué.';
$string['privacy:metadata:quiz_overrides'] = 'Informations sur les dérogations de ce test';
$string['privacy:metadata:quiz_overrides:quiz'] = 'Le test comportant les informations de dérogation';
$string['privacy:metadata:quiz_overrides:timeclose'] = 'La nouvelle date et heure de fermeture du test.';
$string['privacy:metadata:quiz_overrides:timelimit'] = 'La nouvelle durée du test.';
$string['privacy:metadata:quiz_overrides:timeopen'] = 'La nouvelle date et heure d\'ouverture du test.';
$string['privacy:metadata:quiz_overrides:userid'] = 'L\'utilisateur au bénéfice de la dérogation';
$string['publish'] = 'Publier';
$string['publishedit'] = 'Pour ajouter ou modifier une question de cette catégorie, vous devez avoir ces droits d\'accès dans le cours publiant cette catégorie.';
$string['qbrief'] = 'Q. {$a}';
$string['qname'] = 'nom';
$string['qti'] = 'Format IMS QTI';
$string['qtypename'] = 'type, nom';
$string['question'] = 'Libellé de la question';
$string['questionbank'] = 'de la banque de questions';
$string['questionbankmanagement'] = 'Gestion banque de questions';
$string['questionbehaviour'] = 'Comportement des questions';
$string['questioncats'] = 'Catégories de questions';
$string['questiondeleted'] = 'Cette question a été supprimée. Veuillez contacter votre enseignant.';
$string['questiondependencyadd'] = 'Il n\'y a pas de restriction sur le moment où cette question peut être tentée. Cliquez pour modifier';
$string['questiondependencyfree'] = 'Il n\'y a pas de restriction sur cette question.';
$string['questiondependencyremove'] = 'La question {$a->thisq} ne peut pas être tentée avant que la question précédente {$a->previousq} ait reçu une réponse. Cliquez pour modifier';
$string['questiondependsonprevious'] = 'Cette question ne peut pas être tentée avant que la question précédente ait reçu une réponse.';
$string['questioninuse'] = 'La question « {$a->questionname} » est actuellement utilisée dans<br />{$a->quiznames}<br />Elle ne sera pas retirée de ce(s) test(s), mais seulement de la catégorie.';
$string['questionmissing'] = 'La question est manquante pour cette session';
$string['questionname'] = 'Nom de la question';
$string['questionnonav'] = '<span class="accesshide">Question </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnonavinfo'] = '<span class="accesshide">Information </span>{$a->number}<span class="accesshide"> {$a->attributes}</span>';
$string['questionnotloaded'] = 'La question {$a} n\'a pas été chargée depuis la base de données';
$string['questionorder'] = 'Ordre des questions';
$string['questionposition'] = 'Nouveau rang dans la suite des questions pour la question {$a}';
$string['questions'] = 'Questions';
$string['questionsetpreview'] = 'Prévisualisation du jeu de questions';
$string['questionsinclhidden'] = 'Questions (y compris masquées)';
$string['questionsinthisquiz'] = 'Questions dans ce test';
$string['questionsmatchingfilter'] = 'Questions correspondant à ce filtre : {$a}';
$string['questionsperpage'] = 'Questions par page';
$string['questionsperpageselected'] = 'Le nombre de questions par page a été spécifié, de sorte que la pagination est fixe. C\'est pourquoi les outils de pagination sont désactivés. Vous pouvez changer ceci dans {$a}';
$string['questionsperpagex'] = 'Questions par page : {$a}';
$string['questiontext'] = 'Texte de la question';
$string['questiontextisempty'] = '[Texte de question vide]';
$string['questiontype'] = 'Question de type {$a}';
$string['questiontypesetupoptions'] = 'Options pour les types de questions :';
$string['quiz:addinstance'] = 'Ajouter un test';
$string['quiz:attempt'] = 'Effectuer des tests';
$string['quizavailable'] = 'Le test est disponible jusqu\'au {$a}';
$string['quizclose'] = 'Fermer le test';
$string['quizclosed'] = 'Ce test a été fermé le {$a}';
$string['quizcloses'] = 'Le test ferme';
$string['quizcloseson'] = 'Ce test sera fermé le {$a}';
$string['quiz:deleteattempts'] = 'Supprimer les tentatives de tests';
$string['quiz:emailconfirmsubmission'] = 'Recevoir un courriel de confirmation lors de l\'envoi d\'un test';
$string['quiz:emailnotifysubmission'] = 'Recevoir par courriel notification des tentatives envoyées par les participants';
$string['quiz:emailwarnoverdue'] = 'Obtenir un message d\'avertissement lorsqu\'une tentative arrive au délai et requiert d\'être envoyé.';
$string['quizeventcloses'] = '{$a} se termine';
$string['quizeventopens'] = '{$a} s\'ouvre';
$string['quiz:grade'] = 'Évaluer manuellement les tests';
$string['quiz:ignoretimelimits'] = 'Ignorer la limite de temps du test';
$string['quizisclosed'] = 'Ce test est fermé';
$string['quizisclosedwillopen'] = 'Test fermé (ouverture {$a})';
$string['quizisopen'] = 'Ce test est ouvert';
$string['quizisopenwillclose'] = 'Test ouvert (fermera le {$a})';
$string['quiz:manage'] = 'Gérer les tests';
$string['quiz:manageoverrides'] = 'Gérer les dérogations de test';
$string['quiznavigation'] = 'Navigation du test';
$string['quizopen'] = 'Ouvrir ce test';
$string['quizopenclose'] = 'Dates d\'ouverture et de fermeture';
$string['quizopenclose_help'] = 'Les étudiants ne peuvent commencer leur tentative qu\'après l\'heure d\'ouverture et doivent la terminer avant l\'heure de fermeture.';
$string['quizopened'] = 'Ce test est ouvert.';
$string['quizopenedon'] = 'Ce test est ouvert depuis {$a}';
$string['quizopens'] = 'Le test est rendu disponible';
$string['quizopenwillclose'] = 'Ce test est ouvert et sera fermée le {$a} à';
$string['quizordernotrandom'] = 'L\'ordre du test n\'est pas mélangé';
$string['quizorderrandom'] = '* L\'ordre du test est mélangé';
$string['quiz:preview'] = 'Prévisualiser les tests';
$string['quiz:regrade'] = 'Ré-évaluer les tentatives des tests';
$string['quiz:reviewmyattempts'] = 'Relire ses propres tentatives';
$string['quizsettings'] = 'Réglages du test';
$string['quiztimer'] = 'Minuterie';
$string['quiz:view'] = 'Voir les informations des tests';
$string['quiz:viewreports'] = 'Consulter les rapports des tests';
$string['quizwillopen'] = 'Ce test sera ouvert le {$a}';
$string['random'] = 'Question aléatoire';
$string['randomcreate'] = 'Créer des questions aléatoires';
$string['randomediting'] = 'Modification d\'une question aléatoire';
$string['randomfromcategory'] = 'Question aléatoire tirée des catégories :';
$string['randomfromexistingcategory'] = 'Question aléatoire d\'une catégorie existante';
$string['randomfromunavailabletag'] = '{$a} (non disponible)';
$string['randomnosubcat'] = 'Questions aléatoires tirée de cette catégorie (sans les sous-catégories).';
$string['randomnumber'] = 'Nombre de questions aléatoires';
$string['randomquestion'] = 'Question aléatoire';
$string['randomquestion_help'] = 'Une question aléatoire permet d\'insérer une question tirée au hasard dans une catégorie spécifique ou spécifiée par un tag dans une activité.';
$string['randomquestiontags'] = 'Tags';
$string['randomquestiontags_help'] = 'Il est possible de restreindre les critères de sélection en indiquant ici des tags de questions.

Les questions aléatoires seront sélectionnées parmi les questions qui tous ces tags.';
$string['randomquestionusinganewcategory'] = 'Question aléatoire d\'une nouvelle catégorie';
$string['randomwithsubcat'] = 'Questions aléatoires tirées de cette catégorie et des sous-catégories';
$string['readytosend'] = 'Vous êtes sur le point d\'envoyer votre test à l\'évaluation. Voulez-vous vraiment continuer ?';
$string['reattemptquiz'] = 'Effectuer de nouveau le test';
$string['recentlyaddedquestion'] = 'Question ajoutée récemment !';
$string['recurse'] = 'Afficher aussi les questions des sous-catégories';
$string['redoesofthisquestion'] = 'Autres questions déjà répondues ici : {$a}';
$string['redoquestion'] = 'Tenter une autre question semblable';
$string['regrade'] = 'Recalculer les notes de toutes les tentatives';
$string['regradecomplete'] = 'Toutes les tentatives ont été ré-évaluées';
$string['regradecount'] = '{$a->changed} sur {$a->attempt} notes ont été changées';
$string['regradedisplayexplanation'] = 'Les tentatives modifiées durant le nouveau calcul des notes sont affichées comme hyperliens dans la fenêtre de relecture des questions';
$string['regradenotallowed'] = 'Vous n\'avez pas les droits d\'accès requis pour ré-évaluer ce test';
$string['regradingquestion'] = 'Nouveau calcul de « {$a} ».';
$string['regradingquiz'] = 'Nouveau calcul des notes du test « {$a} »';
$string['remove'] = 'Supprimer';
$string['removeallgroupoverrides'] = 'Supprimer toutes les dérogations de groupe';
$string['removeallquizattempts'] = 'Supprimer toutes les tentatives des tests';
$string['removealluseroverrides'] = 'Supprimer toutes les dérogations utilisateur';
$string['removeemptypage'] = 'Supprimer page vide';
$string['removepagebreak'] = 'Supprimer le saut de page';
$string['removeselected'] = 'Retirer la sélection';
$string['rename'] = 'Renommer';
$string['renderingserverconnectfailed'] = 'Le serveur {$a} n\'a pas pu traiter une requête RQP. Vérifiez que l\'URL est correcte.';
$string['reorderquestions'] = 'Réordonner les questions';
$string['reordertool'] = 'Afficher l\'outil d\'organisation';
$string['repaginate'] = 'Repaginer avec {$a} questions par page';
$string['repaginatecommand'] = 'Repaginer';
$string['repaginatenow'] = 'Repaginer maintenant';
$string['replace'] = 'Remplacer';
$string['replacementoptions'] = 'Options de remplacement';
$string['report'] = 'Rapports';
$string['reportanalysis'] = 'Analyse des éléments';
$string['reportattemptsfrom'] = 'Tentatives des';
$string['reportattemptsthatare'] = 'Tentatives qui sont';
$string['reportdisplayoptions'] = 'Options d\'affichage';
$string['reportfullstat'] = 'Statistiques détaillées';
$string['reportmulti_percent'] = 'Pourcentages multiples';
$string['reportmulti_q_x_student'] = 'Choix des étudiants';
$string['reportmulti_resp'] = 'Réponses individuelles';
$string['reportmustselectstate'] = 'Vous devez sélectionner au moins un état.';
$string['reportnotfound'] = 'Rapport inconnu ({$a})';
$string['reportoverview'] = 'Vue d\'ensemble';
$string['reportregrade'] = 'Recalculer les notes';
$string['reportresponses'] = 'Réponses détaillées';
$string['reports'] = 'Rapports';
$string['reportshowonly'] = 'Afficher selon les tentatives';
$string['reportshowonlyfinished'] = 'Afficher au plus une tentative terminée par utilisateur ({$a})';
$string['reportsimplestat'] = 'Statistique simple';
$string['reportusersall'] = 'utilisateurs ayant effectué le test';
$string['reportuserswith'] = 'utilisateurs inscrits ayant effectué le test';
$string['reportuserswithorwithout'] = 'utilisateurs inscrits (ayant ou non effectué le test)';
$string['reportuserswithout'] = 'utilisateurs inscrits n\'ayant pas effectué le test';
$string['reportwhattoinclude'] = 'Informations à inclure dans le rapport';
$string['requirepassword'] = 'Nécessite une clef';
$string['requirepassword_help'] = 'Si vous spécifiez ici un mot de passe, les participants devront le saisir avant de pouvoir faire le test.';
$string['requiresubnet'] = 'Restriction par adresse IP';
$string['requiresubnet_help'] = 'L\'accès à un test peut être restreint à des sous-réseaux particuliers d\'un réseau local (LAN) ou d\'Internet en indiquant ici une liste d\'adresses IP complètes ou partielles, séparées par des virgules. Cela est particulièrement utile pour des tests sans surveillance, afin de s\'assurer que seules les personnes dans un lieu déterminé puissent accéder au test.';
$string['response'] = 'Réponse du participant';
$string['responses'] = 'Réponses du participant';
$string['results'] = 'Résultats';
$string['returnattempt'] = 'Retour à la tentative';
$string['reuseifpossible'] = 'réutiliser supprimés précédemment';
$string['reverttodefaults'] = 'Revenir aux réglages par défaut des tests';
$string['review'] = 'Relecture';
$string['reviewafter'] = 'Permettre la relecture après la fermeture du test';
$string['reviewalways'] = 'Permettre la relecture n\'importe quand';
$string['reviewattempt'] = 'Relecture de cette tentative';
$string['reviewbefore'] = 'Permettre la relecture durant l\'ouverture du test';
$string['reviewclosed'] = 'Après la fermeture du test';
$string['reviewduring'] = 'Pendant la tentative';
$string['reviewimmediately'] = 'Immédiatement après la tentative';
$string['reviewnever'] = 'Ne jamais permettre la relecture';
$string['reviewofattempt'] = 'Relecture de la tentative {$a}';
$string['reviewofpreview'] = 'Relecture de la prévisualisation';
$string['reviewofquestion'] = 'Relecture de la question {$a->question} dans {$a->quiz}, de {$a->user}';
$string['reviewopen'] = 'Plus tard, alors que le test est encore ouvert';
$string['reviewoptions'] = 'Les étudiants peuvent relire';
$string['reviewoptionsheading'] = 'Options de relecture';
$string['reviewoptionsheading_help'] = 'Ces options permettent de décider les informations que les participants au test peuvent voir lorsqu\'ils relisent une tentative ou consultent les rapports des tests effectués.

**Durant la tentative** n\'est valable que pour certains comportements de test, par exemple « Interactif avec essais multiples », qui peut afficher des feedbacks durant la tentative.

**Immédiatement après la tentative** signifie dans les deux minutes après que le participant a terminé sa tentative en cliquant sur le bouton « Tout envoyer et terminer ».

**Plus tard, alors que le test est encore ouvert** veut dire après ces deux minutes, mais avant que le test soit fermé.

**Après la fermeture du test** veut dire après la date de fermeture du test. Si le test n\'a pas de date de fermeture, cet état n\'est jamais atteint.';
$string['reviewoverallfeedback'] = 'Feedback global';
$string['reviewoverallfeedback_help'] = 'Le feedback donné au terme d\'une tentative, en fonction du total des points obtenu par le participant.';
$string['reviewresponse'] = 'Relire la réponse';
$string['reviewresponsetoq'] = 'Relire la réponse (question {$a})';
$string['reviewthisattempt'] = 'Relire vos réponses à cette tentative';
$string['rqp'] = 'Question distante';
$string['rqps'] = 'Questions distantes';
$string['sameasoverall'] = 'Identique aux notes globales';
$string['save'] = 'Enregistrer';
$string['saveandedit'] = 'Enregistrer et effectuer des modifications';
$string['saveattemptfailed'] = 'Échec de la sauvegarde de la tentative en cours.';
$string['savedfromdeletedcourse'] = 'Récupérées du cours supprimé « {$a} »';
$string['savegrades'] = 'Enregistrer les notes';
$string['savemyanswers'] = 'Enregistrer mes réponses';
$string['savenosubmit'] = 'Enregistrer sans envoyer';
$string['saveoverrideandstay'] = 'Enregistrer et ajouter une autre dérogation';
$string['savequiz'] = 'Enregistrer l\'ensemble du test';
$string['saving'] = 'Enregistrement';
$string['savingnewgradeforquestion'] = 'Enregistrement d\'une nouvelle note pour la question d\'identifiant {$a}.';
$string['savingnewmaximumgrade'] = 'Enregistrement de la nouvelle note maximale.';
$string['score'] = 'Score brut';
$string['scores'] = 'Scores';
$string['search:activity'] = 'Test – information sur l\'activité';
$string['sectionheadingedit'] = 'Modifier le titre « {$a} »';
$string['sectionheadingremove'] = 'Supprimer le titre « {$a} »';
$string['seequestions'] = '(voir les questions)';
$string['select'] = 'Sélectionner';
$string['selectall'] = 'Tout sélectionner';
$string['selectcategory'] = 'Sélectionner catégorie';
$string['selectedattempts'] = 'Tentatives sélectionnées...';
$string['selectmultipleitems'] = 'Sélectionner plusieurs éléments';
$string['selectmultipletoolbar'] = 'Sélectionner plusieurs barres d\'outils';
$string['selectnone'] = 'Tout désélectionner';
$string['selectquestiontype'] = '-- Sélectionner le type de question --';
$string['serveradded'] = 'Serveur ajouté';
$string['serveridentifier'] = 'Identifiant';
$string['serverinfo'] = 'Information serveur';
$string['servers'] = 'Serveurs';
$string['serverurl'] = 'URL du serveur';
$string['settingsoverrides'] = 'Courts-circuits des réglages';
$string['shortanswer'] = 'Réponse courte';
$string['show'] = 'Afficher';
$string['showall'] = 'Afficher toutes les questions sur une page';
$string['showblocks'] = 'Afficher les blocs durant les tests';
$string['showblocks_help'] = 'Si ce réglage est activé, les blocs habituellement affichés dans le cours s\'affichent également dans le test.';
$string['showbreaks'] = 'Montrer les sauts de page';
$string['showcategorycontents'] = 'Afficher le contenu de la catégorie {$a->arrow}';
$string['showcorrectanswer'] = 'Dans le feedback,<br />afficher les réponses correctes ?';
$string['showdetailedmarks'] = 'Afficher le détail des points';
$string['showeachpage'] = 'Afficher une page à la fois';
$string['showfeedback'] = 'Après le test, afficher le feedback ?';
$string['showinsecurepopup'] = 'Utiliser une fenêtre « sécurisée » pour les tentatives';
$string['showlargeimage'] = 'Grande image';
$string['shownoattempts'] = 'Afficher les étudiants sans tentative';
$string['shownoattemptsonly'] = 'N\'afficher que les étudiants sans tentative';
$string['shownoimage'] = 'Pas d\'image';
$string['showreport'] = 'Afficher le rapport';
$string['showsmallimage'] = 'Petite image';
$string['showteacherattempts'] = 'Afficher les tentatives des enseignants';
$string['showuserpicture'] = 'Afficher l\'avatar du participant';
$string['showuserpicture_help'] = 'Si ce réglage est activé, le nom et l\'avatar de l\'étudiant s\'affichent durant le test et lors de la relecture. Cela permet aux surveillants de vérifier plus facilement qu\'un étudiant est bien connecté à son propre compte.';
$string['shuffle'] = 'Mélanger';
$string['shuffleanswers'] = 'Mélanger les réponses';
$string['shuffledrandomly'] = 'Mélangées aléatoirement';
$string['shufflequestions'] = 'Mélanger';
$string['shufflequestions_help'] = 'Si ce réglage est activé, à chaque tentative du test, l\'ordre des questions dans cette section sera mélangé dans un ordre aléatoire différent.

Ceci permet de rendre plus difficile le partage des réponses entre étudiants, mais rend également plus difficile les discussions entre les étudiants et vous sur une question déterminée.';
$string['shufflewithin'] = 'Mélanger les éléments des questions';
$string['shufflewithin_help'] = 'Si cette option est activée, les propositions de réponses aux questions seront mélangées aléatoirement à chaque nouvelle tentative du test, à condition que l\'option correspondant ait également été activée dans les paramètres de la question. Le réglage ne s\'applique qu\'aux questions qui comportent des propositions de réponses, telles que les questions à choix multiple ou les questions d\'appariement.';
$string['singleanswer'] = 'Veuillez choisir une réponse.';
$string['sortage'] = 'Trier par date';
$string['sortalpha'] = 'Trier par nom';
$string['sortquestionsbyx'] = 'Trier les questions par : {$a}';
$string['sortsubmit'] = 'Trier les questions';
$string['sorttypealpha'] = 'Trier par type et par nom';
$string['specificapathnotonquestion'] = 'Le chemin d\'accès au fichier indiqué n\'est pas présent dans la question spécifiée';
$string['specificquestionnotonquiz'] = 'La question indiquée n\'est pas présente dans le test spécifié';
$string['startagain'] = 'Recommencer';
$string['startattempt'] = 'Démarrer une tentative';
$string['startedon'] = 'Commencé le';
$string['startnewpreview'] = 'Prévisualiser à nouveau';
$string['stateabandoned'] = 'Jamais remis';
$string['statefinished'] = 'Terminé';
$string['statefinisheddetails'] = 'Remis {$a}';
$string['stateinprogress'] = 'En cours';
$string['statenotloaded'] = 'L\'état de la question {$a} n\'a pas été chargé depuis la base de données';
$string['stateoverdue'] = 'En retard';
$string['stateoverduedetails'] = 'Doit être remis par {$a}';
$string['status'] = 'État';
$string['stoponerror'] = 'Stopper en cas d\'erreur';
$string['submitallandfinish'] = 'Tout envoyer et terminer';
$string['subneterror'] = 'Désolé, ce test a été configuré de façon à ne pouvoir être effectué que depuis certains ordinateurs. Votre ordinateur n\'est actuellement pas autorisé.';
$string['subnetnotice'] = 'Ce test a été configuré de façon à ne pouvoir être effectué que depuis certains ordinateurs. Votre ordinateur n\'est pas situé dans une sous-réseau autorisé. En tant qu\'enseignant, vous pouvez toutefois le prévisualiser.';
$string['subplugintype_quiz'] = 'Rapport';
$string['subplugintype_quizaccess'] = 'Règle d\'accès';
$string['subplugintype_quizaccess_plural'] = 'Règles d\'accès';
$string['subplugintype_quiz_plural'] = 'Rapports';
$string['substitutedby'] = 'sera remplacé par';
$string['summaryofattempt'] = 'Résumé de la tentative';
$string['summaryofattempts'] = 'Résumé de vos tentatives précédentes';
$string['temporaryblocked'] = 'Il ne vous est temporairement plus permis d\'effectuer le test.<br />Vous pourrez effectuer une nouvelle tentative le ';
$string['theattempt'] = 'La tentative';
$string['theattempt_help'] = 'Détermine si le participant peut relire la tentative ou non.';
$string['time'] = 'Temps';
$string['timecompleted'] = 'Terminé';
$string['timedelay'] = 'Vous ne pouvez effectuer le test maintenant, car le délai entre deux tentatives n\'est pas encore échu';
$string['timeleft'] = 'Temps restant';
$string['timelimit'] = 'Temps disponible';
$string['timelimitexeeded'] = 'Désolé ! La limite de temps est échue !';
$string['timelimit_help'] = 'Si ce réglage est activité, le temps imparti est indiqué sur la page initiale du test et un compte à rebours est affiché dans le bloc de navigation du test.';
$string['timestr'] = '%H:%M:%S, le %d.%m.%y';
$string['timesup'] = 'Le chrono est enclenché !';
$string['timetaken'] = 'Temps mis';
$string['timing'] = 'Temps';
$string['tofile'] = 'Vers le fichier';
$string['tolerance'] = 'Tolerance';
$string['toomanyrandom'] = 'Le nombre de questions aléatoires demandées est plus grand que le nombre de celles qui restent dans cette catégorie !';
$string['top'] = 'Catégorie racine';
$string['totalmarksx'] = 'Total des notes : {$a}';
$string['totalquestionsinrandomqcategory'] = 'Total des {$a} questions de la catégorie.';
$string['true'] = 'Vrai';
$string['truefalse'] = 'Vrai/Faux';
$string['type'] = 'Type';
$string['unfinished'] = 'ouvert';
$string['ungraded'] = 'Pas notée';
$string['unit'] = 'Unité';
$string['unknowntype'] = 'Type de question non supporté à la ligne {$a}. La question sera ignorée';
$string['updatequizslotswithrandomxofy'] = 'Modification de l\'insertion des données de questions aléatoires du test ({$a->done}/{$a->total})';
$string['updatesettings'] = 'Modifier les réglages du test';
$string['updatingatttemptgrades'] = 'Mise à jour des notes.';
$string['updatingfinalgrades'] = 'Mise à jour des notes finales.';
$string['updatingthegradebook'] = 'Mise à jour du carnet de notes';
$string['upgradesure'] = '<div>ATTENTION ! Les tables du module Test seront considérablement modifiées, et cette mise à jour n\'a pas encore été suffisamment testée. Nous vous recommandons instamment de faire une copie de sauvegarde de votre base de données avant de continuer !</div>';
$string['upgradingquizattempts'] = 'Mise à jour des tentatives : test {$a->done}/{$a->outof} (Id du test {$a->info})';
$string['upgradingveryoldquizattempts'] = 'Mise à jour des tentatives vraiment anciennes : {$a->done}/{$a->outof}';
$string['url'] = 'URL';
$string['usedcategorymoved'] = 'Cette catégorie a été déplacée au niveau du site, car elle est publiée et certaines de ses questions sont utilisées dans d\'autres cours.';
$string['useroverrides'] = 'Dérogations utilisateur';
$string['useroverridesdeleted'] = 'Dérogations utilisateur supprimées';
$string['usersnone'] = 'Aucun étudiant n\'a accès à ce test';
$string['validate'] = 'Valider';
$string['viewallanswers'] = 'Afficher les {$a} tentatives du test';
$string['viewallreports'] = 'Afficher le rapport des {$a} tentatives';
$string['viewed'] = 'Vu';
$string['warningmissingtype'] = '<b>Le type de cette question n\'est pas installé sur votre Moodle.<br />Veuillez informer l\'administrateur de votre Moodle.</b>';
$string['wheregrade'] = 'Où est ma note ?';
$string['wildcard'] = 'Caractère joker';
$string['windowclosing'] = 'Cette fenêtre se fermera dans quelques instants.';
$string['withsummary'] = 'avec des statistiques résumées';
$string['wronguse'] = 'Vous ne pouvez pas utiliser cette page ainsi';
$string['xhtml'] = 'XHTML';
$string['youneedtoenrol'] = 'Vous devez vous inscrire à ce cours avant d\'effectuer ce test';
$string['yourfinalgradeis'] = 'Votre note finale pour ce test est {$a}.';
