<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Scrum
 *
 * @ORM\Table(name="timeline")
 * @ORM\Entity(repositoryClass="App\Repository\TimelineRepository")
 * 
 */
class Timeline
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="backgroundcolor", type="string", nullable=true)
     */
    private $backgroundcolor;
    
    /**
     * @ORM\Column(name="backgroundimage", type="string", nullable=true)
     */
    private $backgroundimage;
    
    /**
     * @ORM\Column(name="backgroundmode", type="string", nullable=true)
     */
    private $backgroundmode;   
    
    /**
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;
        
    /**
     * @ORM\Column(type="integer")
     */
    private $start;

    /**
     * @ORM\Column(type="integer")
     */
    private $end;

    /**
     * @ORM\Column(type="string", length=100)
     */
    private $unity;

    /**
     * @ORM\Column(type="string", length=100)
     */
    private $zoom;

    /**
     * @ORM\Column(type="string", length=100, nullable=true)
     */
    private $color;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    private $usebackground;

    /**
     * @ORM\Column(type="string", length=100, nullable=true)
     */
    private $background;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="timelines")
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="Timelinesegment", mappedBy="timeline", cascade={"persist"}, orphanRemoval=true)
     */
    private $timelinesegments;

    /**
     * @ORM\OneToMany(targetEntity="Timelinedate", mappedBy="timeline", cascade={"persist"}, orphanRemoval=true)
     */
    private $timelinedates;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="timelines", cascade={"persist"})
     * @ORM\JoinTable(name="timelinegroupe",
     *   joinColumns={@ORM\JoinColumn(name="timeline", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="timelinereaders", cascade={"persist"})
     * @ORM\JoinTable(name="timelinegroupereader",
     *   joinColumns={@ORM\JoinColumn(name="timeline", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groupreaders;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="timelineshareds", cascade={"persist"})
     * @ORM\JoinTable(name="timelineuser",
     *   joinColumns={@ORM\JoinColumn(name="timeline", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $users;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="timelinesharedreaders", cascade={"persist"})
     * @ORM\JoinTable(name="timelineuserreader",
     *   joinColumns={@ORM\JoinColumn(name="timeline", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $userreaders;

    public function __construct()
    {
        $this->timelinesegments = new ArrayCollection();
        $this->timelinedates = new ArrayCollection();
        $this->groups = new ArrayCollection();
        $this->groupreaders = new ArrayCollection();
        $this->users = new ArrayCollection();
        $this->userreaders = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }
    
    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getStart(): ?int
    {
        return $this->start;
    }

    public function setStart(int $start): self
    {
        $this->start = $start;

        return $this;
    }

    public function getEnd(): ?int
    {
        return $this->end;
    }

    public function setEnd(int $end): self
    {
        $this->end = $end;

        return $this;
    }

    public function getUnity(): ?string
    {
        return $this->unity;
    }

    public function setUnity(string $unity): self
    {
        $this->unity = $unity;

        return $this;
    }

    public function getZoom(): ?string
    {
        return $this->zoom;
    }

    public function setZoom(string $zoom): self
    {
        $this->zoom = $zoom;

        return $this;
    }

    public function getColor(): ?string
    {
        return $this->color;
    }

    public function setColor(?string $color): self
    {
        $this->color = $color;

        return $this;
    }

    public function getUsebackground(): ?bool
    {
        return $this->usebackground;
    }

    public function setUsebackground(?bool $usebackground): self
    {
        $this->usebackground = $usebackground;

        return $this;
    }

    public function getBackground(): ?string
    {
        return $this->background;
    }

    public function setBackground(?string $background): self
    {
        $this->background = $background;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|Timelinesegment[]
     */
    public function getTimelinesegments(): Collection
    {
        return $this->timelinesegments;
    }

    public function addTimelinesegment(Timelinesegment $timelinesegment): self
    {
        if (!$this->timelinesegments->contains($timelinesegment)) {
            $this->timelinesegments[] = $timelinesegment;
            $timelinesegment->setTimeline($this);
        }

        return $this;
    }

    public function removeTimelinesegment(Timelinesegment $timelinesegment): self
    {
        if ($this->timelinesegments->contains($timelinesegment)) {
            $this->timelinesegments->removeElement($timelinesegment);
            // set the owning side to null (unless already changed)
            if ($timelinesegment->getTimeline() === $this) {
                $timelinesegment->setTimeline(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Timelinedate[]
     */
    public function getTimelinedates(): Collection
    {
        return $this->timelinedates;
    }

    public function addTimelinedate(Timelinedate $timelinedate): self
    {
        if (!$this->timelinedates->contains($timelinedate)) {
            $this->timelinedates[] = $timelinedate;
            $timelinedate->setTimeline($this);
        }

        return $this;
    }

    public function removeTimelinedate(Timelinedate $timelinedate): self
    {
        if ($this->timelinedates->contains($timelinedate)) {
            $this->timelinedates->removeElement($timelinedate);
            // set the owning side to null (unless already changed)
            if ($timelinedate->getTimeline() === $this) {
                $timelinedate->setTimeline(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Group[]
     */
    public function getGroups(): Collection
    {
        return $this->groups;
    }

    public function addGroup(Group $group): self
    {
        if (!$this->groups->contains($group)) {
            $this->groups[] = $group;
        }

        return $this;
    }

    public function removeGroup(Group $group): self
    {
        if ($this->groups->contains($group)) {
            $this->groups->removeElement($group);
        }

        return $this;
    }

    /**
     * @return Collection|Group[]
     */
    public function getGroupreaders(): Collection
    {
        return $this->groupreaders;
    }

    public function addGroupreader(Group $groupreader): self
    {
        if (!$this->groupreaders->contains($groupreader)) {
            $this->groupreaders[] = $groupreader;
        }

        return $this;
    }

    public function removeGroupreader(Group $groupreader): self
    {
        if ($this->groupreaders->contains($groupreader)) {
            $this->groupreaders->removeElement($groupreader);
        }

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getUsers(): Collection
    {
        return $this->users;
    }

    public function addUser(User $user): self
    {
        if (!$this->users->contains($user)) {
            $this->users[] = $user;
        }

        return $this;
    }

    public function removeUser(User $user): self
    {
        if ($this->users->contains($user)) {
            $this->users->removeElement($user);
        }

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getUserreaders(): Collection
    {
        return $this->userreaders;
    }

    public function addUserreader(User $userreader): self
    {
        if (!$this->userreaders->contains($userreader)) {
            $this->userreaders[] = $userreader;
        }

        return $this;
    }

    public function removeUserreader(User $userreader): self
    {
        if ($this->userreaders->contains($userreader)) {
            $this->userreaders->removeElement($userreader);
        }

        return $this;
    }

    public function getBackgroundcolor(): ?string
    {
        return $this->backgroundcolor;
    }

    public function setBackgroundcolor(?string $backgroundcolor): self
    {
        $this->backgroundcolor = $backgroundcolor;

        return $this;
    }

    public function getBackgroundimage(): ?string
    {
        return $this->backgroundimage;
    }

    public function setBackgroundimage(?string $backgroundimage): self
    {
        $this->backgroundimage = $backgroundimage;

        return $this;
    }

    public function getBackgroundmode(): ?string
    {
        return $this->backgroundmode;
    }

    public function setBackgroundmode(?string $backgroundmode): self
    {
        $this->backgroundmode = $backgroundmode;

        return $this;
    }

}
