<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use FOS\CKEditorBundle\Form\Type\CKEditorType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;

class TimelineType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        if($options["mode"]!="view") {
            $builder
            ->add('submit', SubmitType::class, [
                'label' => 'Valider',
                'attr' => ['class' => 'btn btn-success']
            ]);

            $builder
            ->add('title', TextType::class, [
                'label' => 'Titre',
            ]);

            $builder
            ->add('start', IntegerType::class, [
                'label' => 'Année de début',
            ]);

            $builder
            ->add('end', IntegerType::class, [
                'label' => 'Année de fin',
            ]);

            $choices=[
                "tout les mois" => "months",
                "toute les années" => "years",
                "tout les 2 ans" => "2 years",
                "tout les 5 ans" => "5 years",
                "tout les 10 ans" => "10 years",
                "tout les 50 ans" => "50 years",
                "tout les 100 ans" => "100 years",
                "tout les 1000 ans" => "1000 years",
            ];
            $builder
            ->add('unity', ChoiceType::class, [
                'label' => "Découper la ligne",
                'choices' => $choices
            ]);

            $choices=["1"=>"1","1.2"=>"1.2","1.4"=>"1.4","1.6"=>"1.6","1.8"=>"1.8","2"=>"2","2.2"=>"2.2","2.4"=>"2.4","2.6"=>"2.6","2.8"=>"2.8","3"=>"3"];
            $builder
            ->add('zoom', ChoiceType::class, [
                'label' => "Zoom par défaut",
                'choices' => $choices
            ]);

            $builder
            ->add('color', TextType::class,[
                'label' => "Couleur de fond",
                'required' => false,
                'attr' => ["class" => "pick-a-color form-control"],
            ]);

            $choices=[
                "non" => "0",
                "oui" => "1",
            ];
            $builder
            ->add('usebackground', ChoiceType::class, [
                'label' => "Utiliser une image de fond sur la frise",
                'choices' => $choices
            ]);

            $builder->add('background',HiddenType::class);

            $builder
            ->add('groups', Select2EntityType::class, [
                'label'                 => 'Les membres de ces groupes',
                'class'                 => 'App:Group',
                'multiple'              => true,
                'remote_route'          => 'app_group_select',
                'primary_key'           => 'id',
                'text_property'         => 'name',
                'minimum_input_length'  => 0,
                'page_limit'            => 100,
                'allow_clear'           => true,
                'delay'                 => 250,
                'cache'                 => false,
                'cache_timeout'         => 60000,
                'language'              => 'fr',
                'placeholder'           => 'Sélectionner des groupes',                        
            ]);            

            $builder
            ->add('groupreaders', Select2EntityType::class, [
                'label'                 => 'Les membres de ces groupes',
                'class'                 => 'App:Group',
                'multiple'              => true,
                'remote_route'          => 'app_group_select',
                'primary_key'           => 'id',
                'text_property'         => 'name',
                'minimum_input_length'  => 0,
                'page_limit'            => 100,
                'allow_clear'           => true,
                'delay'                 => 250,
                'cache'                 => false,
                'cache_timeout'         => 60000,
                'language'              => 'fr',
                'placeholder'           => 'Sélectionner des groupes',                        
            ]);  

            $builder
            ->add('users', Select2EntityType::class, [
                    'label'                 => 'Ces utilisateurs',
                    'class'                 => 'App:User',
                    'multiple'              => true,
                    'remote_route'          => 'app_user_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'displayname',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Sélectionner des utilisateurs',                        
            ]);            

            $builder
            ->add('userreaders', Select2EntityType::class, [
                    'label'                 => 'Ces utilisateurs',
                    'class'                 => 'App:User',
                    'multiple'              => true,
                    'remote_route'          => 'app_user_select',
                    'primary_key'           => 'id',
                    'text_property'         => 'displayname',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Sélectionner des utilisateurs',                        
            ]); 

            if($options["access"]=="admin") {
                $builder
                ->add('user', Select2EntityType::class, [
                        'label'                 => 'Propriétaire',
                        'class'                 => 'App:User',
                        'multiple'              => false,
                        'required'              => true,
                        'remote_route'          => 'app_user_select',
                        'primary_key'           => 'id',
                        'text_property'         => 'displayname',
                        'minimum_input_length'  => 0,
                        'page_limit'            => 100,
                        'allow_clear'           => true,
                        'delay'                 => 250,
                        'cache'                 => false,
                        'cache_timeout'         => 60000,
                        'language'              => 'fr',
                        'placeholder'           => 'Sélectionner un utilisateurs',                        
                ]);                 
            }

            $builder
            ->add('backgroundcolor', TextType::class, [
                    'label'                 => 'Couleur de fond',
                    'required'              => false,
                    'attr'                  => ['class' => 'pick-a-color form-control']
            ]);
            
            $builder->add('backgroundimage',HiddenType::class);  

            $choices=["cover" => "cover","repeat" => "repeat"];
            $builder
            ->add('backgroundmode', ChoiceType::class,[
                'label'                     => "Mode d'affichage de l'image de fond",
                'attr'                      => ["class" => "form-control"],
                'required'                  => true,
                'choices'                   => $choices
            ]);              
        }
        else {
            $builder
            ->add('description',CKEditorType::class,[
                    'config_name'           => 'full_config',    
                    'label'                 => 'Description',
                    'mapped'                => false,
                    'required'              => false,
                    'config'                => [
                        'height' => '300px',
                        'filebrowserUploadRoute' => 'app_ckuploadbytype',
                        'filebrowserUploadRouteParameters' => ['type' => 'timeline','id' => $options["id"]],
                    ],
            ]);
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'App\Entity\Timeline',
            'mode' => "string",
            'access' => "string",
            'id' => "string"
        ));
    }
}
