<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpKernel\KernelInterface;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Id\AssignedGenerator;
use Symfony\Component\Finder\Finder;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

use App\Service\toolService;

use App\Entity\Wordcloud as Entity;
use App\Form\WordcloudType as Form;
use App\Entity\Wordcloudword as Wordcloudword;
use App\Entity\Document as Document;
use App\Entity\Message as Message;
use App\Entity\User;
use App\Repository\WordcloudwordRepository;

class WordcloudController extends AbstractController
{
    private $data   = "wordcloud";
    private $route  = "app_user_wordcloud";
    private $render = "Wordcloud/";
    private $entity = "App:Wordcloud";
    private $appKernel;
    private $tool;

    public function __construct(KernelInterface $appKernel,toolService $tool)
    {
        $this->appKernel = $appKernel;
        $this->tool = $tool;
    }

    public function list(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $datas = $em->getRepository($this->entity)->findAll();

        return $this->render($this->render.'list.html.twig',[
            $this->data."s" => $datas,
            "useheader"     => true,
            "usesidebar"    => true,
        ]);
    }

    public function view($id, Request $request, $access="user")
    {
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');

        $perm = $this->perm($data);
        if(!$perm) return $this->redirect($this->generateUrl('app_user_noperm',["displayname"=>$data->getUser()->getDisplayname(),"email"=>$data->getUser()->getEmail(),"url"=>$this->generateUrl($this->route."_view",["id"=>$id], UrlGeneratorInterface::ABSOLUTE_URL)]));    

        $form = $this->createForm(Form::class,$data,array("mode"=>"view", "access" => $access, "id" => $data->getId()));

        return $this->render($this->render.'view.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => ($access=="admin"),
            'maxwidth'      => false,
            $this->data     => $data,
            'form'          => $form->createView(),
            'access'        => $access,
            'perm'          => $perm,
        ]);
    }

    public function info($id, Request $request, $access="user")
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        
        if (!$data) return new JsonResponse(array('message' => 'Interdit'), 400);
        /** @var WordcloudwordRepository */
        $wordRepo = $em->getRepository(Wordcloudword::class);
        /** @var Wordcloudword[] */
        $words = $wordRepo->getWordsUser($id,$this->getUser());
        $finalArray =$data->getInfo();
        $finalArray['ownWordsById']= [];
        $finalArray['jQWCloud']= $data->getInfojQWCloud();
        if($words) {
            foreach($words as $word) {
                $finalArray['ownWordsById'][$word->getId()] = $word->getTitle();
            }
            $finalArray = array_merge($data->getInfo(),$finalArray);
        }
        $response = new Response(json_encode($finalArray));
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }

    public function image($id)
    {
        return $this->render($this->render.'image.html.twig',["id"=>$id]);
    }

    public function message(Request $request, $access="user")
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $id=$request->request->get('id');
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository("App:Wordcloudword")->find($id);
        if (!$data) return new JsonResponse(array('message' => 'Interdit'), 400);
        $perm = $this->perm($data->getWordcloud());
        if(!$perm) return false;

        $messages=$em->getRepository("App:Message")->findBy(["wordcloudword"=>$data],["submitdate"=>"DESC"]);
        $output=[];
        foreach($messages as $message) {
            $msg=$message->getMessage();
            $username=$message->getUser()->getUsername();

            $fgcandel=false;
            if($message->getUser()==$this->getUser()) $fgcandel=true;
            if($data->getUser()==$this->getUser()) $fgcandel=true;
            if($data->getWordcloud()->getUser()==$this->getUser()) $fgcandel=true;

            array_push($output, [
                "idwid" => $data->getId(),
                "idmsg" => $message->getId(),
                "message" => $msg,
                "date" => $message->getSubmitdate()->format("d/m/Y H:i"),
                "username" => $username,
                "fgcandel" => $fgcandel,
            ]);
        }

        $response = new Response(json_encode($output));
        $response->headers->set('Content-Type', 'application/json');
        return $response;

    }

    public function submit(Request $request, $access="user") {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data = new Entity();
        if($access=="user") $data->setUser($this->getUser());

        // Création du formulaire
        $form = $this->createForm(Form::class,$data,array("mode"=>"submit", "access" => $access));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");

        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();

            $em->persist($data);
            $em->flush();

            // Retour à la liste
            return $this->redirect($this->generateUrl('app_'.$access.'_wordcloud_view',["id"=>$data->getId()]));
        }

        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader'         => true,
            'usesidebar'        => ($access=="admin"),
            'maxwidth'          => ($access=="user"),
            $this->data         => $data,
            'mode'              => 'submit',
            'form'              => $form->createView(),
            'access'            => $access,
        ]);
    }

    public function update($id, Request $request, $access="user") {
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');
        if($data->getUser()!=$this->getUser()&&!$this->getUser()->hasRole("ROLE_ADMIN")&&!$this->getUser()->hasRole("ROLE_MODO"))
        throw $this->createNotFoundException('Permission denied');

        // Création du formulaire
        $form = $this->createForm(Form::class,$data,array("mode"=>"update", "access" => $access));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"update");

        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $data = $form->getData();
            $em->persist($data);
            $em->flush();

            // Retour à la liste
            if($access=="user")
                return $this->redirect($this->generateUrl('app_'.$access.'_wordcloud_view',["id"=>$data->getId()]));
            else
                return $this->redirect($this->generateUrl('app_admin_wordcloud'));

        }

        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader'         => true,
            'usesidebar'        => ($access=="admin"),
            'maxwidth'          => ($access=="user"),
            $this->data         => $data,
            'mode'              => 'update',
            'form'              => $form->createView(),
            'access'            => $access
        ]);
    }

    public function delete($id, Request $request, $access="user") {
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');
        if($data->getUser()!=$this->getUser()&&!$this->getUser()->hasRole("ROLE_ADMIN")&&!$this->getUser()->hasRole("ROLE_MODO"))
        throw $this->createNotFoundException('Permission denied');

        $em->remove($data);
        $em->flush();

        if($access=="user")
            return $this->redirect($this->generateUrl('app_home'));
        else
            return $this->redirect($this->generateUrl('app_admin_wordcloud'));
    }

    public function export($id, Request $request, $access="user") {
        $em = $this->getDoctrine()->getManager();
        $wordcloud=$em->getRepository($this->entity)->find($id);
        if (!$wordcloud) throw $this->createNotFoundException('Unable to find entity.');
        if($wordcloud->getUser()!=$this->getUser()&&!$this->getUser()->hasRole("ROLE_ADMIN")&&!$this->getUser()->hasRole("ROLE_MODO"))
        throw $this->createNotFoundException('Permission denied');

        $fs = new Filesystem();
        $rootdir = $this->appKernel->getProjectDir();
        $destdir = $rootdir."/uploads/export/wordcloud/$id";

        // Regénération du répertoire d'export
        $fs->remove($destdir);
        $fs->mkdir($rootdir."/uploads");
        $fs->mkdir($rootdir."/uploads/export");
        $fs->mkdir($rootdir."/uploads/export/wordcloud");
        $fs->mkdir($rootdir."/uploads/export/wordcloud/$id");
        $fs->mkdir($rootdir."/uploads/export/wordcloud/$id/public");
        $fs->mkdir($rootdir."/uploads/export/wordcloud/$id/public/wordcloud");
        $fs->mkdir($rootdir."/uploads/export/wordcloud/$id/public/document");
        $fs->mkdir($rootdir."/uploads/export/wordcloud/$id/private");
        $fs->mkdir($rootdir."/uploads/export/wordcloud/$id/private/wordcloud");
        $fs->mkdir($rootdir."/uploads/export/wordcloud/$id/private/document");

        // Création du json d'export
        $export = new \stdClass();
        $export->type = "wordcloud";
        $export->id = $wordcloud->getId();
        $export->title = $wordcloud->getTitle();
        $export->user = $wordcloud->getUser()->getId();

        $export->groups = [];
        $groups=$wordcloud->getGroups();
        foreach($groups as $group) {
            $idgrp=$group->getId();
            $export->groups[$idgrp] = new \stdClass();
            $export->groups[$idgrp]->id=$idgrp;
        }

        $export->groupwriters = [];
        $groups=$wordcloud->getGroupwriters();
        foreach($groups as $group) {
            $idgrp=$group->getId();
            $export->groupwriters[$idgrp] = new \stdClass();
            $export->groupwriters[$idgrp]->id=$idgrp;
        }

        $export->groupreaders = [];
        $groups=$wordcloud->getGroupreaders();
        foreach($groups as $group) {
            $idgrp=$group->getId();
            $export->groupreaders[$idgrp] = new \stdClass();
            $export->groupreaders[$idgrp]->id=$idgrp;
        }

        $export->users = [];
        $users=$wordcloud->getUsers();
        foreach($users as $user) {
            $idusr=$user->getId();
            $export->users[$idusr] = new \stdClass();
            $export->users[$idusr]->id=$idusr;
        }

        $export->userwriters = [];
        $users=$wordcloud->getUserwriters();
        foreach($users as $user) {
            $idusr=$user->getId();
            $export->userwriters[$idusr] = new \stdClass();
            $export->userwriters[$idusr]->id=$idusr;
        }

        $export->userreaders = [];
        $users=$wordcloud->getUserreaders();
        foreach($users as $user) {
            $idusr=$user->getId();
            $export->userreaders[$idusr] = new \stdClass();
            $export->userreaders[$idusr]->id=$idusr;
        }

        $export->widgets = [];
        $wordcloudwords = $wordcloud->getWordcloudwords();
        foreach($wordcloudwords as $wordcloudword) {
            $idwid=$wordcloudword->getId();
            $export->widgets[$idwid] = new \stdClass();
            $export->widgets[$idwid]->id=$idwid;
            $export->widgets[$idwid]->title=$wordcloudword->getTitle();
            $export->widgets[$idwid]->user=($wordcloudword->getUser()?$wordcloudword->getUser()->getId():$wordcloud->getUser()->getId());

            // Copier les documents
            if($fs->exists($rootdir."/uploads/document/wordcloudword/$idwid")) $fs->mirror($rootdir."/uploads/document/wordcloudword/$idwid", $destdir."/private/document/$idwid");
        }

        file_put_contents($destdir."/info.json",json_encode($export));
        $now=new \Datetime();
        $zipName=$rootdir."/uploads/export/Nuage-".$now->format("Ymd")."-$id.zip";  
        $this->tool->zip($destdir,$zipName);

        $response = new BinaryFileResponse($zipName);
        $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_INLINE);
        return $response;
    }


    public function import(Request $request, $access="user") {
        return $this->render($this->render.'import.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => ($access=="admin"),
            'access'        => $access
        ]);
    }

    public function importzip($access="user")
    {
        return $this->render($this->render.'importzip.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
            'access'        => $access
        ]);
    }

    public function importexec(Request $request,$access="user")
    {
        if (!$request->isXmlHttpRequest()) return new JsonResponse(array('message' => 'Interdit'), 400);

        $em = $this->getDoctrine()->getManager();
        $metadata =  $em->getClassMetaData($this->entity);
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata =  $em->getClassMetaData("App:Wordcloudword");
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata =  $em->getClassMetaData("App:Document");
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $output=array();

        // Décompresser le fichier zip et controler son format
        $rootdir = $this->appKernel->getProjectDir();
        $zip = $rootdir."/".$request->request->get('file');
        $tmp=explode("/",$zip);
        $tmp=explode(".",end($tmp));
        $id=$tmp[0];
        $destdir = $rootdir."/uploads/import/$id";
        $unzipped = $this->tool->unzip($zip,$destdir);
        $error="";
        if(!$unzipped)
            return $this->importreturnerror("<p>Votre fichier ZIP n'a pas pu être décompressé<p>");
        else {
            // Chargement du fichier json associé
            $json=file_get_contents($destdir."/info.json");
            if(!$json) return $this->importreturnerror("<p>Contenu du fichier ZIP invalide<p>");;
            $json= json_decode($json);
            if(!$json) return $this->importreturnerror("<p>Contenu du fichier ZIP invalide<p>");;
        }

        // Structure attendu
        $frmboards=["type","id","title","user","groups","groupwriters","groupreaders","users","userwriters","userreaders","widgets"];
        $frmwidgets=["id","title","user"];

        // On vérifie la structure du json
        foreach($frmboards as $frm) {
            if (!property_exists($json,$frm)) $error.="<p>Contenu du fichier ZIP invalide = propriété $frm manquante<p>";
        }
        if($error) return $this->importreturnerror($error);
        if($json->type!="wordcloud") return $this->importreturnerror("<p>Contenu du fichier ZIP invalide = type invalide<p>");

        // On s'assure que les widgets sont correctement formée
        foreach($json->widgets as $widget) {
            foreach($frmwidgets as $frm) {
                if (!property_exists($widget,$frm)) $error.="<p>Contenu du fichier ZIP invalide = propriété billet $frm manquante<p>";
            }
        }
        if($error) return $this->importreturnerror($error);

        // On s'assure que le board à restaurer existe
        $board=$em->getRepository($this->entity)->find($json->id);
        if(!$board) return $this->importreturnerror("<p>Impossible de restaurer le board n'existe pas</p>");

        // On s'assure que l'utilisateur à la permission de restaurer ce board
        if($access=="user") {
            if($board->getUser()!=$this->getUser()) return $this->importreturnerror("<p>N'étant pas propriétaire du board vous ne pouvait pas le restaurer</p>");
        }
        $owner=$board->getUser();

        if($error!="") {
            $output["status"]="KO";
            $output["error"]=$error;
        }
        else {
            // On supprime le board pour le regénrer
            $em->remove($board);
            $em->flush();

            // Génération de la sauvegarde
            $board = new Entity();
            $board->setId($json->id);
            $board->setTitle($json->title);
            $board->setUser($owner);

            foreach($json->groups as $widgrp) {
                $group=$em->getRepository("App:Group")->find($widgrp->id);
                if($group) $board->addGroup($group);
            }
            foreach($json->groupwriters as $widgrp) {
                $group=$em->getRepository("App:Group")->find($widgrp->id);
                if($group) $board->addGroupwriter($group);
            }
            foreach($json->groupreaders as $widgrp) {
                $group=$em->getRepository("App:Group")->find($widgrp->id);
                if($group) $board->addGroupreader($group);
            }

            foreach($json->users as $widusr) {
                $user=$em->getRepository("App:User")->find($widusr->id);
                if($user) $board->addUser($user);
            }
            foreach($json->userwriters as $widusr) {
                $user=$em->getRepository("App:User")->find($widusr->id);
                if($user) $board->addUserwriter($user);
            }
            foreach($json->userreaders as $widusr) {
                $user=$em->getRepository("App:User")->find($widusr->id);
                if($user) $board->addUserreader($user);
            }

            $em->persist($board);
            $em->flush();


            foreach($json->widgets as $widjson) {
                $user=$em->getRepository("App:User")->find($widjson->user);
                if(!$user) $user=$owner;

                $widget = new Wordcloudword();
                $widget->setId($widjson->id);
                $widget->setTitle($widjson->title);
                $widget->setUser($user);
                $widget->setWordcloud($board);

                $em->persist($widget);
                $em->flush();
            }
        }

        $output["status"]="OK";
        $output["id"]=$json->id;
        $response = new Response(json_encode($output));
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }

    private function importreturnerror($error) {
        $output["status"]="KO";
        $output["error"]=$error;

        $response = new Response(json_encode($output));
        $response->headers->set('Content-Type', 'application/json');
        return $response;
    }

    private function perm($entity) {
        $perm=false;

        if($entity->getUser()==$this->getUser()) $perm="write";
        //if($this->getUser()->hasRole("ROLE_ADMIN")) $perm="write";
        if($this->getUser()->hasRole("ROLE_MODO")) $perm="write";

        // Récupération des groupes de l'utilisateur
        $groups=$this->getUser()->getGroups();

        // Ses groupes ont-ils la permission
        foreach($groups as $group) {
            if($entity->getGroups()->contains($group)) $perm="write";
        }

        // Son compte a-til la permission
        if($entity->getUsers()->contains($this->getUser())) $perm="write";

        // Si pas de permission on regarde s'il a les permissions en écriture limitée
        if(!$perm) {
            // Ses groupes ont-ils la permission
            foreach($groups as $group) {
                if($entity->getGroupwriters()->contains($group)) $perm="writeuser";
            }

            // Son compte a-til la permission
            if($entity->getUserwriters()->contains($this->getUser())) $perm="writeuser";
        }

        // Si pas de permission on regarde s'il a les permissions en lecture
        if(!$perm) {
            // Ses groupes ont-ils la permission
            foreach($groups as $group) {
                if($entity->getGroupreaders()->contains($group)) $perm="read";
            }

            // Son compte a-til la permission
            if($entity->getUserreaders()->contains($this->getUser())) $perm="read";
        }

        // Erreur si non permis
        if(!$perm) return false;

        return $perm;
    }

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" || $mode=="update")) {
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }
}
