<?php

namespace App\Service;

use App\Entity\User;
use App\Entity\Group;

class ldapService
{

    protected $host;
    protected $port;
    protected $tls;
    protected $user = null;
    protected $password = null;
    protected $basedn;

    private $connection = null;

    public function __construct($ldapHost, $ldapPort, $ldapTls, $ldapUser, $ldapPassword, $ldapBasedn)
    {
        $this->host = $ldapHost;
        $this->port = $ldapPort;
        $this->tls  = $ldapTls;
        $this->user = $ldapUser;
        $this->password = $ldapPassword;
        $this->basedn = $ldapBasedn;
    }

    public function connect() {
        if($this->connection){
            return $this->connection;
        } else {
            $ldapConn = ldap_connect($this->host, $this->port);
            if($ldapConn){
                ldap_set_option($ldapConn, LDAP_OPT_PROTOCOL_VERSION, 3);
                ldap_set_option($ldapConn, LDAP_OPT_REFERRALS, 0);
                if($this->tls) ldap_start_tls($ldapConn);
                
                if(ldap_bind( $ldapConn, $this->user, $this->password)){
                    $this->connection = $ldapConn;
                    return $this->connection;
                }
            }
        }
    }

    public function search($filter, $attributes = array(), $subBranch = '') {
        $connection = $this->connect();
        $branch = ($subBranch ? $subBranch : $this->basedn);
        $result = ldap_search($connection, $branch, $filter, $attributes,0,0,0);
        if(!$result) {
            $this->ldapError();
        }
        return $this->resultToArray($result);
    }

    private function resultToArray($result){

        $connection = $this->connect();
        $resultArray = array();

        if($result){
            $entry = ldap_first_entry($connection, $result);
            while ($entry){
                $row = array();
                $attr = ldap_first_attribute($connection, $entry);
                while ($attr){
                    $val = ldap_get_values_len($connection, $entry, $attr);
                    if(array_key_exists('count', $val) AND $val['count'] == 1){
                        $row[strtolower($attr)] = $val[0];
                    } else {
                        $row[strtolower($attr)] = $val;
                    }
                    $attr = ldap_next_attribute($connection, $entry);
                }
                $resultArray[] = $row;
                $entry = ldap_next_entry($connection, $entry);
            }
        }

        return $resultArray;
    }

    public function disconnect(){
      $connection = $this->connect();
      ldap_unbind($connection);
    }

    public function ldapError(){
        $connection = $this->connect();
        throw new \Exception(
            'Error: ('. ldap_errno($connection) .') '. ldap_error($connection)
        );
    }


//==================================================================================================================================================================
//== Init du Service Synfony========================================================================================================================================
//==================================================================================================================================================================

    public function getUser() {
        return $this->user;
    }

    public function setUser($user) {
        $this->user = $user;
        return $this;
    }

    public function getPassword() {
        return $this->password;
    }

    public function setPassword($password) {
        $this->password = $password;
        return $this;
    }

    public function getBaseDN() {
        return $this->basedn;
    }

    public function setBaseDN($basedn) {
        $this->basedn = $basedn;
        return $this;
    }
}
