<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;

/**
 * Group
 * 
 * @ORM\Entity(repositoryClass="App\Repository\GroupRepository")
 * @ORM\Table(name="groupe", uniqueConstraints={@ORM\UniqueConstraint(name="name", columns={"name"})}, indexes={@ORM\Index(name="idexternal", columns={"idexternal"})} )
 * @UniqueEntity("name", message="Ce nom de groupe existe dèja")
 */
class Group
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string")
     *
     */
    private $name;

    /**
     * @ORM\Column(type="text", nullable=true)
     */
    private $ldapfilter;

    /**
     * @ORM\Column(type="string", nullable=true)
     */
    private $idexternal;

    /**
    * @ORM\ManyToMany(targetEntity="User", mappedBy="groups")
    */    
    protected $users;

    /**
    * @ORM\ManyToMany(targetEntity="Scrum", mappedBy="groups")
    */    
    protected $scrums;      

    /**
    * @ORM\ManyToMany(targetEntity="Scrum", mappedBy="groupwriters")
    */    
    protected $scrumwriters;  
    
    /**
    * @ORM\ManyToMany(targetEntity="Scrum", mappedBy="groupreaders")
    */    
    protected $scrumreaders;  

    /**
    * @ORM\ManyToMany(targetEntity="Whiteboard", mappedBy="groups")
    */    
    protected $whiteboards;      

    /**
    * @ORM\ManyToMany(targetEntity="Whiteboard", mappedBy="groupwriters")
    */    
    protected $whiteboardwriters;  
    
    /**
    * @ORM\ManyToMany(targetEntity="Whiteboard", mappedBy="groupreaders")
    */    
    protected $whiteboardreaders;  

    /**
    * @ORM\ManyToMany(targetEntity="Wordcloud", mappedBy="groups")
    */    
    protected $wordclouds;      

    /**
    * @ORM\ManyToMany(targetEntity="Wordcloud", mappedBy="groupwriters")
    */    
    protected $wordcloudwriters;  
    
    /**
    * @ORM\ManyToMany(targetEntity="Wordcloud", mappedBy="groupreaders")
    */    
    protected $wordcloudreaders;  

    /**
    * @ORM\ManyToMany(targetEntity="Timeline", mappedBy="groups")
    */    
    protected $timelines;      

    /**
    * @ORM\ManyToMany(targetEntity="Timeline", mappedBy="groupreaders")
    */    
    protected $timelinereaders;  

    /**
    * @ORM\ManyToMany(targetEntity="Mindmap", mappedBy="groups")
    */    
    protected $mindmaps;      

    /**
    * @ORM\ManyToMany(targetEntity="Mindmap", mappedBy="groupreaders")
    */    
    protected $mindmapreaders;  

    /**
    * @ORM\ManyToMany(targetEntity="Etherpad", mappedBy="groups")
    */    
    protected $etherpads;      

    /**
    * @ORM\ManyToMany(targetEntity="Ethercalc", mappedBy="groups")
    */    
    protected $ethercalcs;   

    public function __construct()
    {
        $this->users = new ArrayCollection();
        $this->scrums = new ArrayCollection();
        $this->scrumwriters = new ArrayCollection();
        $this->scrumreaders = new ArrayCollection();
        $this->etherpads = new ArrayCollection();
        $this->ethercalcs = new ArrayCollection();
        $this->timelines = new ArrayCollection();
        $this->timelinereaders = new ArrayCollection();
        $this->mindmaps = new ArrayCollection();
        $this->mindmapreaders = new ArrayCollection();
        $this->whiteboards = new ArrayCollection();
        $this->whiteboardwriters = new ArrayCollection();
        $this->whiteboardreaders = new ArrayCollection();
        $this->wordclouds = new ArrayCollection();
        $this->wordcloudwriters = new ArrayCollection();
        $this->wordcloudreaders = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getLdapfilter(): ?string
    {
        return $this->ldapfilter;
    }

    public function setLdapfilter(?string $ldapfilter): self
    {
        $this->ldapfilter = $ldapfilter;

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getUsers(): Collection
    {
        return $this->users;
    }

    public function addUser(User $user): self
    {
        if (!$this->users->contains($user)) {
            $this->users[] = $user;
            $user->addGroup($this);
        }

        return $this;
    }

    public function removeUser(User $user): self
    {
        if ($this->users->contains($user)) {
            $this->users->removeElement($user);
            $user->removeGroup($this);
        }

        return $this;
    }

    public function getIdexternal(): ?string
    {
        return $this->idexternal;
    }

    public function setIdexternal(?string $idexternal): self
    {
        $this->idexternal = $idexternal;

        return $this;
    }

    /**
     * @return Collection|Scrum[]
     */
    public function getScrums(): Collection
    {
        return $this->scrums;
    }

    public function addScrum(Scrum $scrum): self
    {
        if (!$this->scrums->contains($scrum)) {
            $this->scrums[] = $scrum;
            $scrum->addGroup($this);
        }

        return $this;
    }

    public function removeScrum(Scrum $scrum): self
    {
        if ($this->scrums->contains($scrum)) {
            $this->scrums->removeElement($scrum);
            $scrum->removeGroup($this);
        }

        return $this;
    }

    /**
     * @return Collection|Scrum[]
     */
    public function getScrumwriters(): Collection
    {
        return $this->scrumwriters;
    }

    public function addScrumwriter(Scrum $scrumwriter): self
    {
        if (!$this->scrumwriters->contains($scrumwriter)) {
            $this->scrumwriters[] = $scrumwriter;
            $scrumwriter->addGroupwriter($this);
        }

        return $this;
    }

    public function removeScrumwriter(Scrum $scrumwriter): self
    {
        if ($this->scrumwriters->contains($scrumwriter)) {
            $this->scrumwriters->removeElement($scrumwriter);
            $scrumwriter->removeGroupwriter($this);
        }

        return $this;
    }

    /**
     * @return Collection|Scrum[]
     */
    public function getScrumreaders(): Collection
    {
        return $this->scrumreaders;
    }

    public function addScrumreader(Scrum $scrumreader): self
    {
        if (!$this->scrumreaders->contains($scrumreader)) {
            $this->scrumreaders[] = $scrumreader;
            $scrumreader->addGroupreader($this);
        }

        return $this;
    }

    public function removeScrumreader(Scrum $scrumreader): self
    {
        if ($this->scrumreaders->contains($scrumreader)) {
            $this->scrumreaders->removeElement($scrumreader);
            $scrumreader->removeGroupreader($this);
        }

        return $this;
    }

    /**
     * @return Collection|Etherpad[]
     */
    public function getEtherpads(): Collection
    {
        return $this->etherpads;
    }

    public function addEtherpad(Etherpad $etherpad): self
    {
        if (!$this->etherpads->contains($etherpad)) {
            $this->etherpads[] = $etherpad;
            $etherpad->addGroup($this);
        }

        return $this;
    }

    public function removeEtherpad(Etherpad $etherpad): self
    {
        if ($this->etherpads->contains($etherpad)) {
            $this->etherpads->removeElement($etherpad);
            $etherpad->removeGroup($this);
        }

        return $this;
    }

    /**
     * @return Collection|Ethercalc[]
     */
    public function getEthercalcs(): Collection
    {
        return $this->ethercalcs;
    }

    public function addEthercalc(Ethercalc $ethercalc): self
    {
        if (!$this->ethercalcs->contains($ethercalc)) {
            $this->ethercalcs[] = $ethercalc;
            $ethercalc->addGroup($this);
        }

        return $this;
    }

    public function removeEthercalc(Ethercalc $ethercalc): self
    {
        if ($this->ethercalcs->contains($ethercalc)) {
            $this->ethercalcs->removeElement($ethercalc);
            $ethercalc->removeGroup($this);
        }

        return $this;
    }

    /**
     * @return Collection|Timeline[]
     */
    public function getTimelines(): Collection
    {
        return $this->timelines;
    }

    public function addTimeline(Timeline $timeline): self
    {
        if (!$this->timelines->contains($timeline)) {
            $this->timelines[] = $timeline;
            $timeline->addGroup($this);
        }

        return $this;
    }

    public function removeTimeline(Timeline $timeline): self
    {
        if ($this->timelines->contains($timeline)) {
            $this->timelines->removeElement($timeline);
            $timeline->removeGroup($this);
        }

        return $this;
    }

    /**
     * @return Collection|Timeline[]
     */
    public function getTimelinereaders(): Collection
    {
        return $this->timelinereaders;
    }

    public function addTimelinereader(Timeline $timelinereader): self
    {
        if (!$this->timelinereaders->contains($timelinereader)) {
            $this->timelinereaders[] = $timelinereader;
            $timelinereader->addGroupreader($this);
        }

        return $this;
    }

    public function removeTimelinereader(Timeline $timelinereader): self
    {
        if ($this->timelinereaders->contains($timelinereader)) {
            $this->timelinereaders->removeElement($timelinereader);
            $timelinereader->removeGroupreader($this);
        }

        return $this;
    }

    /**
     * @return Collection|Mindmap[]
     */
    public function getMindmaps(): Collection
    {
        return $this->mindmaps;
    }

    public function addMindmap(Mindmap $mindmap): self
    {
        if (!$this->mindmaps->contains($mindmap)) {
            $this->mindmaps[] = $mindmap;
            $mindmap->addGroup($this);
        }

        return $this;
    }

    public function removeMindmap(Mindmap $mindmap): self
    {
        if ($this->mindmaps->contains($mindmap)) {
            $this->mindmaps->removeElement($mindmap);
            $mindmap->removeGroup($this);
        }

        return $this;
    }

    /**
     * @return Collection|Mindmap[]
     */
    public function getMindmapreaders(): Collection
    {
        return $this->mindmapreaders;
    }

    public function addMindmapreader(Mindmap $mindmapreader): self
    {
        if (!$this->mindmapreaders->contains($mindmapreader)) {
            $this->mindmapreaders[] = $mindmapreader;
            $mindmapreader->addGroupreader($this);
        }

        return $this;
    }

    public function removeMindmapreader(Mindmap $mindmapreader): self
    {
        if ($this->mindmapreaders->contains($mindmapreader)) {
            $this->mindmapreaders->removeElement($mindmapreader);
            $mindmapreader->removeGroupreader($this);
        }

        return $this;
    }

    /**
     * @return Collection|Whiteboard[]
     */
    public function getWhiteboards(): Collection
    {
        return $this->whiteboards;
    }

    public function addWhiteboard(Whiteboard $whiteboard): self
    {
        if (!$this->whiteboards->contains($whiteboard)) {
            $this->whiteboards[] = $whiteboard;
            $whiteboard->addGroup($this);
        }

        return $this;
    }

    public function removeWhiteboard(Whiteboard $whiteboard): self
    {
        if ($this->whiteboards->contains($whiteboard)) {
            $this->whiteboards->removeElement($whiteboard);
            $whiteboard->removeGroup($this);
        }

        return $this;
    }

    /**
     * @return Collection|Whiteboard[]
     */
    public function getWhiteboardwriters(): Collection
    {
        return $this->whiteboardwriters;
    }

    public function addWhiteboardwriter(Whiteboard $whiteboardwriter): self
    {
        if (!$this->whiteboardwriters->contains($whiteboardwriter)) {
            $this->whiteboardwriters[] = $whiteboardwriter;
            $whiteboardwriter->addGroupwriter($this);
        }

        return $this;
    }

    public function removeWhiteboardwriter(Whiteboard $whiteboardwriter): self
    {
        if ($this->whiteboardwriters->contains($whiteboardwriter)) {
            $this->whiteboardwriters->removeElement($whiteboardwriter);
            $whiteboardwriter->removeGroupwriter($this);
        }

        return $this;
    }

    /**
     * @return Collection|Whiteboard[]
     */
    public function getWhiteboardreaders(): Collection
    {
        return $this->whiteboardreaders;
    }

    public function addWhiteboardreader(Whiteboard $whiteboardreader): self
    {
        if (!$this->whiteboardreaders->contains($whiteboardreader)) {
            $this->whiteboardreaders[] = $whiteboardreader;
            $whiteboardreader->addGroupreader($this);
        }

        return $this;
    }

    public function removeWhiteboardreader(Whiteboard $whiteboardreader): self
    {
        if ($this->whiteboardreaders->contains($whiteboardreader)) {
            $this->whiteboardreaders->removeElement($whiteboardreader);
            $whiteboardreader->removeGroupreader($this);
        }

        return $this;
    }

    /**
     * @return Collection|Wordcloud[]
     */
    public function getWordclouds(): Collection
    {
        return $this->wordclouds;
    }

    public function addWordcloud(Wordcloud $wordcloud): self
    {
        if (!$this->wordclouds->contains($wordcloud)) {
            $this->wordclouds[] = $wordcloud;
            $wordcloud->addGroup($this);
        }

        return $this;
    }

    public function removeWordcloud(Wordcloud $wordcloud): self
    {
        if ($this->wordclouds->contains($wordcloud)) {
            $this->wordclouds->removeElement($wordcloud);
            $wordcloud->removeGroup($this);
        }

        return $this;
    }

    /**
     * @return Collection|Wordcloud[]
     */
    public function getWordcloudwriters(): Collection
    {
        return $this->wordcloudwriters;
    }

    public function addWordcloudwriter(Wordcloud $wordcloudwriter): self
    {
        if (!$this->wordcloudwriters->contains($wordcloudwriter)) {
            $this->wordcloudwriters[] = $wordcloudwriter;
            $wordcloudwriter->addGroupwriter($this);
        }

        return $this;
    }

    public function removeWordcloudwriter(Wordcloud $wordcloudwriter): self
    {
        if ($this->wordcloudwriters->contains($wordcloudwriter)) {
            $this->wordcloudwriters->removeElement($wordcloudwriter);
            $wordcloudwriter->removeGroupwriter($this);
        }

        return $this;
    }

    /**
     * @return Collection|Wordcloud[]
     */
    public function getWordcloudreaders(): Collection
    {
        return $this->wordcloudreaders;
    }

    public function addWordcloudreader(Wordcloud $wordcloudreader): self
    {
        if (!$this->wordcloudreaders->contains($wordcloudreader)) {
            $this->wordcloudreaders[] = $wordcloudreader;
            $wordcloudreader->addGroupreader($this);
        }

        return $this;
    }

    public function removeWordcloudreader(Wordcloud $wordcloudreader): self
    {
        if ($this->wordcloudreaders->contains($wordcloudreader)) {
            $this->wordcloudreaders->removeElement($wordcloudreader);
            $wordcloudreader->removeGroupreader($this);
        }

        return $this;
    }
}