<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Timelinedate
 *
 * @ORM\Table(name="timelinedate")
 * @ORM\Entity(repositoryClass="App\Repository\TimelinedateRepository")
 * 
 */
class Timelinedate
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;
        
    /**
     * @ORM\Column(type="integer")
     */
    private $start;

    /**
     * @ORM\Column(type="integer")
     */
    private $startmonth;
    
    /**
     * @ORM\Column(type="integer")
     */
    private $startday;

    /**
     * @ORM\Column(type="string", length=100, nullable=true)
     */
    private $color;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     */
    private $usebackground;

    /**
     * @ORM\Column(type="string", length=100, nullable=true)
     */
    private $background;

    /**
     * @ORM\Column(type="string", length=100)
     */
    private $posy;  

    /**
     * @ORM\ManyToOne(targetEntity="Timeline", inversedBy="timelinedates")
     */
    private $timeline;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }
    
    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getStart(): ?int
    {
        return $this->start;
    }

    public function setStart(int $start): self
    {
        $this->start = $start;

        return $this;
    }

    public function getStartmonth(): ?int
    {
        return $this->startmonth;
    }

    public function setStartmonth(int $startmonth): self
    {
        $this->startmonth = $startmonth;

        return $this;
    }

    public function getStartday(): ?int
    {
        return $this->startday;
    }

    public function setStartday(int $startday): self
    {
        $this->startday = $startday;

        return $this;
    }

    public function getColor(): ?string
    {
        return $this->color;
    }

    public function setColor(string $color): self
    {
        $this->color = $color;

        return $this;
    }

    public function getUsebackground(): ?bool
    {
        return $this->usebackground;
    }

    public function setUsebackground(bool $usebackground): self
    {
        $this->usebackground = $usebackground;

        return $this;
    }

    public function getBackground(): ?string
    {
        return $this->background;
    }

    public function setBackground(string $background): self
    {
        $this->background = $background;

        return $this;
    }

    public function getPosy(): ?string
    {
        return $this->posy;
    }

    public function setPosy(string $posy): self
    {
        $this->posy = $posy;

        return $this;
    }

    public function getTimeline(): ?Timeline
    {
        return $this->timeline;
    }

    public function setTimeline(?Timeline $timeline): self
    {
        $this->timeline = $timeline;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }
}
