<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpKernel\KernelInterface;
use Symfony\Component\Form\FormError;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\ResponseHeaderBag;
use Doctrine\ORM\Mapping\ClassMetadata;
use Doctrine\ORM\Id\AssignedGenerator;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

use App\Service\toolService;

use App\Entity\Timeline as Entity;
use App\Form\TimelineType as Form;
use App\Entity\Timelinesegment as Timelinesegment;
use App\Entity\Timelinedate as Timelinedate;

class TimelineController extends AbstractController
{
    private $data   = "timeline";
    private $route  = "app_user_timeline";
    private $render = "Timeline/";
    private $entity = "App:Timeline";
    private $appKernel;
    private $tool;
    
    public function __construct(KernelInterface $appKernel,toolService $tool)
    {
        $this->appKernel = $appKernel;
        $this->tool = $tool;
    }

    public function list(Request $request)
    {
        $em = $this->getDoctrine()->getManager();
        $datas = $em->getRepository($this->entity)->findAll();

        return $this->render($this->render.'list.html.twig',[
            $this->data."s" => $datas,
            "useheader"     => true,
            "usesidebar"    => true,
        ]);
    }

    public function view($id, Request $request, $access="user")
    {
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');

        $perm = $this->perm($data);
        if(!$perm) return $this->redirect($this->generateUrl('app_user_noperm',["displayname"=>$data->getUser()->getDisplayname(),"email"=>$data->getUser()->getEmail(),"url"=>$this->generateUrl($this->route."_view",["id"=>$id], UrlGeneratorInterface::ABSOLUTE_URL)]));    

        $form = $this->createForm(Form::class,$data,array("mode"=>"view", "access" => $access, "id"=>$id));

        return $this->render($this->render.'view.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => ($access=="admin"),   
            'maxwidth'      => false,           
            $this->data     => $data,
            'form'          => $form->createView(),
            'access'        => $access,
            'perm'          => $perm,
        ]);
    }

    public function info($id, Request $request, $access="user")
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        if (!$data) return new JsonResponse(array('message' => 'Interdit'), 400);

        $output=[
            "id" => $data->getId(),
            "title" => $data->getTitle(),
            "start" => $data->getStart(),
            "end" => $data->getEnd(),
            "unity" => $data->getUnity(),
            "color" => ($data->getColor()?$data->getColor():$this->get("session")->get("colorbgbodydark")),
            "usebackground" => $data->getUsebackground(),
            "background" => $data->getBackground(),
            "segments" => [],
            "dates" => [],
        ];

        $segments=$data->getTimelinesegments();
        foreach($segments as $segment) {
            $output["segments"][$segment->getId()]=new \stdClass;
            $output["segments"][$segment->getId()]->id = $segment->getId();
            $output["segments"][$segment->getId()]->title = $segment->getTitle();
            $output["segments"][$segment->getId()]->start = $segment->getStart();
            $output["segments"][$segment->getId()]->startmonth = $segment->getStartmonth();
            $output["segments"][$segment->getId()]->end = $segment->getEnd();
            $output["segments"][$segment->getId()]->endmonth = $segment->getEndmonth();
            $output["segments"][$segment->getId()]->color = ($segment->getColor()?$segment->getColor():$this->get("session")->get("colorbgbodydark"));
            $output["segments"][$segment->getId()]->usebackground = $segment->getUsebackground();
            $output["segments"][$segment->getId()]->background = $segment->getBackground();
            $output["segments"][$segment->getId()]->line = $segment->getLine();
        }

        $dates=$data->getTimelinedates();
        foreach($dates as $date) {
            $output["dates"][$date->getId()]=new \stdClass;
            $output["dates"][$date->getId()]->id = $date->getId();
            $output["dates"][$date->getId()]->title = $date->getTitle();
            $output["dates"][$date->getId()]->description = $date->getDescription();
            $output["dates"][$date->getId()]->start = $date->getStart();
            $output["dates"][$date->getId()]->startmonth = $date->getStartmonth();
            $output["dates"][$date->getId()]->startday = $date->getStartday();
            $output["dates"][$date->getId()]->color = ($date->getColor()?$date->getColor():$this->get("session")->get("colorbgbodydark"));
            $output["dates"][$date->getId()]->usebackground = $date->getUsebackground();
            $output["dates"][$date->getId()]->background = $date->getBackground();
            $output["dates"][$date->getId()]->posY = $date->getPosy();
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    }

    public function infosegment($id, Request $request, $access="user")
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository("App:Timelinesegment")->find($id);
        if (!$data) return new JsonResponse(array('message' => 'Interdit'), 400);

        $output=[
            "id" => $data->getId(),
            "title" => $data->getTitle(),
            "description" => $data->getDescription(),
            "start" => $data->getStart(),
            "startmonth" => $data->getStartmonth(),
            "end" => $data->getEnd(),
            "endmonth" => $data->getEndmonth(),
            "color" => ($data->getColor()?$data->getColor():$this->get("session")->get("colorbgbodydark")),
            "usebackground" => $data->getUsebackground(),
            "background" => $data->getBackground(),
            "line" => $data->getLine(),
        ];

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    }

    public function infodate($id, Request $request, $access="user")
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository("App:Timelinedate")->find($id);
        if (!$data) return new JsonResponse(array('message' => 'Interdit'), 400);

        $output=[
            "id" => $data->getId(),
            "title" => $data->getTitle(),
            "description" => $data->getDescription(),
            "start" => $data->getStart(),
            "startmonth" => $data->getStartmonth(),
            "startday" => $data->getStartday(),
            "color" => ($data->getColor()?$data->getColor():$this->get("session")->get("colorbgbodydark")),
            "usebackground" => $data->getUsebackground(),
            "background" => $data->getBackground(),
            "posY" => $data->getPosy(),
        ];

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    }

    public function submit(Request $request, $access="user") {
        // Initialisation de l'enregistrement
        $em = $this->getDoctrine()->getManager();
        $data = new Entity();
        if($access=="user") $data->setUser($this->getUser());
        $data->setUnity("years");
        $data->setZoom("1");

        // Création du formulaire
        $form = $this->createForm(Form::class,$data,array("mode"=>"submit", "access" => $access));

        // Récupération des data du formulaire
        $form->handleRequest($request);
        
        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"submit");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            
            $em->persist($data);
            $em->flush();

            // On deplace le background dans sa destination finale
            if($data->getUsebackground()) {
                $fs = new Filesystem();
                $rootdir = $this->appKernel->getProjectDir()."/public/uploads/timeline";
                $fs->mkdir($rootdir);
                $destdir = $rootdir."/".$data->getId();
                $fs->mkdir($destdir);
                $fs->rename($rootdir."/submit/".$data->getBackground(),$destdir."/".$data->getBackground(), true);
            }

            // Retour à la liste
            return $this->redirect($this->generateUrl('app_'.$access.'_timeline_view',["id"=>$data->getId()]));    
        }

        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader'         => true,
            'usesidebar'        => ($access=="admin"),     
            'maxwidth'          => ($access=="user"),            
            $this->data         => $data,
            'mode'              => 'submit',
            'form'              => $form->createView(),
            'access'            => $access,
        ]);    
    }

    public function update($id, Request $request, $access="user") {
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');
        if($data->getUser()!=$this->getUser()&&!$this->getUser()->hasRole("ROLE_ADMIN")&&!$this->getUser()->hasRole("ROLE_MODO")) 
        throw $this->createNotFoundException('Permission denied');

        // Création du formulaire
        $form = $this->createForm(Form::class,$data,array("mode"=>"update", "access" => $access));

        // Récupération des data du formulaire
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm(null,$form,$request,$data,"update");
        
        // Sur validation
        if ($form->get('submit')->isClicked() && $form->isValid()) {  
            $data = $form->getData();  
            $em->persist($data);
            $em->flush();

            // Retour à la liste
            if($access=="user")
                return $this->redirect($this->generateUrl('app_'.$access.'_timeline_view',["id"=>$data->getId()]));          
            else 
                return $this->redirect($this->generateUrl('app_admin_timeline'));     

        }
        
        // Affichage du formulaire
        return $this->render($this->render.'edit.html.twig', [
            'useheader'         => true,
            'usesidebar'        => ($access=="admin"),  
            'maxwidth'          => ($access=="user"),
            $this->data         => $data,
            'mode'              => 'update',
            'form'              => $form->createView(),
            'access'            => $access
        ]);         
    }

    public function delete($id, Request $request, $access="user") {
        $em = $this->getDoctrine()->getManager();
        $data=$em->getRepository($this->entity)->find($id);
        if (!$data) throw $this->createNotFoundException('Unable to find entity.');
        if($data->getUser()!=$this->getUser()&&!$this->getUser()->hasRole("ROLE_ADMIN")&&!$this->getUser()->hasRole("ROLE_MODO")) 
        throw $this->createNotFoundException('Permission denied');

        $em->remove($data);
        $em->flush();

        if($access=="user")
            return $this->redirect($this->generateUrl('app_home'));          
        else
            return $this->redirect($this->generateUrl('app_admin_timeline'));          
    }    

    public function export($id, Request $request, $access="user") {
        $em = $this->getDoctrine()->getManager();
        $timeline=$em->getRepository($this->entity)->find($id);
        if (!$timeline) throw $this->createNotFoundException('Unable to find entity.');
        if($timeline->getUser()!=$this->getUser()&&!$this->getUser()->hasRole("ROLE_ADMIN")&&!$this->getUser()->hasRole("ROLE_MODO")) 
        throw $this->createNotFoundException('Permission denied');

        $fs = new Filesystem();
        $rootdir = $this->appKernel->getProjectDir();
        $destdir = $rootdir."/uploads/export/timeline/$id";

        // Regénération du répertoire d'export
        $fs->remove($destdir);
        $fs->mkdir($rootdir."/uploads");
        $fs->mkdir($rootdir."/uploads/export");
        $fs->mkdir($rootdir."/uploads/export/timeline");
        $fs->mkdir($rootdir."/uploads/export/timeline/$id");
        $fs->mkdir($rootdir."/uploads/export/timeline/$id/public");
        $fs->mkdir($rootdir."/uploads/export/timeline/$id/public/timeline");

        // Création du json d'export
        $export = new \stdClass();
        $export->type = "timeline";
        $export->id = $timeline->getId();
        $export->title = $timeline->getTitle();
        $export->description = $timeline->getDescription();
        $export->start = $timeline->getStart();
        $export->end = $timeline->getEnd();
        $export->unity = $timeline->getUnity();
        $export->zoom = $timeline->getZoom();
        $export->color = $timeline->getColor();
        $export->usebackground = $timeline->getUsebackground();
        $export->background = $timeline->getBackground();
        $export->user = $timeline->getUser()->getId();

        $export->groups = [];
        $groups=$timeline->getGroups();
        foreach($groups as $group) {
            $idgrp=$group->getId();
            $export->groups[$idgrp] = new \stdClass();
            $export->groups[$idgrp]->id=$idgrp;
        }
        
        $export->groupreaders = [];
        $groups=$timeline->getGroupreaders();
        foreach($groups as $group) {
            $idgrp=$group->getId();
            $export->groupreaders[$idgrp] = new \stdClass();
            $export->groupreaders[$idgrp]->id=$idgrp;
        } 

        $export->users = [];
        $users=$timeline->getUsers();
        foreach($users as $user) {
            $idusr=$user->getId();
            $export->users[$idusr] = new \stdClass();
            $export->users[$idusr]->id=$idusr;
        }
        
        $export->userreaders = [];
        $users=$timeline->getUserreaders();
        foreach($users as $user) {
            $idusr=$user->getId();
            $export->userreaders[$idusr] = new \stdClass();
            $export->userreaders[$idusr]->id=$idusr;
        } 

        $export->segments = [];
        $timelinesegments = $timeline->getTimelinesegments();
        foreach($timelinesegments as $timelinesegment) {
            $idseg=$timelinesegment->getId();
            $export->segments[$idseg] = new \stdClass();
            $export->segments[$idseg]->id=$idseg;
            $export->segments[$idseg]->title=$timelinesegment->getTitle();
            $export->segments[$idseg]->description=$timelinesegment->getDescription();
            $export->segments[$idseg]->start=$timelinesegment->getStart();
            $export->segments[$idseg]->startmonth=$timelinesegment->getStartmonth();
            $export->segments[$idseg]->end=$timelinesegment->getEnd();
            $export->segments[$idseg]->endmonth=$timelinesegment->getEndmonth();
            $export->segments[$idseg]->color=$timelinesegment->getColor();
            $export->segments[$idseg]->usebackground=$timelinesegment->getUsebackground();
            $export->segments[$idseg]->background=$timelinesegment->getBackground();
            $export->segments[$idseg]->line=$timelinesegment->getLine();
        }

        $export->dates = [];
        $timelinedates = $timeline->getTimelinedates();
        foreach($timelinedates as $timelinedate) {
            $iddat=$timelinedate->getId();
            $export->dates[$iddat] = new \stdClass();
            $export->dates[$iddat]->id=$iddat;
            $export->dates[$iddat]->title=$timelinedate->getTitle();
            $export->dates[$iddat]->description=$timelinedate->getDescription();
            $export->dates[$iddat]->start=$timelinedate->getStart();
            $export->dates[$iddat]->startmonth=$timelinedate->getStartmonth();
            $export->dates[$iddat]->startday=$timelinedate->getStartday();
            $export->dates[$iddat]->color=$timelinedate->getColor();
            $export->dates[$iddat]->usebackground=$timelinedate->getUsebackground();
            $export->dates[$iddat]->background=$timelinedate->getBackground();
            $export->dates[$iddat]->posy=$timelinedate->getPosy();
        }

        // Copier les fichiers  public/privé
        if($fs->exists($rootdir."/public/uploads/timeline/$id")) $fs->mirror($rootdir."/public/uploads/timeline/$id", $destdir."/public/timeline/$id");

        file_put_contents($destdir."/info.json",json_encode($export));
        $now=new \Datetime();
        $zipName=$rootdir."/uploads/export/Frise-".$now->format("Ymd")."-$id.zip";        
        $this->tool->zip($destdir,$zipName);

        $response = new BinaryFileResponse($zipName);
        $response->setContentDisposition(ResponseHeaderBag::DISPOSITION_INLINE);
        return $response;
    }


    public function import(Request $request, $access="user") {
        return $this->render($this->render.'import.html.twig',[
            'useheader'     => true,
            'usemenu'       => false,
            'usesidebar'    => ($access=="admin"),
            'access'        => $access
        ]);
    }

    public function importzip($access="user")
    {
        return $this->render($this->render.'importzip.html.twig',[
            'useheader'     => false,
            'usemenu'       => false,
            'usesidebar'    => false,
            'access'        => $access
        ]);
    }
    
    public function importexec(Request $request,$access="user")
    {
        if (!$request->isXmlHttpRequest()) return new JsonResponse(array('message' => 'Interdit'), 400);

        $em = $this->getDoctrine()->getManager();
        $metadata =  $em->getClassMetaData($this->entity);
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $metadata =  $em->getClassMetaData("App:Timelinesegment");
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());
        
        $metadata =  $em->getClassMetaData("App:Timelinedate");
        $metadata->setIdGeneratorType(ClassMetadata::GENERATOR_TYPE_NONE);
        $metadata->setIdGenerator(new AssignedGenerator());

        $output=array();

        // Décompresser le fichier zip et controler son format
        $rootdir = $this->appKernel->getProjectDir();
        $zip = $rootdir."/".$request->request->get('file');
        $tmp=explode("/",$zip);
        $tmp=explode(".",end($tmp));
        $id=$tmp[0];
        $destdir = $rootdir."/uploads/import/$id";
        $unzipped = $this->tool->unzip($zip,$destdir);
        $error="";
        if(!$unzipped) 
            return $this->importreturnerror("<p>Votre fichier ZIP n'a pas pu être décompressé<p>");
        else {
            // Chargement du fichier json associé
            $json=file_get_contents($destdir."/info.json");
            if(!$json) return $this->importreturnerror("<p>Contenu du fichier ZIP invalide<p>");;
            $json= json_decode($json);
            if(!$json) return $this->importreturnerror("<p>Contenu du fichier ZIP invalide<p>");;
        }

        // Structure attendu
        $frmboards=["type","id","title","description","start","end","unity","zoom","color","usebackground","background","user","groups","groupreaders","users","userreaders","segments","dates"];
        $frmsegments=["id","title","description","start","startmonth","end","endmonth","color","usebackground","background","line"];
        $frmdates=["id","title","description","start","startmonth","startday","color","usebackground","background","posy"];

        // On vérifie la structure du json
        foreach($frmboards as $frm) {
            if (!property_exists($json,$frm)) $error.="<p>Contenu du fichier ZIP invalide = propriété $frm manquante<p>";
        }
        if($error) return $this->importreturnerror($error);
        if($json->type!="timeline") return $this->importreturnerror("<p>Contenu du fichier ZIP invalide = type invalide<p>");

        // On s'assure que les segements sont correctement formé
        foreach($json->segments as $segment) {
            foreach($frmsegments as $frm) {
                if (!property_exists($segment,$frm)) $error.="<p>Contenu du fichier ZIP invalide = propriété segment $frm manquante<p>";
            }
        }
        if($error) return $this->importreturnerror($error);      

        // On s'assure que les dates sont correctement formé
        foreach($json->dates as $date) {
            foreach($frmdates as $frm) {
                if (!property_exists($date,$frm)) $error.="<p>Contenu du fichier ZIP invalide = propriété date $frm manquante<p>";
            }
        }
        if($error) return $this->importreturnerror($error);      

        // On s'assure que le board à restaurer existe
        $board=$em->getRepository($this->entity)->find($json->id);
        if(!$board) return $this->importreturnerror("<p>Impossible de restaurer le board n'existe pas</p>");      

        // On s'assure que l'utilisateur à la permission de restaurer ce board
        if($access=="user") {
            if($board->getUser()!=$this->getUser()) return $this->importreturnerror("<p>N'étant pas propriétaire du board vous ne pouvait pas le restaurer</p>");
        }
        $owner=$board->getUser();

        if($error!="") {
            $output["status"]="KO";
            $output["error"]=$error;
        }
        else {
            // On supprime le board pour le regénrer
            $em->remove($board);
            $em->flush();
               
            // Génération de la sauvegarde
            $board = new Entity();
            $board->setId($json->id);
            $board->setTitle($json->title);
            $board->setDescription($json->description);
            $board->setStart($json->start);
            $board->setEnd($json->end);
            $board->setUnity($json->unity);
            $board->setZoom($json->zoom);
            $board->setColor($json->color);
            $board->setUsebackground($json->usebackground);
            $board->setBackground($json->background);
            $board->setUser($owner);

            foreach($json->groups as $widgrp) {
                $group=$em->getRepository("App:Group")->find($widgrp->id);
                if($group) $board->addGroup($group);
            }
            foreach($json->groupreaders as $widgrp) {
                $group=$em->getRepository("App:Group")->find($widgrp->id);
                if($group) $board->addGroupreader($group);
            }
            
            foreach($json->users as $widusr) {
                $user=$em->getRepository("App:User")->find($widusr->id);
                if($user) $board->addUser($user);
            }
            foreach($json->userreaders as $widusr) {
                $user=$em->getRepository("App:User")->find($widusr->id);
                if($user) $board->addUserreader($user);
            }

            $em->persist($board);
            $em->flush();

            foreach($json->segments as $segjson) {
                $segment = new Timelinesegment();
                $segment->setId($segjson->id);
                $segment->setTitle($segjson->title);
                $segment->setDescription($segjson->description);
                $segment->setStart($segjson->start);
                $segment->setStartmonth($segjson->startmonth);
                $segment->setEnd($segjson->end);
                $segment->setEndmonth($segjson->endmonth);
                $segment->setColor($segjson->color);
                $segment->setUsebackground($segjson->usebackground);
                $segment->setBackground($segjson->background);
                $segment->setLine($segjson->line);
                $segment->setTimeline($board);

                $em->persist($segment);
                $em->flush();               
            }

            foreach($json->dates as $datjson) {
                $date = new Timelinedate();
                $date->setId($datjson->id);
                $date->setTitle($datjson->title);
                $date->setDescription($datjson->description);
                $date->setStart($datjson->start);
                $date->setStartmonth($datjson->startmonth);
                $date->setStartday($datjson->startday);
                $date->setColor($datjson->color);
                $date->setUsebackground($datjson->usebackground);
                $date->setBackground($datjson->background);
                $date->setPosy($datjson->posy);
                $date->setTimeline($board);

                $em->persist($date);
                $em->flush();               
            }

            // On clone les fichiers
            $fs = new Filesystem();
            if($fs->exists($destdir."/public/timeline/".$json->id)) $fs->mirror($destdir."/public/timeline/".$json->id, $rootdir."/public/uploads/timeline/".$json->id);        
        }

        $output["status"]="OK";
        $output["id"]=$json->id;
        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;   
    }

    private function importreturnerror($error) {
        $output["status"]="KO";
        $output["error"]=$error;

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');        
        return $response;        
    }

    private function perm($entity) {
        $perm=false;

        if($entity->getUser()==$this->getUser()) $perm="write";
        if($this->getUser()->hasRole("ROLE_ADMIN")) $perm="write";
        if($this->getUser()->hasRole("ROLE_MODO")) $perm="write";

        // Récupération des groupes de l'utilisateur
        $groups=$this->getUser()->getGroups();

        // Ses groupes ont-ils la permission 
        foreach($groups as $group) {
            if($entity->getGroups()->contains($group)) $perm="write";
        }

        // Son compte a-til la permission
        if($entity->getUsers()->contains($this->getUser())) $perm="write";

        // Si pas de permission on regarde s'il a les permissions en lecture
        if(!$perm) {
            // Ses groupes ont-ils la permission 
            foreach($groups as $group) {
                if($entity->getGroupreaders()->contains($group)) $perm="read";
            }

            // Son compte a-til la permission
            if($entity->getUserreaders()->contains($this->getUser())) $perm="read";
        }

        // Erreur si non permis
        if(!$perm) return false;

        return $perm;
    }

    protected function getErrorForm($id,$form,$request,$data,$mode) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {
        }

        if ($form->get('submit')->isClicked() && $mode=="submit") {
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" || $mode=="update")) {
            if($data->getStart()>$data->getEnd()) {
                $form->addError(new FormError("L'année de début ne peut être supérieure à l'année de fin"));
            }

            if($data->getUsebackground()&&!$data->getBackground()) {
                $form->addError(new FormError("Vous devez placer une image de fond"));
            }
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $this->get('session')->getFlashBag()->clear();

            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }      
}
