<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Whiteboardwidget
 *
 * @ORM\Table(name="whiteboardwidget")
 * @ORM\Entity(repositoryClass="App\Repository\WhiteboardwidgetRepository")
 * 
 */
class Whiteboardwidget
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;

    /**
     * @ORM\Column(name="colorbody", type="string", nullable=true)
     */
    private $colorbody;

    /**
     * @ORM\Column(name="colorfont", type="string", nullable=true)
     */
    private $colorfont;
    
    /**
     * @ORM\Column(name="filetype", type="string", nullable=true)
     */
    private $filetype;

    /**
     * @ORM\Column(name="file", type="string", nullable=true)
     */
    private $file;

    /**
     * @ORM\Column(name="posx", type="integer")
     */
    private $posx;

    /**
     * @ORM\Column(name="posy", type="integer")
     */
    private $posy;

    /**
     * @ORM\Column(name="width", type="integer")
     */
    private $width;

    /**
     * @ORM\Column(name="roworder", type="integer")
     */
    private $roworder;

    /**
     * @ORM\ManyToOne(targetEntity="Whiteboard", inversedBy="whiteboardwidgets")
     */
    private $whiteboard;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="whiteboardwidgets")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="Document", mappedBy="whiteboardwidget", cascade={"persist"}, orphanRemoval=true)
     */
    private $whiteboardwidgetdocuments;

    /**
     * @ORM\OneToMany(targetEntity="Message", mappedBy="whiteboardwidget", cascade={"persist"}, orphanRemoval=true)
     */
    private $messages;

    public function __construct()
    {
        $this->whiteboardwidgetdocuments = new ArrayCollection();
        $this->messages = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }
    
    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getFiletype(): ?string
    {
        return $this->filetype;
    }

    public function setFiletype(?string $filetype): self
    {
        $this->filetype = $filetype;

        return $this;
    }

    public function getFile(): ?string
    {
        return $this->file;
    }

    public function setFile(?string $file): self
    {
        $this->file = $file;

        return $this;
    }

    public function getPosx(): ?int
    {
        return $this->posx;
    }

    public function setPosx(int $posx): self
    {
        $this->posx = $posx;

        return $this;
    }

    public function getPosy(): ?int
    {
        return $this->posy;
    }

    public function setPosy(int $posy): self
    {
        $this->posy = $posy;

        return $this;
    }

    public function getWidth(): ?int
    {
        return $this->width;
    }

    public function setWidth(int $width): self
    {
        $this->width = $width;

        return $this;
    }

    public function getRoworder(): ?int
    {
        return $this->roworder;
    }

    public function setRoworder(int $roworder): self
    {
        $this->roworder = $roworder;

        return $this;
    }

    public function getWhiteboard(): ?Whiteboard
    {
        return $this->whiteboard;
    }

    public function setWhiteboard(?Whiteboard $whiteboard): self
    {
        $this->whiteboard = $whiteboard;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|Document[]
     */
    public function getWhiteboardwidgetdocuments(): Collection
    {
        return $this->whiteboardwidgetdocuments;
    }

    public function addWhiteboardwidgetdocument(Document $whiteboardwidgetdocument): self
    {
        if (!$this->whiteboardwidgetdocuments->contains($whiteboardwidgetdocument)) {
            $this->whiteboardwidgetdocuments[] = $whiteboardwidgetdocument;
            $whiteboardwidgetdocument->setWhiteboardwidget($this);
        }

        return $this;
    }

    public function removeWhiteboardwidgetdocument(Document $whiteboardwidgetdocument): self
    {
        if ($this->whiteboardwidgetdocuments->contains($whiteboardwidgetdocument)) {
            $this->whiteboardwidgetdocuments->removeElement($whiteboardwidgetdocument);
            // set the owning side to null (unless already changed)
            if ($whiteboardwidgetdocument->getWhiteboardwidget() === $this) {
                $whiteboardwidgetdocument->setWhiteboardwidget(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Message[]
     */
    public function getMessages(): Collection
    {
        return $this->messages;
    }

    public function addMessage(Message $message): self
    {
        if (!$this->messages->contains($message)) {
            $this->messages[] = $message;
            $message->setWhiteboardwidget($this);
        }

        return $this;
    }

    public function removeMessage(Message $message): self
    {
        if ($this->messages->contains($message)) {
            $this->messages->removeElement($message);
            // set the owning side to null (unless already changed)
            if ($message->getWhiteboardwidget() === $this) {
                $message->setWhiteboardwidget(null);
            }
        }

        return $this;
    }

    public function getColorbody(): ?string
    {
        return $this->colorbody;
    }

    public function setColorbody(?string $colorbody): self
    {
        $this->colorbody = $colorbody;

        return $this;
    }

    public function getColorfont(): ?string
    {
        return $this->colorfont;
    }

    public function setColorfont(?string $colorfont): self
    {
        $this->colorfont = $colorfont;

        return $this;
    }


}
