<?php

namespace Cadoles\PortalBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Projecttasktag
 *
 * @ORM\Entity
 * @ORM\Table(name="projecttasktag")
 */
class Projecttasktag
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
     * @ORM\Column(name="color", type="string", nullable=false)
     */
    private $color;  

    /**
     * @ORM\OneToMany(targetEntity="Cadoles\PortalBundle\Entity\Projecttask", mappedBy="projecttasktag")
     * @ORM\JoinColumn(nullable=true, onDelete="SET NULL")
     */
    private $projecttasks;


    // A garder pour forcer l'id en init
    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }


    /**
     * Constructor
     */
    public function __construct()
    {
        $this->projecttasks = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Projecttasktag
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set color
     *
     * @param string $color
     *
     * @return Projecttasktag
     */
    public function setColor($color)
    {
        $this->color = $color;

        return $this;
    }

    /**
     * Get color
     *
     * @return string
     */
    public function getColor()
    {
        return $this->color;
    }

    /**
     * Add projecttask
     *
     * @param \Cadoles\PortalBundle\Entity\Projecttask $projecttask
     *
     * @return Projecttasktag
     */
    public function addProjecttask(\Cadoles\PortalBundle\Entity\Projecttask $projecttask)
    {
        $this->projecttasks[] = $projecttask;

        return $this;
    }

    /**
     * Remove projecttask
     *
     * @param \Cadoles\PortalBundle\Entity\Projecttask $projecttask
     */
    public function removeProjecttask(\Cadoles\PortalBundle\Entity\Projecttask $projecttask)
    {
        $this->projecttasks->removeElement($projecttask);
    }

    /**
     * Get projecttasks
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getProjecttasks()
    {
        return $this->projecttasks;
    }
}
