<?php

namespace Cadoles\PortalBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Ivory\CKEditorBundle\Form\Type\CKEditorType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;

use Symfony\Component\OptionsResolver\OptionsResolver;
use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;

class BlogcommentType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $user=$options['user'];

        $builder
            ->add('submit', SubmitType::class, [
                "label"         => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"          => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])

            ->add('name', TextType::class, [
                'label'         => 'Titre'
            ])
            
            ->add("description",CKEditorType::class,[
                "config_name"   => 'full_config',
                "label"         => 'Description',
                "required"      => false,
                "disabled"      => ($options["mode"]=="delete"?true:false),
                "config"        => ["height" => "500px",'filebrowserUploadRoute' => 'cadoles_portal_'.$options["access"].'_blogcomment_upload']
            ]); 
            
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'Cadoles\PortalBundle\Entity\Blogcomment',
            'mode' => 'string',
            'access' => 'string',
            'user' => 'Cadoles\CoreBundle\Entity\User'
        ]);
    }
}
