<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="message")
 */
class Message
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="text")
     */
    private $topic;

    /**
     * @ORM\Column(type="datetime")
     */
    private $submitdate;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="messages")
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="Group", inversedBy="messages")
     */
    private $group;

    /**
     * @ORM\ManyToOne(targetEntity="Message", inversedBy="childs")
     */
    private $parent;

    /**
     * @ORM\OneToMany(targetEntity="Message", mappedBy="parent", cascade={"persist"}, orphanRemoval=true)
     */
    protected $childs;  

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="messagereaders", cascade={"persist"})
     * @ORM\JoinTable(name="messageuserread",
     *   joinColumns={@ORM\JoinColumn(name="message", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $readers;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="messagesees", cascade={"persist"})
     * @ORM\JoinTable(name="messageusersee",
     *   joinColumns={@ORM\JoinColumn(name="message", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $sees;


    /* champs calculé non stocké en base */
    private $haveread;
    public function getHaveread()
    {
        return $this->haveread;
    }    
    public function setHaveread($haveread) {
        $this->haveread = $haveread;

        return $this;        
    }

    private $havesee;
    public function getHavesee()
    {
        return $this->havesee;
    }    
    public function setHavesee($havesee) {
        $this->havesee = $havesee;

        return $this;        
    }

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->submitdate = new \DateTime();
    }



    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set topic
     *
     * @param string $topic
     *
     * @return Message
     */
    public function setTopic($topic)
    {
        $this->topic = $topic;

        return $this;
    }

    /**
     * Get topic
     *
     * @return string
     */
    public function getTopic()
    {
        return $this->topic;
    }

    /**
     * Set submitdate
     *
     * @param \DateTime $submitdate
     *
     * @return Message
     */
    public function setSubmitdate($submitdate)
    {
        $this->submitdate = $submitdate;

        return $this;
    }

    /**
     * Get submitdate
     *
     * @return \DateTime
     */
    public function getSubmitdate()
    {
        return $this->submitdate;
    }

    /**
     * Set user
     *
     * @param User $user
     *
     * @return Message
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set group
     *
     * @param Group $group
     *
     * @return Group
     */
    public function setGroup(Group $group = null)
    {
        $this->group = $group;

        return $this;
    }

    /**
     * Get group
     *
     * @return Group
     */
    public function getGroup()
    {
        return $this->group;
    }

    /**
     * Add reader
     *
     * @param User $reader
     *
     * @return User
     */
    public function addReader(User $reader)
    {
        $this->readers[] = $reader;

        return $this;
    }

    /**
     * Remove reader
     *
     * @param User $reader
     */
    public function removeReader(User $reader)
    {
        $this->readers->removeElement($reader);
    }

    /**
     * Get readers
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getReaders()
    {
        return $this->readers;
    }

    /**
     * Add see
     *
     * @param User $see
     *
     * @return Message
     */
    public function addSee(User $see)
    {
        $this->sees[] = $see;

        return $this;
    }

    /**
     * Remove see
     *
     * @param User $see
     */
    public function removeSee(User $see)
    {
        $this->sees->removeElement($see);
    }

    /**
     * Get sees
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getSees()
    {
        return $this->sees;
    }

    /**
     * Set parent
     *
     * @param Message $parent
     *
     * @return Message
     */
    public function setParent(Message $parent = null)
    {
        $this->parent = $parent;

        return $this;
    }

    /**
     * Get parent
     *
     * @return Message
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Add child
     *
     * @param Message $child
     *
     * @return Message
     */
    public function addChild(Message $child)
    {
        $this->childs[] = $child;

        return $this;
    }

    /**
     * Remove child
     *
     * @param Message $child
     */
    public function removeChild(Message $child)
    {
        $this->childs->removeElement($child);
    }

    /**
     * Get childs
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getChilds()
    {
        return $this->childs;
    }
}
