<?php
namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="permmodoprofil")
 *
  */
class PermModoProfil
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=50, unique=true)
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity="PermModo", mappedBy="permmodoprofil", cascade={"persist"}, orphanRemoval=true)
     */
    private $permmodos;    

    /**
     * @ORM\OneToMany(targetEntity="User", mappedBy="permmodoprofil")
     */
    private $users;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->permmodos = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set id.
     *
     * @param string $id
     *
     * @return PermModoProfil
     */
    public function setId($id)
    {
        $this->id = $id;
        
        return $this;
    }

    /**
     * Set name.
     *
     * @param string $name
     *
     * @return PermModoProfil
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Add permmodo.
     *
     * @param PermModo $permmodo
     *
     * @return PermModoProfil
     */
    public function addPermmodo(PermModo $permmodo)
    {
        $this->permmodos[] = $permmodo;

        return $this;
    }

    /**
     * Remove permmodo.
     *
     * @param PermModo $permmodo
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removePermmodo(PermModo $permmodo)
    {
        return $this->permmodos->removeElement($permmodo);
    }

    /**
     * Get permmodos.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPermmodos()
    {
        return $this->permmodos;
    }

    /**
     * Add user
     *
     * @param User $user
     *
     * @return PermModoProfil
     */
    public function addUser(User $user)
    {
        $this->users[] = $user;

        return $this;
    }

    /**
     * Remove user
     *
     * @param User $user
     */
    public function removeUser(User $user)
    {
        $this->users->removeElement($user);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUsers()
    {
        return $this->users;
    }
}
