<?php

namespace App\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Projectcomment
 *
 * @ORM\Entity
 * @ORM\Table(name="projectcomment")
 * @ORM\HasLifecycleCallbacks
 */
class Projectcomment
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $name;

    /**
    * @var string
    *
    * @ORM\Column(name="description", type="text", nullable=true)
    */
    private $description;

    /**
     * @ORM\Column(name="submit", type="datetime")
     */
    private $submit;   

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="projectcomments")
     * @ORM\JoinColumn(nullable=true)
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="Projecttask", inversedBy="projectcomments")
     * @ORM\JoinColumn(nullable=false)
     */
    private $projecttask;



    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set name
     *
     * @param string $name
     *
     * @return Projectcomment
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Set description
     *
     * @param string $description
     *
     * @return Projectcomment
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set submit
     *
     * @param \DateTime $submit
     *
     * @return Projectcomment
     */
    public function setSubmit($submit)
    {
        $this->submit = $submit;

        return $this;
    }

    /**
     * Get submit
     *
     * @return \DateTime
     */
    public function getSubmit()
    {
        return $this->submit;
    }

    /**
     * Set user
     *
     * @param User $user
     *
     * @return Projectcomment
     */
    public function setUser(User $user = null)
    {
        $this->user = $user;

        return $this;
    }

    /**
     * Get user
     *
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Set projecttask
     *
     * @param Projecttask $projecttask
     *
     * @return Projectcomment
     */
    public function setProjecttask(Projecttask $projecttask)
    {
        $this->projecttask = $projecttask;

        return $this;
    }

    /**
     * Get projecttask
     *
     * @return Projecttask
     */
    public function getProjecttask()
    {
        return $this->projecttask;
    }
}
