<?php
namespace App\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;


use Doctrine\ORM\EntityRepository;

class GroupType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder->add('submit',
            SubmitType::class, array(
                "label"       => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"        => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            )
        );

        if($options["portal_activate"]) {
            $choices=array("oui" => "1","non" => "0");

            if(!$options["fgall"]) {
                $builder->add("fgcanshare",
                    ChoiceType::class,array(
                        "label"       =>"Groupe de Travail",
                        'disabled'    => ($options["mode"]=="delete"||$options["access"]=="user"?true:false),
                        "choices"     => $choices
                    )
                ); 

                $builder->add('pagetemplate',
                    EntityType::class,[
                        "class"        => "App\Entity\Page",
                        "label"        => "Modèle de Page pour l'accueil du groupe",
                        "required"     => false,
                        "choice_label" => "name",
                        "query_builder"=> function (EntityRepository $er)  { 
                            return $er->createQueryBuilder('page')->where('page.parentfor=:parentfor')->setParameter('parentfor', 'group');
                        },
                        "disabled"    => ($options["mode"]=="delete"?true:false),
                        "attr"         => array("readonly" => ($options["mode"]=="delete"?true:false))
                ]);
                
                
                if($options["access"]=="config" || $options["mode"] == "update") {
                    $builder->add('owner',
                    Select2EntityType::class, array(
                        'label' => "Propriétaire",
                        'disabled' => ($options["mode"]=="delete"?true:false),
                        "required"    => false,
                        'multiple' => false,
                        'remote_route' => 'app_core_'.$options["access"].'_user_ajax_selectlist',
                        'class' => 'App\Entity\User',
                        'primary_key' => 'id',
                        'text_property' => 'username',
                        'minimum_input_length' => 2,
                        'page_limit' => 10,
                        'allow_clear' => true,
                        'delay' => 250,
                        'cache' => false,
                        'cache_timeout' => 60000, // if 'cache' is true
                        'language' => 'fr',
                        'placeholder' => 'Selectionner un propriétaire',
                    ));
                }
                
            }

            if($options["access"]=="config") {
                $builder->add('email',
                    EmailType::class, array(
                        "label"       =>"Mail",
                        "disabled"    => ($options["mode"]=="delete"?true:false),
                        "required"    => false,
                    )
                );

                $builder->add("fgcancreatepage",
                    ChoiceType::class,array(
                        "label"       =>"Permission de créer des Pages",
                        'disabled'    => ($options["mode"]=="delete"?true:false),
                        "choices"     => $choices
                    )
                );             

                $builder->add("fgcancreatecalendar",
                    ChoiceType::class,array(
                        "label"       =>"Permission de créer des Calendriers",
                        'disabled'    => ($options["mode"]=="delete"?true:false),
                        "choices"     => $choices
                    )
                );             

                $builder->add("fgcancreateblog",
                    ChoiceType::class,array(
                        "label"       =>"Permission de créer des Blogs",
                        'disabled'    => ($options["mode"]=="delete"?true:false),
                        "choices"     => $choices
                    )
                );   

                $builder->add("fgcancreateproject",
                    ChoiceType::class,array(
                        "label"       =>"Permission de créer des Projets",
                        'disabled'    => ($options["mode"]=="delete"?true:false),
                        "choices"     => $choices
                    )
                );   

                $builder->add('pages', Select2EntityType::class, [
                    'label'                 => 'Afficher les Pages',
                    'class'                 => 'App\Entity\Page',
                    'multiple'              => true,
                    'remote_route'          => 'app_portal_config_ajax_page_seleclist',
                    'primary_key'           => 'id',
                    'text_property'         => 'name',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des pages',                        
                ]);  
                                
                $builder->add('items', Select2EntityType::class, [
                    'label'                 => 'Afficher les Items',
                    'class'                 => 'App\Entity\Item',
                    'multiple'              => true,
                    'remote_route'          => 'app_portal_config_ajax_item_seleclist',
                    'primary_key'           => 'id',
                    'text_property'         => 'title',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des items',                        
                ]);   
                
                $builder->add('alerts', Select2EntityType::class, [
                    'label'                 => 'Afficher les Annonces',
                    'class'                 => 'App\Entity\Alert',
                    'multiple'              => true,
                    'remote_route'          => 'app_portal_config_ajax_alert_seleclist',
                    'primary_key'           => 'id',
                    'text_property'         => 'title',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des annonces',                        
                ]);    

                $builder->add('calendars', Select2EntityType::class, [
                    'label'                 => 'Afficher les Calendriers',
                    'class'                 => 'App\Entity\Calendar',
                    'multiple'              => true,
                    'remote_route'          => 'app_portal_config_ajax_calendar_seleclist',
                    'primary_key'           => 'id',
                    'text_property'         => 'name',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des calendriers',                        
                ]);   
                
                $builder->add('blogs', Select2EntityType::class, [
                    'label'                 => 'Afficher les Blogs',
                    'class'                 => 'App\Entity\Blog',
                    'multiple'              => true,
                    'remote_route'          => 'app_portal_config_ajax_blog_seleclist',
                    'primary_key'           => 'id',
                    'text_property'         => 'name',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des blogs',                        
                ]);              

                $builder->add('projects', Select2EntityType::class, [
                    'label'                 => 'Afficher les Projets',
                    'class'                 => 'App\Entity\Project',
                    'multiple'              => true,
                    'remote_route'          => 'app_portal_config_ajax_project_seleclist',
                    'primary_key'           => 'id',
                    'text_property'         => 'name',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des projets',                        
                ]);              


                $builder->add('fluxs', Select2EntityType::class, [
                    'label'                 => 'Afficher les Flux',
                    'class'                 => 'App\Entity\Flux',
                    'multiple'              => true,
                    'remote_route'          => 'app_portal_config_ajax_flux_seleclist',
                    'primary_key'           => 'id',
                    'text_property'         => 'title',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des flux',                        
                ]);     
                

                $builder->add('notices', Select2EntityType::class, [
                    'label'                 => 'Afficher les Chartes',
                    'class'                 => 'App\Entity\Notice',
                    'multiple'              => true,
                    'remote_route'          => 'app_portal_config_ajax_notice_seleclist',
                    'primary_key'           => 'id',
                    'text_property'         => 'title',
                    'minimum_input_length'  => 0,
                    'page_limit'            => 100,
                    'allow_clear'           => true,
                    'delay'                 => 250,
                    'cache'                 => false,
                    'cache_timeout'         => 60000,
                    'language'              => 'fr',
                    'placeholder'           => 'Selectionner des chartes',                        
                ]); 
            }             
        }

        $builder->add('idicon', HiddenType::class,['mapped'=> false,'data' => $options["idicon"]]);

        $builder->add('color', TextType::class, [
            'label'         => "Couleur",
            'required'      => false,
            'attr'          => array("class" => "pick-a-color")              
        ]);

        $builder->add("description", TextareaType::class, [
            "label"         => 'Description',
            "required"      => false,
            "disabled"      => ($options["mode"]=="delete"?true:false),
            "attr"          => array("rows" => '4')
        ]);          

        if(!$options["updatelimite"]) {
            $builder->add('label',
                TextType::class, array(
                    "label"       =>"Label",
                    "disabled"    => ($options["mode"]=="delete"?true:false),
                )
            );   
            
            $choices=array("oui" => "1","non" => "0");
            $builder->add("fgopen",
                ChoiceType::class,array(
                    "label"       =>"Groupe Ouvert (inscription possible par les utilisateurs)",
                    'disabled'    => ($options["mode"]=="delete"?true:false),
                    "choices"     => $choices
                )
            ); 

            // Si masteridentity = LDAP alors on demande le filtre des utilisateurs qui appartiennent à ce groupe
            if($options["masteridentity"]=="LDAP"&&$options["access"]=="config") 
            {
                $choices=array("oui" => "1","non" => "0");
                $builder->add("fgassoc",
                    ChoiceType::class,array(
                        "mapped"      => false,
                        "label"       => "Groupe associé à l'annuaire ?",
                        'disabled'    => ($options["mode"]=="delete"?true:false),
                        "choices"     => $choices
                    )
                ); 

                $builder->add('ldapfilter',
                    TextType::class, array(
                        "label"       => "Filtre LDAP des utilisateurs",
                        "label_attr"  => array("id" => "label_group_ldapfilter"),                    
                        "disabled"    => ($options["mode"]=="delete"?true:false),
                        "required"    => false,
                    )
                );   
            }        

            if($options["masteridentity"]=="SSO") 
            {
                $choices=array("oui" => "1","non" => "0");
                $builder->add("fgassoc",
                    ChoiceType::class,array(
                        "mapped"      => false,
                        "label"       => "Groupe associé à des attributs SSO ?",
                        'disabled'    => ($options["mode"]=="delete"?true:false),
                        "choices"     => $choices
                    )
                ); 

                $builder->add('attributes',
                    TextareaType::class, array(
                        "label"       => "Attributs SSO des utilisateurs",
                        "label_attr"  => array("id" => "label_group_attributes"),
                        "disabled"    => ($options["mode"]=="delete"?true:false),
                        "required"    => false,
                    )
                );   
            }          
        }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'App\Entity\Group',
            'mode' => "string",
            'access' => "string",
            'masteridentity' => "string",
            'portal_activate' => "boolean",
            'updatelimite' => "boolean",
            'fgall' => "boolean",
            'idicon' => "string",
        ));
    }
}
