#!/bin/bash

# Installer Ninegate = apt get install eole-ninegate
echo " == Installation de ninegate"
apt-get install eole-ninegate ninegate-apps --reinstall

# Recharger les dicos
echo " == Recharger les dicos"
python -c "from creole.reconfigure import templates;templates()" > /dev/null

# Désactiver draaf
echo " == Désactiver eole-draaf"
CreoleSet activer_draaf non > /dev/null 2>&1
if [ -f "/var/www/html/eportail/local/config/external.php" ] 
then
    mv /var/www/html/eportail/local/config/external.php /root/migration/backup/eportail-external.php
fi

cp -f /root/migration/ldap.php /var/www/html/eportail/local/config/ldap.php

# Activer Ninegate
echo " == Activer ninegate"
CreoleSet activer_ninegate oui > /dev/null 2>&1
CreoleSet ninegate_masteridentity SQL > /dev/null 2>&1
CreoleSet ninegate_mode_auth CAS > /dev/null 2>&1

CreoleSet ninegate_syncldap oui > /dev/null 2>&1
CreoleSet ninegate_pwdadmin cadoles > /dev/null 2>&1
CreoleSet ninegate_organization draaf > /dev/null 2>&1
CreoleSet ninegate_niveau01branche services > /dev/null 2>&1
CreoleSet ninegate_niveau02branche establishments > /dev/null 2>&1
CreoleSet ninegate_niveau01name DRAAF > /dev/null 2>&1
CreoleSet ninegate_niveau01siren 130007107 > /dev/null 2>&1

CreoleSet ninegate_niveau01label Département > /dev/null 2>&1
CreoleSet ninegate_niveau01labels Départements > /dev/null 2>&1
CreoleSet ninegate_niveau02view oui > /dev/null 2>&1
CreoleSet ninegate_niveau02label Localisation > /dev/null 2>&1
CreoleSet ninegate_niveau02labels Localisations > /dev/null 2>&1

CreoleSet ninegate_moderegistration byadmin > /dev/null 2>&1

CreoleSet ninegate_noreply noreply@ac-dijon.fr > /dev/null 2>&1
CreoleSet ninegate_smtphost smtp.ac-dijon.fr > /dev/null 2>&1
CreoleSet ninegate_smtpport 25 > /dev/null 2>&1
CreoleSet ninegate_smtpencryption null > /dev/null 2>&1
CreoleSet ninegate_smtpauthmode null > /dev/null 2>&1

# Désactiver cron ninegate
CreoleSet ninegate_activate_cron non > /dev/null 2>&1

# Nettoyage eole-draaf
echo " == Nettoyage eole-draaf"
rm -rf /usr/share/eole/postservice/90-draaf
if [ -d "/var/www/html/draaf" ] 
then
    mv /var/www/html/draaf /root/migration/backup/
fi

# Reconfigure
echo " == genconfig = configurez ninegate"






