<?php

namespace Cadoles\CASBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Security\Core\Authentication\Token\UsernamePasswordToken;
use Symfony\Component\Security\Http\Event\InteractiveLoginEvent;
use Symfony\Component\EventDispatcher\EventDispatcher;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

use Cadoles\CoreBundle\Entity\User;
use Cadoles\CoreBundle\Entity\Group;

class SecurityController extends Controller
{
    public function metadataAction()
    {
        return parent::metadataAction();
    }

   public function loginAction(Request $request)
    {
        // Récupération de la cible de navigation
        $redirect = $request->get("redirect");

        // Masteridentity
        $masteridentity=$this->getParameter("masteridentity");

        // Init Client CAS
        \phpCAS::setDebug("/var/log/phpcas/phpCAS-ninegate.log");
        if($this->getParameter("cas_type")=="client")
            @\phpCAS::client(CAS_VERSION_2_0, $this->getParameter('cas_host'), $this->getParameter('cas_port'), is_null($this->getParameter('cas_path')) ? '' : $this->getParameter('cas_path'), false);
        else
            @\phpCAS::proxy(CAS_VERSION_2_0, $this->getParameter('cas_host'), $this->getParameter('cas_port'), is_null($this->getParameter('cas_path')) ? '' : $this->getParameter('cas_path'), false);
        \phpCAS::setNoCasServerValidation();


        // Authentification
        \phpCAS::forceAuthentication();

        // Récupération UID
        $username = \phpCAS::getUser();

        // Récupération Attribut
        $attributes = \phpCAS::getAttributes();

        // Init
        $email = "";
        $lastname = "";
        $firstname = "";

        // Rechercher l'utilisateur
        $em = $this->getDoctrine()->getManager();
        if(isset($attributes[$this->getParameter('user_attr_cas_username')]))
            $username = $attributes[$this->getParameter('user_attr_cas_username')];

        if(isset($attributes[$this->getParameter('user_attr_cas_mail')]))
            $email = $attributes[$this->getParameter('user_attr_cas_mail')];

        if(isset($attributes[$this->getParameter('user_attr_cas_lastname')]))
            $lastname = $attributes[$this->getParameter('user_attr_cas_lastname')];

        if(isset($attributes[$this->getParameter('user_attr_cas_firstname')]))
            $firstname = $attributes[$this->getParameter('user_attr_cas_firstname')];

        $user = $em->getRepository('CadolesCoreBundle:User')->findOneBy(array("username"=>$username));
        $exists = $user ? true : false;

        if (!$exists) {
            if($masteridentity=="SQL") {
                // C'est pas normal que l'on puisse se connecter alors que l'utilisateur n'est pas connu en base
                // La base étant le maitre de l'identité
                throw $this->createNotFoundException('Permission denied');
            }

            if($masteridentity=="LDAP") {
                // Normalement la synchronisation des comptes aurait du générer le compte en base c'est donc pas normal
                // Peut-être juste relancer une synchronisation
                // On tente une synchronisation via methode SSO
                $masteridentity="SSO";
                // throw $this->createNotFoundException('Permission denied. Need to synchronize LDAP ? Contact your administrator');
            }

            if($masteridentity=="SSO") {
                if(empty($email)) $email = $username."@nomail.com";

                // On s'assure qu'il n'y a pas déjà un utilisateur avec le même mail
                $usermail = $em->getRepository('CadolesCoreBundle:User')->findOneBy(array("email"=>$email));
                if($usermail) {
                    return $this->render('CadolesCoreBundle:Registration:info.html.twig', [
                        'useheader'         => true,
                        'usemenu'           => false,
                        'usesidebar'        => false,                   
                        'infotitle'         => "Première connexion",
                        'info'              => "Votre compte ne peut être activé car votre adresse mel est déjà utilisée par un autre compte utilisateur.<br>Nous sommes désolés du désagrément et vous invitons à contacter un administrateur.",
                        'mode'              => "error",
                        'redirectto'         => "",
                    ]);
                }

                // Là c'est normal que potentiellement il n'existe pas il faut donc l'autogénérer
                $user = new User();

                // On calcule le niveau01 de l'utilisateur
                $niveau01=$em->getRepository('CadolesCoreBundle:Niveau01')->calculateNiveau01($attributes);
                if(!$niveau01) {
                    $niveau01=$em->getRepository('CadolesCoreBundle:Niveau01')->findAll()[0];
                    //throw $this->createNotFoundException('Permission denied. No Organisation Niveau 01 match');
                }

                $user->setUsername($username);
                $user->setEmail($email);
                $user->setLastname($lastname);
                $user->setFirstname($firstname);

                $user->setPassword("CASPWD-".$username);
                $user->setSalt("CASPWD-".$username);

                $user->setNiveau01($niveau01);
                $user->setSiren($niveau01->getSiren());
                $user->setSiret("");

                $user->setAvatar("noavatar.png");
                $user->setVisible(true);
                $user->setAuthlevel("simple");
                $user->setBelongingpopulation("agent");
                $user->setRole("ROLE_USER");

                if(in_array($username,$this->getParameter("ldap_usersadmin")))
                    $user->setRole("ROLE_ADMIN");

                $em->persist($user);
                $em->flush();

                // Génération auto des groupes
                $this->submitGroup($attributes);

                // On calcule les groupes de l'utilisateur
                $user=$em->getRepository('CadolesCoreBundle:Group')->calculateGroup($user,$attributes);

            }
        }
        else {
            // Mise à jour des valeurs uniquement si le maitre de l'identité est le SSO
            if($masteridentity=="SSO") {
                // On calcule le niveau01 de l'utilisateur
                $niveau01=$em->getRepository('CadolesCoreBundle:Niveau01')->calculateNiveau01($attributes);
                if(!$niveau01)
                    throw $this->createNotFoundException('Permission denied. No Organisation Niveau 01 match');

                // On s'assure que le niveau 02 appartient bien au niveau 01 calculé
                $sameniveau01=(!is_null($user->getNiveau02())&&$niveau01==$user->getNiveau02()->getNiveau01());

                $user->setLastname($lastname);
                $user->setFirstname($firstname);
                $user->setEmail($email);
                if(!$sameniveau01) {
                    $user->setNiveau01($niveau01);
                    $user->setNiveau02(null);
                }
                if(in_array($username,$this->getParameter("ldap_usersadmin")))
                    $user->setRole("ROLE_ADMIN");

                // Génération auto des groupes
                $this->submitGroup($attributes);

                // On calcule les groupes de l'utilisateur
                $user=$em->getRepository('CadolesCoreBundle:Group')->calculateGroup($user,$attributes);


                $em->persist($user);
                $em->flush();
            }
        }

        // Sauvegarde des attributes en session
        $this->get('session')->set('attributes', $attributes);

        // Sauvegarde des ssoitems en session
        $ssoitems=[];
        if($this->getParameter('ssosynchroitem')) {
            $user_attr_cas_item=$this->getParameter('user_attr_cas_item');
            if(array_key_exists($user_attr_cas_item,$attributes)) {
                if(!is_array($attributes[$user_attr_cas_item])) {
                    $attributes[$user_attr_cas_item]=[$attributes[$user_attr_cas_item]];
                }
                $ssoitems=$attributes[$user_attr_cas_item];
            }
        }
        $this->get('session')->set('ssoitems', $ssoitems);

        // Autoconnexion
        // Récupérer le token de l'utilisateur
        $token = new UsernamePasswordToken($user, null, "main", $user->getRoles());
        $this->get("security.token_storage")->setToken($token);

        // Simuler l'evenement de connexion
        $event = new InteractiveLoginEvent($request, $token);
        $dispatcher = new EventDispatcher();
        $dispatcher->dispatch("security.interactive_login", $event);

        // On enregistre sa visite
        $user->setVisitedate(new \DateTime());
        $user->setVisitecpt($user->getVisitecpt()+1);
        $em->persist($user);
        $em->flush();

        if($redirect)
            return $this->redirect($redirect);
        else
            return $this->redirect($this->generateUrl('cadoles_core_home'));
    }

    public function logoutAction() {
        // Init Client CAS
        \phpCAS::setDebug(false);
        if($this->getParameter("cas_type")=="client")
            @\phpCAS::client(CAS_VERSION_2_0, $this->getParameter('cas_host'), $this->getParameter('cas_port'), is_null($this->getParameter('cas_path')) ? '' : $this->getParameter('cas_path'), true);
        else
            @\phpCAS::proxy(CAS_VERSION_2_0, $this->getParameter('cas_host'), $this->getParameter('cas_port'), is_null($this->getParameter('cas_path')) ? '' : $this->getParameter('cas_path'), true);
        \phpCAS::setNoCasServerValidation();


        // Logout
        $url=$this->generateUrl('cadoles_core_home', array(), UrlGeneratorInterface::ABSOLUTE_URL);
        \phpCAS::logout(array("service"=>$url));
    }

    public function testAction() {
        $em = $this->getDoctrine()->getManager();

        // Init Client CAS
        \phpCAS::setDebug("/var/log/phpcas/phpCAS-ninegate.log");
        if($this->getParameter("cas_type")=="client")
            @\phpCAS::client(CAS_VERSION_2_0, $this->getParameter('cas_host'), $this->getParameter('cas_port'), is_null($this->getParameter('cas_path')) ? '' : $this->getParameter('cas_path'), false);
        else
            @\phpCAS::proxy(CAS_VERSION_2_0, $this->getParameter('cas_host'), $this->getParameter('cas_port'), is_null($this->getParameter('cas_path')) ? '' : $this->getParameter('cas_path'), false);
        \phpCAS::setNoCasServerValidation();


        // Authentification
        \phpCAS::forceAuthentication();

        // Récupération UID
        $username = \phpCAS::getUser();

        // Récupération Attribut
        $attributes = \phpCAS::getAttributes();
        $user = $em->getRepository('CadolesCoreBundle:User')->findOneBy(array("username"=>$username));

        // On calcule le niveau01 de l'utilisateur
        $niveau01=$em->getRepository('CadolesCoreBundle:Niveau01')->calculateNiveau01($attributes);

        // Génération auto des groupes
        $groups=$this->submitGroup($attributes);

        // On calcule les groupes de l'utilisateur
        $user=$em->getRepository('CadolesCoreBundle:Group')->calculateGroup($user,$attributes);

        return $this->render('CadolesCASBundle:Test:test.html.twig',[
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => false,
            'attributes'        => $attributes,
            'user'              => $user,
            'username'          => $username,
            'niveau01'          => $niveau01,
        ]);

    }

    private function submitGroup($attributes) {
        $em = $this->getDoctrine()->getManager();

        if(!$this->getParameter('ssosynchrogroup'))
            return null;

        $user_attr_cas_group=$this->getParameter('user_attr_cas_group');

        // Si l'utilisateur possège l'attribut groupe dans ses attributs
        if(array_key_exists($user_attr_cas_group,$attributes)) {
            if(!is_array($attributes[$user_attr_cas_group])) {
                $attributes[$user_attr_cas_group]=[$attributes[$user_attr_cas_group]];
            }

            foreach($attributes[$user_attr_cas_group] as $ssogroup) {
                $basedn=$this->getParameter('ldap_basedn');
                $name=$ssogroup;
                if($basedn!="") {
                    // Si présence du basedn dans le nom du groupe = nous sommes en présence d'un DN = on récupere donc comme nom que son cn
                    if(stripos($name,$basedn)!==false) {
                        $tbname=explode(",",$name);
                        $tbname=explode("=",$tbname[0]);
                        $name=$tbname[1];
                    }
                }
                

                // Recherche du groupe
                $group=$em->getRepository("CadolesCoreBundle:Group")->findOneBy(["label"=>$name]);
                if(!$group) {
                    $group=new Group();
                    $group->setLabel($name);
                    $group->setFgcancreatepage(false);
                    $group->setFgcancreateblog(false);
                    $group->setFgcancreatecalendar(false);
                    $group->setFgcancreateproject(false);
                    $group->setFgcanshare(false);
                    $group->setFgopen(false);
                    $group->setFgall(false);
                }

                $group->setAttributes('{"'.$user_attr_cas_group.'":"'.$ssogroup.'"}');
                $group->setFgtemplate(false);

                $em->persist($group);
                $em->flush();

            }
        }

    }

    function imapunreadAction() {
        if($this->getParameter("active_imapunread")&&$this->getParameter("cas_type")=="proxy") {
            $ip=$this->getParameter("imapundread_ip");

            // Init Client CAS
            \phpCAS::setDebug("/var/log/phpcas/phpCAS-ninegate.log");
            @\phpCAS::proxy(CAS_VERSION_2_0, $this->getParameter('cas_host'), $this->getParameter('cas_port'), is_null($this->getParameter('cas_path')) ? '' : $this->getParameter('cas_path'), false);
            \phpCAS::setNoCasServerValidation();
            \phpCAS::forceAuthentication();
        
            
            $pt= \phpCAS::retrievePT('imap://'.$ip,$t,$f);
            $a = \phpCAS::serviceMail("{".$ip.":993/imap/ssl/novalidate-cert}","imap://".$ip,0, $errc,$err,$pt);
            $unseen = imap_status($a, "{".$ip.":993/imap/ssl/novalidate-cert}INBOX", SA_UNSEEN);
            
            $count=$unseen->unseen;
            $response = new Response(json_encode($count));    
        }
        else 
            $response = new Response(json_encode(""));    

        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    }
}
