<?php
namespace Cadoles\CoreBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\Form\Extension\Core\Type\RepeatedType;
use Symfony\Component\Form\Extension\Core\Type\PasswordType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\ButtonType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;


use Doctrine\ORM\EntityRepository;
use Doctrine\ORM\EntityManager;
use Doctrine\ORM\Query\Expr\Join;

class Niveau02Type extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $session = new Session();
        $builder->add('submit',
            SubmitType::class, array(
                "label"       => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"        => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            )
        );

        if($options["user"]->getRole()=="ROLE_MODO") {
            $userid=$options["user"]->getId();
            $builder->add('niveau01',
                EntityType::class,
                array(
                    "class"         => "CadolesCoreBundle:Niveau01",
                    "label"         => $session->get('labelniveau01'),
                    "choice_label"  => "label",
                    "disabled"      => ($options["mode"]!="submit"?true:false),
                    "attr"          => array("class" => "form-control", "style" => "margin-bottom:15px","readonly" => ($options["mode"]!="submit"?true:false)),
                    "query_builder"=> function (EntityRepository $er) use($userid) { 
                        $result=$er->createQueryBuilder("table")->innerJoin("CadolesCoreBundle:UserModo", "usermodo", Join::WITH, "table.id = usermodo.niveau01");
                        $result->andWhere("usermodo.user = :userid");
                        $result->setParameter('userid', $userid);
                        return $result;
                    },                  
                )
            ); 
        }
        else {
            $builder->add('niveau01',
                EntityType::class,
                array(
                    "class"         => "CadolesCoreBundle:Niveau01",
                    "label"         => $session->get('labelniveau01'),
                    "choice_label"  => "label",
                    "disabled"      => ($options["mode"]!="submit"?true:false),
                    "attr"          => array("class" => "form-control", "style" => "margin-bottom:15px","readonly" => ($options["mode"]!="submit"?true:false))
                )
            ); 
        }

        $builder->add('label',
            TextType::class, array(
                "label"       =>"Label",
                "disabled"    => ($options["mode"]=="delete"?true:false),
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
            )
        );

        $builder->add('siret',
            TextType::class, array(
                "label"       =>"SIRET",
                "disabled"    => ($options["mode"]=="delete"?true:false),
                "required"    => false,
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px")
            )
        );  
        
        $builder->add('postaladress',
            TextareaType::class, array(
                "label"       => "Adresse",
                "required"    => false,
                "disabled"    => ($options["mode"]=="delete"?true:false),
                "attr"        => array("class" => "form-control", "style" => "margin-bottom:15px; height:100px")
            )
        );          
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Cadoles\CoreBundle\Entity\Niveau02',
            'mode' => "string",
            'user' => 'Cadoles\CoreBundle\Entity\User',
        ));
    }
}
