<?php

namespace Cadoles\PortalBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Tetranz\Select2EntityBundle\Form\Type\Select2EntityType;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Cadoles\CoreBundle\Form\Type\IconChoiceType;

class PageUpdateWidgetType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('submit',SubmitType::class, [
                "label"         => ($options["mode"]=="delete"?"Confirmer la Suppression":"Valider"),
                "attr"          => ($options["mode"]=="delete"?array("class" => "btn btn-danger"):array("class" => "btn btn-success"))
            ])

            ->add('name', TextType::class, [
                'label'         => 'Nom'
            ])  
            
            ->add('roworder', IntegerType::class, [
                'label'         => 'Ordre',
            ])                

            ->add('fonticon', IconChoiceType::class, [
                'label' => 'Icône',
                'required' => false,
            ])

            ->add('maxwidth', IntegerType::class, [
                'label'         => "Largeur maximum (0 pour largeur de l'écran)",
            ])

            ->add('fgpreference', ChoiceType::class, [
                "label"         => "Permettre aux utilisateurs de préserver leurs préférences d'affichage",
                "choices" => ["Oui"=> 1,"Non"=> 0],                
                "disabled"      => ($options["mode"]=="delete"?true:false),
            ])       

            ->add('template', HiddenType::class, [
                'label'         => 'Template',
                'required'      => false
            ]);   
            
            if($options["access"]=="config"&&$options["for"]!="group") {
                $builder
                    ->add('roles', ChoiceType::class, [
                        "label"         => 'Visible pour les Rôles',
                        "choices" => [
                            "Visiteur"              => 'ROLE_ANONYME',
                            "Utilisateur"           => 'ROLE_USER',
                            "Animateur de Groupe"   => 'ROLE_ANIM',
                            "Modérateur"            => 'ROLE_MODO',
                            "Administateur"         => 'ROLE_ADMIN',
                        ],                
                        "multiple"      => true,
                        "expanded"      => true,
                        "disabled"      => ($options["mode"]=="delete"?true:false),
                    ])

                    ->add('groups', Select2EntityType::class, [
                        'label'                 => 'Visible pour les Groupes',
                        'class'                 => 'CadolesCoreBundle:Group',
                        'text_property'         => 'label',
                        'multiple'              => true,
                        'remote_route'          => 'cadoles_core_ajax_group_list',
                        'primary_key'           => 'id',
                        'text_property'         => 'label',
                        'minimum_input_length'  => 0,
                        'page_limit'            => 100,
                        'allow_clear'           => true,
                        'delay'                 => 250,
                        'cache'                 => false,
                        'cache_timeout'         => 60000,
                        'language'              => 'fr',
                        'placeholder'           => 'Selectionner un groupe',                        
                    ])
                    
                    ->add('user', Select2EntityType::class, [
                        'label' => "Propriétaire",
                        'disabled' => ($options["mode"]=="delete"?true:false),
                        "required"    => false,
                        'multiple' => false,
                        'remote_route' => 'cadoles_core_config_user_ajax_selectlist',
                        'class' => 'Cadoles\coreBundle\Entity\User',
                        'primary_key' => 'id',
                        'text_property' => 'username',
                        'minimum_input_length' => 2,
                        'page_limit' => 10,
                        'allow_clear' => true,
                        'delay' => 250,
                        'cache' => false,
                        'cache_timeout' => 60000, // if 'cache' is true
                        'language' => 'fr',
                        'placeholder' => 'Selectionner un propriétaire',
                        'attr' => array("class" => "form-control", "style" => "margin-bottom:15px")
                    ]);
            }
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults([
            'data_class' => 'Cadoles\PortalBundle\Entity\Page',
            'access' => 'string',
            'mode' => 'string',
            'for' => 'string'
        ]);
    }
}
