<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\Form\FormError;
use Doctrine\Persistence\ManagerRegistry;

use App\Entity\Page;
use App\Form\PagetemplateSubmitType;
use App\Form\PageUpdateWidgetType;

class PagetemplateController extends AbstractController
{
    private $nameentity="Page";
    private $labelentity="App\Entity\Page";
    private $routeprimary="app_portal_config_pagetemplate";

    public function list()
    {
        return $this->render('Pagetemplate\list.html.twig',[
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => true,
        ]);
    }

    public function ajaxlist($access="config", Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }
        
        $start=$request->query->get('start');
        $length= $request->query->get('length');
        $search= $request->query->get('search');
        $draw= $request->query->get('draw');
        $order= $request->query->get('order');

        // Query de base
        $qbase=$em->getManager()->createQueryBuilder()->from($this->labelentity,'table');
        $qsearch=$em->getManager()->createQueryBuilder()->from($this->labelentity,'table');
        
        $qbase->where("table.user is null");
        $qbase->andWhere('table.parentfor is not null') ;
        $qsearch->where("table.user is null");
        $qsearch->andWhere('table.parentfor is not null') ;
        $qsearch->andwhere('table.id LIKE :value OR table.name LIKE :value OR table.parentfor LIKE :value');
        $qsearch->setParameter("value", "%".$search["value"]."%");                  

        // Nombre total d'enregistrement
        $total = $qbase->select('COUNT(table)')->getQuery()->getSingleScalarResult();
        

        // Nombre d'enregistrement filtré
        if($search["value"]=="")
            $totalf = $total;
        else
            $totalf= $qsearch->select('COUNT(table)')->getQuery()->getSingleScalarResult();
        

        // Parcours des Enregistrement
        if($search["value"]=="")
            $qb = $qbase->select('table');
        else
            $qb = $qsearch->select('table');

        // Order
        switch($order[0]["column"]) {
            case 1 : 
            $qb->orderBy('table.roworder',$order[0]["dir"]);
            break;
            case 2 : 
            $qb->orderBy('table.name',$order[0]["dir"]);
            break;
            case 3 : 
            $qb->orderBy('table.parentfor',$order[0]["dir"]);
            break;            
        }

        // Execution de la requete d'affichage
        $datas=$qb->setFirstResult($start)->setMaxResults($length)->getQuery()->getResult();

        // Construction du tableau de retour
        $output = array(
            'draw' => $draw,
            'recordsFiltered' => $totalf,
            'recordsTotal' => $total,
            'data' => array(),
        );
        foreach($datas as $data) {

            $route=str_replace("_config_","_".$access."_",$this->routeprimary);
            $action = "";
            $action.="<a href='".$this->generateUrl($route.'_update', array('id'=>$data->getId()))."' title='Configurer'><i class='fa fa-cog fa-fw fa-2x'></i></a>";
            $action.="<a href='".$this->generateUrl($route.'_view', array('id'=>$data->getId()))."'><i class='fa fa-eye fa-fw fa-2x' title='Afficher'></i></a>";
            $action.="<a href='".$this->generateUrl($route.'_delete', array('id'=>$data->getId()))."' data-method='delete' title='Supprimer'><i class='fa fa-trash fa-fw fa-2x'></i></a>";

            array_push($output["data"],[
                $action,
                $data->getRoworder(),
                $data->getName(),
                $data->getParentfor(),
            ]);
        }

        // Retour
        return new Response(json_encode($output), 200);
    }  

    private function entityForm($access="config", Page $entity, ManagerRegistry $em)
    {
        $route=str_replace("_config_","_".$access."_",$this->routeprimary);

        if ($em->getManager()->contains($entity)) {
            return $this->createForm(PageUpdateWidgetType::class, $entity, [
                "mode"   => "update",
                "access" => $access,
                "for" => $entity->getParentfor(),
            ]);
        }
        else {
            return $this->createForm(PagetemplateSubmitType::class, $entity, [
                "mode"   => "update",
                "access" => $access
            ]);
        }
    }

    public function submit($access="config", Request $request, ManagerRegistry $em)
    {
        if($access=="user"&&!$request->getSession()->get('cancreatepage'))
            throw $this->createNotFoundException('Permission denied');

        $pagecategory=$em->getRepository("App\Entity\Pagecategory")->find(2);
        $entity = new Page();
        $entity->setMaxwidth(0);
        $entity->setRoworder(0);
        $entity->getFgpreference(true);
        $entity->setParentfor("user");
        $entity->setPagecategory($pagecategory);

        $form   = $this->entityForm($access,$entity,$em);
        $form->handleRequest($request);

        // Sur erreur
        $this->getErrorForm(null,$form,$request,$entity,"submit",$em);

        if ($form->get('submit')->isClicked() && $form->isValid()) {
            if($access=="user") $entity->setUser($this->getUser());

            $em->getManager()->persist($entity);
            $em->getManager()->flush();

            $route=str_replace("_config_","_".$access."_",$this->routeprimary);
            return $this->redirect($this->generateUrl($route.'_update',["id"=>$entity->getId()]));
        }

        return $this->render('Pagetemplate\submit.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),     
            'maxwidth'          => ($access=="user"),     
            'entity'            => $entity,
            'mode'              => "submit",
            'access'            => $access,
            'form'              => $form->createView()
        ]);
    }

    public function update($id, $access="config", Request $request, ManagerRegistry $em)
    {
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');
     
        
        // Création du formulaire
        $form = $this->entityForm($access,$entity,$em);
        $form->handleRequest($request);

        if ($form->get('submit')->isClicked() && $form->isValid()) {
            $em->getManager()->flush();

            return $this->redirect($this->generateUrl($this->routeprimary.'_view',["id"=>$id]));
        }

        return $this->render($this->nameentity.'\updatewidget.html.twig', [
            'useheader'         => true,
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),    
            'maxwidth'          => ($access=="user"),                     
            'entity'            => $entity,
            'access'            => $access,
            'mode'              => "updatetemplate",
            'form'              => $form->createView(),
        ]);
    }

    public function delete($id, $access="config", Request $request, ManagerRegistry $em)
    {
        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');
    
        // On s'assure que l'utilisateur à la permission de supprimer
        if($access=="user") {
            $em->getRepository($this->labelentity)->getPermission($this->getUser(),$entity,$cansee,$canupdate);
            if(!$canupdate) throw $this->createNotFoundException('Permission denied');
        }
 

        $error=false;
        $request->getSession()->getFlashBag()->clear();
        
        $group = $em->getRepository("App\Entity\Group")->findOneBy(["pagetemplate"=>$entity]);
        if($group ) {
            $error=true;
            $request->getSession()->getFlashBag()->add("error", "Impossible de supprimer ce modèle, il est utilisé par au moins un groupe");            
        }

        if($entity->getParentfor()=="app") {
            $error=true;
            $request->getSession()->getFlashBag()->add("error", "Vous ne pouvez pas supprimer un template de type Application");            
        }

        if(!$error) {
            // Suppression
            $em->getManager()->remove($entity);
            $em->getManager()->flush();
        } 

        // Retour
        return $this->redirect($this->generateUrl($this->routeprimary));

    }

    public function ajaxseleclist(Request $request, ManagerRegistry $em)
    {
        // S'assurer que c'est un appel ajax
        if (!$request->isXmlHttpRequest()) {
            return new JsonResponse(array('message' => 'Interdit'), 400);
        }

        $output=array();
        $page_limit=$request->query->get('page_limit');
        $q=$request->query->get('q');
        $usage=$request->query->get('usage');

        $qb = $em->getManager()->createQueryBuilder();
        $qb->select('table')->from("App\Entity\Page",'table')
           ->where('table.name LIKE :value')
           ->andWhere('table.parentfor=:usage')
           ->setParameter("value", "%".$q."%")
           ->setParameter("usage", $usage)
           ->orderBy('table.name');
        
        $datas=$qb->setFirstResult(0)->setMaxResults($page_limit)->getQuery()->getResult();
        foreach($datas as $data) {
            array_push($output,array("id"=>$data->getId(),"text"=>$data->getName()));
        }

        $response = new Response(json_encode($output));    
        $response->headers->set('Content-Type', 'application/json');      
        return $response;
    } 

    public function view($id, $access=null, Request $request, ManagerRegistry $em) {

        $entity = $em->getRepository($this->labelentity)->find($id);
        if (!$entity) throw $this->createNotFoundException('Unable to find entity.');

        // Permissions
        $canupdate = true;

        return $this->render($this->nameentity.'\viewwidget.html.twig', [
            'useheader'         => ($access=="config"),
            'usemenu'           => false,
            'usesidebar'        => ($access=="config"),                    
            'entity'            => $entity,
            'access'            => $access,
            'canupdate'         => $canupdate,
            'mode'              => "viewtemplate",
            'widgets'           => $em->getRepository("App\Entity\Widget")->getWidgetAccess($access),
            'usage'             => "config",
            'group'             => "",
            'look'              => "view",
            'selwidget'         => null,
        ]);
    }

    protected function getErrorForm($id,$form,$request,$data,$mode,$em) {
        if ($form->get('submit')->isClicked()&&$mode=="delete") {          
        }

        if ($form->get('submit')->isClicked() && ($mode=="submit" )) {
            if($data->getParentfor()=="app") {
                $tmp=$em->getRepository("App\Entity\Page")->findOneBy(["parentfor"=>"app"]);
                if($tmp) $form->addError(new FormError("Il ne peut avoir qu'un seul template de type Application"));
            }
        }

        if ($form->get('submit')->isClicked() && !$form->isValid()) {
            $errors = $form->getErrors();
            foreach( $errors as $error ) {
                $request->getSession()->getFlashBag()->add("error", $error->getMessage());
            }
        }
    }     
}
