<?php
namespace Cadoles\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="permmodoprofil")
 *
  */
class PermModoProfil
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=50, unique=true)
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity="PermModo", mappedBy="permmodoprofil", cascade={"persist"}, orphanRemoval=true)
     */
    private $permmodos;    

    /**
     * @ORM\OneToMany(targetEntity="User", mappedBy="permmodoprofil")
     */
    private $users;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->permmodos = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set id.
     *
     * @param string $id
     *
     * @return PermModoProfil
     */
    public function setId($id)
    {
        $this->id = $id;
        
        return $this;
    }

    /**
     * Set name.
     *
     * @param string $name
     *
     * @return PermModoProfil
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * Get name.
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Add permmodo.
     *
     * @param \Cadoles\CoreBundle\Entity\PermModo $permmodo
     *
     * @return PermModoProfil
     */
    public function addPermmodo(\Cadoles\CoreBundle\Entity\PermModo $permmodo)
    {
        $this->permmodos[] = $permmodo;

        return $this;
    }

    /**
     * Remove permmodo.
     *
     * @param \Cadoles\CoreBundle\Entity\PermModo $permmodo
     *
     * @return boolean TRUE if this collection contained the specified element, FALSE otherwise.
     */
    public function removePermmodo(\Cadoles\CoreBundle\Entity\PermModo $permmodo)
    {
        return $this->permmodos->removeElement($permmodo);
    }

    /**
     * Get permmodos.
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPermmodos()
    {
        return $this->permmodos;
    }

    /**
     * Add user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     *
     * @return PermModoProfil
     */
    public function addUser(\Cadoles\CoreBundle\Entity\User $user)
    {
        $this->users[] = $user;

        return $this;
    }

    /**
     * Remove user
     *
     * @param \Cadoles\CoreBundle\Entity\User $user
     */
    public function removeUser(\Cadoles\CoreBundle\Entity\User $user)
    {
        $this->users->removeElement($user);
    }

    /**
     * Get users
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getUsers()
    {
        return $this->users;
    }
}
