<?php
namespace App\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Filesystem\Filesystem;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Doctrine\ORM\EntityManagerInterface;

class PurgeRegistrationCommand extends Command
{
    private $container;
    private $em;
    private $output;
    private $filesystem;
    private $rootlog;


    public function __construct(ContainerInterface $container, EntityManagerInterface $em)
    {
        parent::__construct();
        $this->container = $container;
        $this->em = $em;
    }

    protected function configure()
    {
        $this
            ->setName('app:PurgeRegistration')
            ->setDescription('Purge Registration')
            ->setHelp('This command Purge the obsolete Registration')
            ->addArgument('cronid', InputArgument::OPTIONAL, 'ID Cron Job') 
            ->addArgument('lastchance', InputArgument::OPTIONAL, 'Lastchance to run the cron')              
        ;
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->output       = $output;
        $this->filesystem   = new Filesystem();
        $this->rootlog      = $this->container->get('kernel')->getProjectDir()."/var/log/";

        $this->writelnred('');
        $this->writelnred('== app:PurgeRegistration');        
        $this->writelnred('==========================================================================================================');

        $now=new \DateTime('now');


        $datas = $this->em
                ->createQueryBuilder()
                ->select('table')
                ->from('App\Entity\Registration','table')
                ->where('table.keyexpire<:now')
                ->setParameter("now",$now->format("Y-m-d H:i:s"))
                ->getQuery()
                ->getResult();
        foreach($datas as $data) {
            $this->writeln('    - Inscription supprimée = '.$data->getkeyexpire()->format("Y-m-d H:i:s")." >> ".$data->getUsername());
            $this->em->remove($data);
            $this->em->flush();            
        }

        $this->writeln('');
        return Command::SUCCESS;
    }

    private function writelnred($string) { 
        $this->output->writeln('<fg=red>'.$string.'</>');
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }
    private function writeln($string) { 
        $this->output->writeln($string);
        $this->filesystem->appendToFile($this->rootlog.'cron.log', $string."\n");
    }     
}
