<?php
namespace Cadoles\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;

use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 * @ORM\Table(name="statut")
 * @ORM\HasLifecycleCallbacks()
 *
 * @UniqueEntity(fields="label", message="Un statut existe déjà avec ce label")
 */
class Statut
{
    /**
     * @ORM\Column(type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=250, unique=true)
     */
    private $label;

    /**
     * @var ArrayCollection $registrations
     * @var Registration
     *
     * @ORM\OneToMany(targetEntity="Registration", mappedBy="statut", cascade={"persist", "remove"}, orphanRemoval=true)
     */
    private $registrations;


    /**
     * Constructor
     */
    public function __construct()
    {
        $this->registrations = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set label
     *
     * @param string $label
     *
     * @return Statut
     */
    public function setLabel($label)
    {
        $this->label = $label;

        return $this;
    }

    /**
     * Get label
     *
     * @return string
     */
    public function getLabel()
    {
        return $this->label;
    }

    /**
     * Add registration
     *
     * @param \Cadoles\CoreBundle\Entity\Registration $registration
     *
     * @return Statut
     */
    public function addRegistration(\Cadoles\CoreBundle\Entity\Registration $registration)
    {
        $this->registrations[] = $registration;

        return $this;
    }

    /**
     * Remove registration
     *
     * @param \Cadoles\CoreBundle\Entity\Registration $registration
     */
    public function removeRegistration(\Cadoles\CoreBundle\Entity\Registration $registration)
    {
        $this->registrations->removeElement($registration);
    }

    /**
     * Get registrations
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getRegistrations()
    {
        return $this->registrations;
    }
}
