<?php

namespace Cadoles\PortalBundle\Repository;

use Doctrine\ORM\EntityRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Cadoles\PortalBundle\Entity\Project;

class ProjecttaskRepository extends EntityRepository
{
   
    public function getProjectsTasks($projects,$start,$length=10,&$count,&$articles)
    {
        $count=$this->createQueryBuilder('projecttask')
                ->select('COUNT(projecttask)')
                ->andwhere('projecttask.project IN(:project)')
                ->setParameter('project',$projects)
                ->getQuery()->getSingleScalarResult();

        $articles=$this->createQueryBuilder('projecttask')
                ->andwhere('projecttask.project IN(:project)')
                ->setParameter('project',$projects)
                ->orderBy('projecttask.submit', 'DESC')
                ->addOrderBy('projecttask.name', 'ASC')  
                ->setFirstResult($start)->setMaxResults($length)                  
                ->getQuery()->getResult();
    }

    public function getProjectTasksByDate($project,$user,$start,$end)
    {
        $projecttasks=$this->createQueryBuilder('projecttask')
                             ->where('projecttask.project=:project')
                             ->andWhere('projecttask.owner=:user OR projecttask.user=:user')
                             ->andWhere('projecttask.end>=:start')
                             ->andWhere('projecttask.end<=:end')
                             ->setParameter('project',$project)
                             ->setParameter('user',$user)
                             ->setParameter('start',$start)
                             ->setParameter('end',$end)
                             ->OrderBy('projecttask.end', 'ASC')   
                             ->getQuery()->getResult();
        
        return $projecttasks;
    }    
}
